// media/capture/mojom/video_capture_buffer.mojom-shared-internal.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef MEDIA_CAPTURE_MOJOM_VIDEO_CAPTURE_BUFFER_MOJOM_SHARED_INTERNAL_H_
#define MEDIA_CAPTURE_MOJOM_VIDEO_CAPTURE_BUFFER_MOJOM_SHARED_INTERNAL_H_
#include "mojo/public/cpp/bindings/lib/array_internal.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/map_data_internal.h"
#include "mojo/public/cpp/bindings/lib/buffer.h"
#include "gpu/ipc/common/mailbox_holder.mojom-shared-internal.h"
#include "gpu/ipc/common/exported_shared_image.mojom-shared-internal.h"
#include "gpu/ipc/common/sync_token.mojom-shared-internal.h"
#include "media/capture/mojom/video_capture_types.mojom-shared-internal.h"
#include "media/mojo/mojom/media_types.mojom-shared-internal.h"
#include "mojo/public/mojom/base/shared_memory.mojom-shared-internal.h"
#include "mojo/public/mojom/base/time.mojom-shared-internal.h"
#include "ui/gfx/geometry/mojom/geometry.mojom-shared-internal.h"
#include "ui/gfx/mojom/buffer_types.mojom-shared-internal.h"
#include "ui/gfx/mojom/color_space.mojom-shared-internal.h"
#include "mojo/public/cpp/bindings/lib/native_enum_data.h"
#include "mojo/public/interfaces/bindings/native_struct.mojom-shared-internal.h"



namespace mojo {
namespace internal {
class ValidationContext;
}
}


namespace media::mojom {
namespace internal {
class VideoFrameInfo_Data;
class ReadyBuffer_Data;
class SharedImageBufferHandleSet_Data;
class VideoBufferHandle_Data;

#pragma pack(push, 1)


class  VideoBufferHandle_Data {
 public:
  // Used to identify Mojom Union Data Classes.
  typedef void MojomUnionDataType;

  VideoBufferHandle_Data() = default;
  // Do nothing in the destructor since it won't be called when it is a
  // non-inlined union.
  ~VideoBufferHandle_Data() = default;

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context,
                       bool inlined);

  bool is_null() const { return size == 0; }

  void set_null() {
    size = 0U;
    tag = static_cast<VideoBufferHandle_Tag>(0);
    data.unknown = 0U;
  }

  // TODO(crbug.com/40731316): SHOUTY_CASE values are being deprecated per C++ code style
  // guidelines (https://google.github.io/styleguide/cppguide.html#Enumerator_Names),
  // please use kCamelCase values instead.  Cleanup NULL_VALUE, BOOL_VALUE, INT_VALUE, etc.
  // generation once codebase is transitioned to kNullValue, kBoolValue, kIntValue, etc.
  enum class VideoBufferHandle_Tag : uint32_t {

    
    kUnsafeShmemRegion,
    
    kReadOnlyShmemRegion,
    
    kSharedImageHandle,
    
    kGpuMemoryBufferHandle,
  };

  // A note on layout:
  // "Each non-static data member is allocated as if it were the sole member of
  // a struct." - Section 9.5.2 ISO/IEC 14882:2011 (The C++ Spec)
  union MOJO_ALIGNAS(8) Union_ {
    Union_() : unknown(0) {}
    mojo::internal::Pointer<::mojo_base::mojom::internal::UnsafeSharedMemoryRegion_Data> f_unsafe_shmem_region;
    mojo::internal::Pointer<::mojo_base::mojom::internal::ReadOnlySharedMemoryRegion_Data> f_read_only_shmem_region;
    mojo::internal::Pointer<internal::SharedImageBufferHandleSet_Data> f_shared_image_handle;
    mojo::internal::Pointer<::gfx::mojom::internal::GpuMemoryBufferHandle_Data> f_gpu_memory_buffer_handle;
    uint64_t unknown;
  };

  uint32_t size;
  VideoBufferHandle_Tag tag;
  Union_ data;
};
static_assert(sizeof(VideoBufferHandle_Data) == mojo::internal::kUnionDataSize,
              "Bad sizeof(VideoBufferHandle_Data)");
class  VideoFrameInfo_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<::mojo_base::mojom::internal::TimeDelta_Data> timestamp;
  mojo::internal::Pointer<::media::mojom::internal::VideoFrameMetadata_Data> metadata;
  int32_t pixel_format;
  uint8_t is_premapped : 1;
  uint8_t pad3_[3];
  mojo::internal::Pointer<::gfx::mojom::internal::Size_Data> coded_size;
  mojo::internal::Pointer<::gfx::mojom::internal::Rect_Data> visible_rect;
  mojo::internal::Pointer<::gfx::mojom::internal::ColorSpace_Data> color_space;
  mojo::internal::Pointer<::media::mojom::internal::PlaneStrides_Data> strides;

 private:
  friend class mojo::internal::MessageFragment<VideoFrameInfo_Data>;

  VideoFrameInfo_Data();
  ~VideoFrameInfo_Data() = delete;
};
static_assert(sizeof(VideoFrameInfo_Data) == 64,
              "Bad sizeof(VideoFrameInfo_Data)");
// Used by VideoFrameInfo::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct VideoFrameInfo_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  VideoFrameInfo_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~VideoFrameInfo_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::Message& message) override {
    mojo::internal::MessageFragment<VideoFrameInfo_Data> fragment(message);
    mojo::internal::Serialize<DataView>(user_data_, fragment);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    VideoFrameInfo_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};
class  ReadyBuffer_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  int32_t buffer_id;
  uint8_t pad0_[4];
  mojo::internal::Pointer<internal::VideoFrameInfo_Data> info;

 private:
  friend class mojo::internal::MessageFragment<ReadyBuffer_Data>;

  ReadyBuffer_Data();
  ~ReadyBuffer_Data() = delete;
};
static_assert(sizeof(ReadyBuffer_Data) == 24,
              "Bad sizeof(ReadyBuffer_Data)");
// Used by ReadyBuffer::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct ReadyBuffer_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  ReadyBuffer_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~ReadyBuffer_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::Message& message) override {
    mojo::internal::MessageFragment<ReadyBuffer_Data> fragment(message);
    mojo::internal::Serialize<DataView>(user_data_, fragment);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    ReadyBuffer_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};
class  SharedImageBufferHandleSet_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<::gpu::mojom::internal::ExportedSharedImage_Data> shared_image;
  mojo::internal::Pointer<::gpu::mojom::internal::SyncToken_Data> sync_token;

 private:
  friend class mojo::internal::MessageFragment<SharedImageBufferHandleSet_Data>;

  SharedImageBufferHandleSet_Data();
  ~SharedImageBufferHandleSet_Data() = delete;
};
static_assert(sizeof(SharedImageBufferHandleSet_Data) == 24,
              "Bad sizeof(SharedImageBufferHandleSet_Data)");
// Used by SharedImageBufferHandleSet::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct SharedImageBufferHandleSet_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  SharedImageBufferHandleSet_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~SharedImageBufferHandleSet_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::Message& message) override {
    mojo::internal::MessageFragment<SharedImageBufferHandleSet_Data> fragment(message);
    mojo::internal::Serialize<DataView>(user_data_, fragment);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    SharedImageBufferHandleSet_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};

#pragma pack(pop)

}  // namespace internal

}  // media::mojom

#endif  // MEDIA_CAPTURE_MOJOM_VIDEO_CAPTURE_BUFFER_MOJOM_SHARED_INTERNAL_H_