// media/mojo/mojom/renderer.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef MEDIA_MOJO_MOJOM_RENDERER_MOJOM_H_
#define MEDIA_MOJO_MOJOM_RENDERER_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>

#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "media/mojo/mojom/renderer.mojom-features.h"  // IWYU pragma: export
#include "media/mojo/mojom/renderer.mojom-shared.h"  // IWYU pragma: export
#include "media/mojo/mojom/renderer.mojom-forward.h"  // IWYU pragma: export
#include "media/mojo/mojom/demuxer_stream.mojom-forward.h"
#include "media/mojo/mojom/media_types.mojom.h"
#include "mojo/public/mojom/base/time.mojom.h"
#include "mojo/public/mojom/base/unguessable_token.mojom.h"
#include "services/network/public/mojom/site_for_cookies.mojom.h"
#include "services/network/public/mojom/storage_access_api.mojom.h"
#include "ui/gfx/geometry/mojom/geometry.mojom.h"
#include "url/mojom/url.mojom.h"
#include "url/mojom/origin.mojom.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/lib/message_size_estimator.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"






namespace media::mojom {

class RendererProxy;

template <typename ImplRefTraits>
class RendererStub;

class RendererRequestValidator;
class RendererResponseValidator;


class Renderer
    : public RendererInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();

  static const char Name_[];
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = true;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = RendererInterfaceBase;
  using Proxy_ = RendererProxy;

  template <typename ImplRefTraits>
  using Stub_ = RendererStub<ImplRefTraits>;

  using RequestValidator_ = RendererRequestValidator;
  using ResponseValidator_ = RendererResponseValidator;
  enum MethodMinVersions : uint32_t {
    kInitializeMinVersion = 0,
    kFlushMinVersion = 0,
    kStartPlayingFromMinVersion = 0,
    kSetPlaybackRateMinVersion = 0,
    kSetVolumeMinVersion = 0,
    kSetCdmMinVersion = 0,
    kSetLatencyHintMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct Initialize_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct Flush_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct StartPlayingFrom_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SetPlaybackRate_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SetVolume_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SetCdm_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SetLatencyHint_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~Renderer() = default;


  using InitializeCallback = base::OnceCallback<void(bool)>;
  
  virtual void Initialize(::mojo::PendingAssociatedRemote<RendererClient> client, std::optional<std::vector<::mojo::PendingRemote<::media::mojom::DemuxerStream>>> streams, MediaUrlParamsPtr media_url_params, InitializeCallback callback) = 0;


  using FlushCallback = base::OnceCallback<void()>;
  
  virtual void Flush(FlushCallback callback) = 0;

  
  virtual void StartPlayingFrom(::base::TimeDelta time) = 0;

  
  virtual void SetPlaybackRate(double playback_rate) = 0;

  
  virtual void SetVolume(float volume) = 0;


  using SetCdmCallback = base::OnceCallback<void(bool)>;
  
  virtual void SetCdm(const std::optional<::base::UnguessableToken>& cdm_id, SetCdmCallback callback) = 0;

  
  virtual void SetLatencyHint(std::optional<::base::TimeDelta> latency_hint) = 0;
};

class RendererClientProxy;

template <typename ImplRefTraits>
class RendererClientStub;

class RendererClientRequestValidator;


class RendererClient
    : public RendererClientInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();

  static const char Name_[];
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = RendererClientInterfaceBase;
  using Proxy_ = RendererClientProxy;

  template <typename ImplRefTraits>
  using Stub_ = RendererClientStub<ImplRefTraits>;

  using RequestValidator_ = RendererClientRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kOnTimeUpdateMinVersion = 0,
    kOnBufferingStateChangeMinVersion = 0,
    kOnEndedMinVersion = 0,
    kOnErrorMinVersion = 0,
    kOnAudioConfigChangeMinVersion = 0,
    kOnVideoConfigChangeMinVersion = 0,
    kOnVideoNaturalSizeChangeMinVersion = 0,
    kOnVideoOpacityChangeMinVersion = 0,
    kOnStatisticsUpdateMinVersion = 0,
    kOnWaitingMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct OnTimeUpdate_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnBufferingStateChange_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnEnded_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnError_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnAudioConfigChange_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnVideoConfigChange_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnVideoNaturalSizeChange_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnVideoOpacityChange_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnStatisticsUpdate_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnWaiting_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~RendererClient() = default;

  
  virtual void OnTimeUpdate(::base::TimeDelta time, ::base::TimeDelta max_time, ::base::TimeTicks capture_time) = 0;

  
  virtual void OnBufferingStateChange(::media::BufferingState state, ::media::BufferingStateChangeReason reason) = 0;

  
  virtual void OnEnded() = 0;

  
  virtual void OnError(const ::media::PipelineStatus& status) = 0;

  
  virtual void OnAudioConfigChange(const ::media::AudioDecoderConfig& config) = 0;

  
  virtual void OnVideoConfigChange(const ::media::VideoDecoderConfig& config) = 0;

  
  virtual void OnVideoNaturalSizeChange(const ::gfx::Size& size) = 0;

  
  virtual void OnVideoOpacityChange(bool opaque) = 0;

  
  virtual void OnStatisticsUpdate(const ::media::PipelineStatistics& stats) = 0;

  
  virtual void OnWaiting(::media::WaitingReason reason) = 0;
};



class  RendererProxy
    : public Renderer {
 public:
  using InterfaceType = Renderer;

  explicit RendererProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void Initialize(::mojo::PendingAssociatedRemote<RendererClient> client, std::optional<std::vector<::mojo::PendingRemote<::media::mojom::DemuxerStream>>> streams, MediaUrlParamsPtr media_url_params, InitializeCallback callback) final;
  
  void Flush(FlushCallback callback) final;
  
  void StartPlayingFrom(::base::TimeDelta time) final;
  
  void SetPlaybackRate(double playback_rate) final;
  
  void SetVolume(float volume) final;
  
  void SetCdm(const std::optional<::base::UnguessableToken>& cdm_id, SetCdmCallback callback) final;
  
  void SetLatencyHint(std::optional<::base::TimeDelta> latency_hint) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class  RendererClientProxy
    : public RendererClient {
 public:
  using InterfaceType = RendererClient;

  explicit RendererClientProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void OnTimeUpdate(::base::TimeDelta time, ::base::TimeDelta max_time, ::base::TimeTicks capture_time) final;
  
  void OnBufferingStateChange(::media::BufferingState state, ::media::BufferingStateChangeReason reason) final;
  
  void OnEnded() final;
  
  void OnError(const ::media::PipelineStatus& status) final;
  
  void OnAudioConfigChange(const ::media::AudioDecoderConfig& config) final;
  
  void OnVideoConfigChange(const ::media::VideoDecoderConfig& config) final;
  
  void OnVideoNaturalSizeChange(const ::gfx::Size& size) final;
  
  void OnVideoOpacityChange(bool opaque) final;
  
  void OnStatisticsUpdate(const ::media::PipelineStatistics& stats) final;
  
  void OnWaiting(::media::WaitingReason reason) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class  RendererStubDispatch {
 public:
  static bool Accept(Renderer* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      Renderer* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<Renderer>>
class RendererStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  RendererStub() = default;
  ~RendererStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return RendererStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return RendererStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  RendererClientStubDispatch {
 public:
  static bool Accept(RendererClient* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      RendererClient* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<RendererClient>>
class RendererClientStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  RendererClientStub() = default;
  ~RendererClientStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return RendererClientStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return RendererClientStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  RendererRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  RendererClientRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  RendererResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};








class  MediaUrlParams {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<MediaUrlParams, T>::value>;
  using DataView = MediaUrlParamsDataView;
  using Data_ = internal::MediaUrlParams_Data;

  template <typename... Args>
  static MediaUrlParamsPtr New(Args&&... args) {
    return MediaUrlParamsPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static MediaUrlParamsPtr From(const U& u) {
    return mojo::TypeConverter<MediaUrlParamsPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, MediaUrlParams>::Convert(*this);
  }


  MediaUrlParams();

  MediaUrlParams(
      const ::GURL& media_url,
      const ::net::SiteForCookies& site_for_cookies,
      const ::url::Origin& top_frame_origin,
      ::net::StorageAccessApiStatus storage_access_api_status,
      bool allow_credentials,
      bool is_hls,
      const base::flat_map<std::string, std::string>& headers);


  ~MediaUrlParams();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = MediaUrlParamsPtr>
  MediaUrlParamsPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, MediaUrlParams::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, MediaUrlParams::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, MediaUrlParams::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        MediaUrlParams::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        MediaUrlParams::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::MediaUrlParams_UnserializedMessageContext<
            UserType, MediaUrlParams::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<MediaUrlParams::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return MediaUrlParams::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::MediaUrlParams_UnserializedMessageContext<
            UserType, MediaUrlParams::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<MediaUrlParams::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::GURL media_url;
  
  ::net::SiteForCookies site_for_cookies;
  
  ::url::Origin top_frame_origin;
  
  ::net::StorageAccessApiStatus storage_access_api_status;
  
  bool allow_credentials;
  
  bool is_hls;
  
  base::flat_map<std::string, std::string> headers;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, MediaUrlParams::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, MediaUrlParams::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, MediaUrlParams::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, MediaUrlParams::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
MediaUrlParamsPtr MediaUrlParams::Clone() const {
  return New(
      mojo::Clone(media_url),
      mojo::Clone(site_for_cookies),
      mojo::Clone(top_frame_origin),
      mojo::Clone(storage_access_api_status),
      mojo::Clone(allow_credentials),
      mojo::Clone(is_hls),
      mojo::Clone(headers)
  );
}

template <typename T, MediaUrlParams::EnableIfSame<T>*>
bool MediaUrlParams::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->media_url, other_struct.media_url))
    return false;
  if (!mojo::Equals(this->site_for_cookies, other_struct.site_for_cookies))
    return false;
  if (!mojo::Equals(this->top_frame_origin, other_struct.top_frame_origin))
    return false;
  if (!mojo::Equals(this->storage_access_api_status, other_struct.storage_access_api_status))
    return false;
  if (!mojo::Equals(this->allow_credentials, other_struct.allow_credentials))
    return false;
  if (!mojo::Equals(this->is_hls, other_struct.is_hls))
    return false;
  if (!mojo::Equals(this->headers, other_struct.headers))
    return false;
  return true;
}

template <typename T, MediaUrlParams::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.media_url < rhs.media_url)
    return true;
  if (rhs.media_url < lhs.media_url)
    return false;
  if (lhs.site_for_cookies < rhs.site_for_cookies)
    return true;
  if (rhs.site_for_cookies < lhs.site_for_cookies)
    return false;
  if (lhs.top_frame_origin < rhs.top_frame_origin)
    return true;
  if (rhs.top_frame_origin < lhs.top_frame_origin)
    return false;
  if (lhs.storage_access_api_status < rhs.storage_access_api_status)
    return true;
  if (rhs.storage_access_api_status < lhs.storage_access_api_status)
    return false;
  if (lhs.allow_credentials < rhs.allow_credentials)
    return true;
  if (rhs.allow_credentials < lhs.allow_credentials)
    return false;
  if (lhs.is_hls < rhs.is_hls)
    return true;
  if (rhs.is_hls < lhs.is_hls)
    return false;
  if (lhs.headers < rhs.headers)
    return true;
  if (rhs.headers < lhs.headers)
    return false;
  return false;
}


}  // media::mojom

namespace mojo {


template <>
struct  StructTraits<::media::mojom::MediaUrlParams::DataView,
                                         ::media::mojom::MediaUrlParamsPtr> {
  static bool IsNull(const ::media::mojom::MediaUrlParamsPtr& input) { return !input; }
  static void SetToNull(::media::mojom::MediaUrlParamsPtr* output) { output->reset(); }

  static const decltype(::media::mojom::MediaUrlParams::media_url)& media_url(
      const ::media::mojom::MediaUrlParamsPtr& input) {
    return input->media_url;
  }

  static const decltype(::media::mojom::MediaUrlParams::site_for_cookies)& site_for_cookies(
      const ::media::mojom::MediaUrlParamsPtr& input) {
    return input->site_for_cookies;
  }

  static const decltype(::media::mojom::MediaUrlParams::top_frame_origin)& top_frame_origin(
      const ::media::mojom::MediaUrlParamsPtr& input) {
    return input->top_frame_origin;
  }

  static decltype(::media::mojom::MediaUrlParams::storage_access_api_status) storage_access_api_status(
      const ::media::mojom::MediaUrlParamsPtr& input) {
    return input->storage_access_api_status;
  }

  static decltype(::media::mojom::MediaUrlParams::allow_credentials) allow_credentials(
      const ::media::mojom::MediaUrlParamsPtr& input) {
    return input->allow_credentials;
  }

  static decltype(::media::mojom::MediaUrlParams::is_hls) is_hls(
      const ::media::mojom::MediaUrlParamsPtr& input) {
    return input->is_hls;
  }

  static const decltype(::media::mojom::MediaUrlParams::headers)& headers(
      const ::media::mojom::MediaUrlParamsPtr& input) {
    return input->headers;
  }

  static bool Read(::media::mojom::MediaUrlParams::DataView input, ::media::mojom::MediaUrlParamsPtr* output);
};

}  // namespace mojo

#endif  // MEDIA_MOJO_MOJOM_RENDERER_MOJOM_H_