// services/media_session/public/mojom/media_session.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_MEDIA_SESSION_PUBLIC_MOJOM_MEDIA_SESSION_MOJOM_SHARED_H_
#define SERVICES_MEDIA_SESSION_PUBLIC_MOJOM_MEDIA_SESSION_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "services/media_session/public/mojom/media_session.mojom-shared-internal.h"
#include "mojo/public/mojom/base/string16.mojom-shared.h"
#include "mojo/public/mojom/base/time.mojom-shared.h"
#include "ui/gfx/geometry/mojom/geometry.mojom-shared.h"
#include "url/mojom/url.mojom-shared.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization.h"
#include "mojo/public/cpp/system/data_pipe.h"






namespace media_session::mojom {
class MediaImageDataView;

class ChapterInformationDataView;

class MediaMetadataDataView;

class MediaImageBitmapDataView;

class MediaPositionDataView;

class RemotePlaybackMetadataDataView;

class MediaSessionInfoDataView;

class MediaSessionDebugInfoDataView;



}  // media_session::mojom

namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::media_session::mojom::MediaImageDataView> {
  using Data = ::media_session::mojom::internal::MediaImage_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::media_session::mojom::ChapterInformationDataView> {
  using Data = ::media_session::mojom::internal::ChapterInformation_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::media_session::mojom::MediaMetadataDataView> {
  using Data = ::media_session::mojom::internal::MediaMetadata_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::media_session::mojom::MediaImageBitmapDataView> {
  using Data = ::media_session::mojom::internal::MediaImageBitmap_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::media_session::mojom::MediaPositionDataView> {
  using Data = ::media_session::mojom::internal::MediaPosition_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::media_session::mojom::RemotePlaybackMetadataDataView> {
  using Data = ::media_session::mojom::internal::RemotePlaybackMetadata_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::media_session::mojom::MediaSessionInfoDataView> {
  using Data = ::media_session::mojom::internal::MediaSessionInfo_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::media_session::mojom::MediaSessionDebugInfoDataView> {
  using Data = ::media_session::mojom::internal::MediaSessionDebugInfo_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace media_session::mojom {


enum class MediaPlaybackState : int32_t {
  
  kPaused = 0,
  
  kPlaying = 1,
  kMinValue = 0,
  kMaxValue = 1,
};

 std::ostream& operator<<(std::ostream& os, MediaPlaybackState value);
inline bool IsKnownEnumValue(MediaPlaybackState value) {
  return internal::MediaPlaybackState_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class MediaSessionAction : int32_t {
  
  kPlay = 0,
  
  kPause = 1,
  
  kPreviousTrack = 2,
  
  kNextTrack = 3,
  
  kSeekBackward = 4,
  
  kSeekForward = 5,
  
  kSkipAd = 6,
  
  kStop = 7,
  
  kSeekTo = 8,
  
  kScrubTo = 9,
  
  kEnterPictureInPicture = 10,
  
  kExitPictureInPicture = 11,
  
  kSwitchAudioDevice = 12,
  
  kToggleMicrophone = 13,
  
  kToggleCamera = 14,
  
  kHangUp = 15,
  
  kRaise = 16,
  
  kSetMute = 17,
  
  kPreviousSlide = 18,
  
  kNextSlide = 19,
  
  kEnterAutoPictureInPicture = 20,
  kMinValue = 0,
  kMaxValue = 20,
};

 std::ostream& operator<<(std::ostream& os, MediaSessionAction value);
inline bool IsKnownEnumValue(MediaSessionAction value) {
  return internal::MediaSessionAction_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class MediaSessionImageType : int32_t {
  
  kArtwork = 0,
  
  kSourceIcon = 1,
  
  kChapter = 2,
  kMinValue = 0,
  kMaxValue = 2,
};

 std::ostream& operator<<(std::ostream& os, MediaSessionImageType value);
inline bool IsKnownEnumValue(MediaSessionImageType value) {
  return internal::MediaSessionImageType_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class MediaPictureInPictureState : int32_t {
  
  kNotInPictureInPicture = 0,
  
  kInPictureInPicture = 1,
  kMinValue = 0,
  kMaxValue = 1,
};

 std::ostream& operator<<(std::ostream& os, MediaPictureInPictureState value);
inline bool IsKnownEnumValue(MediaPictureInPictureState value) {
  return internal::MediaPictureInPictureState_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class MediaAudioVideoState : int32_t {
  
  kDeprecatedUnknown = 0,
  
  kAudioOnly = 1,
  
  kAudioVideo = 2,
  
  kVideoOnly = 3,
  kMinValue = 0,
  kMaxValue = 3,
};

 std::ostream& operator<<(std::ostream& os, MediaAudioVideoState value);
inline bool IsKnownEnumValue(MediaAudioVideoState value) {
  return internal::MediaAudioVideoState_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class MediaImageBitmapColorType : int32_t {
  
  kRGBA_8888 = 0,
  
  kBGRA_8888 = 1,
  kMinValue = 0,
  kMaxValue = 1,
};

 std::ostream& operator<<(std::ostream& os, MediaImageBitmapColorType value);
inline bool IsKnownEnumValue(MediaImageBitmapColorType value) {
  return internal::MediaImageBitmapColorType_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class MicrophoneState : int32_t {
  
  kUnknown = 0,
  
  kMuted = 1,
  
  kUnmuted = 2,
  kMinValue = 0,
  kMaxValue = 2,
};

 std::ostream& operator<<(std::ostream& os, MicrophoneState value);
inline bool IsKnownEnumValue(MicrophoneState value) {
  return internal::MicrophoneState_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class CameraState : int32_t {
  
  kUnknown = 0,
  
  kTurnedOn = 1,
  
  kTurnedOff = 2,
  kMinValue = 0,
  kMaxValue = 2,
};

 std::ostream& operator<<(std::ostream& os, CameraState value);
inline bool IsKnownEnumValue(CameraState value) {
  return internal::CameraState_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class MediaSessionInfo_SessionState : int32_t {
  
  kActive = 0,
  
  kDucking = 1,
  
  kSuspended = 2,
  
  kInactive = 3,
  kMinValue = 0,
  kMaxValue = 3,
};

 std::ostream& operator<<(std::ostream& os, MediaSessionInfo_SessionState value);
inline bool IsKnownEnumValue(MediaSessionInfo_SessionState value) {
  return internal::MediaSessionInfo_SessionState_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class MediaSession_SuspendType : int32_t {
  
  kSystem = 0,
  
  kUI = 1,
  
  kContent = 2,
  kMinValue = 0,
  kMaxValue = 2,
};

 std::ostream& operator<<(std::ostream& os, MediaSession_SuspendType value);
inline bool IsKnownEnumValue(MediaSession_SuspendType value) {
  return internal::MediaSession_SuspendType_Data::IsKnownValue(
      static_cast<int32_t>(value));
}
// Interface base classes. They are used for type safety check.
class MediaSessionObserverInterfaceBase {};

using MediaSessionObserverPtrDataView =
    mojo::InterfacePtrDataView<MediaSessionObserverInterfaceBase>;
using MediaSessionObserverRequestDataView =
    mojo::InterfaceRequestDataView<MediaSessionObserverInterfaceBase>;
using MediaSessionObserverAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<MediaSessionObserverInterfaceBase>;
using MediaSessionObserverAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<MediaSessionObserverInterfaceBase>;
class MediaSessionInterfaceBase {};

using MediaSessionPtrDataView =
    mojo::InterfacePtrDataView<MediaSessionInterfaceBase>;
using MediaSessionRequestDataView =
    mojo::InterfaceRequestDataView<MediaSessionInterfaceBase>;
using MediaSessionAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<MediaSessionInterfaceBase>;
using MediaSessionAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<MediaSessionInterfaceBase>;


class MediaImageDataView {
 public:
  MediaImageDataView() = default;

  MediaImageDataView(
      internal::MediaImage_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetSrcDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSrc(UserType* output) {
    
    auto* pointer = data_->src.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, message_);
  }
  inline void GetTypeDataView(
      ::mojo_base::mojom::String16DataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadType(UserType* output) {
    
    auto* pointer = data_->type.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::String16DataView>(
        pointer, output, message_);
  }
  inline void GetSizesDataView(
      mojo::ArrayDataView<::gfx::mojom::SizeDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSizes(UserType* output) {
    
    auto* pointer = data_->sizes.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::gfx::mojom::SizeDataView>>(
        pointer, output, message_);
  }
 private:
  internal::MediaImage_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class ChapterInformationDataView {
 public:
  ChapterInformationDataView() = default;

  ChapterInformationDataView(
      internal::ChapterInformation_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetTitleDataView(
      ::mojo_base::mojom::String16DataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTitle(UserType* output) {
    
    auto* pointer = data_->title.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::String16DataView>(
        pointer, output, message_);
  }
  inline void GetStartTimeDataView(
      ::mojo_base::mojom::TimeDeltaDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadStartTime(UserType* output) {
    
    auto* pointer = data_->startTime.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeDeltaDataView>(
        pointer, output, message_);
  }
  inline void GetArtworkDataView(
      mojo::ArrayDataView<MediaImageDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadArtwork(UserType* output) {
    
    auto* pointer = data_->artwork.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::media_session::mojom::MediaImageDataView>>(
        pointer, output, message_);
  }
 private:
  internal::ChapterInformation_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class MediaMetadataDataView {
 public:
  MediaMetadataDataView() = default;

  MediaMetadataDataView(
      internal::MediaMetadata_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetTitleDataView(
      ::mojo_base::mojom::String16DataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTitle(UserType* output) {
    
    auto* pointer = data_->title.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::String16DataView>(
        pointer, output, message_);
  }
  inline void GetArtistDataView(
      ::mojo_base::mojom::String16DataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadArtist(UserType* output) {
    
    auto* pointer = data_->artist.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::String16DataView>(
        pointer, output, message_);
  }
  inline void GetAlbumDataView(
      ::mojo_base::mojom::String16DataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadAlbum(UserType* output) {
    
    auto* pointer = data_->album.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::String16DataView>(
        pointer, output, message_);
  }
  inline void GetSourceTitleDataView(
      ::mojo_base::mojom::String16DataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSourceTitle(UserType* output) {
    
    auto* pointer = data_->source_title.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::String16DataView>(
        pointer, output, message_);
  }
  inline void GetChaptersDataView(
      mojo::ArrayDataView<ChapterInformationDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadChapters(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::ArrayDataView<::media_session::mojom::ChapterInformationDataView>, UserType>(),
    "Attempting to read the optional `chapters` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadChapters` instead "
    "of `ReadChapters if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->header_.version >= 21
                    ? data_->chapters.Get() : nullptr;
    return mojo::internal::Deserialize<mojo::ArrayDataView<::media_session::mojom::ChapterInformationDataView>>(
        pointer, output, message_);
  }
 private:
  internal::MediaMetadata_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class MediaImageBitmapDataView {
 public:
  MediaImageBitmapDataView() = default;

  MediaImageBitmapDataView(
      internal::MediaImageBitmap_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  int32_t width() const {
    return data_->width;
  }
  int32_t height() const {
    return data_->height;
  }
  inline void GetPixelDataDataView(
      mojo::ArrayDataView<uint8_t>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPixelData(UserType* output) {
    
    auto* pointer = data_->pixel_data.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<uint8_t>>(
        pointer, output, message_);
  }
  template <typename UserType>
  [[nodiscard]] bool ReadColorType(UserType* output) const {
    auto data_value = data_->header_.version >= 5
                      ? data_->color_type : 0;
    return mojo::internal::Deserialize<::media_session::mojom::MediaImageBitmapColorType>(
        data_value, output);
  }
  MediaImageBitmapColorType color_type() const {
    if (data_->header_.version < 5)
      return MediaImageBitmapColorType{};
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::media_session::mojom::MediaImageBitmapColorType>(data_->color_type));
  }
 private:
  internal::MediaImageBitmap_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class MediaPositionDataView {
 public:
  MediaPositionDataView() = default;

  MediaPositionDataView(
      internal::MediaPosition_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  double playback_rate() const {
    return data_->playback_rate;
  }
  inline void GetDurationDataView(
      ::mojo_base::mojom::TimeDeltaDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDuration(UserType* output) {
    
    auto* pointer = data_->duration.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeDeltaDataView>(
        pointer, output, message_);
  }
  inline void GetPositionDataView(
      ::mojo_base::mojom::TimeDeltaDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPosition(UserType* output) {
    
    auto* pointer = data_->position.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeDeltaDataView>(
        pointer, output, message_);
  }
  inline void GetLastUpdatedTimeDataView(
      ::mojo_base::mojom::TimeTicksDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadLastUpdatedTime(UserType* output) {
    
    auto* pointer = data_->last_updated_time.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeTicksDataView>(
        pointer, output, message_);
  }
  bool end_of_media() const {
    if (data_->header_.version < 13)
      return bool{};
    return data_->end_of_media;
  }
 private:
  internal::MediaPosition_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class RemotePlaybackMetadataDataView {
 public:
  RemotePlaybackMetadataDataView() = default;

  RemotePlaybackMetadataDataView(
      internal::RemotePlaybackMetadata_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetVideoCodecDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadVideoCodec(UserType* output) {
    
    auto* pointer = data_->video_codec.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetAudioCodecDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadAudioCodec(UserType* output) {
    
    auto* pointer = data_->audio_codec.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  bool remote_playback_disabled() const {
    return data_->remote_playback_disabled;
  }
  bool remote_playback_started() const {
    if (data_->header_.version < 17)
      return bool{};
    return data_->remote_playback_started;
  }
  inline void GetUnusedFieldDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadUnusedField(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::StringDataView, UserType>(),
    "Attempting to read the optional `unused_field` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadUnusedField` instead "
    "of `ReadUnusedField if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->header_.version >= 17
                    ? data_->unused_field.Get() : nullptr;
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  bool is_encrypted_media() const {
    if (data_->header_.version < 18)
      return bool{};
    return data_->is_encrypted_media;
  }
 private:
  internal::RemotePlaybackMetadata_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class MediaSessionInfoDataView {
 public:
  MediaSessionInfoDataView() = default;

  MediaSessionInfoDataView(
      internal::MediaSessionInfo_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  [[nodiscard]] bool ReadState(UserType* output) const {
    auto data_value = data_->state;
    return mojo::internal::Deserialize<::media_session::mojom::MediaSessionInfo_SessionState>(
        data_value, output);
  }
  MediaSessionInfo_SessionState state() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::media_session::mojom::MediaSessionInfo_SessionState>(data_->state));
  }
  bool force_duck() const {
    return data_->force_duck;
  }
  template <typename UserType>
  [[nodiscard]] bool ReadPlaybackState(UserType* output) const {
    auto data_value = data_->header_.version >= 1
                      ? data_->playback_state : 0;
    return mojo::internal::Deserialize<::media_session::mojom::MediaPlaybackState>(
        data_value, output);
  }
  MediaPlaybackState playback_state() const {
    if (data_->header_.version < 1)
      return MediaPlaybackState{};
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::media_session::mojom::MediaPlaybackState>(data_->playback_state));
  }
  bool is_controllable() const {
    if (data_->header_.version < 2)
      return bool{};
    return data_->is_controllable;
  }
  bool prefer_stop_for_gain_focus_loss() const {
    if (data_->header_.version < 4)
      return bool{};
    return data_->prefer_stop_for_gain_focus_loss;
  }
  bool deprecated_is_sensitive() const {
    if (data_->header_.version < 6)
      return bool{};
    return data_->deprecated_is_sensitive;
  }
  template <typename UserType>
  [[nodiscard]] bool ReadPictureInPictureState(UserType* output) const {
    auto data_value = data_->header_.version >= 7
                      ? data_->picture_in_picture_state : 0;
    return mojo::internal::Deserialize<::media_session::mojom::MediaPictureInPictureState>(
        data_value, output);
  }
  MediaPictureInPictureState picture_in_picture_state() const {
    if (data_->header_.version < 7)
      return MediaPictureInPictureState{};
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::media_session::mojom::MediaPictureInPictureState>(data_->picture_in_picture_state));
  }
  template <typename UserType>
  [[nodiscard]] bool ReadDeprecatedAudioVideoState(UserType* output) const {
    auto data_value = data_->header_.version >= 8
                      ? data_->deprecated_audio_video_state : 0;
    return mojo::internal::Deserialize<::media_session::mojom::MediaAudioVideoState>(
        data_value, output);
  }
  MediaAudioVideoState deprecated_audio_video_state() const {
    if (data_->header_.version < 8)
      return MediaAudioVideoState{};
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::media_session::mojom::MediaAudioVideoState>(data_->deprecated_audio_video_state));
  }
  inline void GetAudioSinkIdDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadAudioSinkId(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::StringDataView, UserType>(),
    "Attempting to read the optional `audio_sink_id` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadAudioSinkId` instead "
    "of `ReadAudioSinkId if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->header_.version >= 9
                    ? data_->audio_sink_id.Get() : nullptr;
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetAudioVideoStatesDataView(
      mojo::ArrayDataView<MediaAudioVideoState>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadAudioVideoStates(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::ArrayDataView<::media_session::mojom::MediaAudioVideoState>, UserType>(),
    "Attempting to read the optional `audio_video_states` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadAudioVideoStates` instead "
    "of `ReadAudioVideoStates if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->header_.version >= 10
                    ? data_->audio_video_states.Get() : nullptr;
    return mojo::internal::Deserialize<mojo::ArrayDataView<::media_session::mojom::MediaAudioVideoState>>(
        pointer, output, message_);
  }
  template <typename UserType>
  [[nodiscard]] bool ReadMicrophoneState(UserType* output) const {
    auto data_value = data_->header_.version >= 11
                      ? data_->microphone_state : 0;
    return mojo::internal::Deserialize<::media_session::mojom::MicrophoneState>(
        data_value, output);
  }
  MicrophoneState microphone_state() const {
    if (data_->header_.version < 11)
      return MicrophoneState{};
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::media_session::mojom::MicrophoneState>(data_->microphone_state));
  }
  template <typename UserType>
  [[nodiscard]] bool ReadCameraState(UserType* output) const {
    auto data_value = data_->header_.version >= 11
                      ? data_->camera_state : 0;
    return mojo::internal::Deserialize<::media_session::mojom::CameraState>(
        data_value, output);
  }
  CameraState camera_state() const {
    if (data_->header_.version < 11)
      return CameraState{};
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::media_session::mojom::CameraState>(data_->camera_state));
  }
  bool muted() const {
    if (data_->header_.version < 12)
      return bool{};
    return data_->muted;
  }
  bool has_presentation() const {
    if (data_->header_.version < 14)
      return bool{};
    return data_->has_presentation;
  }
  inline void GetRemotePlaybackMetadataDataView(
      RemotePlaybackMetadataDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadRemotePlaybackMetadata(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::media_session::mojom::RemotePlaybackMetadataDataView, UserType>(),
    "Attempting to read the optional `remote_playback_metadata` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadRemotePlaybackMetadata` instead "
    "of `ReadRemotePlaybackMetadata if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->header_.version >= 15
                    ? data_->remote_playback_metadata.Get() : nullptr;
    return mojo::internal::Deserialize<::media_session::mojom::RemotePlaybackMetadataDataView>(
        pointer, output, message_);
  }
  bool hide_metadata() const {
    if (data_->header_.version < 16)
      return bool{};
    return data_->hide_metadata;
  }
  bool ignore_for_active_session() const {
    if (data_->header_.version < 20)
      return bool{};
    return data_->ignore_for_active_session;
  }
  bool meets_visibility_threshold() const {
    if (data_->header_.version < 21)
      return bool{};
    return data_->meets_visibility_threshold;
  }
 private:
  internal::MediaSessionInfo_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class MediaSessionDebugInfoDataView {
 public:
  MediaSessionDebugInfoDataView() = default;

  MediaSessionDebugInfoDataView(
      internal::MediaSessionDebugInfo_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetNameDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadName(UserType* output) {
    
    auto* pointer = data_->name.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetOwnerDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadOwner(UserType* output) {
    
    auto* pointer = data_->owner.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetStateDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadState(UserType* output) {
    
    auto* pointer = data_->state.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
 private:
  internal::MediaSessionDebugInfo_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


}  // media_session::mojom

namespace std {

template <>
struct hash<::media_session::mojom::MediaPlaybackState>
    : public mojo::internal::EnumHashImpl<::media_session::mojom::MediaPlaybackState> {};

template <>
struct hash<::media_session::mojom::MediaSessionAction>
    : public mojo::internal::EnumHashImpl<::media_session::mojom::MediaSessionAction> {};

template <>
struct hash<::media_session::mojom::MediaSessionImageType>
    : public mojo::internal::EnumHashImpl<::media_session::mojom::MediaSessionImageType> {};

template <>
struct hash<::media_session::mojom::MediaPictureInPictureState>
    : public mojo::internal::EnumHashImpl<::media_session::mojom::MediaPictureInPictureState> {};

template <>
struct hash<::media_session::mojom::MediaAudioVideoState>
    : public mojo::internal::EnumHashImpl<::media_session::mojom::MediaAudioVideoState> {};

template <>
struct hash<::media_session::mojom::MediaImageBitmapColorType>
    : public mojo::internal::EnumHashImpl<::media_session::mojom::MediaImageBitmapColorType> {};

template <>
struct hash<::media_session::mojom::MicrophoneState>
    : public mojo::internal::EnumHashImpl<::media_session::mojom::MicrophoneState> {};

template <>
struct hash<::media_session::mojom::CameraState>
    : public mojo::internal::EnumHashImpl<::media_session::mojom::CameraState> {};

template <>
struct hash<::media_session::mojom::MediaSessionInfo_SessionState>
    : public mojo::internal::EnumHashImpl<::media_session::mojom::MediaSessionInfo_SessionState> {};

template <>
struct hash<::media_session::mojom::MediaSession_SuspendType>
    : public mojo::internal::EnumHashImpl<::media_session::mojom::MediaSession_SuspendType> {};

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::media_session::mojom::MediaPlaybackState, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::media_session::mojom::MediaPlaybackState, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::media_session::mojom::MediaPlaybackState>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::media_session::mojom::MediaSessionAction, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::media_session::mojom::MediaSessionAction, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::media_session::mojom::MediaSessionAction>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::media_session::mojom::MediaSessionImageType, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::media_session::mojom::MediaSessionImageType, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::media_session::mojom::MediaSessionImageType>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::media_session::mojom::MediaPictureInPictureState, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::media_session::mojom::MediaPictureInPictureState, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::media_session::mojom::MediaPictureInPictureState>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::media_session::mojom::MediaAudioVideoState, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::media_session::mojom::MediaAudioVideoState, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::media_session::mojom::MediaAudioVideoState>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::media_session::mojom::MediaImageBitmapColorType, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::media_session::mojom::MediaImageBitmapColorType, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::media_session::mojom::MediaImageBitmapColorType>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::media_session::mojom::MicrophoneState, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::media_session::mojom::MicrophoneState, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::media_session::mojom::MicrophoneState>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::media_session::mojom::CameraState, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::media_session::mojom::CameraState, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::media_session::mojom::CameraState>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::media_session::mojom::MediaSessionInfo_SessionState, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::media_session::mojom::MediaSessionInfo_SessionState, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::media_session::mojom::MediaSessionInfo_SessionState>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::media_session::mojom::MediaSession_SuspendType, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::media_session::mojom::MediaSession_SuspendType, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::media_session::mojom::MediaSession_SuspendType>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::media_session::mojom::MediaImageDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::media_session::mojom::MediaImageDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::media_session::mojom::internal::MediaImage_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    decltype(Traits::src(input)) in_src = Traits::src(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->src)::BaseType> src_fragment(
            fragment.message());
    mojo::internal::Serialize<::url::mojom::UrlDataView>(
        in_src, src_fragment);
    fragment->src.Set(
        src_fragment.is_null() ? nullptr : src_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->src.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null src in MediaImage struct");
    decltype(Traits::type(input)) in_type = Traits::type(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->type)::BaseType> type_fragment(
            fragment.message());
    mojo::internal::Serialize<::mojo_base::mojom::String16DataView>(
        in_type, type_fragment);
    fragment->type.Set(
        type_fragment.is_null() ? nullptr : type_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->type.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null type in MediaImage struct");
    decltype(Traits::sizes(input)) in_sizes = Traits::sizes(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->sizes)::BaseType>
        sizes_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& sizes_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    mojo::internal::Serialize<mojo::ArrayDataView<::gfx::mojom::SizeDataView>>(
        in_sizes, sizes_fragment, &sizes_validate_params);
    fragment->sizes.Set(
        sizes_fragment.is_null() ? nullptr : sizes_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->sizes.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null sizes in MediaImage struct");
  }

  static bool Deserialize(::media_session::mojom::internal::MediaImage_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::media_session::mojom::MediaImageDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::media_session::mojom::ChapterInformationDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::media_session::mojom::ChapterInformationDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::media_session::mojom::internal::ChapterInformation_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    decltype(Traits::title(input)) in_title = Traits::title(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->title)::BaseType> title_fragment(
            fragment.message());
    mojo::internal::Serialize<::mojo_base::mojom::String16DataView>(
        in_title, title_fragment);
    fragment->title.Set(
        title_fragment.is_null() ? nullptr : title_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->title.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null title in ChapterInformation struct");
    decltype(Traits::startTime(input)) in_startTime = Traits::startTime(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->startTime)::BaseType> startTime_fragment(
            fragment.message());
    mojo::internal::Serialize<::mojo_base::mojom::TimeDeltaDataView>(
        in_startTime, startTime_fragment);
    fragment->startTime.Set(
        startTime_fragment.is_null() ? nullptr : startTime_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->startTime.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null startTime in ChapterInformation struct");
    decltype(Traits::artwork(input)) in_artwork = Traits::artwork(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->artwork)::BaseType>
        artwork_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& artwork_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    mojo::internal::Serialize<mojo::ArrayDataView<::media_session::mojom::MediaImageDataView>>(
        in_artwork, artwork_fragment, &artwork_validate_params);
    fragment->artwork.Set(
        artwork_fragment.is_null() ? nullptr : artwork_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->artwork.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null artwork in ChapterInformation struct");
  }

  static bool Deserialize(::media_session::mojom::internal::ChapterInformation_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::media_session::mojom::ChapterInformationDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::media_session::mojom::MediaMetadataDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::media_session::mojom::MediaMetadataDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::media_session::mojom::internal::MediaMetadata_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    decltype(Traits::title(input)) in_title = Traits::title(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->title)::BaseType> title_fragment(
            fragment.message());
    mojo::internal::Serialize<::mojo_base::mojom::String16DataView>(
        in_title, title_fragment);
    fragment->title.Set(
        title_fragment.is_null() ? nullptr : title_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->title.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null title in MediaMetadata struct");
    decltype(Traits::artist(input)) in_artist = Traits::artist(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->artist)::BaseType> artist_fragment(
            fragment.message());
    mojo::internal::Serialize<::mojo_base::mojom::String16DataView>(
        in_artist, artist_fragment);
    fragment->artist.Set(
        artist_fragment.is_null() ? nullptr : artist_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->artist.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null artist in MediaMetadata struct");
    decltype(Traits::album(input)) in_album = Traits::album(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->album)::BaseType> album_fragment(
            fragment.message());
    mojo::internal::Serialize<::mojo_base::mojom::String16DataView>(
        in_album, album_fragment);
    fragment->album.Set(
        album_fragment.is_null() ? nullptr : album_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->album.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null album in MediaMetadata struct");
    decltype(Traits::source_title(input)) in_source_title = Traits::source_title(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->source_title)::BaseType> source_title_fragment(
            fragment.message());
    mojo::internal::Serialize<::mojo_base::mojom::String16DataView>(
        in_source_title, source_title_fragment);
    fragment->source_title.Set(
        source_title_fragment.is_null() ? nullptr : source_title_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->source_title.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null source_title in MediaMetadata struct");
    decltype(Traits::chapters(input)) in_chapters = Traits::chapters(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->chapters)::BaseType>
        chapters_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& chapters_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    mojo::internal::Serialize<mojo::ArrayDataView<::media_session::mojom::ChapterInformationDataView>>(
        in_chapters, chapters_fragment, &chapters_validate_params);
    fragment->chapters.Set(
        chapters_fragment.is_null() ? nullptr : chapters_fragment.data());
  }

  static bool Deserialize(::media_session::mojom::internal::MediaMetadata_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::media_session::mojom::MediaMetadataDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::media_session::mojom::MediaImageBitmapDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::media_session::mojom::MediaImageBitmapDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::media_session::mojom::internal::MediaImageBitmap_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    fragment->width = Traits::width(input);
    fragment->height = Traits::height(input);
    decltype(Traits::pixel_data(input)) in_pixel_data = Traits::pixel_data(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->pixel_data)::BaseType>
        pixel_data_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& pixel_data_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    mojo::internal::Serialize<mojo::ArrayDataView<uint8_t>>(
        in_pixel_data, pixel_data_fragment, &pixel_data_validate_params);
    fragment->pixel_data.Set(
        pixel_data_fragment.is_null() ? nullptr : pixel_data_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->pixel_data.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null pixel_data in MediaImageBitmap struct");
    mojo::internal::Serialize<::media_session::mojom::MediaImageBitmapColorType>(
        Traits::color_type(input), &fragment->color_type);
  }

  static bool Deserialize(::media_session::mojom::internal::MediaImageBitmap_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::media_session::mojom::MediaImageBitmapDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::media_session::mojom::MediaPositionDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::media_session::mojom::MediaPositionDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::media_session::mojom::internal::MediaPosition_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    fragment->playback_rate = Traits::playback_rate(input);
    decltype(Traits::duration(input)) in_duration = Traits::duration(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->duration)::BaseType> duration_fragment(
            fragment.message());
    mojo::internal::Serialize<::mojo_base::mojom::TimeDeltaDataView>(
        in_duration, duration_fragment);
    fragment->duration.Set(
        duration_fragment.is_null() ? nullptr : duration_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->duration.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null duration in MediaPosition struct");
    decltype(Traits::position(input)) in_position = Traits::position(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->position)::BaseType> position_fragment(
            fragment.message());
    mojo::internal::Serialize<::mojo_base::mojom::TimeDeltaDataView>(
        in_position, position_fragment);
    fragment->position.Set(
        position_fragment.is_null() ? nullptr : position_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->position.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null position in MediaPosition struct");
    decltype(Traits::last_updated_time(input)) in_last_updated_time = Traits::last_updated_time(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->last_updated_time)::BaseType> last_updated_time_fragment(
            fragment.message());
    mojo::internal::Serialize<::mojo_base::mojom::TimeTicksDataView>(
        in_last_updated_time, last_updated_time_fragment);
    fragment->last_updated_time.Set(
        last_updated_time_fragment.is_null() ? nullptr : last_updated_time_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->last_updated_time.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null last_updated_time in MediaPosition struct");
    fragment->end_of_media = Traits::end_of_media(input);
  }

  static bool Deserialize(::media_session::mojom::internal::MediaPosition_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::media_session::mojom::MediaPositionDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::media_session::mojom::RemotePlaybackMetadataDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::media_session::mojom::RemotePlaybackMetadataDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::media_session::mojom::internal::RemotePlaybackMetadata_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    decltype(Traits::video_codec(input)) in_video_codec = Traits::video_codec(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->video_codec)::BaseType> video_codec_fragment(
            fragment.message());
    mojo::internal::Serialize<mojo::StringDataView>(
        in_video_codec, video_codec_fragment);
    fragment->video_codec.Set(
        video_codec_fragment.is_null() ? nullptr : video_codec_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->video_codec.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null video_codec in RemotePlaybackMetadata struct");
    decltype(Traits::audio_codec(input)) in_audio_codec = Traits::audio_codec(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->audio_codec)::BaseType> audio_codec_fragment(
            fragment.message());
    mojo::internal::Serialize<mojo::StringDataView>(
        in_audio_codec, audio_codec_fragment);
    fragment->audio_codec.Set(
        audio_codec_fragment.is_null() ? nullptr : audio_codec_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->audio_codec.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null audio_codec in RemotePlaybackMetadata struct");
    fragment->remote_playback_disabled = Traits::remote_playback_disabled(input);
    fragment->remote_playback_started = Traits::remote_playback_started(input);
    decltype(Traits::unused_field(input)) in_unused_field = Traits::unused_field(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->unused_field)::BaseType> unused_field_fragment(
            fragment.message());
    mojo::internal::Serialize<mojo::StringDataView>(
        in_unused_field, unused_field_fragment);
    fragment->unused_field.Set(
        unused_field_fragment.is_null() ? nullptr : unused_field_fragment.data());
    fragment->is_encrypted_media = Traits::is_encrypted_media(input);
  }

  static bool Deserialize(::media_session::mojom::internal::RemotePlaybackMetadata_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::media_session::mojom::RemotePlaybackMetadataDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::media_session::mojom::MediaSessionInfoDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::media_session::mojom::MediaSessionInfoDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::media_session::mojom::internal::MediaSessionInfo_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    mojo::internal::Serialize<::media_session::mojom::MediaSessionInfo_SessionState>(
        Traits::state(input), &fragment->state);
    fragment->force_duck = Traits::force_duck(input);
    mojo::internal::Serialize<::media_session::mojom::MediaPlaybackState>(
        Traits::playback_state(input), &fragment->playback_state);
    fragment->is_controllable = Traits::is_controllable(input);
    fragment->prefer_stop_for_gain_focus_loss = Traits::prefer_stop_for_gain_focus_loss(input);
    fragment->deprecated_is_sensitive = Traits::deprecated_is_sensitive(input);
    mojo::internal::Serialize<::media_session::mojom::MediaPictureInPictureState>(
        Traits::picture_in_picture_state(input), &fragment->picture_in_picture_state);
    mojo::internal::Serialize<::media_session::mojom::MediaAudioVideoState>(
        Traits::deprecated_audio_video_state(input), &fragment->deprecated_audio_video_state);
    decltype(Traits::audio_sink_id(input)) in_audio_sink_id = Traits::audio_sink_id(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->audio_sink_id)::BaseType> audio_sink_id_fragment(
            fragment.message());
    mojo::internal::Serialize<mojo::StringDataView>(
        in_audio_sink_id, audio_sink_id_fragment);
    fragment->audio_sink_id.Set(
        audio_sink_id_fragment.is_null() ? nullptr : audio_sink_id_fragment.data());
    decltype(Traits::audio_video_states(input)) in_audio_video_states = Traits::audio_video_states(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->audio_video_states)::BaseType>
        audio_video_states_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& audio_video_states_validate_params =
        mojo::internal::GetArrayOfEnumsValidator<0, false, ::media_session::mojom::internal::MediaAudioVideoState_Data::Validate>();
    mojo::internal::Serialize<mojo::ArrayDataView<::media_session::mojom::MediaAudioVideoState>>(
        in_audio_video_states, audio_video_states_fragment, &audio_video_states_validate_params);
    fragment->audio_video_states.Set(
        audio_video_states_fragment.is_null() ? nullptr : audio_video_states_fragment.data());
    mojo::internal::Serialize<::media_session::mojom::MicrophoneState>(
        Traits::microphone_state(input), &fragment->microphone_state);
    mojo::internal::Serialize<::media_session::mojom::CameraState>(
        Traits::camera_state(input), &fragment->camera_state);
    fragment->muted = Traits::muted(input);
    fragment->has_presentation = Traits::has_presentation(input);
    decltype(Traits::remote_playback_metadata(input)) in_remote_playback_metadata = Traits::remote_playback_metadata(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->remote_playback_metadata)::BaseType> remote_playback_metadata_fragment(
            fragment.message());
    mojo::internal::Serialize<::media_session::mojom::RemotePlaybackMetadataDataView>(
        in_remote_playback_metadata, remote_playback_metadata_fragment);
    fragment->remote_playback_metadata.Set(
        remote_playback_metadata_fragment.is_null() ? nullptr : remote_playback_metadata_fragment.data());
    fragment->hide_metadata = Traits::hide_metadata(input);
    fragment->ignore_for_active_session = Traits::ignore_for_active_session(input);
    fragment->meets_visibility_threshold = Traits::meets_visibility_threshold(input);
  }

  static bool Deserialize(::media_session::mojom::internal::MediaSessionInfo_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::media_session::mojom::MediaSessionInfoDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::media_session::mojom::MediaSessionDebugInfoDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::media_session::mojom::MediaSessionDebugInfoDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::media_session::mojom::internal::MediaSessionDebugInfo_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    decltype(Traits::name(input)) in_name = Traits::name(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->name)::BaseType> name_fragment(
            fragment.message());
    mojo::internal::Serialize<mojo::StringDataView>(
        in_name, name_fragment);
    fragment->name.Set(
        name_fragment.is_null() ? nullptr : name_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->name.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null name in MediaSessionDebugInfo struct");
    decltype(Traits::owner(input)) in_owner = Traits::owner(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->owner)::BaseType> owner_fragment(
            fragment.message());
    mojo::internal::Serialize<mojo::StringDataView>(
        in_owner, owner_fragment);
    fragment->owner.Set(
        owner_fragment.is_null() ? nullptr : owner_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->owner.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null owner in MediaSessionDebugInfo struct");
    decltype(Traits::state(input)) in_state = Traits::state(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->state)::BaseType> state_fragment(
            fragment.message());
    mojo::internal::Serialize<mojo::StringDataView>(
        in_state, state_fragment);
    fragment->state.Set(
        state_fragment.is_null() ? nullptr : state_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->state.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null state in MediaSessionDebugInfo struct");
  }

  static bool Deserialize(::media_session::mojom::internal::MediaSessionDebugInfo_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::media_session::mojom::MediaSessionDebugInfoDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace media_session::mojom {

inline void MediaImageDataView::GetSrcDataView(
    ::url::mojom::UrlDataView* output) {
  auto pointer = data_->src.Get();
  *output = ::url::mojom::UrlDataView(pointer, message_);
}
inline void MediaImageDataView::GetTypeDataView(
    ::mojo_base::mojom::String16DataView* output) {
  auto pointer = data_->type.Get();
  *output = ::mojo_base::mojom::String16DataView(pointer, message_);
}
inline void MediaImageDataView::GetSizesDataView(
    mojo::ArrayDataView<::gfx::mojom::SizeDataView>* output) {
  auto pointer = data_->sizes.Get();
  *output = mojo::ArrayDataView<::gfx::mojom::SizeDataView>(pointer, message_);
}


inline void ChapterInformationDataView::GetTitleDataView(
    ::mojo_base::mojom::String16DataView* output) {
  auto pointer = data_->title.Get();
  *output = ::mojo_base::mojom::String16DataView(pointer, message_);
}
inline void ChapterInformationDataView::GetStartTimeDataView(
    ::mojo_base::mojom::TimeDeltaDataView* output) {
  auto pointer = data_->startTime.Get();
  *output = ::mojo_base::mojom::TimeDeltaDataView(pointer, message_);
}
inline void ChapterInformationDataView::GetArtworkDataView(
    mojo::ArrayDataView<MediaImageDataView>* output) {
  auto pointer = data_->artwork.Get();
  *output = mojo::ArrayDataView<MediaImageDataView>(pointer, message_);
}


inline void MediaMetadataDataView::GetTitleDataView(
    ::mojo_base::mojom::String16DataView* output) {
  auto pointer = data_->title.Get();
  *output = ::mojo_base::mojom::String16DataView(pointer, message_);
}
inline void MediaMetadataDataView::GetArtistDataView(
    ::mojo_base::mojom::String16DataView* output) {
  auto pointer = data_->artist.Get();
  *output = ::mojo_base::mojom::String16DataView(pointer, message_);
}
inline void MediaMetadataDataView::GetAlbumDataView(
    ::mojo_base::mojom::String16DataView* output) {
  auto pointer = data_->album.Get();
  *output = ::mojo_base::mojom::String16DataView(pointer, message_);
}
inline void MediaMetadataDataView::GetSourceTitleDataView(
    ::mojo_base::mojom::String16DataView* output) {
  auto pointer = data_->source_title.Get();
  *output = ::mojo_base::mojom::String16DataView(pointer, message_);
}
inline void MediaMetadataDataView::GetChaptersDataView(
    mojo::ArrayDataView<ChapterInformationDataView>* output) {
  auto pointer = data_->header_.version >= 21
                 ? data_->chapters.Get() : nullptr;
  *output = mojo::ArrayDataView<ChapterInformationDataView>(pointer, message_);
}


inline void MediaImageBitmapDataView::GetPixelDataDataView(
    mojo::ArrayDataView<uint8_t>* output) {
  auto pointer = data_->pixel_data.Get();
  *output = mojo::ArrayDataView<uint8_t>(pointer, message_);
}


inline void MediaPositionDataView::GetDurationDataView(
    ::mojo_base::mojom::TimeDeltaDataView* output) {
  auto pointer = data_->duration.Get();
  *output = ::mojo_base::mojom::TimeDeltaDataView(pointer, message_);
}
inline void MediaPositionDataView::GetPositionDataView(
    ::mojo_base::mojom::TimeDeltaDataView* output) {
  auto pointer = data_->position.Get();
  *output = ::mojo_base::mojom::TimeDeltaDataView(pointer, message_);
}
inline void MediaPositionDataView::GetLastUpdatedTimeDataView(
    ::mojo_base::mojom::TimeTicksDataView* output) {
  auto pointer = data_->last_updated_time.Get();
  *output = ::mojo_base::mojom::TimeTicksDataView(pointer, message_);
}


inline void RemotePlaybackMetadataDataView::GetVideoCodecDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->video_codec.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void RemotePlaybackMetadataDataView::GetAudioCodecDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->audio_codec.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void RemotePlaybackMetadataDataView::GetUnusedFieldDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->header_.version >= 17
                 ? data_->unused_field.Get() : nullptr;
  *output = mojo::StringDataView(pointer, message_);
}


inline void MediaSessionInfoDataView::GetAudioSinkIdDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->header_.version >= 9
                 ? data_->audio_sink_id.Get() : nullptr;
  *output = mojo::StringDataView(pointer, message_);
}
inline void MediaSessionInfoDataView::GetAudioVideoStatesDataView(
    mojo::ArrayDataView<MediaAudioVideoState>* output) {
  auto pointer = data_->header_.version >= 10
                 ? data_->audio_video_states.Get() : nullptr;
  *output = mojo::ArrayDataView<MediaAudioVideoState>(pointer, message_);
}
inline void MediaSessionInfoDataView::GetRemotePlaybackMetadataDataView(
    RemotePlaybackMetadataDataView* output) {
  auto pointer = data_->header_.version >= 15
                 ? data_->remote_playback_metadata.Get() : nullptr;
  *output = RemotePlaybackMetadataDataView(pointer, message_);
}


inline void MediaSessionDebugInfoDataView::GetNameDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->name.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void MediaSessionDebugInfoDataView::GetOwnerDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->owner.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void MediaSessionDebugInfoDataView::GetStateDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->state.Get();
  *output = mojo::StringDataView(pointer, message_);
}



}  // media_session::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

namespace perfetto {

template <>
struct  TraceFormatTraits<::media_session::mojom::MediaPlaybackState> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::media_session::mojom::MediaPlaybackState value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct  TraceFormatTraits<::media_session::mojom::MediaSessionAction> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::media_session::mojom::MediaSessionAction value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct  TraceFormatTraits<::media_session::mojom::MediaSessionImageType> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::media_session::mojom::MediaSessionImageType value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct  TraceFormatTraits<::media_session::mojom::MediaPictureInPictureState> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::media_session::mojom::MediaPictureInPictureState value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct  TraceFormatTraits<::media_session::mojom::MediaAudioVideoState> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::media_session::mojom::MediaAudioVideoState value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct  TraceFormatTraits<::media_session::mojom::MediaImageBitmapColorType> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::media_session::mojom::MediaImageBitmapColorType value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct  TraceFormatTraits<::media_session::mojom::MicrophoneState> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::media_session::mojom::MicrophoneState value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct  TraceFormatTraits<::media_session::mojom::CameraState> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::media_session::mojom::CameraState value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct  TraceFormatTraits<::media_session::mojom::MediaSessionInfo_SessionState> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::media_session::mojom::MediaSessionInfo_SessionState value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct  TraceFormatTraits<::media_session::mojom::MediaSession_SuspendType> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::media_session::mojom::MediaSession_SuspendType value);
};

} // namespace perfetto

#endif  // SERVICES_MEDIA_SESSION_PUBLIC_MOJOM_MEDIA_SESSION_MOJOM_SHARED_H_