// services/network/public/mojom/first_party_sets.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_NETWORK_PUBLIC_MOJOM_FIRST_PARTY_SETS_MOJOM_H_
#define SERVICES_NETWORK_PUBLIC_MOJOM_FIRST_PARTY_SETS_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>

#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "services/network/public/mojom/first_party_sets.mojom-features.h"  // IWYU pragma: export
#include "services/network/public/mojom/first_party_sets.mojom-shared.h"  // IWYU pragma: export
#include "services/network/public/mojom/first_party_sets.mojom-forward.h"  // IWYU pragma: export
#include "mojo/public/mojom/base/version.mojom.h"
#include "services/network/public/mojom/schemeful_site.mojom.h"
#include <string>
#include <vector>




#include "services/network/public/cpp/first_party_sets_mojom_traits.h"




namespace network::mojom {





class  SiteIndex {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<SiteIndex, T>::value>;
  using DataView = SiteIndexDataView;
  using Data_ = internal::SiteIndex_Data;

  template <typename... Args>
  static SiteIndexPtr New(Args&&... args) {
    return SiteIndexPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static SiteIndexPtr From(const U& u) {
    return mojo::TypeConverter<SiteIndexPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, SiteIndex>::Convert(*this);
  }


  SiteIndex();

  explicit SiteIndex(
      uint32_t value);


  ~SiteIndex();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = SiteIndexPtr>
  SiteIndexPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, SiteIndex::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, SiteIndex::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, SiteIndex::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        SiteIndex::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        SiteIndex::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::SiteIndex_UnserializedMessageContext<
            UserType, SiteIndex::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<SiteIndex::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return SiteIndex::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::SiteIndex_UnserializedMessageContext<
            UserType, SiteIndex::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<SiteIndex::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  uint32_t value;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, SiteIndex::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, SiteIndex::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, SiteIndex::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, SiteIndex::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}














class  FirstPartySetEntry {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<FirstPartySetEntry, T>::value>;
  using DataView = FirstPartySetEntryDataView;
  using Data_ = internal::FirstPartySetEntry_Data;

  template <typename... Args>
  static FirstPartySetEntryPtr New(Args&&... args) {
    return FirstPartySetEntryPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static FirstPartySetEntryPtr From(const U& u) {
    return mojo::TypeConverter<FirstPartySetEntryPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, FirstPartySetEntry>::Convert(*this);
  }


  FirstPartySetEntry();

  FirstPartySetEntry(
      const ::net::SchemefulSite& primary,
      ::net::SiteType site_type,
      const std::optional<::net::FirstPartySetEntry::SiteIndex>& site_index);


  ~FirstPartySetEntry();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = FirstPartySetEntryPtr>
  FirstPartySetEntryPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, FirstPartySetEntry::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, FirstPartySetEntry::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, FirstPartySetEntry::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        FirstPartySetEntry::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        FirstPartySetEntry::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::FirstPartySetEntry_UnserializedMessageContext<
            UserType, FirstPartySetEntry::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<FirstPartySetEntry::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return FirstPartySetEntry::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::FirstPartySetEntry_UnserializedMessageContext<
            UserType, FirstPartySetEntry::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<FirstPartySetEntry::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::net::SchemefulSite primary;
  
  ::net::SiteType site_type;
  
  std::optional<::net::FirstPartySetEntry::SiteIndex> site_index;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, FirstPartySetEntry::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, FirstPartySetEntry::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, FirstPartySetEntry::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, FirstPartySetEntry::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  FirstPartySetMetadata {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<FirstPartySetMetadata, T>::value>;
  using DataView = FirstPartySetMetadataDataView;
  using Data_ = internal::FirstPartySetMetadata_Data;

  template <typename... Args>
  static FirstPartySetMetadataPtr New(Args&&... args) {
    return FirstPartySetMetadataPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static FirstPartySetMetadataPtr From(const U& u) {
    return mojo::TypeConverter<FirstPartySetMetadataPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, FirstPartySetMetadata>::Convert(*this);
  }


  FirstPartySetMetadata();

  FirstPartySetMetadata(
      const std::optional<::net::FirstPartySetEntry>& frame_entry,
      const std::optional<::net::FirstPartySetEntry>& top_frame_entry);


  ~FirstPartySetMetadata();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = FirstPartySetMetadataPtr>
  FirstPartySetMetadataPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, FirstPartySetMetadata::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, FirstPartySetMetadata::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, FirstPartySetMetadata::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        FirstPartySetMetadata::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        FirstPartySetMetadata::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::FirstPartySetMetadata_UnserializedMessageContext<
            UserType, FirstPartySetMetadata::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<FirstPartySetMetadata::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return FirstPartySetMetadata::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::FirstPartySetMetadata_UnserializedMessageContext<
            UserType, FirstPartySetMetadata::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<FirstPartySetMetadata::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::optional<::net::FirstPartySetEntry> frame_entry;
  
  std::optional<::net::FirstPartySetEntry> top_frame_entry;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, FirstPartySetMetadata::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, FirstPartySetMetadata::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, FirstPartySetMetadata::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, FirstPartySetMetadata::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  FirstPartySetEntryOverride {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<FirstPartySetEntryOverride, T>::value>;
  using DataView = FirstPartySetEntryOverrideDataView;
  using Data_ = internal::FirstPartySetEntryOverride_Data;

  template <typename... Args>
  static FirstPartySetEntryOverridePtr New(Args&&... args) {
    return FirstPartySetEntryOverridePtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static FirstPartySetEntryOverridePtr From(const U& u) {
    return mojo::TypeConverter<FirstPartySetEntryOverridePtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, FirstPartySetEntryOverride>::Convert(*this);
  }


  FirstPartySetEntryOverride();

  explicit FirstPartySetEntryOverride(
      const std::optional<::net::FirstPartySetEntry>& entry);


  ~FirstPartySetEntryOverride();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = FirstPartySetEntryOverridePtr>
  FirstPartySetEntryOverridePtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, FirstPartySetEntryOverride::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, FirstPartySetEntryOverride::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, FirstPartySetEntryOverride::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        FirstPartySetEntryOverride::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        FirstPartySetEntryOverride::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::FirstPartySetEntryOverride_UnserializedMessageContext<
            UserType, FirstPartySetEntryOverride::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<FirstPartySetEntryOverride::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return FirstPartySetEntryOverride::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::FirstPartySetEntryOverride_UnserializedMessageContext<
            UserType, FirstPartySetEntryOverride::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<FirstPartySetEntryOverride::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::optional<::net::FirstPartySetEntry> entry;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, FirstPartySetEntryOverride::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, FirstPartySetEntryOverride::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, FirstPartySetEntryOverride::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, FirstPartySetEntryOverride::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  FirstPartySetsContextConfig {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<FirstPartySetsContextConfig, T>::value>;
  using DataView = FirstPartySetsContextConfigDataView;
  using Data_ = internal::FirstPartySetsContextConfig_Data;

  template <typename... Args>
  static FirstPartySetsContextConfigPtr New(Args&&... args) {
    return FirstPartySetsContextConfigPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static FirstPartySetsContextConfigPtr From(const U& u) {
    return mojo::TypeConverter<FirstPartySetsContextConfigPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, FirstPartySetsContextConfig>::Convert(*this);
  }


  FirstPartySetsContextConfig();

  explicit FirstPartySetsContextConfig(
      const base::flat_map<::net::SchemefulSite, ::net::FirstPartySetEntryOverride>& customizations);


  ~FirstPartySetsContextConfig();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = FirstPartySetsContextConfigPtr>
  FirstPartySetsContextConfigPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, FirstPartySetsContextConfig::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, FirstPartySetsContextConfig::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, FirstPartySetsContextConfig::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        FirstPartySetsContextConfig::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        FirstPartySetsContextConfig::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::FirstPartySetsContextConfig_UnserializedMessageContext<
            UserType, FirstPartySetsContextConfig::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<FirstPartySetsContextConfig::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return FirstPartySetsContextConfig::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::FirstPartySetsContextConfig_UnserializedMessageContext<
            UserType, FirstPartySetsContextConfig::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<FirstPartySetsContextConfig::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  base::flat_map<::net::SchemefulSite, ::net::FirstPartySetEntryOverride> customizations;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, FirstPartySetsContextConfig::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, FirstPartySetsContextConfig::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, FirstPartySetsContextConfig::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, FirstPartySetsContextConfig::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  FirstPartySetsCacheFilter {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<FirstPartySetsCacheFilter, T>::value>;
  using DataView = FirstPartySetsCacheFilterDataView;
  using Data_ = internal::FirstPartySetsCacheFilter_Data;

  template <typename... Args>
  static FirstPartySetsCacheFilterPtr New(Args&&... args) {
    return FirstPartySetsCacheFilterPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static FirstPartySetsCacheFilterPtr From(const U& u) {
    return mojo::TypeConverter<FirstPartySetsCacheFilterPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, FirstPartySetsCacheFilter>::Convert(*this);
  }


  FirstPartySetsCacheFilter();

  FirstPartySetsCacheFilter(
      const base::flat_map<::net::SchemefulSite, int64_t>& filter,
      int64_t browser_run_id);


  ~FirstPartySetsCacheFilter();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = FirstPartySetsCacheFilterPtr>
  FirstPartySetsCacheFilterPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, FirstPartySetsCacheFilter::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, FirstPartySetsCacheFilter::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, FirstPartySetsCacheFilter::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        FirstPartySetsCacheFilter::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        FirstPartySetsCacheFilter::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::FirstPartySetsCacheFilter_UnserializedMessageContext<
            UserType, FirstPartySetsCacheFilter::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<FirstPartySetsCacheFilter::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return FirstPartySetsCacheFilter::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::FirstPartySetsCacheFilter_UnserializedMessageContext<
            UserType, FirstPartySetsCacheFilter::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<FirstPartySetsCacheFilter::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  base::flat_map<::net::SchemefulSite, int64_t> filter;
  
  int64_t browser_run_id;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, FirstPartySetsCacheFilter::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, FirstPartySetsCacheFilter::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, FirstPartySetsCacheFilter::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, FirstPartySetsCacheFilter::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  GlobalFirstPartySets {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<GlobalFirstPartySets, T>::value>;
  using DataView = GlobalFirstPartySetsDataView;
  using Data_ = internal::GlobalFirstPartySets_Data;

  template <typename... Args>
  static GlobalFirstPartySetsPtr New(Args&&... args) {
    return GlobalFirstPartySetsPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static GlobalFirstPartySetsPtr From(const U& u) {
    return mojo::TypeConverter<GlobalFirstPartySetsPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, GlobalFirstPartySets>::Convert(*this);
  }


  GlobalFirstPartySets();

  GlobalFirstPartySets(
      const ::base::Version& public_sets_version,
      const base::flat_map<::net::SchemefulSite, ::net::FirstPartySetEntry>& sets,
      const base::flat_map<::net::SchemefulSite, ::net::SchemefulSite>& aliases,
      ::net::FirstPartySetsContextConfig manual_config,
      const base::flat_map<::net::SchemefulSite, ::net::SchemefulSite>& manual_aliases);

GlobalFirstPartySets(const GlobalFirstPartySets&) = delete;
GlobalFirstPartySets& operator=(const GlobalFirstPartySets&) = delete;

  ~GlobalFirstPartySets();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = GlobalFirstPartySetsPtr>
  GlobalFirstPartySetsPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, GlobalFirstPartySets::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, GlobalFirstPartySets::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, GlobalFirstPartySets::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        GlobalFirstPartySets::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        GlobalFirstPartySets::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::GlobalFirstPartySets_UnserializedMessageContext<
            UserType, GlobalFirstPartySets::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<GlobalFirstPartySets::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return GlobalFirstPartySets::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::GlobalFirstPartySets_UnserializedMessageContext<
            UserType, GlobalFirstPartySets::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<GlobalFirstPartySets::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::base::Version public_sets_version;
  
  base::flat_map<::net::SchemefulSite, ::net::FirstPartySetEntry> sets;
  
  base::flat_map<::net::SchemefulSite, ::net::SchemefulSite> aliases;
  
  ::net::FirstPartySetsContextConfig manual_config;
  
  base::flat_map<::net::SchemefulSite, ::net::SchemefulSite> manual_aliases;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, GlobalFirstPartySets::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, GlobalFirstPartySets::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, GlobalFirstPartySets::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, GlobalFirstPartySets::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
SiteIndexPtr SiteIndex::Clone() const {
  return New(
      mojo::Clone(value)
  );
}

template <typename T, SiteIndex::EnableIfSame<T>*>
bool SiteIndex::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->value, other_struct.value))
    return false;
  return true;
}

template <typename T, SiteIndex::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.value < rhs.value)
    return true;
  if (rhs.value < lhs.value)
    return false;
  return false;
}
template <typename StructPtrType>
FirstPartySetEntryPtr FirstPartySetEntry::Clone() const {
  return New(
      mojo::Clone(primary),
      mojo::Clone(site_type),
      mojo::Clone(site_index)
  );
}

template <typename T, FirstPartySetEntry::EnableIfSame<T>*>
bool FirstPartySetEntry::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->primary, other_struct.primary))
    return false;
  if (!mojo::Equals(this->site_type, other_struct.site_type))
    return false;
  if (!mojo::Equals(this->site_index, other_struct.site_index))
    return false;
  return true;
}

template <typename T, FirstPartySetEntry::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.primary < rhs.primary)
    return true;
  if (rhs.primary < lhs.primary)
    return false;
  if (lhs.site_type < rhs.site_type)
    return true;
  if (rhs.site_type < lhs.site_type)
    return false;
  if (lhs.site_index < rhs.site_index)
    return true;
  if (rhs.site_index < lhs.site_index)
    return false;
  return false;
}
template <typename StructPtrType>
FirstPartySetMetadataPtr FirstPartySetMetadata::Clone() const {
  return New(
      mojo::Clone(frame_entry),
      mojo::Clone(top_frame_entry)
  );
}

template <typename T, FirstPartySetMetadata::EnableIfSame<T>*>
bool FirstPartySetMetadata::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->frame_entry, other_struct.frame_entry))
    return false;
  if (!mojo::Equals(this->top_frame_entry, other_struct.top_frame_entry))
    return false;
  return true;
}

template <typename T, FirstPartySetMetadata::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.frame_entry < rhs.frame_entry)
    return true;
  if (rhs.frame_entry < lhs.frame_entry)
    return false;
  if (lhs.top_frame_entry < rhs.top_frame_entry)
    return true;
  if (rhs.top_frame_entry < lhs.top_frame_entry)
    return false;
  return false;
}
template <typename StructPtrType>
FirstPartySetEntryOverridePtr FirstPartySetEntryOverride::Clone() const {
  return New(
      mojo::Clone(entry)
  );
}

template <typename T, FirstPartySetEntryOverride::EnableIfSame<T>*>
bool FirstPartySetEntryOverride::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->entry, other_struct.entry))
    return false;
  return true;
}

template <typename T, FirstPartySetEntryOverride::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.entry < rhs.entry)
    return true;
  if (rhs.entry < lhs.entry)
    return false;
  return false;
}
template <typename StructPtrType>
FirstPartySetsContextConfigPtr FirstPartySetsContextConfig::Clone() const {
  return New(
      mojo::Clone(customizations)
  );
}

template <typename T, FirstPartySetsContextConfig::EnableIfSame<T>*>
bool FirstPartySetsContextConfig::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->customizations, other_struct.customizations))
    return false;
  return true;
}

template <typename T, FirstPartySetsContextConfig::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.customizations < rhs.customizations)
    return true;
  if (rhs.customizations < lhs.customizations)
    return false;
  return false;
}
template <typename StructPtrType>
FirstPartySetsCacheFilterPtr FirstPartySetsCacheFilter::Clone() const {
  return New(
      mojo::Clone(filter),
      mojo::Clone(browser_run_id)
  );
}

template <typename T, FirstPartySetsCacheFilter::EnableIfSame<T>*>
bool FirstPartySetsCacheFilter::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->filter, other_struct.filter))
    return false;
  if (!mojo::Equals(this->browser_run_id, other_struct.browser_run_id))
    return false;
  return true;
}

template <typename T, FirstPartySetsCacheFilter::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.filter < rhs.filter)
    return true;
  if (rhs.filter < lhs.filter)
    return false;
  if (lhs.browser_run_id < rhs.browser_run_id)
    return true;
  if (rhs.browser_run_id < lhs.browser_run_id)
    return false;
  return false;
}
template <typename StructPtrType>
GlobalFirstPartySetsPtr GlobalFirstPartySets::Clone() const {
  return New(
      mojo::Clone(public_sets_version),
      mojo::Clone(sets),
      mojo::Clone(aliases),
      mojo::Clone(manual_config),
      mojo::Clone(manual_aliases)
  );
}

template <typename T, GlobalFirstPartySets::EnableIfSame<T>*>
bool GlobalFirstPartySets::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->public_sets_version, other_struct.public_sets_version))
    return false;
  if (!mojo::Equals(this->sets, other_struct.sets))
    return false;
  if (!mojo::Equals(this->aliases, other_struct.aliases))
    return false;
  if (!mojo::Equals(this->manual_config, other_struct.manual_config))
    return false;
  if (!mojo::Equals(this->manual_aliases, other_struct.manual_aliases))
    return false;
  return true;
}

template <typename T, GlobalFirstPartySets::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.public_sets_version < rhs.public_sets_version)
    return true;
  if (rhs.public_sets_version < lhs.public_sets_version)
    return false;
  if (lhs.sets < rhs.sets)
    return true;
  if (rhs.sets < lhs.sets)
    return false;
  if (lhs.aliases < rhs.aliases)
    return true;
  if (rhs.aliases < lhs.aliases)
    return false;
  if (lhs.manual_config < rhs.manual_config)
    return true;
  if (rhs.manual_config < lhs.manual_config)
    return false;
  if (lhs.manual_aliases < rhs.manual_aliases)
    return true;
  if (rhs.manual_aliases < lhs.manual_aliases)
    return false;
  return false;
}


}  // network::mojom

namespace mojo {


template <>
struct  StructTraits<::network::mojom::SiteIndex::DataView,
                                         ::network::mojom::SiteIndexPtr> {
  static bool IsNull(const ::network::mojom::SiteIndexPtr& input) { return !input; }
  static void SetToNull(::network::mojom::SiteIndexPtr* output) { output->reset(); }

  static decltype(::network::mojom::SiteIndex::value) value(
      const ::network::mojom::SiteIndexPtr& input) {
    return input->value;
  }

  static bool Read(::network::mojom::SiteIndex::DataView input, ::network::mojom::SiteIndexPtr* output);
};


template <>
struct  StructTraits<::network::mojom::FirstPartySetEntry::DataView,
                                         ::network::mojom::FirstPartySetEntryPtr> {
  static bool IsNull(const ::network::mojom::FirstPartySetEntryPtr& input) { return !input; }
  static void SetToNull(::network::mojom::FirstPartySetEntryPtr* output) { output->reset(); }

  static const decltype(::network::mojom::FirstPartySetEntry::primary)& primary(
      const ::network::mojom::FirstPartySetEntryPtr& input) {
    return input->primary;
  }

  static decltype(::network::mojom::FirstPartySetEntry::site_type) site_type(
      const ::network::mojom::FirstPartySetEntryPtr& input) {
    return input->site_type;
  }

  static const decltype(::network::mojom::FirstPartySetEntry::site_index)& site_index(
      const ::network::mojom::FirstPartySetEntryPtr& input) {
    return input->site_index;
  }

  static bool Read(::network::mojom::FirstPartySetEntry::DataView input, ::network::mojom::FirstPartySetEntryPtr* output);
};


template <>
struct  StructTraits<::network::mojom::FirstPartySetMetadata::DataView,
                                         ::network::mojom::FirstPartySetMetadataPtr> {
  static bool IsNull(const ::network::mojom::FirstPartySetMetadataPtr& input) { return !input; }
  static void SetToNull(::network::mojom::FirstPartySetMetadataPtr* output) { output->reset(); }

  static const decltype(::network::mojom::FirstPartySetMetadata::frame_entry)& frame_entry(
      const ::network::mojom::FirstPartySetMetadataPtr& input) {
    return input->frame_entry;
  }

  static const decltype(::network::mojom::FirstPartySetMetadata::top_frame_entry)& top_frame_entry(
      const ::network::mojom::FirstPartySetMetadataPtr& input) {
    return input->top_frame_entry;
  }

  static bool Read(::network::mojom::FirstPartySetMetadata::DataView input, ::network::mojom::FirstPartySetMetadataPtr* output);
};


template <>
struct  StructTraits<::network::mojom::FirstPartySetEntryOverride::DataView,
                                         ::network::mojom::FirstPartySetEntryOverridePtr> {
  static bool IsNull(const ::network::mojom::FirstPartySetEntryOverridePtr& input) { return !input; }
  static void SetToNull(::network::mojom::FirstPartySetEntryOverridePtr* output) { output->reset(); }

  static const decltype(::network::mojom::FirstPartySetEntryOverride::entry)& entry(
      const ::network::mojom::FirstPartySetEntryOverridePtr& input) {
    return input->entry;
  }

  static bool Read(::network::mojom::FirstPartySetEntryOverride::DataView input, ::network::mojom::FirstPartySetEntryOverridePtr* output);
};


template <>
struct  StructTraits<::network::mojom::FirstPartySetsContextConfig::DataView,
                                         ::network::mojom::FirstPartySetsContextConfigPtr> {
  static bool IsNull(const ::network::mojom::FirstPartySetsContextConfigPtr& input) { return !input; }
  static void SetToNull(::network::mojom::FirstPartySetsContextConfigPtr* output) { output->reset(); }

  static const decltype(::network::mojom::FirstPartySetsContextConfig::customizations)& customizations(
      const ::network::mojom::FirstPartySetsContextConfigPtr& input) {
    return input->customizations;
  }

  static bool Read(::network::mojom::FirstPartySetsContextConfig::DataView input, ::network::mojom::FirstPartySetsContextConfigPtr* output);
};


template <>
struct  StructTraits<::network::mojom::FirstPartySetsCacheFilter::DataView,
                                         ::network::mojom::FirstPartySetsCacheFilterPtr> {
  static bool IsNull(const ::network::mojom::FirstPartySetsCacheFilterPtr& input) { return !input; }
  static void SetToNull(::network::mojom::FirstPartySetsCacheFilterPtr* output) { output->reset(); }

  static const decltype(::network::mojom::FirstPartySetsCacheFilter::filter)& filter(
      const ::network::mojom::FirstPartySetsCacheFilterPtr& input) {
    return input->filter;
  }

  static decltype(::network::mojom::FirstPartySetsCacheFilter::browser_run_id) browser_run_id(
      const ::network::mojom::FirstPartySetsCacheFilterPtr& input) {
    return input->browser_run_id;
  }

  static bool Read(::network::mojom::FirstPartySetsCacheFilter::DataView input, ::network::mojom::FirstPartySetsCacheFilterPtr* output);
};


template <>
struct  StructTraits<::network::mojom::GlobalFirstPartySets::DataView,
                                         ::network::mojom::GlobalFirstPartySetsPtr> {
  static bool IsNull(const ::network::mojom::GlobalFirstPartySetsPtr& input) { return !input; }
  static void SetToNull(::network::mojom::GlobalFirstPartySetsPtr* output) { output->reset(); }

  static const decltype(::network::mojom::GlobalFirstPartySets::public_sets_version)& public_sets_version(
      const ::network::mojom::GlobalFirstPartySetsPtr& input) {
    return input->public_sets_version;
  }

  static const decltype(::network::mojom::GlobalFirstPartySets::sets)& sets(
      const ::network::mojom::GlobalFirstPartySetsPtr& input) {
    return input->sets;
  }

  static const decltype(::network::mojom::GlobalFirstPartySets::aliases)& aliases(
      const ::network::mojom::GlobalFirstPartySetsPtr& input) {
    return input->aliases;
  }

  static const decltype(::network::mojom::GlobalFirstPartySets::manual_config)& manual_config(
      const ::network::mojom::GlobalFirstPartySetsPtr& input) {
    return input->manual_config;
  }

  static const decltype(::network::mojom::GlobalFirstPartySets::manual_aliases)& manual_aliases(
      const ::network::mojom::GlobalFirstPartySetsPtr& input) {
    return input->manual_aliases;
  }

  static bool Read(::network::mojom::GlobalFirstPartySets::DataView input, ::network::mojom::GlobalFirstPartySetsPtr* output);
};

}  // namespace mojo

#endif  // SERVICES_NETWORK_PUBLIC_MOJOM_FIRST_PARTY_SETS_MOJOM_H_