// services/proxy_resolver/public/mojom/proxy_resolver.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "services/proxy_resolver/public/mojom/proxy_resolver.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "mojo/public/cpp/bindings/features.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "services/proxy_resolver/public/mojom/proxy_resolver.mojom-params-data.h"
#include "services/proxy_resolver/public/mojom/proxy_resolver.mojom-shared-message-ids.h"

#include "services/proxy_resolver/public/mojom/proxy_resolver.mojom-import-headers.h"
#include "services/proxy_resolver/public/mojom/proxy_resolver.mojom-test-utils.h"
#include "net/cert/cert_verify_result.h"


namespace proxy_resolver::mojom {
ProxyInfo::ProxyInfo()
    : proxy_chains() {}

ProxyInfo::ProxyInfo(
    std::vector<::net::ProxyChain> proxy_chains_in)
    : proxy_chains(std::move(proxy_chains_in)) {}

ProxyInfo::~ProxyInfo() = default;

void ProxyInfo::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "proxy_chains"), this->proxy_chains,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::vector<::net::ProxyChain>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool ProxyInfo::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
const char HostResolverRequestClient::Name_[] = "proxy_resolver.mojom.HostResolverRequestClient";

HostResolverRequestClient::IPCStableHashFunction HostResolverRequestClient::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::HostResolverRequestClient>(message.name())) {
    case messages::HostResolverRequestClient::kReportResult: {
      return &HostResolverRequestClient::ReportResult_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* HostResolverRequestClient::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::HostResolverRequestClient>(message.name())) {
      case messages::HostResolverRequestClient::kReportResult:
            return "Receive proxy_resolver::mojom::HostResolverRequestClient::ReportResult";
    }
  } else {
    switch (static_cast<messages::HostResolverRequestClient>(message.name())) {
      case messages::HostResolverRequestClient::kReportResult:
            return "Receive reply proxy_resolver::mojom::HostResolverRequestClient::ReportResult";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t HostResolverRequestClient::ReportResult_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)proxy_resolver::mojom::HostResolverRequestClient::ReportResult");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

HostResolverRequestClientProxy::HostResolverRequestClientProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void HostResolverRequestClientProxy::ReportResult(
    int32_t in_error, const std::vector<::net::IPAddress>& in_result) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send proxy_resolver::mojom::HostResolverRequestClient::ReportResult", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("error"), in_error,
                        "<value of type int32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result"), in_result,
                        "<value of type const std::vector<::net::IPAddress>&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::HostResolverRequestClient::kReportResult), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::proxy_resolver::mojom::internal::HostResolverRequestClient_ReportResult_Params_Data> params(
          message);
  params.Allocate();
  params->error = in_error;
  mojo::internal::MessageFragment<
      typename decltype(params->result)::BaseType>
      result_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& result_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  mojo::internal::Serialize<mojo::ArrayDataView<::network::mojom::IPAddressDataView>>(
      in_result, result_fragment, &result_validate_params);
  params->result.Set(
      result_fragment.is_null() ? nullptr : result_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->result.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null result in HostResolverRequestClient.ReportResult request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(HostResolverRequestClient::Name_);
  message.set_method_name("ReportResult");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool HostResolverRequestClientStubDispatch::Accept(
    HostResolverRequestClient* impl,
    mojo::Message* message) {
  switch (static_cast<messages::HostResolverRequestClient>(message->header()->name)) {
    case messages::HostResolverRequestClient::kReportResult: {
      DCHECK(message->is_serialized());
      internal::HostResolverRequestClient_ReportResult_Params_Data* params =
          reinterpret_cast<internal::HostResolverRequestClient_ReportResult_Params_Data*>(
              message->mutable_payload());
      
      
      // Validation for HostResolverRequestClient.0
      bool success = true;
      int32_t p_error{};
      std::vector<::net::IPAddress> p_result{};
      HostResolverRequestClient_ReportResult_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_error = input_data_view.error();
      if (success && !input_data_view.ReadResult(&p_result))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            HostResolverRequestClient::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ReportResult(        
        std::move(p_error), 
        std::move(p_result));
      return true;
    }
  }
  return false;
}

// static
bool HostResolverRequestClientStubDispatch::AcceptWithResponder(
    HostResolverRequestClient* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::HostResolverRequestClient>(message->header()->name)) {
    case messages::HostResolverRequestClient::kReportResult: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kHostResolverRequestClientValidationInfo[] = {
    {base::to_underlying(messages::HostResolverRequestClient::kReportResult),
     { &internal::HostResolverRequestClient_ReportResult_Params_Data::Validate,
      nullptr /* no response */}},
};

bool HostResolverRequestClientRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::proxy_resolver::mojom::HostResolverRequestClient::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kHostResolverRequestClientValidationInfo);
}

const char ProxyResolver::Name_[] = "proxy_resolver.mojom.ProxyResolver";

ProxyResolver::IPCStableHashFunction ProxyResolver::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::ProxyResolver>(message.name())) {
    case messages::ProxyResolver::kGetProxyForUrl: {
      return &ProxyResolver::GetProxyForUrl_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* ProxyResolver::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::ProxyResolver>(message.name())) {
      case messages::ProxyResolver::kGetProxyForUrl:
            return "Receive proxy_resolver::mojom::ProxyResolver::GetProxyForUrl";
    }
  } else {
    switch (static_cast<messages::ProxyResolver>(message.name())) {
      case messages::ProxyResolver::kGetProxyForUrl:
            return "Receive reply proxy_resolver::mojom::ProxyResolver::GetProxyForUrl";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t ProxyResolver::GetProxyForUrl_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)proxy_resolver::mojom::ProxyResolver::GetProxyForUrl");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

ProxyResolverProxy::ProxyResolverProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void ProxyResolverProxy::GetProxyForUrl(
    const ::GURL& in_url, const ::net::NetworkAnonymizationKey& in_network_anonymization_key, ::mojo::PendingRemote<ProxyResolverRequestClient> in_client) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send proxy_resolver::mojom::ProxyResolver::GetProxyForUrl", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("url"), in_url,
                        "<value of type const ::GURL&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("network_anonymization_key"), in_network_anonymization_key,
                        "<value of type const ::net::NetworkAnonymizationKey&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("client"), in_client,
                        "<value of type ::mojo::PendingRemote<ProxyResolverRequestClient>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ProxyResolver::kGetProxyForUrl), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::proxy_resolver::mojom::internal::ProxyResolver_GetProxyForUrl_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->url)::BaseType> url_fragment(
          params.message());
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
      in_url, url_fragment);
  params->url.Set(
      url_fragment.is_null() ? nullptr : url_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->url.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null url in ProxyResolver.GetProxyForUrl request");
  mojo::internal::MessageFragment<decltype(params->network_anonymization_key)>
      network_anonymization_key_fragment(params.message());
  network_anonymization_key_fragment.Claim(&params->network_anonymization_key);
  mojo::internal::Serialize<::network::mojom::NetworkAnonymizationKeyDataView>(
      in_network_anonymization_key, network_anonymization_key_fragment, true);
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->network_anonymization_key.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null network_anonymization_key in ProxyResolver.GetProxyForUrl request");
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::proxy_resolver::mojom::ProxyResolverRequestClientInterfaceBase>>(
      in_client, &params->client, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->client),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid client in ProxyResolver.GetProxyForUrl request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ProxyResolver::Name_);
  message.set_method_name("GetProxyForUrl");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool ProxyResolverStubDispatch::Accept(
    ProxyResolver* impl,
    mojo::Message* message) {
  switch (static_cast<messages::ProxyResolver>(message->header()->name)) {
    case messages::ProxyResolver::kGetProxyForUrl: {
      DCHECK(message->is_serialized());
      internal::ProxyResolver_GetProxyForUrl_Params_Data* params =
          reinterpret_cast<internal::ProxyResolver_GetProxyForUrl_Params_Data*>(
              message->mutable_payload());
      
      
      // Validation for ProxyResolver.0
      bool success = true;
      ::GURL p_url{};
      ::net::NetworkAnonymizationKey p_network_anonymization_key{};
      ::mojo::PendingRemote<ProxyResolverRequestClient> p_client{};
      ProxyResolver_GetProxyForUrl_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadUrl(&p_url))
        success = false;
      if (success && !input_data_view.ReadNetworkAnonymizationKey(&p_network_anonymization_key))
        success = false;
      if (success) {
        p_client =
            input_data_view.TakeClient<decltype(p_client)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ProxyResolver::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetProxyForUrl(        
        std::move(p_url), 
        std::move(p_network_anonymization_key), 
        std::move(p_client));
      return true;
    }
  }
  return false;
}

// static
bool ProxyResolverStubDispatch::AcceptWithResponder(
    ProxyResolver* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::ProxyResolver>(message->header()->name)) {
    case messages::ProxyResolver::kGetProxyForUrl: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kProxyResolverValidationInfo[] = {
    {base::to_underlying(messages::ProxyResolver::kGetProxyForUrl),
     { &internal::ProxyResolver_GetProxyForUrl_Params_Data::Validate,
      nullptr /* no response */}},
};

bool ProxyResolverRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::proxy_resolver::mojom::ProxyResolver::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kProxyResolverValidationInfo);
}

const char ProxyResolverRequestClient::Name_[] = "proxy_resolver.mojom.ProxyResolverRequestClient";

ProxyResolverRequestClient::IPCStableHashFunction ProxyResolverRequestClient::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::ProxyResolverRequestClient>(message.name())) {
    case messages::ProxyResolverRequestClient::kReportResult: {
      return &ProxyResolverRequestClient::ReportResult_Sym::IPCStableHash;
    }
    case messages::ProxyResolverRequestClient::kAlert: {
      return &ProxyResolverRequestClient::Alert_Sym::IPCStableHash;
    }
    case messages::ProxyResolverRequestClient::kOnError: {
      return &ProxyResolverRequestClient::OnError_Sym::IPCStableHash;
    }
    case messages::ProxyResolverRequestClient::kResolveDns: {
      return &ProxyResolverRequestClient::ResolveDns_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* ProxyResolverRequestClient::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::ProxyResolverRequestClient>(message.name())) {
      case messages::ProxyResolverRequestClient::kReportResult:
            return "Receive proxy_resolver::mojom::ProxyResolverRequestClient::ReportResult";
      case messages::ProxyResolverRequestClient::kAlert:
            return "Receive proxy_resolver::mojom::ProxyResolverRequestClient::Alert";
      case messages::ProxyResolverRequestClient::kOnError:
            return "Receive proxy_resolver::mojom::ProxyResolverRequestClient::OnError";
      case messages::ProxyResolverRequestClient::kResolveDns:
            return "Receive proxy_resolver::mojom::ProxyResolverRequestClient::ResolveDns";
    }
  } else {
    switch (static_cast<messages::ProxyResolverRequestClient>(message.name())) {
      case messages::ProxyResolverRequestClient::kReportResult:
            return "Receive reply proxy_resolver::mojom::ProxyResolverRequestClient::ReportResult";
      case messages::ProxyResolverRequestClient::kAlert:
            return "Receive reply proxy_resolver::mojom::ProxyResolverRequestClient::Alert";
      case messages::ProxyResolverRequestClient::kOnError:
            return "Receive reply proxy_resolver::mojom::ProxyResolverRequestClient::OnError";
      case messages::ProxyResolverRequestClient::kResolveDns:
            return "Receive reply proxy_resolver::mojom::ProxyResolverRequestClient::ResolveDns";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t ProxyResolverRequestClient::ReportResult_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)proxy_resolver::mojom::ProxyResolverRequestClient::ReportResult");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t ProxyResolverRequestClient::Alert_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)proxy_resolver::mojom::ProxyResolverRequestClient::Alert");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t ProxyResolverRequestClient::OnError_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)proxy_resolver::mojom::ProxyResolverRequestClient::OnError");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t ProxyResolverRequestClient::ResolveDns_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)proxy_resolver::mojom::ProxyResolverRequestClient::ResolveDns");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

ProxyResolverRequestClientProxy::ProxyResolverRequestClientProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void ProxyResolverRequestClientProxy::ReportResult(
    int32_t in_error, const ::net::ProxyInfo& in_proxy_info) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send proxy_resolver::mojom::ProxyResolverRequestClient::ReportResult", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("error"), in_error,
                        "<value of type int32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("proxy_info"), in_proxy_info,
                        "<value of type const ::net::ProxyInfo&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ProxyResolverRequestClient::kReportResult), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::proxy_resolver::mojom::internal::ProxyResolverRequestClient_ReportResult_Params_Data> params(
          message);
  params.Allocate();
  params->error = in_error;
  mojo::internal::MessageFragment<
      typename decltype(params->proxy_info)::BaseType> proxy_info_fragment(
          params.message());
  mojo::internal::Serialize<::proxy_resolver::mojom::ProxyInfoDataView>(
      in_proxy_info, proxy_info_fragment);
  params->proxy_info.Set(
      proxy_info_fragment.is_null() ? nullptr : proxy_info_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->proxy_info.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null proxy_info in ProxyResolverRequestClient.ReportResult request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ProxyResolverRequestClient::Name_);
  message.set_method_name("ReportResult");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void ProxyResolverRequestClientProxy::Alert(
    const std::string& in_error) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send proxy_resolver::mojom::ProxyResolverRequestClient::Alert", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("error"), in_error,
                        "<value of type const std::string&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ProxyResolverRequestClient::kAlert), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::proxy_resolver::mojom::internal::ProxyResolverRequestClient_Alert_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->error)::BaseType> error_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      in_error, error_fragment);
  params->error.Set(
      error_fragment.is_null() ? nullptr : error_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->error.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null error in ProxyResolverRequestClient.Alert request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ProxyResolverRequestClient::Name_);
  message.set_method_name("Alert");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void ProxyResolverRequestClientProxy::OnError(
    int32_t in_line_number, const std::string& in_error) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send proxy_resolver::mojom::ProxyResolverRequestClient::OnError", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("line_number"), in_line_number,
                        "<value of type int32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("error"), in_error,
                        "<value of type const std::string&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ProxyResolverRequestClient::kOnError), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::proxy_resolver::mojom::internal::ProxyResolverRequestClient_OnError_Params_Data> params(
          message);
  params.Allocate();
  params->line_number = in_line_number;
  mojo::internal::MessageFragment<
      typename decltype(params->error)::BaseType> error_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      in_error, error_fragment);
  params->error.Set(
      error_fragment.is_null() ? nullptr : error_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->error.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null error in ProxyResolverRequestClient.OnError request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ProxyResolverRequestClient::Name_);
  message.set_method_name("OnError");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void ProxyResolverRequestClientProxy::ResolveDns(
    const std::string& in_host, ::net::ProxyResolveDnsOperation in_operation, const ::net::NetworkAnonymizationKey& in_network_anonymization_key, ::mojo::PendingRemote<HostResolverRequestClient> in_client) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send proxy_resolver::mojom::ProxyResolverRequestClient::ResolveDns", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("host"), in_host,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("operation"), in_operation,
                        "<value of type ::net::ProxyResolveDnsOperation>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("network_anonymization_key"), in_network_anonymization_key,
                        "<value of type const ::net::NetworkAnonymizationKey&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("client"), in_client,
                        "<value of type ::mojo::PendingRemote<HostResolverRequestClient>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ProxyResolverRequestClient::kResolveDns), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::proxy_resolver::mojom::internal::ProxyResolverRequestClient_ResolveDns_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->host)::BaseType> host_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      in_host, host_fragment);
  params->host.Set(
      host_fragment.is_null() ? nullptr : host_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->host.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null host in ProxyResolverRequestClient.ResolveDns request");
  mojo::internal::Serialize<::proxy_resolver::mojom::HostResolveOperation>(
      in_operation, &params->operation);
  mojo::internal::MessageFragment<decltype(params->network_anonymization_key)>
      network_anonymization_key_fragment(params.message());
  network_anonymization_key_fragment.Claim(&params->network_anonymization_key);
  mojo::internal::Serialize<::network::mojom::NetworkAnonymizationKeyDataView>(
      in_network_anonymization_key, network_anonymization_key_fragment, true);
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->network_anonymization_key.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null network_anonymization_key in ProxyResolverRequestClient.ResolveDns request");
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::proxy_resolver::mojom::HostResolverRequestClientInterfaceBase>>(
      in_client, &params->client, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->client),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid client in ProxyResolverRequestClient.ResolveDns request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ProxyResolverRequestClient::Name_);
  message.set_method_name("ResolveDns");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool ProxyResolverRequestClientStubDispatch::Accept(
    ProxyResolverRequestClient* impl,
    mojo::Message* message) {
  switch (static_cast<messages::ProxyResolverRequestClient>(message->header()->name)) {
    case messages::ProxyResolverRequestClient::kReportResult: {
      DCHECK(message->is_serialized());
      internal::ProxyResolverRequestClient_ReportResult_Params_Data* params =
          reinterpret_cast<internal::ProxyResolverRequestClient_ReportResult_Params_Data*>(
              message->mutable_payload());
      
      
      // Validation for ProxyResolverRequestClient.0
      bool success = true;
      int32_t p_error{};
      ::net::ProxyInfo p_proxy_info{};
      ProxyResolverRequestClient_ReportResult_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_error = input_data_view.error();
      if (success && !input_data_view.ReadProxyInfo(&p_proxy_info))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ProxyResolverRequestClient::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ReportResult(        
        std::move(p_error), 
        std::move(p_proxy_info));
      return true;
    }
    case messages::ProxyResolverRequestClient::kAlert: {
      DCHECK(message->is_serialized());
      internal::ProxyResolverRequestClient_Alert_Params_Data* params =
          reinterpret_cast<internal::ProxyResolverRequestClient_Alert_Params_Data*>(
              message->mutable_payload());
      
      
      // Validation for ProxyResolverRequestClient.1
      bool success = true;
      std::string p_error{};
      ProxyResolverRequestClient_Alert_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadError(&p_error))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ProxyResolverRequestClient::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Alert(        
        std::move(p_error));
      return true;
    }
    case messages::ProxyResolverRequestClient::kOnError: {
      DCHECK(message->is_serialized());
      internal::ProxyResolverRequestClient_OnError_Params_Data* params =
          reinterpret_cast<internal::ProxyResolverRequestClient_OnError_Params_Data*>(
              message->mutable_payload());
      
      
      // Validation for ProxyResolverRequestClient.2
      bool success = true;
      int32_t p_line_number{};
      std::string p_error{};
      ProxyResolverRequestClient_OnError_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_line_number = input_data_view.line_number();
      if (success && !input_data_view.ReadError(&p_error))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ProxyResolverRequestClient::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnError(        
        std::move(p_line_number), 
        std::move(p_error));
      return true;
    }
    case messages::ProxyResolverRequestClient::kResolveDns: {
      DCHECK(message->is_serialized());
      internal::ProxyResolverRequestClient_ResolveDns_Params_Data* params =
          reinterpret_cast<internal::ProxyResolverRequestClient_ResolveDns_Params_Data*>(
              message->mutable_payload());
      
      
      // Validation for ProxyResolverRequestClient.3
      bool success = true;
      std::string p_host{};
      ::net::ProxyResolveDnsOperation p_operation{};
      ::net::NetworkAnonymizationKey p_network_anonymization_key{};
      ::mojo::PendingRemote<HostResolverRequestClient> p_client{};
      ProxyResolverRequestClient_ResolveDns_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadHost(&p_host))
        success = false;
      if (success && !input_data_view.ReadOperation(&p_operation))
        success = false;
      if (success && !input_data_view.ReadNetworkAnonymizationKey(&p_network_anonymization_key))
        success = false;
      if (success) {
        p_client =
            input_data_view.TakeClient<decltype(p_client)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ProxyResolverRequestClient::Name_, 3, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ResolveDns(        
        std::move(p_host), 
        std::move(p_operation), 
        std::move(p_network_anonymization_key), 
        std::move(p_client));
      return true;
    }
  }
  return false;
}

// static
bool ProxyResolverRequestClientStubDispatch::AcceptWithResponder(
    ProxyResolverRequestClient* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::ProxyResolverRequestClient>(message->header()->name)) {
    case messages::ProxyResolverRequestClient::kReportResult: {
      break;
    }
    case messages::ProxyResolverRequestClient::kAlert: {
      break;
    }
    case messages::ProxyResolverRequestClient::kOnError: {
      break;
    }
    case messages::ProxyResolverRequestClient::kResolveDns: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kProxyResolverRequestClientValidationInfo[] = {
    {base::to_underlying(messages::ProxyResolverRequestClient::kReportResult),
     { &internal::ProxyResolverRequestClient_ReportResult_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::ProxyResolverRequestClient::kAlert),
     { &internal::ProxyResolverRequestClient_Alert_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::ProxyResolverRequestClient::kOnError),
     { &internal::ProxyResolverRequestClient_OnError_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::ProxyResolverRequestClient::kResolveDns),
     { &internal::ProxyResolverRequestClient_ResolveDns_Params_Data::Validate,
      nullptr /* no response */}},
};

bool ProxyResolverRequestClientRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::proxy_resolver::mojom::ProxyResolverRequestClient::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kProxyResolverRequestClientValidationInfo);
}

const char ProxyResolverFactory::Name_[] = "proxy_resolver.mojom.ProxyResolverFactory";

ProxyResolverFactory::IPCStableHashFunction ProxyResolverFactory::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::ProxyResolverFactory>(message.name())) {
    case messages::ProxyResolverFactory::kCreateResolver: {
      return &ProxyResolverFactory::CreateResolver_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* ProxyResolverFactory::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::ProxyResolverFactory>(message.name())) {
      case messages::ProxyResolverFactory::kCreateResolver:
            return "Receive proxy_resolver::mojom::ProxyResolverFactory::CreateResolver";
    }
  } else {
    switch (static_cast<messages::ProxyResolverFactory>(message.name())) {
      case messages::ProxyResolverFactory::kCreateResolver:
            return "Receive reply proxy_resolver::mojom::ProxyResolverFactory::CreateResolver";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t ProxyResolverFactory::CreateResolver_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)proxy_resolver::mojom::ProxyResolverFactory::CreateResolver");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

ProxyResolverFactoryProxy::ProxyResolverFactoryProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void ProxyResolverFactoryProxy::CreateResolver(
    const std::string& in_pac_script, ::mojo::PendingReceiver<ProxyResolver> in_receiver, ::mojo::PendingRemote<ProxyResolverFactoryRequestClient> in_client) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send proxy_resolver::mojom::ProxyResolverFactory::CreateResolver", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("pac_script"), in_pac_script,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("receiver"), in_receiver,
                        "<value of type ::mojo::PendingReceiver<ProxyResolver>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("client"), in_client,
                        "<value of type ::mojo::PendingRemote<ProxyResolverFactoryRequestClient>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ProxyResolverFactory::kCreateResolver), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::proxy_resolver::mojom::internal::ProxyResolverFactory_CreateResolver_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->pac_script)::BaseType> pac_script_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      in_pac_script, pac_script_fragment);
  params->pac_script.Set(
      pac_script_fragment.is_null() ? nullptr : pac_script_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->pac_script.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null pac_script in ProxyResolverFactory.CreateResolver request");
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::proxy_resolver::mojom::ProxyResolverInterfaceBase>>(
      in_receiver, &params->receiver, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->receiver),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid receiver in ProxyResolverFactory.CreateResolver request");
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::proxy_resolver::mojom::ProxyResolverFactoryRequestClientInterfaceBase>>(
      in_client, &params->client, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->client),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid client in ProxyResolverFactory.CreateResolver request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ProxyResolverFactory::Name_);
  message.set_method_name("CreateResolver");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool ProxyResolverFactoryStubDispatch::Accept(
    ProxyResolverFactory* impl,
    mojo::Message* message) {
  switch (static_cast<messages::ProxyResolverFactory>(message->header()->name)) {
    case messages::ProxyResolverFactory::kCreateResolver: {
      DCHECK(message->is_serialized());
      internal::ProxyResolverFactory_CreateResolver_Params_Data* params =
          reinterpret_cast<internal::ProxyResolverFactory_CreateResolver_Params_Data*>(
              message->mutable_payload());
      
      
      // Validation for ProxyResolverFactory.0
      bool success = true;
      std::string p_pac_script{};
      ::mojo::PendingReceiver<ProxyResolver> p_receiver{};
      ::mojo::PendingRemote<ProxyResolverFactoryRequestClient> p_client{};
      ProxyResolverFactory_CreateResolver_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadPacScript(&p_pac_script))
        success = false;
      if (success) {
        p_receiver =
            input_data_view.TakeReceiver<decltype(p_receiver)>();
      }
      if (success) {
        p_client =
            input_data_view.TakeClient<decltype(p_client)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ProxyResolverFactory::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CreateResolver(        
        std::move(p_pac_script), 
        std::move(p_receiver), 
        std::move(p_client));
      return true;
    }
  }
  return false;
}

// static
bool ProxyResolverFactoryStubDispatch::AcceptWithResponder(
    ProxyResolverFactory* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::ProxyResolverFactory>(message->header()->name)) {
    case messages::ProxyResolverFactory::kCreateResolver: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kProxyResolverFactoryValidationInfo[] = {
    {base::to_underlying(messages::ProxyResolverFactory::kCreateResolver),
     { &internal::ProxyResolverFactory_CreateResolver_Params_Data::Validate,
      nullptr /* no response */}},
};

bool ProxyResolverFactoryRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::proxy_resolver::mojom::ProxyResolverFactory::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kProxyResolverFactoryValidationInfo);
}

const char ProxyResolverFactoryRequestClient::Name_[] = "proxy_resolver.mojom.ProxyResolverFactoryRequestClient";

ProxyResolverFactoryRequestClient::IPCStableHashFunction ProxyResolverFactoryRequestClient::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::ProxyResolverFactoryRequestClient>(message.name())) {
    case messages::ProxyResolverFactoryRequestClient::kReportResult: {
      return &ProxyResolverFactoryRequestClient::ReportResult_Sym::IPCStableHash;
    }
    case messages::ProxyResolverFactoryRequestClient::kAlert: {
      return &ProxyResolverFactoryRequestClient::Alert_Sym::IPCStableHash;
    }
    case messages::ProxyResolverFactoryRequestClient::kOnError: {
      return &ProxyResolverFactoryRequestClient::OnError_Sym::IPCStableHash;
    }
    case messages::ProxyResolverFactoryRequestClient::kResolveDns: {
      return &ProxyResolverFactoryRequestClient::ResolveDns_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* ProxyResolverFactoryRequestClient::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::ProxyResolverFactoryRequestClient>(message.name())) {
      case messages::ProxyResolverFactoryRequestClient::kReportResult:
            return "Receive proxy_resolver::mojom::ProxyResolverFactoryRequestClient::ReportResult";
      case messages::ProxyResolverFactoryRequestClient::kAlert:
            return "Receive proxy_resolver::mojom::ProxyResolverFactoryRequestClient::Alert";
      case messages::ProxyResolverFactoryRequestClient::kOnError:
            return "Receive proxy_resolver::mojom::ProxyResolverFactoryRequestClient::OnError";
      case messages::ProxyResolverFactoryRequestClient::kResolveDns:
            return "Receive proxy_resolver::mojom::ProxyResolverFactoryRequestClient::ResolveDns";
    }
  } else {
    switch (static_cast<messages::ProxyResolverFactoryRequestClient>(message.name())) {
      case messages::ProxyResolverFactoryRequestClient::kReportResult:
            return "Receive reply proxy_resolver::mojom::ProxyResolverFactoryRequestClient::ReportResult";
      case messages::ProxyResolverFactoryRequestClient::kAlert:
            return "Receive reply proxy_resolver::mojom::ProxyResolverFactoryRequestClient::Alert";
      case messages::ProxyResolverFactoryRequestClient::kOnError:
            return "Receive reply proxy_resolver::mojom::ProxyResolverFactoryRequestClient::OnError";
      case messages::ProxyResolverFactoryRequestClient::kResolveDns:
            return "Receive reply proxy_resolver::mojom::ProxyResolverFactoryRequestClient::ResolveDns";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t ProxyResolverFactoryRequestClient::ReportResult_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)proxy_resolver::mojom::ProxyResolverFactoryRequestClient::ReportResult");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t ProxyResolverFactoryRequestClient::Alert_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)proxy_resolver::mojom::ProxyResolverFactoryRequestClient::Alert");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t ProxyResolverFactoryRequestClient::OnError_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)proxy_resolver::mojom::ProxyResolverFactoryRequestClient::OnError");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t ProxyResolverFactoryRequestClient::ResolveDns_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)proxy_resolver::mojom::ProxyResolverFactoryRequestClient::ResolveDns");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

ProxyResolverFactoryRequestClientProxy::ProxyResolverFactoryRequestClientProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void ProxyResolverFactoryRequestClientProxy::ReportResult(
    int32_t in_error) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send proxy_resolver::mojom::ProxyResolverFactoryRequestClient::ReportResult", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("error"), in_error,
                        "<value of type int32_t>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ProxyResolverFactoryRequestClient::kReportResult), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::proxy_resolver::mojom::internal::ProxyResolverFactoryRequestClient_ReportResult_Params_Data> params(
          message);
  params.Allocate();
  params->error = in_error;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ProxyResolverFactoryRequestClient::Name_);
  message.set_method_name("ReportResult");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void ProxyResolverFactoryRequestClientProxy::Alert(
    const std::string& in_error) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send proxy_resolver::mojom::ProxyResolverFactoryRequestClient::Alert", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("error"), in_error,
                        "<value of type const std::string&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ProxyResolverFactoryRequestClient::kAlert), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::proxy_resolver::mojom::internal::ProxyResolverFactoryRequestClient_Alert_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->error)::BaseType> error_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      in_error, error_fragment);
  params->error.Set(
      error_fragment.is_null() ? nullptr : error_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->error.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null error in ProxyResolverFactoryRequestClient.Alert request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ProxyResolverFactoryRequestClient::Name_);
  message.set_method_name("Alert");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void ProxyResolverFactoryRequestClientProxy::OnError(
    int32_t in_line_number, const std::string& in_error) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send proxy_resolver::mojom::ProxyResolverFactoryRequestClient::OnError", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("line_number"), in_line_number,
                        "<value of type int32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("error"), in_error,
                        "<value of type const std::string&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ProxyResolverFactoryRequestClient::kOnError), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::proxy_resolver::mojom::internal::ProxyResolverFactoryRequestClient_OnError_Params_Data> params(
          message);
  params.Allocate();
  params->line_number = in_line_number;
  mojo::internal::MessageFragment<
      typename decltype(params->error)::BaseType> error_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      in_error, error_fragment);
  params->error.Set(
      error_fragment.is_null() ? nullptr : error_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->error.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null error in ProxyResolverFactoryRequestClient.OnError request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ProxyResolverFactoryRequestClient::Name_);
  message.set_method_name("OnError");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void ProxyResolverFactoryRequestClientProxy::ResolveDns(
    const std::string& in_host, ::net::ProxyResolveDnsOperation in_operation, const ::net::NetworkAnonymizationKey& in_network_anonymization_key, ::mojo::PendingRemote<HostResolverRequestClient> in_client) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send proxy_resolver::mojom::ProxyResolverFactoryRequestClient::ResolveDns", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("host"), in_host,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("operation"), in_operation,
                        "<value of type ::net::ProxyResolveDnsOperation>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("network_anonymization_key"), in_network_anonymization_key,
                        "<value of type const ::net::NetworkAnonymizationKey&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("client"), in_client,
                        "<value of type ::mojo::PendingRemote<HostResolverRequestClient>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ProxyResolverFactoryRequestClient::kResolveDns), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::proxy_resolver::mojom::internal::ProxyResolverFactoryRequestClient_ResolveDns_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->host)::BaseType> host_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      in_host, host_fragment);
  params->host.Set(
      host_fragment.is_null() ? nullptr : host_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->host.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null host in ProxyResolverFactoryRequestClient.ResolveDns request");
  mojo::internal::Serialize<::proxy_resolver::mojom::HostResolveOperation>(
      in_operation, &params->operation);
  mojo::internal::MessageFragment<decltype(params->network_anonymization_key)>
      network_anonymization_key_fragment(params.message());
  network_anonymization_key_fragment.Claim(&params->network_anonymization_key);
  mojo::internal::Serialize<::network::mojom::NetworkAnonymizationKeyDataView>(
      in_network_anonymization_key, network_anonymization_key_fragment, true);
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->network_anonymization_key.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null network_anonymization_key in ProxyResolverFactoryRequestClient.ResolveDns request");
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::proxy_resolver::mojom::HostResolverRequestClientInterfaceBase>>(
      in_client, &params->client, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->client),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid client in ProxyResolverFactoryRequestClient.ResolveDns request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ProxyResolverFactoryRequestClient::Name_);
  message.set_method_name("ResolveDns");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool ProxyResolverFactoryRequestClientStubDispatch::Accept(
    ProxyResolverFactoryRequestClient* impl,
    mojo::Message* message) {
  switch (static_cast<messages::ProxyResolverFactoryRequestClient>(message->header()->name)) {
    case messages::ProxyResolverFactoryRequestClient::kReportResult: {
      DCHECK(message->is_serialized());
      internal::ProxyResolverFactoryRequestClient_ReportResult_Params_Data* params =
          reinterpret_cast<internal::ProxyResolverFactoryRequestClient_ReportResult_Params_Data*>(
              message->mutable_payload());
      
      
      // Validation for ProxyResolverFactoryRequestClient.0
      bool success = true;
      int32_t p_error{};
      ProxyResolverFactoryRequestClient_ReportResult_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_error = input_data_view.error();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ProxyResolverFactoryRequestClient::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ReportResult(        
        std::move(p_error));
      return true;
    }
    case messages::ProxyResolverFactoryRequestClient::kAlert: {
      DCHECK(message->is_serialized());
      internal::ProxyResolverFactoryRequestClient_Alert_Params_Data* params =
          reinterpret_cast<internal::ProxyResolverFactoryRequestClient_Alert_Params_Data*>(
              message->mutable_payload());
      
      
      // Validation for ProxyResolverFactoryRequestClient.1
      bool success = true;
      std::string p_error{};
      ProxyResolverFactoryRequestClient_Alert_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadError(&p_error))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ProxyResolverFactoryRequestClient::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Alert(        
        std::move(p_error));
      return true;
    }
    case messages::ProxyResolverFactoryRequestClient::kOnError: {
      DCHECK(message->is_serialized());
      internal::ProxyResolverFactoryRequestClient_OnError_Params_Data* params =
          reinterpret_cast<internal::ProxyResolverFactoryRequestClient_OnError_Params_Data*>(
              message->mutable_payload());
      
      
      // Validation for ProxyResolverFactoryRequestClient.2
      bool success = true;
      int32_t p_line_number{};
      std::string p_error{};
      ProxyResolverFactoryRequestClient_OnError_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_line_number = input_data_view.line_number();
      if (success && !input_data_view.ReadError(&p_error))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ProxyResolverFactoryRequestClient::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnError(        
        std::move(p_line_number), 
        std::move(p_error));
      return true;
    }
    case messages::ProxyResolverFactoryRequestClient::kResolveDns: {
      DCHECK(message->is_serialized());
      internal::ProxyResolverFactoryRequestClient_ResolveDns_Params_Data* params =
          reinterpret_cast<internal::ProxyResolverFactoryRequestClient_ResolveDns_Params_Data*>(
              message->mutable_payload());
      
      
      // Validation for ProxyResolverFactoryRequestClient.3
      bool success = true;
      std::string p_host{};
      ::net::ProxyResolveDnsOperation p_operation{};
      ::net::NetworkAnonymizationKey p_network_anonymization_key{};
      ::mojo::PendingRemote<HostResolverRequestClient> p_client{};
      ProxyResolverFactoryRequestClient_ResolveDns_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadHost(&p_host))
        success = false;
      if (success && !input_data_view.ReadOperation(&p_operation))
        success = false;
      if (success && !input_data_view.ReadNetworkAnonymizationKey(&p_network_anonymization_key))
        success = false;
      if (success) {
        p_client =
            input_data_view.TakeClient<decltype(p_client)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ProxyResolverFactoryRequestClient::Name_, 3, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ResolveDns(        
        std::move(p_host), 
        std::move(p_operation), 
        std::move(p_network_anonymization_key), 
        std::move(p_client));
      return true;
    }
  }
  return false;
}

// static
bool ProxyResolverFactoryRequestClientStubDispatch::AcceptWithResponder(
    ProxyResolverFactoryRequestClient* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::ProxyResolverFactoryRequestClient>(message->header()->name)) {
    case messages::ProxyResolverFactoryRequestClient::kReportResult: {
      break;
    }
    case messages::ProxyResolverFactoryRequestClient::kAlert: {
      break;
    }
    case messages::ProxyResolverFactoryRequestClient::kOnError: {
      break;
    }
    case messages::ProxyResolverFactoryRequestClient::kResolveDns: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kProxyResolverFactoryRequestClientValidationInfo[] = {
    {base::to_underlying(messages::ProxyResolverFactoryRequestClient::kReportResult),
     { &internal::ProxyResolverFactoryRequestClient_ReportResult_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::ProxyResolverFactoryRequestClient::kAlert),
     { &internal::ProxyResolverFactoryRequestClient_Alert_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::ProxyResolverFactoryRequestClient::kOnError),
     { &internal::ProxyResolverFactoryRequestClient_OnError_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::ProxyResolverFactoryRequestClient::kResolveDns),
     { &internal::ProxyResolverFactoryRequestClient_ResolveDns_Params_Data::Validate,
      nullptr /* no response */}},
};

bool ProxyResolverFactoryRequestClientRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::proxy_resolver::mojom::ProxyResolverFactoryRequestClient::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kProxyResolverFactoryRequestClientValidationInfo);
}



}  // proxy_resolver::mojom


namespace mojo {


// static
bool StructTraits<::proxy_resolver::mojom::ProxyInfo::DataView, ::proxy_resolver::mojom::ProxyInfoPtr>::Read(
    ::proxy_resolver::mojom::ProxyInfo::DataView input,
    ::proxy_resolver::mojom::ProxyInfoPtr* output) {
  bool success = true;
  ::proxy_resolver::mojom::ProxyInfoPtr result(::proxy_resolver::mojom::ProxyInfo::New());
  
      if (success && !input.ReadProxyChains(&result->proxy_chains))
        success = false;
  *output = std::move(result);
  return success;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace proxy_resolver::mojom {


void HostResolverRequestClientInterceptorForTesting::ReportResult(int32_t error, const std::vector<::net::IPAddress>& result) {
  GetForwardingInterface()->ReportResult(
    std::move(error)
    , 
    std::move(result)
    );
}
HostResolverRequestClientAsyncWaiter::HostResolverRequestClientAsyncWaiter(
    HostResolverRequestClient* proxy) : proxy_(proxy) {}

HostResolverRequestClientAsyncWaiter::~HostResolverRequestClientAsyncWaiter() = default;




void ProxyResolverInterceptorForTesting::GetProxyForUrl(const ::GURL& url, const ::net::NetworkAnonymizationKey& network_anonymization_key, ::mojo::PendingRemote<ProxyResolverRequestClient> client) {
  GetForwardingInterface()->GetProxyForUrl(
    std::move(url)
    , 
    std::move(network_anonymization_key)
    , 
    std::move(client)
    );
}
ProxyResolverAsyncWaiter::ProxyResolverAsyncWaiter(
    ProxyResolver* proxy) : proxy_(proxy) {}

ProxyResolverAsyncWaiter::~ProxyResolverAsyncWaiter() = default;




void ProxyResolverRequestClientInterceptorForTesting::ReportResult(int32_t error, const ::net::ProxyInfo& proxy_info) {
  GetForwardingInterface()->ReportResult(
    std::move(error)
    , 
    std::move(proxy_info)
    );
}
void ProxyResolverRequestClientInterceptorForTesting::Alert(const std::string& error) {
  GetForwardingInterface()->Alert(
    std::move(error)
    );
}
void ProxyResolverRequestClientInterceptorForTesting::OnError(int32_t line_number, const std::string& error) {
  GetForwardingInterface()->OnError(
    std::move(line_number)
    , 
    std::move(error)
    );
}
void ProxyResolverRequestClientInterceptorForTesting::ResolveDns(const std::string& host, ::net::ProxyResolveDnsOperation operation, const ::net::NetworkAnonymizationKey& network_anonymization_key, ::mojo::PendingRemote<HostResolverRequestClient> client) {
  GetForwardingInterface()->ResolveDns(
    std::move(host)
    , 
    std::move(operation)
    , 
    std::move(network_anonymization_key)
    , 
    std::move(client)
    );
}
ProxyResolverRequestClientAsyncWaiter::ProxyResolverRequestClientAsyncWaiter(
    ProxyResolverRequestClient* proxy) : proxy_(proxy) {}

ProxyResolverRequestClientAsyncWaiter::~ProxyResolverRequestClientAsyncWaiter() = default;




void ProxyResolverFactoryInterceptorForTesting::CreateResolver(const std::string& pac_script, ::mojo::PendingReceiver<ProxyResolver> receiver, ::mojo::PendingRemote<ProxyResolverFactoryRequestClient> client) {
  GetForwardingInterface()->CreateResolver(
    std::move(pac_script)
    , 
    std::move(receiver)
    , 
    std::move(client)
    );
}
ProxyResolverFactoryAsyncWaiter::ProxyResolverFactoryAsyncWaiter(
    ProxyResolverFactory* proxy) : proxy_(proxy) {}

ProxyResolverFactoryAsyncWaiter::~ProxyResolverFactoryAsyncWaiter() = default;




void ProxyResolverFactoryRequestClientInterceptorForTesting::ReportResult(int32_t error) {
  GetForwardingInterface()->ReportResult(
    std::move(error)
    );
}
void ProxyResolverFactoryRequestClientInterceptorForTesting::Alert(const std::string& error) {
  GetForwardingInterface()->Alert(
    std::move(error)
    );
}
void ProxyResolverFactoryRequestClientInterceptorForTesting::OnError(int32_t line_number, const std::string& error) {
  GetForwardingInterface()->OnError(
    std::move(line_number)
    , 
    std::move(error)
    );
}
void ProxyResolverFactoryRequestClientInterceptorForTesting::ResolveDns(const std::string& host, ::net::ProxyResolveDnsOperation operation, const ::net::NetworkAnonymizationKey& network_anonymization_key, ::mojo::PendingRemote<HostResolverRequestClient> client) {
  GetForwardingInterface()->ResolveDns(
    std::move(host)
    , 
    std::move(operation)
    , 
    std::move(network_anonymization_key)
    , 
    std::move(client)
    );
}
ProxyResolverFactoryRequestClientAsyncWaiter::ProxyResolverFactoryRequestClientAsyncWaiter(
    ProxyResolverFactoryRequestClient* proxy) : proxy_(proxy) {}

ProxyResolverFactoryRequestClientAsyncWaiter::~ProxyResolverFactoryRequestClientAsyncWaiter() = default;






}  // proxy_resolver::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif