// services/viz/privileged/mojom/compositing/frame_sink_video_capture.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "services/viz/privileged/mojom/compositing/frame_sink_video_capture.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "services/viz/privileged/mojom/compositing/frame_sink_video_capture.mojom-params-data.h"
namespace viz {
namespace mojom {

NOINLINE static const char* BufferFormatPreferenceToStringHelper(BufferFormatPreference value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case BufferFormatPreference::kDefault:
      return "kDefault";
    case BufferFormatPreference::kPreferGpuMemoryBuffer:
      return "kPreferGpuMemoryBuffer";
    default:
      return nullptr;
  }
}

std::string BufferFormatPreferenceToString(BufferFormatPreference value) {
  const char *str = BufferFormatPreferenceToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown BufferFormatPreference value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, BufferFormatPreference value) {
  return os << BufferFormatPreferenceToString(value);
}

namespace internal {
// static
bool VideoCaptureSubTarget_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context,
    bool inlined) {
  if (!data) {
    DCHECK(!inlined);
    return true;
  }

  // If it is inlined, the alignment is already enforced by its enclosing
  // object. We don't have to validate that.
  DCHECK(!inlined || mojo::internal::IsAligned(data));

  if (!inlined &&
      !mojo::internal::ValidateNonInlinedUnionHeaderAndClaimMemory(
          data, validation_context)) {
    return false;
  }

  const VideoCaptureSubTarget_Data* object = static_cast<const VideoCaptureSubTarget_Data*>(data);

  if (inlined && object->is_null())
    return true;

  switch (object->tag) {

    case VideoCaptureSubTarget_Tag::kSubtreeCaptureId: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_subtree_capture_id, 1, validation_context)) {
        return false;
      }
      if (!mojo::internal::ValidateStruct(object->data.f_subtree_capture_id, validation_context))
        return false;
      return true;
    }
    case VideoCaptureSubTarget_Tag::kRegionCaptureCropId: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_region_capture_crop_id, 2, validation_context)) {
        return false;
      }
      if (!mojo::internal::ValidateStruct(object->data.f_region_capture_crop_id, validation_context))
        return false;
      return true;
    }
    default: {

      ReportValidationError(
          validation_context,
          mojo::internal::VALIDATION_ERROR_UNKNOWN_UNION_TAG,
          "unknown tag in VideoCaptureSubTarget");
      return false;
    }
  }
}


// static
bool VideoCaptureTarget_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const VideoCaptureTarget_Data* object =
      static_cast<const VideoCaptureTarget_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->frame_sink_id, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->frame_sink_id, validation_context))
    return false;

  if (!mojo::internal::ValidateInlinedUnion(object->sub_target, validation_context))
    return false;

  return true;
}

VideoCaptureTarget_Data::VideoCaptureTarget_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool FrameSinkVideoConsumerFrameCallbacks_Done_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const FrameSinkVideoConsumerFrameCallbacks_Done_Params_Data* object =
      static_cast<const FrameSinkVideoConsumerFrameCallbacks_Done_Params_Data*>(data);

  return true;
}

FrameSinkVideoConsumerFrameCallbacks_Done_Params_Data::FrameSinkVideoConsumerFrameCallbacks_Done_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool FrameSinkVideoConsumerFrameCallbacks_ProvideFeedback_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const FrameSinkVideoConsumerFrameCallbacks_ProvideFeedback_Params_Data* object =
      static_cast<const FrameSinkVideoConsumerFrameCallbacks_ProvideFeedback_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->feedback, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->feedback, validation_context))
    return false;

  return true;
}

FrameSinkVideoConsumerFrameCallbacks_ProvideFeedback_Params_Data::FrameSinkVideoConsumerFrameCallbacks_ProvideFeedback_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool FrameSinkVideoConsumer_OnFrameCaptured_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 48, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const FrameSinkVideoConsumer_OnFrameCaptured_Params_Data* object =
      static_cast<const FrameSinkVideoConsumer_OnFrameCaptured_Params_Data*>(data);

  if (!mojo::internal::ValidateInlinedUnionNonNullable(
          object->data, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateInlinedUnion(object->data, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->info, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->info, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->content_rect, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->content_rect, validation_context))
    return false;

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->callbacks, 4, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->callbacks,
                                                 validation_context)) {
    return false;
  }

  return true;
}

FrameSinkVideoConsumer_OnFrameCaptured_Params_Data::FrameSinkVideoConsumer_OnFrameCaptured_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool FrameSinkVideoConsumer_OnNewSubCaptureTargetVersion_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const FrameSinkVideoConsumer_OnNewSubCaptureTargetVersion_Params_Data* object =
      static_cast<const FrameSinkVideoConsumer_OnNewSubCaptureTargetVersion_Params_Data*>(data);

  return true;
}

FrameSinkVideoConsumer_OnNewSubCaptureTargetVersion_Params_Data::FrameSinkVideoConsumer_OnNewSubCaptureTargetVersion_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool FrameSinkVideoConsumer_OnFrameWithEmptyRegionCapture_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const FrameSinkVideoConsumer_OnFrameWithEmptyRegionCapture_Params_Data* object =
      static_cast<const FrameSinkVideoConsumer_OnFrameWithEmptyRegionCapture_Params_Data*>(data);

  return true;
}

FrameSinkVideoConsumer_OnFrameWithEmptyRegionCapture_Params_Data::FrameSinkVideoConsumer_OnFrameWithEmptyRegionCapture_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool FrameSinkVideoConsumer_OnStopped_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const FrameSinkVideoConsumer_OnStopped_Params_Data* object =
      static_cast<const FrameSinkVideoConsumer_OnStopped_Params_Data*>(data);

  return true;
}

FrameSinkVideoConsumer_OnStopped_Params_Data::FrameSinkVideoConsumer_OnStopped_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool FrameSinkVideoConsumer_OnLog_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const FrameSinkVideoConsumer_OnLog_Params_Data* object =
      static_cast<const FrameSinkVideoConsumer_OnLog_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->message, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& message_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->message, validation_context,
                                         &message_validate_params)) {
    return false;
  }

  return true;
}

FrameSinkVideoConsumer_OnLog_Params_Data::FrameSinkVideoConsumer_OnLog_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool FrameSinkVideoCapturer_SetFormat_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const FrameSinkVideoCapturer_SetFormat_Params_Data* object =
      static_cast<const FrameSinkVideoCapturer_SetFormat_Params_Data*>(data);


  if (!::media::mojom::internal::VideoPixelFormat_Data
        ::Validate(object->format, validation_context))
    return false;

  return true;
}

FrameSinkVideoCapturer_SetFormat_Params_Data::FrameSinkVideoCapturer_SetFormat_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool FrameSinkVideoCapturer_SetMinCapturePeriod_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const FrameSinkVideoCapturer_SetMinCapturePeriod_Params_Data* object =
      static_cast<const FrameSinkVideoCapturer_SetMinCapturePeriod_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->min_period, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->min_period, validation_context))
    return false;

  return true;
}

FrameSinkVideoCapturer_SetMinCapturePeriod_Params_Data::FrameSinkVideoCapturer_SetMinCapturePeriod_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool FrameSinkVideoCapturer_SetMinSizeChangePeriod_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const FrameSinkVideoCapturer_SetMinSizeChangePeriod_Params_Data* object =
      static_cast<const FrameSinkVideoCapturer_SetMinSizeChangePeriod_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->min_period, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->min_period, validation_context))
    return false;

  return true;
}

FrameSinkVideoCapturer_SetMinSizeChangePeriod_Params_Data::FrameSinkVideoCapturer_SetMinSizeChangePeriod_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool FrameSinkVideoCapturer_SetResolutionConstraints_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const FrameSinkVideoCapturer_SetResolutionConstraints_Params_Data* object =
      static_cast<const FrameSinkVideoCapturer_SetResolutionConstraints_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->min_size, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->min_size, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->max_size, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->max_size, validation_context))
    return false;

  return true;
}

FrameSinkVideoCapturer_SetResolutionConstraints_Params_Data::FrameSinkVideoCapturer_SetResolutionConstraints_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool FrameSinkVideoCapturer_SetAutoThrottlingEnabled_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const FrameSinkVideoCapturer_SetAutoThrottlingEnabled_Params_Data* object =
      static_cast<const FrameSinkVideoCapturer_SetAutoThrottlingEnabled_Params_Data*>(data);

  return true;
}

FrameSinkVideoCapturer_SetAutoThrottlingEnabled_Params_Data::FrameSinkVideoCapturer_SetAutoThrottlingEnabled_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool FrameSinkVideoCapturer_ChangeTarget_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const FrameSinkVideoCapturer_ChangeTarget_Params_Data* object =
      static_cast<const FrameSinkVideoCapturer_ChangeTarget_Params_Data*>(data);

  if (!mojo::internal::ValidateStruct(object->target, validation_context))
    return false;

  return true;
}

FrameSinkVideoCapturer_ChangeTarget_Params_Data::FrameSinkVideoCapturer_ChangeTarget_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool FrameSinkVideoCapturer_Start_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const FrameSinkVideoCapturer_Start_Params_Data* object =
      static_cast<const FrameSinkVideoCapturer_Start_Params_Data*>(data);

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->consumer, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->consumer,
                                                 validation_context)) {
    return false;
  }


  if (!::viz::mojom::internal::BufferFormatPreference_Data
        ::Validate(object->buffer_format_preference, validation_context))
    return false;

  return true;
}

FrameSinkVideoCapturer_Start_Params_Data::FrameSinkVideoCapturer_Start_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool FrameSinkVideoCapturer_Stop_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const FrameSinkVideoCapturer_Stop_Params_Data* object =
      static_cast<const FrameSinkVideoCapturer_Stop_Params_Data*>(data);

  return true;
}

FrameSinkVideoCapturer_Stop_Params_Data::FrameSinkVideoCapturer_Stop_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool FrameSinkVideoCapturer_RequestRefreshFrame_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const FrameSinkVideoCapturer_RequestRefreshFrame_Params_Data* object =
      static_cast<const FrameSinkVideoCapturer_RequestRefreshFrame_Params_Data*>(data);

  return true;
}

FrameSinkVideoCapturer_RequestRefreshFrame_Params_Data::FrameSinkVideoCapturer_RequestRefreshFrame_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool FrameSinkVideoCapturer_CreateOverlay_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const FrameSinkVideoCapturer_CreateOverlay_Params_Data* object =
      static_cast<const FrameSinkVideoCapturer_CreateOverlay_Params_Data*>(data);

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->receiver, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->receiver,
                                                 validation_context)) {
    return false;
  }

  return true;
}

FrameSinkVideoCapturer_CreateOverlay_Params_Data::FrameSinkVideoCapturer_CreateOverlay_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool FrameSinkVideoCaptureOverlay_SetImageAndBounds_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const FrameSinkVideoCaptureOverlay_SetImageAndBounds_Params_Data* object =
      static_cast<const FrameSinkVideoCaptureOverlay_SetImageAndBounds_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->image, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->image, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->bounds, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->bounds, validation_context))
    return false;

  return true;
}

FrameSinkVideoCaptureOverlay_SetImageAndBounds_Params_Data::FrameSinkVideoCaptureOverlay_SetImageAndBounds_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool FrameSinkVideoCaptureOverlay_SetBounds_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const FrameSinkVideoCaptureOverlay_SetBounds_Params_Data* object =
      static_cast<const FrameSinkVideoCaptureOverlay_SetBounds_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->bounds, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->bounds, validation_context))
    return false;

  return true;
}

FrameSinkVideoCaptureOverlay_SetBounds_Params_Data::FrameSinkVideoCaptureOverlay_SetBounds_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool FrameSinkVideoCaptureOverlay_OnCapturedMouseEvent_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const FrameSinkVideoCaptureOverlay_OnCapturedMouseEvent_Params_Data* object =
      static_cast<const FrameSinkVideoCaptureOverlay_OnCapturedMouseEvent_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->coordinates, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->coordinates, validation_context))
    return false;

  return true;
}

FrameSinkVideoCaptureOverlay_OnCapturedMouseEvent_Params_Data::FrameSinkVideoCaptureOverlay_OnCapturedMouseEvent_Params_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace viz

namespace perfetto {

// static
void TraceFormatTraits<::viz::mojom::BufferFormatPreference>::WriteIntoTrace(
   perfetto::TracedValue context, ::viz::mojom::BufferFormatPreference value) {
  return std::move(context).WriteString(::viz::mojom::BufferFormatPreferenceToString(value));
}

} // namespace perfetto