// third_party/blink/public/mojom/input/stylus_writing_gesture.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "third_party/blink/public/mojom/input/stylus_writing_gesture.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "third_party/blink/public/mojom/input/stylus_writing_gesture.mojom-params-data.h"
namespace blink {
namespace mojom {

NOINLINE static const char* StylusWritingGestureActionToStringHelper(StylusWritingGestureAction value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case StylusWritingGestureAction::DELETE_TEXT:
      return "DELETE_TEXT";
    case StylusWritingGestureAction::ADD_SPACE_OR_TEXT:
      return "ADD_SPACE_OR_TEXT";
    case StylusWritingGestureAction::REMOVE_SPACES:
      return "REMOVE_SPACES";
    case StylusWritingGestureAction::SPLIT_OR_MERGE:
      return "SPLIT_OR_MERGE";
    case StylusWritingGestureAction::SELECT_TEXT:
      return "SELECT_TEXT";
    default:
      return nullptr;
  }
}

std::string StylusWritingGestureActionToString(StylusWritingGestureAction value) {
  const char *str = StylusWritingGestureActionToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown StylusWritingGestureAction value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, StylusWritingGestureAction value) {
  return os << StylusWritingGestureActionToString(value);
}

NOINLINE static const char* StylusWritingGestureGranularityToStringHelper(StylusWritingGestureGranularity value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case StylusWritingGestureGranularity::CHARACTER:
      return "CHARACTER";
    case StylusWritingGestureGranularity::WORD:
      return "WORD";
    default:
      return nullptr;
  }
}

std::string StylusWritingGestureGranularityToString(StylusWritingGestureGranularity value) {
  const char *str = StylusWritingGestureGranularityToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown StylusWritingGestureGranularity value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, StylusWritingGestureGranularity value) {
  return os << StylusWritingGestureGranularityToString(value);
}

namespace internal {


// static
bool StylusWritingGestureData_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 48, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const StylusWritingGestureData_Data* object =
      static_cast<const StylusWritingGestureData_Data*>(data);


  if (!::blink::mojom::internal::StylusWritingGestureAction_Data
        ::Validate(object->action, validation_context))
    return false;


  if (!::blink::mojom::internal::StylusWritingGestureGranularity_Data
        ::Validate(object->granularity, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->start_rect, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->start_rect, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->end_rect, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->text_alternative, 5, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->text_alternative, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->text_to_insert, validation_context))
    return false;

  return true;
}

StylusWritingGestureData_Data::StylusWritingGestureData_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace blink

namespace perfetto {

// static
void TraceFormatTraits<::blink::mojom::StylusWritingGestureAction>::WriteIntoTrace(
   perfetto::TracedValue context, ::blink::mojom::StylusWritingGestureAction value) {
  return std::move(context).WriteString(::blink::mojom::StylusWritingGestureActionToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::blink::mojom::StylusWritingGestureGranularity>::WriteIntoTrace(
   perfetto::TracedValue context, ::blink::mojom::StylusWritingGestureGranularity value) {
  return std::move(context).WriteString(::blink::mojom::StylusWritingGestureGranularityToString(value));
}

} // namespace perfetto