// third_party/blink/public/mojom/messaging/cloneable_message.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "third_party/blink/public/mojom/messaging/cloneable_message.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "third_party/blink/public/mojom/messaging/cloneable_message.mojom-params-data.h"
namespace blink {
namespace mojom {

namespace internal {


// static
bool CloneableMessage_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 88, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const CloneableMessage_Data* object =
      static_cast<const CloneableMessage_Data*>(data);

  if (!mojo::internal::ValidateInlinedUnionNonNullable(
          object->encoded_message, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateInlinedUnion(object->encoded_message, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->blobs, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& blobs_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->blobs, validation_context,
                                         &blobs_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidateStruct(object->sender_origin, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->sender_agent_cluster_id, 8, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->sender_agent_cluster_id, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->file_system_access_tokens, 10, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& file_system_access_tokens_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->file_system_access_tokens, validation_context,
                                         &file_system_access_tokens_validate_params)) {
    return false;
  }

  return true;
}

CloneableMessage_Data::CloneableMessage_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace blink