// third_party/blink/public/mojom/payments/secure_payment_confirmation_service.mojom-blink.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "third_party/blink/public/mojom/payments/secure_payment_confirmation_service.mojom-blink.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "mojo/public/cpp/bindings/features.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "third_party/blink/public/mojom/payments/secure_payment_confirmation_service.mojom-params-data.h"
#include "third_party/blink/public/mojom/payments/secure_payment_confirmation_service.mojom-shared-message-ids.h"

#include "third_party/blink/public/mojom/payments/secure_payment_confirmation_service.mojom-blink-import-headers.h"
#include "third_party/blink/public/mojom/payments/secure_payment_confirmation_service.mojom-blink-test-utils.h"
#include "mojo/public/cpp/bindings/lib/wtf_serialization.h"


namespace payments::mojom::blink {
const char SecurePaymentConfirmationService::Name_[] = "payments.mojom.SecurePaymentConfirmationService";

SecurePaymentConfirmationService::IPCStableHashFunction SecurePaymentConfirmationService::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::SecurePaymentConfirmationService>(message.name())) {
    case messages::SecurePaymentConfirmationService::kStorePaymentCredential: {
      return &SecurePaymentConfirmationService::StorePaymentCredential_Sym::IPCStableHash;
    }
    case messages::SecurePaymentConfirmationService::kMakePaymentCredential: {
      return &SecurePaymentConfirmationService::MakePaymentCredential_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* SecurePaymentConfirmationService::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::SecurePaymentConfirmationService>(message.name())) {
      case messages::SecurePaymentConfirmationService::kStorePaymentCredential:
            return "Receive payments::mojom::SecurePaymentConfirmationService::StorePaymentCredential";
      case messages::SecurePaymentConfirmationService::kMakePaymentCredential:
            return "Receive payments::mojom::SecurePaymentConfirmationService::MakePaymentCredential";
    }
  } else {
    switch (static_cast<messages::SecurePaymentConfirmationService>(message.name())) {
      case messages::SecurePaymentConfirmationService::kStorePaymentCredential:
            return "Receive reply payments::mojom::SecurePaymentConfirmationService::StorePaymentCredential";
      case messages::SecurePaymentConfirmationService::kMakePaymentCredential:
            return "Receive reply payments::mojom::SecurePaymentConfirmationService::MakePaymentCredential";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t SecurePaymentConfirmationService::StorePaymentCredential_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)payments::mojom::SecurePaymentConfirmationService::StorePaymentCredential");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t SecurePaymentConfirmationService::MakePaymentCredential_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)payments::mojom::SecurePaymentConfirmationService::MakePaymentCredential");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

class SecurePaymentConfirmationService_StorePaymentCredential_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  SecurePaymentConfirmationService_StorePaymentCredential_ForwardToCallback(
      SecurePaymentConfirmationService::StorePaymentCredentialCallback callback
      ) : callback_(std::move(callback)) {
  }

  SecurePaymentConfirmationService_StorePaymentCredential_ForwardToCallback(const SecurePaymentConfirmationService_StorePaymentCredential_ForwardToCallback&) = delete;
  SecurePaymentConfirmationService_StorePaymentCredential_ForwardToCallback& operator=(const SecurePaymentConfirmationService_StorePaymentCredential_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  SecurePaymentConfirmationService::StorePaymentCredentialCallback callback_;
};

class SecurePaymentConfirmationService_MakePaymentCredential_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  SecurePaymentConfirmationService_MakePaymentCredential_ForwardToCallback(
      SecurePaymentConfirmationService::MakePaymentCredentialCallback callback
      ) : callback_(std::move(callback)) {
  }

  SecurePaymentConfirmationService_MakePaymentCredential_ForwardToCallback(const SecurePaymentConfirmationService_MakePaymentCredential_ForwardToCallback&) = delete;
  SecurePaymentConfirmationService_MakePaymentCredential_ForwardToCallback& operator=(const SecurePaymentConfirmationService_MakePaymentCredential_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  SecurePaymentConfirmationService::MakePaymentCredentialCallback callback_;
};

SecurePaymentConfirmationServiceProxy::SecurePaymentConfirmationServiceProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void SecurePaymentConfirmationServiceProxy::StorePaymentCredential(
    const WTF::Vector<uint8_t>& in_credential_id, const WTF::String& in_rp_id, const WTF::Vector<uint8_t>& in_user_id, StorePaymentCredentialCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send payments::mojom::SecurePaymentConfirmationService::StorePaymentCredential", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("credential_id"), in_credential_id,
                        "<value of type const WTF::Vector<uint8_t>&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("rp_id"), in_rp_id,
                        "<value of type const WTF::String&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("user_id"), in_user_id,
                        "<value of type const WTF::Vector<uint8_t>&>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::SecurePaymentConfirmationService::kStorePaymentCredential), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::payments::mojom::internal::SecurePaymentConfirmationService_StorePaymentCredential_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->credential_id)::BaseType>
      credential_id_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& credential_id_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  mojo::internal::Serialize<mojo::ArrayDataView<uint8_t>>(
      in_credential_id, credential_id_fragment, &credential_id_validate_params);
  params->credential_id.Set(
      credential_id_fragment.is_null() ? nullptr : credential_id_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->credential_id.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null credential_id in SecurePaymentConfirmationService.StorePaymentCredential request");
  mojo::internal::MessageFragment<
      typename decltype(params->rp_id)::BaseType> rp_id_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      in_rp_id, rp_id_fragment);
  params->rp_id.Set(
      rp_id_fragment.is_null() ? nullptr : rp_id_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->rp_id.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null rp_id in SecurePaymentConfirmationService.StorePaymentCredential request");
  mojo::internal::MessageFragment<
      typename decltype(params->user_id)::BaseType>
      user_id_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& user_id_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  mojo::internal::Serialize<mojo::ArrayDataView<uint8_t>>(
      in_user_id, user_id_fragment, &user_id_validate_params);
  params->user_id.Set(
      user_id_fragment.is_null() ? nullptr : user_id_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->user_id.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null user_id in SecurePaymentConfirmationService.StorePaymentCredential request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SecurePaymentConfirmationService::Name_);
  message.set_method_name("StorePaymentCredential");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new SecurePaymentConfirmationService_StorePaymentCredential_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void SecurePaymentConfirmationServiceProxy::MakePaymentCredential(
    ::blink::mojom::blink::PublicKeyCredentialCreationOptionsPtr in_options, MakePaymentCredentialCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send payments::mojom::SecurePaymentConfirmationService::MakePaymentCredential", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("options"), in_options,
                        "<value of type ::blink::mojom::blink::PublicKeyCredentialCreationOptionsPtr>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::SecurePaymentConfirmationService::kMakePaymentCredential), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::payments::mojom::internal::SecurePaymentConfirmationService_MakePaymentCredential_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->options)::BaseType> options_fragment(
          params.message());
  mojo::internal::Serialize<::blink::mojom::PublicKeyCredentialCreationOptionsDataView>(
      in_options, options_fragment);
  params->options.Set(
      options_fragment.is_null() ? nullptr : options_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->options.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null options in SecurePaymentConfirmationService.MakePaymentCredential request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SecurePaymentConfirmationService::Name_);
  message.set_method_name("MakePaymentCredential");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new SecurePaymentConfirmationService_MakePaymentCredential_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}
class SecurePaymentConfirmationService_StorePaymentCredential_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static SecurePaymentConfirmationService::StorePaymentCredentialCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<SecurePaymentConfirmationService_StorePaymentCredential_ProxyToResponder> proxy(
        new SecurePaymentConfirmationService_StorePaymentCredential_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&SecurePaymentConfirmationService_StorePaymentCredential_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~SecurePaymentConfirmationService_StorePaymentCredential_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  SecurePaymentConfirmationService_StorePaymentCredential_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "SecurePaymentConfirmationService::StorePaymentCredentialCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      PaymentCredentialStorageStatus in_status);
};

bool SecurePaymentConfirmationService_StorePaymentCredential_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::SecurePaymentConfirmationService_StorePaymentCredential_ResponseParams_Data* params =
      reinterpret_cast<
          internal::SecurePaymentConfirmationService_StorePaymentCredential_ResponseParams_Data*>(
              message->mutable_payload());
  
  
  // Validation for SecurePaymentConfirmationService.0
  bool success = true;
  PaymentCredentialStorageStatus p_status{};
  SecurePaymentConfirmationService_StorePaymentCredential_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadStatus(&p_status))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        SecurePaymentConfirmationService::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_status));
  return true;
}

void SecurePaymentConfirmationService_StorePaymentCredential_ProxyToResponder::Run(
    PaymentCredentialStorageStatus in_status) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply payments::mojom::SecurePaymentConfirmationService::StorePaymentCredential", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("status"), in_status,
                        "<value of type PaymentCredentialStorageStatus>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::SecurePaymentConfirmationService::kStorePaymentCredential), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::payments::mojom::internal::SecurePaymentConfirmationService_StorePaymentCredential_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<::payments::mojom::PaymentCredentialStorageStatus>(
      in_status, &params->status);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SecurePaymentConfirmationService::Name_);
  message.set_method_name("StorePaymentCredential");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class SecurePaymentConfirmationService_MakePaymentCredential_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static SecurePaymentConfirmationService::MakePaymentCredentialCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<SecurePaymentConfirmationService_MakePaymentCredential_ProxyToResponder> proxy(
        new SecurePaymentConfirmationService_MakePaymentCredential_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&SecurePaymentConfirmationService_MakePaymentCredential_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~SecurePaymentConfirmationService_MakePaymentCredential_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  SecurePaymentConfirmationService_MakePaymentCredential_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "SecurePaymentConfirmationService::MakePaymentCredentialCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::blink::mojom::blink::AuthenticatorStatus in_status, ::blink::mojom::blink::MakeCredentialAuthenticatorResponsePtr in_credential, ::blink::mojom::blink::WebAuthnDOMExceptionDetailsPtr in_dom_exception_details);
};

bool SecurePaymentConfirmationService_MakePaymentCredential_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::SecurePaymentConfirmationService_MakePaymentCredential_ResponseParams_Data* params =
      reinterpret_cast<
          internal::SecurePaymentConfirmationService_MakePaymentCredential_ResponseParams_Data*>(
              message->mutable_payload());
  
  
  // Validation for SecurePaymentConfirmationService.1
  bool success = true;
  ::blink::mojom::blink::AuthenticatorStatus p_status{};
  ::blink::mojom::blink::MakeCredentialAuthenticatorResponsePtr p_credential{};
  ::blink::mojom::blink::WebAuthnDOMExceptionDetailsPtr p_dom_exception_details{};
  SecurePaymentConfirmationService_MakePaymentCredential_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadStatus(&p_status))
    success = false;
  if (success && !input_data_view.ReadCredential(&p_credential))
    success = false;
  if (success && !input_data_view.ReadDomExceptionDetails(&p_dom_exception_details))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        SecurePaymentConfirmationService::Name_, 1, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_status), 
std::move(p_credential), 
std::move(p_dom_exception_details));
  return true;
}

void SecurePaymentConfirmationService_MakePaymentCredential_ProxyToResponder::Run(
    ::blink::mojom::blink::AuthenticatorStatus in_status, ::blink::mojom::blink::MakeCredentialAuthenticatorResponsePtr in_credential, ::blink::mojom::blink::WebAuthnDOMExceptionDetailsPtr in_dom_exception_details) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply payments::mojom::SecurePaymentConfirmationService::MakePaymentCredential", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("status"), in_status,
                        "<value of type ::blink::mojom::blink::AuthenticatorStatus>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("credential"), in_credential,
                        "<value of type ::blink::mojom::blink::MakeCredentialAuthenticatorResponsePtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("dom_exception_details"), in_dom_exception_details,
                        "<value of type ::blink::mojom::blink::WebAuthnDOMExceptionDetailsPtr>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::SecurePaymentConfirmationService::kMakePaymentCredential), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::payments::mojom::internal::SecurePaymentConfirmationService_MakePaymentCredential_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<::blink::mojom::AuthenticatorStatus>(
      in_status, &params->status);
  mojo::internal::MessageFragment<
      typename decltype(params->credential)::BaseType> credential_fragment(
          params.message());
  mojo::internal::Serialize<::blink::mojom::MakeCredentialAuthenticatorResponseDataView>(
      in_credential, credential_fragment);
  params->credential.Set(
      credential_fragment.is_null() ? nullptr : credential_fragment.data());
  mojo::internal::MessageFragment<
      typename decltype(params->dom_exception_details)::BaseType> dom_exception_details_fragment(
          params.message());
  mojo::internal::Serialize<::blink::mojom::WebAuthnDOMExceptionDetailsDataView>(
      in_dom_exception_details, dom_exception_details_fragment);
  params->dom_exception_details.Set(
      dom_exception_details_fragment.is_null() ? nullptr : dom_exception_details_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SecurePaymentConfirmationService::Name_);
  message.set_method_name("MakePaymentCredential");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool SecurePaymentConfirmationServiceStubDispatch::Accept(
    SecurePaymentConfirmationService* impl,
    mojo::Message* message) {
  switch (static_cast<messages::SecurePaymentConfirmationService>(message->header()->name)) {
    case messages::SecurePaymentConfirmationService::kStorePaymentCredential: {
      break;
    }
    case messages::SecurePaymentConfirmationService::kMakePaymentCredential: {
      break;
    }
  }
  return false;
}

// static
bool SecurePaymentConfirmationServiceStubDispatch::AcceptWithResponder(
    SecurePaymentConfirmationService* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::SecurePaymentConfirmationService>(message->header()->name)) {
    case messages::SecurePaymentConfirmationService::kStorePaymentCredential: {
      internal::SecurePaymentConfirmationService_StorePaymentCredential_Params_Data* params =
          reinterpret_cast<
              internal::SecurePaymentConfirmationService_StorePaymentCredential_Params_Data*>(
                  message->mutable_payload());
      
      
      // Validation for SecurePaymentConfirmationService.0
      bool success = true;
      WTF::Vector<uint8_t> p_credential_id{};
      WTF::String p_rp_id{};
      WTF::Vector<uint8_t> p_user_id{};
      SecurePaymentConfirmationService_StorePaymentCredential_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadCredentialId(&p_credential_id))
        success = false;
      if (success && !input_data_view.ReadRpId(&p_rp_id))
        success = false;
      if (success && !input_data_view.ReadUserId(&p_user_id))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            SecurePaymentConfirmationService::Name_, 0, false);
        return false;
      }
      SecurePaymentConfirmationService::StorePaymentCredentialCallback callback =
          SecurePaymentConfirmationService_StorePaymentCredential_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->StorePaymentCredential(        
        std::move(p_credential_id), 
        std::move(p_rp_id), 
        std::move(p_user_id), std::move(callback));
      return true;
    }
    case messages::SecurePaymentConfirmationService::kMakePaymentCredential: {
      internal::SecurePaymentConfirmationService_MakePaymentCredential_Params_Data* params =
          reinterpret_cast<
              internal::SecurePaymentConfirmationService_MakePaymentCredential_Params_Data*>(
                  message->mutable_payload());
      
      
      // Validation for SecurePaymentConfirmationService.1
      bool success = true;
      ::blink::mojom::blink::PublicKeyCredentialCreationOptionsPtr p_options{};
      SecurePaymentConfirmationService_MakePaymentCredential_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadOptions(&p_options))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            SecurePaymentConfirmationService::Name_, 1, false);
        return false;
      }
      SecurePaymentConfirmationService::MakePaymentCredentialCallback callback =
          SecurePaymentConfirmationService_MakePaymentCredential_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->MakePaymentCredential(        
        std::move(p_options), std::move(callback));
      return true;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kSecurePaymentConfirmationServiceValidationInfo[] = {
    { &internal::SecurePaymentConfirmationService_StorePaymentCredential_Params_Data::Validate,
     &internal::SecurePaymentConfirmationService_StorePaymentCredential_ResponseParams_Data::Validate},
    { &internal::SecurePaymentConfirmationService_MakePaymentCredential_Params_Data::Validate,
     &internal::SecurePaymentConfirmationService_MakePaymentCredential_ResponseParams_Data::Validate},
};

bool SecurePaymentConfirmationServiceRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::payments::mojom::blink::SecurePaymentConfirmationService::Name_;
  return mojo::internal::ValidateRequestGenericPacked(message, name, kSecurePaymentConfirmationServiceValidationInfo);
}

bool SecurePaymentConfirmationServiceResponseValidator::Accept(mojo::Message* message) {
  const char* name = ::payments::mojom::blink::SecurePaymentConfirmationService::Name_;
  return mojo::internal::ValidateResponseGenericPacked(message, name, kSecurePaymentConfirmationServiceValidationInfo);
}


}  // payments::mojom::blink


namespace mojo {

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace payments::mojom::blink {


void SecurePaymentConfirmationServiceInterceptorForTesting::StorePaymentCredential(const WTF::Vector<uint8_t>& credential_id, const WTF::String& rp_id, const WTF::Vector<uint8_t>& user_id, StorePaymentCredentialCallback callback) {
  GetForwardingInterface()->StorePaymentCredential(
    std::move(credential_id)
    , 
    std::move(rp_id)
    , 
    std::move(user_id)
    , std::move(callback));
}
void SecurePaymentConfirmationServiceInterceptorForTesting::MakePaymentCredential(::blink::mojom::blink::PublicKeyCredentialCreationOptionsPtr options, MakePaymentCredentialCallback callback) {
  GetForwardingInterface()->MakePaymentCredential(
    std::move(options)
    , std::move(callback));
}
SecurePaymentConfirmationServiceAsyncWaiter::SecurePaymentConfirmationServiceAsyncWaiter(
    SecurePaymentConfirmationService* proxy) : proxy_(proxy) {}

SecurePaymentConfirmationServiceAsyncWaiter::~SecurePaymentConfirmationServiceAsyncWaiter() = default;

void SecurePaymentConfirmationServiceAsyncWaiter::StorePaymentCredential(
    const WTF::Vector<uint8_t>& credential_id, const WTF::String& rp_id, const WTF::Vector<uint8_t>& user_id, PaymentCredentialStorageStatus* out_status) {
  base::RunLoop loop;
  proxy_->StorePaymentCredential(
      std::move(credential_id),
      std::move(rp_id),
      std::move(user_id),
      base::BindOnce(
          [](base::RunLoop* loop,
             PaymentCredentialStorageStatus* out_status
,
             PaymentCredentialStorageStatus status) {*out_status = std::move(status);
            loop->Quit();
          },
          &loop,
          out_status));
  loop.Run();
}

PaymentCredentialStorageStatus SecurePaymentConfirmationServiceAsyncWaiter::StorePaymentCredential(
    const WTF::Vector<uint8_t>& credential_id, const WTF::String& rp_id, const WTF::Vector<uint8_t>& user_id) {
  PaymentCredentialStorageStatus async_wait_result;
  StorePaymentCredential(std::move(credential_id),std::move(rp_id),std::move(user_id),&async_wait_result);
  return async_wait_result;
}

void SecurePaymentConfirmationServiceAsyncWaiter::MakePaymentCredential(
    ::blink::mojom::blink::PublicKeyCredentialCreationOptionsPtr options, ::blink::mojom::blink::AuthenticatorStatus* out_status, ::blink::mojom::blink::MakeCredentialAuthenticatorResponsePtr* out_credential, ::blink::mojom::blink::WebAuthnDOMExceptionDetailsPtr* out_dom_exception_details) {
  base::RunLoop loop;
  proxy_->MakePaymentCredential(
      std::move(options),
      base::BindOnce(
          [](base::RunLoop* loop,
             ::blink::mojom::blink::AuthenticatorStatus* out_status
,
             ::blink::mojom::blink::MakeCredentialAuthenticatorResponsePtr* out_credential
,
             ::blink::mojom::blink::WebAuthnDOMExceptionDetailsPtr* out_dom_exception_details
,
             ::blink::mojom::blink::AuthenticatorStatus status,
             ::blink::mojom::blink::MakeCredentialAuthenticatorResponsePtr credential,
             ::blink::mojom::blink::WebAuthnDOMExceptionDetailsPtr dom_exception_details) {*out_status = std::move(status);*out_credential = std::move(credential);*out_dom_exception_details = std::move(dom_exception_details);
            loop->Quit();
          },
          &loop,
          out_status,
          out_credential,
          out_dom_exception_details));
  loop.Run();
}








}  // payments::mojom::blink


#if defined(__clang__)
#pragma clang diagnostic pop
#endif