// third_party/blink/public/mojom/presentation/presentation.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "third_party/blink/public/mojom/presentation/presentation.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "third_party/blink/public/mojom/presentation/presentation.mojom-params-data.h"
namespace blink {
namespace mojom {

NOINLINE static const char* ScreenAvailabilityToStringHelper(ScreenAvailability value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case ScreenAvailability::UNKNOWN:
      return "UNKNOWN";
    case ScreenAvailability::UNAVAILABLE:
      return "UNAVAILABLE";
    case ScreenAvailability::SOURCE_NOT_SUPPORTED:
      return "SOURCE_NOT_SUPPORTED";
    case ScreenAvailability::DISABLED:
      return "DISABLED";
    case ScreenAvailability::AVAILABLE:
      return "AVAILABLE";
    default:
      return nullptr;
  }
}

std::string ScreenAvailabilityToString(ScreenAvailability value) {
  const char *str = ScreenAvailabilityToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown ScreenAvailability value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, ScreenAvailability value) {
  return os << ScreenAvailabilityToString(value);
}

NOINLINE static const char* PresentationConnectionStateToStringHelper(PresentationConnectionState value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case PresentationConnectionState::CONNECTING:
      return "CONNECTING";
    case PresentationConnectionState::CONNECTED:
      return "CONNECTED";
    case PresentationConnectionState::CLOSED:
      return "CLOSED";
    case PresentationConnectionState::TERMINATED:
      return "TERMINATED";
    default:
      return nullptr;
  }
}

std::string PresentationConnectionStateToString(PresentationConnectionState value) {
  const char *str = PresentationConnectionStateToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown PresentationConnectionState value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, PresentationConnectionState value) {
  return os << PresentationConnectionStateToString(value);
}

NOINLINE static const char* PresentationConnectionCloseReasonToStringHelper(PresentationConnectionCloseReason value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case PresentationConnectionCloseReason::CONNECTION_ERROR:
      return "CONNECTION_ERROR";
    case PresentationConnectionCloseReason::CLOSED:
      return "CLOSED";
    case PresentationConnectionCloseReason::WENT_AWAY:
      return "WENT_AWAY";
    default:
      return nullptr;
  }
}

std::string PresentationConnectionCloseReasonToString(PresentationConnectionCloseReason value) {
  const char *str = PresentationConnectionCloseReasonToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown PresentationConnectionCloseReason value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, PresentationConnectionCloseReason value) {
  return os << PresentationConnectionCloseReasonToString(value);
}

NOINLINE static const char* PresentationErrorTypeToStringHelper(PresentationErrorType value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case PresentationErrorType::NO_AVAILABLE_SCREENS:
      return "NO_AVAILABLE_SCREENS";
    case PresentationErrorType::PRESENTATION_REQUEST_CANCELLED:
      return "PRESENTATION_REQUEST_CANCELLED";
    case PresentationErrorType::NO_PRESENTATION_FOUND:
      return "NO_PRESENTATION_FOUND";
    case PresentationErrorType::PREVIOUS_START_IN_PROGRESS:
      return "PREVIOUS_START_IN_PROGRESS";
    case PresentationErrorType::UNKNOWN:
      return "UNKNOWN";
    default:
      return nullptr;
  }
}

std::string PresentationErrorTypeToString(PresentationErrorType value) {
  const char *str = PresentationErrorTypeToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown PresentationErrorType value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, PresentationErrorType value) {
  return os << PresentationErrorTypeToString(value);
}

namespace internal {
// static
bool PresentationConnectionMessage_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context,
    bool inlined) {
  if (!data) {
    DCHECK(!inlined);
    return true;
  }

  // If it is inlined, the alignment is already enforced by its enclosing
  // object. We don't have to validate that.
  DCHECK(!inlined || mojo::internal::IsAligned(data));

  if (!inlined &&
      !mojo::internal::ValidateNonInlinedUnionHeaderAndClaimMemory(
          data, validation_context)) {
    return false;
  }

  const PresentationConnectionMessage_Data* object = static_cast<const PresentationConnectionMessage_Data*>(data);

  if (inlined && object->is_null())
    return true;

  switch (object->tag) {

    case PresentationConnectionMessage_Tag::kMessage: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_message, 1, validation_context)) {
        return false;
      }
      constexpr const mojo::internal::ContainerValidateParams& message_validate_params =
          mojo::internal::GetArrayValidator<0, false, nullptr>();
      if (!mojo::internal::ValidateContainer(object->data.f_message, validation_context,
                                             &message_validate_params)) {
        return false;
      }
      return true;
    }
    case PresentationConnectionMessage_Tag::kData: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_data, 2, validation_context)) {
        return false;
      }
      constexpr const mojo::internal::ContainerValidateParams& data_validate_params =
          mojo::internal::GetArrayValidator<0, false, nullptr>();
      if (!mojo::internal::ValidateContainer(object->data.f_data, validation_context,
                                             &data_validate_params)) {
        return false;
      }
      return true;
    }
    default: {

      ReportValidationError(
          validation_context,
          mojo::internal::VALIDATION_ERROR_UNKNOWN_UNION_TAG,
          "unknown tag in PresentationConnectionMessage");
      return false;
    }
  }
}


// static
bool PresentationInfo_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PresentationInfo_Data* object =
      static_cast<const PresentationInfo_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->url, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->url, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->id, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& id_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->id, validation_context,
                                         &id_validate_params)) {
    return false;
  }

  return true;
}

PresentationInfo_Data::PresentationInfo_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PresentationError_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PresentationError_Data* object =
      static_cast<const PresentationError_Data*>(data);


  if (!::blink::mojom::internal::PresentationErrorType_Data
        ::Validate(object->error_type, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->message, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& message_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->message, validation_context,
                                         &message_validate_params)) {
    return false;
  }

  return true;
}

PresentationError_Data::PresentationError_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PresentationConnectionResult_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PresentationConnectionResult_Data* object =
      static_cast<const PresentationConnectionResult_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->presentation_info, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->presentation_info, validation_context))
    return false;

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->connection_remote, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->connection_remote,
                                                 validation_context)) {
    return false;
  }

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->connection_receiver, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->connection_receiver,
                                                 validation_context)) {
    return false;
  }

  return true;
}

PresentationConnectionResult_Data::PresentationConnectionResult_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PresentationConnection_OnMessage_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PresentationConnection_OnMessage_Params_Data* object =
      static_cast<const PresentationConnection_OnMessage_Params_Data*>(data);

  if (!mojo::internal::ValidateInlinedUnionNonNullable(
          object->message, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateInlinedUnion(object->message, validation_context))
    return false;

  return true;
}

PresentationConnection_OnMessage_Params_Data::PresentationConnection_OnMessage_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PresentationConnection_DidChangeState_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PresentationConnection_DidChangeState_Params_Data* object =
      static_cast<const PresentationConnection_DidChangeState_Params_Data*>(data);


  if (!::blink::mojom::internal::PresentationConnectionState_Data
        ::Validate(object->state, validation_context))
    return false;

  return true;
}

PresentationConnection_DidChangeState_Params_Data::PresentationConnection_DidChangeState_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PresentationConnection_DidClose_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PresentationConnection_DidClose_Params_Data* object =
      static_cast<const PresentationConnection_DidClose_Params_Data*>(data);


  if (!::blink::mojom::internal::PresentationConnectionCloseReason_Data
        ::Validate(object->reason, validation_context))
    return false;

  return true;
}

PresentationConnection_DidClose_Params_Data::PresentationConnection_DidClose_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PresentationService_SetController_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PresentationService_SetController_Params_Data* object =
      static_cast<const PresentationService_SetController_Params_Data*>(data);

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->controller, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->controller,
                                                 validation_context)) {
    return false;
  }

  return true;
}

PresentationService_SetController_Params_Data::PresentationService_SetController_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PresentationService_SetReceiver_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PresentationService_SetReceiver_Params_Data* object =
      static_cast<const PresentationService_SetReceiver_Params_Data*>(data);

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->receiver, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->receiver,
                                                 validation_context)) {
    return false;
  }

  return true;
}

PresentationService_SetReceiver_Params_Data::PresentationService_SetReceiver_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PresentationService_SetDefaultPresentationUrls_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PresentationService_SetDefaultPresentationUrls_Params_Data* object =
      static_cast<const PresentationService_SetDefaultPresentationUrls_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->presentation_urls, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& presentation_urls_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->presentation_urls, validation_context,
                                         &presentation_urls_validate_params)) {
    return false;
  }

  return true;
}

PresentationService_SetDefaultPresentationUrls_Params_Data::PresentationService_SetDefaultPresentationUrls_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PresentationService_ListenForScreenAvailability_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PresentationService_ListenForScreenAvailability_Params_Data* object =
      static_cast<const PresentationService_ListenForScreenAvailability_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->availability_url, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->availability_url, validation_context))
    return false;

  return true;
}

PresentationService_ListenForScreenAvailability_Params_Data::PresentationService_ListenForScreenAvailability_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PresentationService_StopListeningForScreenAvailability_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PresentationService_StopListeningForScreenAvailability_Params_Data* object =
      static_cast<const PresentationService_StopListeningForScreenAvailability_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->availability_url, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->availability_url, validation_context))
    return false;

  return true;
}

PresentationService_StopListeningForScreenAvailability_Params_Data::PresentationService_StopListeningForScreenAvailability_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PresentationService_StartPresentation_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PresentationService_StartPresentation_Params_Data* object =
      static_cast<const PresentationService_StartPresentation_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->presentation_urls, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& presentation_urls_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->presentation_urls, validation_context,
                                         &presentation_urls_validate_params)) {
    return false;
  }

  return true;
}

PresentationService_StartPresentation_Params_Data::PresentationService_StartPresentation_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PresentationService_StartPresentation_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PresentationService_StartPresentation_ResponseParams_Data* object =
      static_cast<const PresentationService_StartPresentation_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidateStruct(object->result, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->error, validation_context))
    return false;

  return true;
}

PresentationService_StartPresentation_ResponseParams_Data::PresentationService_StartPresentation_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PresentationService_ReconnectPresentation_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PresentationService_ReconnectPresentation_Params_Data* object =
      static_cast<const PresentationService_ReconnectPresentation_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->presentation_urls, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& presentation_urls_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->presentation_urls, validation_context,
                                         &presentation_urls_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->presentation_id, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& presentation_id_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->presentation_id, validation_context,
                                         &presentation_id_validate_params)) {
    return false;
  }

  return true;
}

PresentationService_ReconnectPresentation_Params_Data::PresentationService_ReconnectPresentation_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PresentationService_ReconnectPresentation_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PresentationService_ReconnectPresentation_ResponseParams_Data* object =
      static_cast<const PresentationService_ReconnectPresentation_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidateStruct(object->result, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->error, validation_context))
    return false;

  return true;
}

PresentationService_ReconnectPresentation_ResponseParams_Data::PresentationService_ReconnectPresentation_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PresentationService_CloseConnection_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PresentationService_CloseConnection_Params_Data* object =
      static_cast<const PresentationService_CloseConnection_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->presentation_url, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->presentation_url, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->presentation_id, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& presentation_id_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->presentation_id, validation_context,
                                         &presentation_id_validate_params)) {
    return false;
  }

  return true;
}

PresentationService_CloseConnection_Params_Data::PresentationService_CloseConnection_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PresentationService_Terminate_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PresentationService_Terminate_Params_Data* object =
      static_cast<const PresentationService_Terminate_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->presentation_url, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->presentation_url, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->presentation_id, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& presentation_id_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->presentation_id, validation_context,
                                         &presentation_id_validate_params)) {
    return false;
  }

  return true;
}

PresentationService_Terminate_Params_Data::PresentationService_Terminate_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PresentationController_OnScreenAvailabilityUpdated_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PresentationController_OnScreenAvailabilityUpdated_Params_Data* object =
      static_cast<const PresentationController_OnScreenAvailabilityUpdated_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->url, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->url, validation_context))
    return false;


  if (!::blink::mojom::internal::ScreenAvailability_Data
        ::Validate(object->availability, validation_context))
    return false;

  return true;
}

PresentationController_OnScreenAvailabilityUpdated_Params_Data::PresentationController_OnScreenAvailabilityUpdated_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PresentationController_OnDefaultPresentationStarted_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PresentationController_OnDefaultPresentationStarted_Params_Data* object =
      static_cast<const PresentationController_OnDefaultPresentationStarted_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->result, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->result, validation_context))
    return false;

  return true;
}

PresentationController_OnDefaultPresentationStarted_Params_Data::PresentationController_OnDefaultPresentationStarted_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PresentationController_OnConnectionStateChanged_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PresentationController_OnConnectionStateChanged_Params_Data* object =
      static_cast<const PresentationController_OnConnectionStateChanged_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->presentation_info, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->presentation_info, validation_context))
    return false;


  if (!::blink::mojom::internal::PresentationConnectionState_Data
        ::Validate(object->newState, validation_context))
    return false;

  return true;
}

PresentationController_OnConnectionStateChanged_Params_Data::PresentationController_OnConnectionStateChanged_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PresentationController_OnConnectionClosed_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PresentationController_OnConnectionClosed_Params_Data* object =
      static_cast<const PresentationController_OnConnectionClosed_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->presentation_info, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->presentation_info, validation_context))
    return false;


  if (!::blink::mojom::internal::PresentationConnectionCloseReason_Data
        ::Validate(object->reason, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->message, 3, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& message_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->message, validation_context,
                                         &message_validate_params)) {
    return false;
  }

  return true;
}

PresentationController_OnConnectionClosed_Params_Data::PresentationController_OnConnectionClosed_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PresentationReceiver_OnReceiverConnectionAvailable_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PresentationReceiver_OnReceiverConnectionAvailable_Params_Data* object =
      static_cast<const PresentationReceiver_OnReceiverConnectionAvailable_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->result, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->result, validation_context))
    return false;

  return true;
}

PresentationReceiver_OnReceiverConnectionAvailable_Params_Data::PresentationReceiver_OnReceiverConnectionAvailable_Params_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace blink

namespace perfetto {

// static
void TraceFormatTraits<::blink::mojom::ScreenAvailability>::WriteIntoTrace(
   perfetto::TracedValue context, ::blink::mojom::ScreenAvailability value) {
  return std::move(context).WriteString(::blink::mojom::ScreenAvailabilityToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::blink::mojom::PresentationConnectionState>::WriteIntoTrace(
   perfetto::TracedValue context, ::blink::mojom::PresentationConnectionState value) {
  return std::move(context).WriteString(::blink::mojom::PresentationConnectionStateToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::blink::mojom::PresentationConnectionCloseReason>::WriteIntoTrace(
   perfetto::TracedValue context, ::blink::mojom::PresentationConnectionCloseReason value) {
  return std::move(context).WriteString(::blink::mojom::PresentationConnectionCloseReasonToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::blink::mojom::PresentationErrorType>::WriteIntoTrace(
   perfetto::TracedValue context, ::blink::mojom::PresentationErrorType value) {
  return std::move(context).WriteString(::blink::mojom::PresentationErrorTypeToString(value));
}

} // namespace perfetto