// third_party/blink/public/mojom/service_worker/controller_service_worker.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_SERVICE_WORKER_CONTROLLER_SERVICE_WORKER_MOJOM_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_SERVICE_WORKER_CONTROLLER_SERVICE_WORKER_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>

#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "third_party/blink/public/mojom/service_worker/controller_service_worker.mojom-features.h"  // IWYU pragma: export
#include "third_party/blink/public/mojom/service_worker/controller_service_worker.mojom-shared.h"  // IWYU pragma: export
#include "third_party/blink/public/mojom/service_worker/controller_service_worker.mojom-forward.h"  // IWYU pragma: export
#include "mojo/public/mojom/base/unguessable_token.mojom.h"
#include "services/network/public/mojom/cross_origin_embedder_policy.mojom.h"
#include "services/network/public/mojom/document_isolation_policy.mojom.h"
#include "third_party/blink/public/mojom/cache_storage/cache_storage.mojom-forward.h"
#include "third_party/blink/public/mojom/service_worker/controller_service_worker_mode.mojom-forward.h"
#include "third_party/blink/public/mojom/service_worker/dispatch_fetch_event_params.mojom-forward.h"
#include "third_party/blink/public/mojom/service_worker/service_worker_embedded_worker_status.mojom.h"
#include "third_party/blink/public/mojom/service_worker/service_worker_event_status.mojom-forward.h"
#include "third_party/blink/public/mojom/service_worker/service_worker_fetch_handler_bypass_option.mojom-forward.h"
#include "third_party/blink/public/mojom/service_worker/service_worker_fetch_handler_type.mojom-forward.h"
#include "third_party/blink/public/mojom/service_worker/service_worker_fetch_response_callback.mojom-forward.h"
#include "third_party/blink/public/mojom/service_worker/service_worker_object.mojom.h"
#include "third_party/blink/public/mojom/service_worker/service_worker_router_rule.mojom.h"
#include "third_party/blink/public/mojom/use_counter/metrics/web_feature.mojom-forward.h"
#include "third_party/blink/public/mojom/service_worker/service_worker_running_status_callback.mojom-forward.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/lib/message_size_estimator.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"


#include "third_party/blink/public/common/common_export.h"




namespace blink::mojom {

class ControllerServiceWorkerProxy;

template <typename ImplRefTraits>
class ControllerServiceWorkerStub;

class ControllerServiceWorkerRequestValidator;
class ControllerServiceWorkerResponseValidator;


class BLINK_COMMON_EXPORT ControllerServiceWorker
    : public ControllerServiceWorkerInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();

  static const char Name_[];
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = ControllerServiceWorkerInterfaceBase;
  using Proxy_ = ControllerServiceWorkerProxy;

  template <typename ImplRefTraits>
  using Stub_ = ControllerServiceWorkerStub<ImplRefTraits>;

  using RequestValidator_ = ControllerServiceWorkerRequestValidator;
  using ResponseValidator_ = ControllerServiceWorkerResponseValidator;
  enum MethodMinVersions : uint32_t {
    kDispatchFetchEventForSubresourceMinVersion = 0,
    kCloneMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct DispatchFetchEventForSubresource_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct Clone_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~ControllerServiceWorker() = default;


  using DispatchFetchEventForSubresourceCallback = base::OnceCallback<void(::blink::mojom::ServiceWorkerEventStatus)>;
  
  virtual void DispatchFetchEventForSubresource(::blink::mojom::DispatchFetchEventParamsPtr params, ::mojo::PendingRemote<::blink::mojom::ServiceWorkerFetchResponseCallback> response_callback, DispatchFetchEventForSubresourceCallback callback) = 0;

  
  virtual void Clone(::mojo::PendingReceiver<ControllerServiceWorker> receiver, const ::network::CrossOriginEmbedderPolicy& cross_origin_embedder_policy, ::mojo::PendingRemote<::network::mojom::CrossOriginEmbedderPolicyReporter> coep_reporter, const ::network::DocumentIsolationPolicy& document_isolation_policy, ::mojo::PendingRemote<::network::mojom::DocumentIsolationPolicyReporter> dip_reporter) = 0;
};

class ControllerServiceWorkerConnectorProxy;

template <typename ImplRefTraits>
class ControllerServiceWorkerConnectorStub;

class ControllerServiceWorkerConnectorRequestValidator;


class BLINK_COMMON_EXPORT ControllerServiceWorkerConnector
    : public ControllerServiceWorkerConnectorInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();

  static const char Name_[];
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = ControllerServiceWorkerConnectorInterfaceBase;
  using Proxy_ = ControllerServiceWorkerConnectorProxy;

  template <typename ImplRefTraits>
  using Stub_ = ControllerServiceWorkerConnectorStub<ImplRefTraits>;

  using RequestValidator_ = ControllerServiceWorkerConnectorRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kUpdateControllerMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct UpdateController_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~ControllerServiceWorkerConnector() = default;

  
  virtual void UpdateController(::mojo::PendingRemote<ControllerServiceWorker> controller) = 0;
};



class BLINK_COMMON_EXPORT ControllerServiceWorkerProxy
    : public ControllerServiceWorker {
 public:
  using InterfaceType = ControllerServiceWorker;

  explicit ControllerServiceWorkerProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void DispatchFetchEventForSubresource(::blink::mojom::DispatchFetchEventParamsPtr params, ::mojo::PendingRemote<::blink::mojom::ServiceWorkerFetchResponseCallback> response_callback, DispatchFetchEventForSubresourceCallback callback) final;
  
  void Clone(::mojo::PendingReceiver<ControllerServiceWorker> receiver, const ::network::CrossOriginEmbedderPolicy& cross_origin_embedder_policy, ::mojo::PendingRemote<::network::mojom::CrossOriginEmbedderPolicyReporter> coep_reporter, const ::network::DocumentIsolationPolicy& document_isolation_policy, ::mojo::PendingRemote<::network::mojom::DocumentIsolationPolicyReporter> dip_reporter) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class BLINK_COMMON_EXPORT ControllerServiceWorkerConnectorProxy
    : public ControllerServiceWorkerConnector {
 public:
  using InterfaceType = ControllerServiceWorkerConnector;

  explicit ControllerServiceWorkerConnectorProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void UpdateController(::mojo::PendingRemote<ControllerServiceWorker> controller) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class BLINK_COMMON_EXPORT ControllerServiceWorkerStubDispatch {
 public:
  static bool Accept(ControllerServiceWorker* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      ControllerServiceWorker* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<ControllerServiceWorker>>
class ControllerServiceWorkerStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  ControllerServiceWorkerStub() = default;
  ~ControllerServiceWorkerStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return ControllerServiceWorkerStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return ControllerServiceWorkerStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class BLINK_COMMON_EXPORT ControllerServiceWorkerConnectorStubDispatch {
 public:
  static bool Accept(ControllerServiceWorkerConnector* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      ControllerServiceWorkerConnector* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<ControllerServiceWorkerConnector>>
class ControllerServiceWorkerConnectorStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  ControllerServiceWorkerConnectorStub() = default;
  ~ControllerServiceWorkerConnectorStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return ControllerServiceWorkerConnectorStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return ControllerServiceWorkerConnectorStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class BLINK_COMMON_EXPORT ControllerServiceWorkerRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class BLINK_COMMON_EXPORT ControllerServiceWorkerConnectorRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class BLINK_COMMON_EXPORT ControllerServiceWorkerResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};









class BLINK_COMMON_EXPORT ServiceWorkerRouterData {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<ServiceWorkerRouterData, T>::value>;
  using DataView = ServiceWorkerRouterDataDataView;
  using Data_ = internal::ServiceWorkerRouterData_Data;

  template <typename... Args>
  static ServiceWorkerRouterDataPtr New(Args&&... args) {
    return ServiceWorkerRouterDataPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static ServiceWorkerRouterDataPtr From(const U& u) {
    return mojo::TypeConverter<ServiceWorkerRouterDataPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, ServiceWorkerRouterData>::Convert(*this);
  }


  ServiceWorkerRouterData();

  ServiceWorkerRouterData(
      const ::blink::ServiceWorkerRouterRules& router_rules,
      ::blink::EmbeddedWorkerStatus initial_running_status,
      ::mojo::PendingReceiver<::blink::mojom::ServiceWorkerRunningStatusCallback> running_status_receiver,
      ::mojo::PendingRemote<::blink::mojom::CacheStorage> remote_cache_storage);

ServiceWorkerRouterData(const ServiceWorkerRouterData&) = delete;
ServiceWorkerRouterData& operator=(const ServiceWorkerRouterData&) = delete;

  ~ServiceWorkerRouterData();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = ServiceWorkerRouterDataPtr>
  ServiceWorkerRouterDataPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, ServiceWorkerRouterData::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, ServiceWorkerRouterData::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, ServiceWorkerRouterData::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        ServiceWorkerRouterData::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::ServiceWorkerRouterData_UnserializedMessageContext<
            UserType, ServiceWorkerRouterData::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<ServiceWorkerRouterData::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return ServiceWorkerRouterData::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::ServiceWorkerRouterData_UnserializedMessageContext<
            UserType, ServiceWorkerRouterData::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<ServiceWorkerRouterData::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::blink::ServiceWorkerRouterRules router_rules;
  
  ::blink::EmbeddedWorkerStatus initial_running_status;
  
  ::mojo::PendingReceiver<::blink::mojom::ServiceWorkerRunningStatusCallback> running_status_receiver;
  
  ::mojo::PendingRemote<::blink::mojom::CacheStorage> remote_cache_storage;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, ServiceWorkerRouterData::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, ServiceWorkerRouterData::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, ServiceWorkerRouterData::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, ServiceWorkerRouterData::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class BLINK_COMMON_EXPORT ControllerServiceWorkerInfo {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<ControllerServiceWorkerInfo, T>::value>;
  using DataView = ControllerServiceWorkerInfoDataView;
  using Data_ = internal::ControllerServiceWorkerInfo_Data;

  template <typename... Args>
  static ControllerServiceWorkerInfoPtr New(Args&&... args) {
    return ControllerServiceWorkerInfoPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static ControllerServiceWorkerInfoPtr From(const U& u) {
    return mojo::TypeConverter<ControllerServiceWorkerInfoPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, ControllerServiceWorkerInfo>::Convert(*this);
  }


  ControllerServiceWorkerInfo();

  ControllerServiceWorkerInfo(
      ::blink::mojom::ControllerServiceWorkerMode mode,
      ::blink::mojom::ServiceWorkerFetchHandlerType fetch_handler_type,
      ::blink::mojom::ServiceWorkerFetchHandlerBypassOption fetch_handler_bypass_option,
      const std::optional<std::string>& sha256_script_checksum,
      bool need_router_evaluate,
      ServiceWorkerRouterDataPtr router_data,
      ::mojo::PendingRemote<ControllerServiceWorker> remote_controller,
      const std::string& client_id,
      const std::optional<::base::UnguessableToken>& fetch_request_window_id,
      ::blink::mojom::ServiceWorkerObjectInfoPtr object_info,
      std::vector<::blink::mojom::WebFeature> used_features);

ControllerServiceWorkerInfo(const ControllerServiceWorkerInfo&) = delete;
ControllerServiceWorkerInfo& operator=(const ControllerServiceWorkerInfo&) = delete;

  ~ControllerServiceWorkerInfo();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = ControllerServiceWorkerInfoPtr>
  ControllerServiceWorkerInfoPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, ControllerServiceWorkerInfo::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, ControllerServiceWorkerInfo::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, ControllerServiceWorkerInfo::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        ControllerServiceWorkerInfo::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::ControllerServiceWorkerInfo_UnserializedMessageContext<
            UserType, ControllerServiceWorkerInfo::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<ControllerServiceWorkerInfo::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return ControllerServiceWorkerInfo::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::ControllerServiceWorkerInfo_UnserializedMessageContext<
            UserType, ControllerServiceWorkerInfo::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<ControllerServiceWorkerInfo::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::blink::mojom::ControllerServiceWorkerMode mode;
  
  ::blink::mojom::ServiceWorkerFetchHandlerType fetch_handler_type;
  
  ::blink::mojom::ServiceWorkerFetchHandlerBypassOption fetch_handler_bypass_option;
  
  std::optional<std::string> sha256_script_checksum;
  
  bool need_router_evaluate;
  
  ServiceWorkerRouterDataPtr router_data;
  
  ::mojo::PendingRemote<ControllerServiceWorker> remote_controller;
  
  std::string client_id;
  
  std::optional<::base::UnguessableToken> fetch_request_window_id;
  
  ::blink::mojom::ServiceWorkerObjectInfoPtr object_info;
  
  std::vector<::blink::mojom::WebFeature> used_features;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, ControllerServiceWorkerInfo::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, ControllerServiceWorkerInfo::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, ControllerServiceWorkerInfo::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, ControllerServiceWorkerInfo::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
ServiceWorkerRouterDataPtr ServiceWorkerRouterData::Clone() const {
  return New(
      mojo::Clone(router_rules),
      mojo::Clone(initial_running_status),
      mojo::Clone(running_status_receiver),
      mojo::Clone(remote_cache_storage)
  );
}

template <typename T, ServiceWorkerRouterData::EnableIfSame<T>*>
bool ServiceWorkerRouterData::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->router_rules, other_struct.router_rules))
    return false;
  if (!mojo::Equals(this->initial_running_status, other_struct.initial_running_status))
    return false;
  if (!mojo::Equals(this->running_status_receiver, other_struct.running_status_receiver))
    return false;
  if (!mojo::Equals(this->remote_cache_storage, other_struct.remote_cache_storage))
    return false;
  return true;
}

template <typename T, ServiceWorkerRouterData::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.router_rules < rhs.router_rules)
    return true;
  if (rhs.router_rules < lhs.router_rules)
    return false;
  if (lhs.initial_running_status < rhs.initial_running_status)
    return true;
  if (rhs.initial_running_status < lhs.initial_running_status)
    return false;
  if (lhs.running_status_receiver < rhs.running_status_receiver)
    return true;
  if (rhs.running_status_receiver < lhs.running_status_receiver)
    return false;
  if (lhs.remote_cache_storage < rhs.remote_cache_storage)
    return true;
  if (rhs.remote_cache_storage < lhs.remote_cache_storage)
    return false;
  return false;
}
template <typename StructPtrType>
ControllerServiceWorkerInfoPtr ControllerServiceWorkerInfo::Clone() const {
  return New(
      mojo::Clone(mode),
      mojo::Clone(fetch_handler_type),
      mojo::Clone(fetch_handler_bypass_option),
      mojo::Clone(sha256_script_checksum),
      mojo::Clone(need_router_evaluate),
      mojo::Clone(router_data),
      mojo::Clone(remote_controller),
      mojo::Clone(client_id),
      mojo::Clone(fetch_request_window_id),
      mojo::Clone(object_info),
      mojo::Clone(used_features)
  );
}

template <typename T, ControllerServiceWorkerInfo::EnableIfSame<T>*>
bool ControllerServiceWorkerInfo::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->mode, other_struct.mode))
    return false;
  if (!mojo::Equals(this->fetch_handler_type, other_struct.fetch_handler_type))
    return false;
  if (!mojo::Equals(this->fetch_handler_bypass_option, other_struct.fetch_handler_bypass_option))
    return false;
  if (!mojo::Equals(this->sha256_script_checksum, other_struct.sha256_script_checksum))
    return false;
  if (!mojo::Equals(this->need_router_evaluate, other_struct.need_router_evaluate))
    return false;
  if (!mojo::Equals(this->router_data, other_struct.router_data))
    return false;
  if (!mojo::Equals(this->remote_controller, other_struct.remote_controller))
    return false;
  if (!mojo::Equals(this->client_id, other_struct.client_id))
    return false;
  if (!mojo::Equals(this->fetch_request_window_id, other_struct.fetch_request_window_id))
    return false;
  if (!mojo::Equals(this->object_info, other_struct.object_info))
    return false;
  if (!mojo::Equals(this->used_features, other_struct.used_features))
    return false;
  return true;
}

template <typename T, ControllerServiceWorkerInfo::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.mode < rhs.mode)
    return true;
  if (rhs.mode < lhs.mode)
    return false;
  if (lhs.fetch_handler_type < rhs.fetch_handler_type)
    return true;
  if (rhs.fetch_handler_type < lhs.fetch_handler_type)
    return false;
  if (lhs.fetch_handler_bypass_option < rhs.fetch_handler_bypass_option)
    return true;
  if (rhs.fetch_handler_bypass_option < lhs.fetch_handler_bypass_option)
    return false;
  if (lhs.sha256_script_checksum < rhs.sha256_script_checksum)
    return true;
  if (rhs.sha256_script_checksum < lhs.sha256_script_checksum)
    return false;
  if (lhs.need_router_evaluate < rhs.need_router_evaluate)
    return true;
  if (rhs.need_router_evaluate < lhs.need_router_evaluate)
    return false;
  if (lhs.router_data < rhs.router_data)
    return true;
  if (rhs.router_data < lhs.router_data)
    return false;
  if (lhs.remote_controller < rhs.remote_controller)
    return true;
  if (rhs.remote_controller < lhs.remote_controller)
    return false;
  if (lhs.client_id < rhs.client_id)
    return true;
  if (rhs.client_id < lhs.client_id)
    return false;
  if (lhs.fetch_request_window_id < rhs.fetch_request_window_id)
    return true;
  if (rhs.fetch_request_window_id < lhs.fetch_request_window_id)
    return false;
  if (lhs.object_info < rhs.object_info)
    return true;
  if (rhs.object_info < lhs.object_info)
    return false;
  if (lhs.used_features < rhs.used_features)
    return true;
  if (rhs.used_features < lhs.used_features)
    return false;
  return false;
}


}  // blink::mojom

namespace mojo {


template <>
struct BLINK_COMMON_EXPORT StructTraits<::blink::mojom::ServiceWorkerRouterData::DataView,
                                         ::blink::mojom::ServiceWorkerRouterDataPtr> {
  static bool IsNull(const ::blink::mojom::ServiceWorkerRouterDataPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::ServiceWorkerRouterDataPtr* output) { output->reset(); }

  static const decltype(::blink::mojom::ServiceWorkerRouterData::router_rules)& router_rules(
      const ::blink::mojom::ServiceWorkerRouterDataPtr& input) {
    return input->router_rules;
  }

  static decltype(::blink::mojom::ServiceWorkerRouterData::initial_running_status) initial_running_status(
      const ::blink::mojom::ServiceWorkerRouterDataPtr& input) {
    return input->initial_running_status;
  }

  static  decltype(::blink::mojom::ServiceWorkerRouterData::running_status_receiver)& running_status_receiver(
       ::blink::mojom::ServiceWorkerRouterDataPtr& input) {
    return input->running_status_receiver;
  }

  static  decltype(::blink::mojom::ServiceWorkerRouterData::remote_cache_storage)& remote_cache_storage(
       ::blink::mojom::ServiceWorkerRouterDataPtr& input) {
    return input->remote_cache_storage;
  }

  static bool Read(::blink::mojom::ServiceWorkerRouterData::DataView input, ::blink::mojom::ServiceWorkerRouterDataPtr* output);
};


template <>
struct BLINK_COMMON_EXPORT StructTraits<::blink::mojom::ControllerServiceWorkerInfo::DataView,
                                         ::blink::mojom::ControllerServiceWorkerInfoPtr> {
  static bool IsNull(const ::blink::mojom::ControllerServiceWorkerInfoPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::ControllerServiceWorkerInfoPtr* output) { output->reset(); }

  static decltype(::blink::mojom::ControllerServiceWorkerInfo::mode) mode(
      const ::blink::mojom::ControllerServiceWorkerInfoPtr& input) {
    return input->mode;
  }

  static decltype(::blink::mojom::ControllerServiceWorkerInfo::fetch_handler_type) fetch_handler_type(
      const ::blink::mojom::ControllerServiceWorkerInfoPtr& input) {
    return input->fetch_handler_type;
  }

  static decltype(::blink::mojom::ControllerServiceWorkerInfo::fetch_handler_bypass_option) fetch_handler_bypass_option(
      const ::blink::mojom::ControllerServiceWorkerInfoPtr& input) {
    return input->fetch_handler_bypass_option;
  }

  static const decltype(::blink::mojom::ControllerServiceWorkerInfo::sha256_script_checksum)& sha256_script_checksum(
      const ::blink::mojom::ControllerServiceWorkerInfoPtr& input) {
    return input->sha256_script_checksum;
  }

  static decltype(::blink::mojom::ControllerServiceWorkerInfo::need_router_evaluate) need_router_evaluate(
      const ::blink::mojom::ControllerServiceWorkerInfoPtr& input) {
    return input->need_router_evaluate;
  }

  static  decltype(::blink::mojom::ControllerServiceWorkerInfo::router_data)& router_data(
       ::blink::mojom::ControllerServiceWorkerInfoPtr& input) {
    return input->router_data;
  }

  static  decltype(::blink::mojom::ControllerServiceWorkerInfo::remote_controller)& remote_controller(
       ::blink::mojom::ControllerServiceWorkerInfoPtr& input) {
    return input->remote_controller;
  }

  static const decltype(::blink::mojom::ControllerServiceWorkerInfo::client_id)& client_id(
      const ::blink::mojom::ControllerServiceWorkerInfoPtr& input) {
    return input->client_id;
  }

  static const decltype(::blink::mojom::ControllerServiceWorkerInfo::fetch_request_window_id)& fetch_request_window_id(
      const ::blink::mojom::ControllerServiceWorkerInfoPtr& input) {
    return input->fetch_request_window_id;
  }

  static  decltype(::blink::mojom::ControllerServiceWorkerInfo::object_info)& object_info(
       ::blink::mojom::ControllerServiceWorkerInfoPtr& input) {
    return input->object_info;
  }

  static const decltype(::blink::mojom::ControllerServiceWorkerInfo::used_features)& used_features(
      const ::blink::mojom::ControllerServiceWorkerInfoPtr& input) {
    return input->used_features;
  }

  static bool Read(::blink::mojom::ControllerServiceWorkerInfo::DataView input, ::blink::mojom::ControllerServiceWorkerInfoPtr* output);
};

}  // namespace mojo

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_SERVICE_WORKER_CONTROLLER_SERVICE_WORKER_MOJOM_H_