// third_party/blink/public/mojom/service_worker/service_worker_registration.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "third_party/blink/public/mojom/service_worker/service_worker_registration.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "third_party/blink/public/mojom/service_worker/service_worker_registration.mojom-params-data.h"
namespace blink {
namespace mojom {

namespace internal {


// static
bool ChangedServiceWorkerObjectsMask_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ChangedServiceWorkerObjectsMask_Data* object =
      static_cast<const ChangedServiceWorkerObjectsMask_Data*>(data);

  return true;
}

ChangedServiceWorkerObjectsMask_Data::ChangedServiceWorkerObjectsMask_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ServiceWorkerRegistrationObjectInfo_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 64, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ServiceWorkerRegistrationObjectInfo_Data* object =
      static_cast<const ServiceWorkerRegistrationObjectInfo_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->scope, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->scope, validation_context))
    return false;


  if (!::blink::mojom::internal::ServiceWorkerUpdateViaCache_Data
        ::Validate(object->update_via_cache, validation_context))
    return false;

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->host_remote, 4, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->host_remote,
                                                 validation_context)) {
    return false;
  }

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->receiver, 5, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->receiver,
                                                 validation_context)) {
    return false;
  }

  if (!mojo::internal::ValidateStruct(object->installing, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->waiting, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->active, validation_context))
    return false;

  return true;
}

ServiceWorkerRegistrationObjectInfo_Data::ServiceWorkerRegistrationObjectInfo_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ServiceWorkerRegistrationObjectHost_Update_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ServiceWorkerRegistrationObjectHost_Update_Params_Data* object =
      static_cast<const ServiceWorkerRegistrationObjectHost_Update_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->outside_fetch_client_settings_object, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->outside_fetch_client_settings_object, validation_context))
    return false;

  return true;
}

ServiceWorkerRegistrationObjectHost_Update_Params_Data::ServiceWorkerRegistrationObjectHost_Update_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ServiceWorkerRegistrationObjectHost_Update_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ServiceWorkerRegistrationObjectHost_Update_ResponseParams_Data* object =
      static_cast<const ServiceWorkerRegistrationObjectHost_Update_ResponseParams_Data*>(data);


  if (!::blink::mojom::internal::ServiceWorkerErrorType_Data
        ::Validate(object->error, validation_context))
    return false;

  constexpr const mojo::internal::ContainerValidateParams& error_msg_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->error_msg, validation_context,
                                         &error_msg_validate_params)) {
    return false;
  }

  return true;
}

ServiceWorkerRegistrationObjectHost_Update_ResponseParams_Data::ServiceWorkerRegistrationObjectHost_Update_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ServiceWorkerRegistrationObjectHost_Unregister_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ServiceWorkerRegistrationObjectHost_Unregister_Params_Data* object =
      static_cast<const ServiceWorkerRegistrationObjectHost_Unregister_Params_Data*>(data);

  return true;
}

ServiceWorkerRegistrationObjectHost_Unregister_Params_Data::ServiceWorkerRegistrationObjectHost_Unregister_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ServiceWorkerRegistrationObjectHost_Unregister_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ServiceWorkerRegistrationObjectHost_Unregister_ResponseParams_Data* object =
      static_cast<const ServiceWorkerRegistrationObjectHost_Unregister_ResponseParams_Data*>(data);


  if (!::blink::mojom::internal::ServiceWorkerErrorType_Data
        ::Validate(object->error, validation_context))
    return false;

  constexpr const mojo::internal::ContainerValidateParams& error_msg_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->error_msg, validation_context,
                                         &error_msg_validate_params)) {
    return false;
  }

  return true;
}

ServiceWorkerRegistrationObjectHost_Unregister_ResponseParams_Data::ServiceWorkerRegistrationObjectHost_Unregister_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ServiceWorkerRegistrationObjectHost_EnableNavigationPreload_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ServiceWorkerRegistrationObjectHost_EnableNavigationPreload_Params_Data* object =
      static_cast<const ServiceWorkerRegistrationObjectHost_EnableNavigationPreload_Params_Data*>(data);

  return true;
}

ServiceWorkerRegistrationObjectHost_EnableNavigationPreload_Params_Data::ServiceWorkerRegistrationObjectHost_EnableNavigationPreload_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ServiceWorkerRegistrationObjectHost_EnableNavigationPreload_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ServiceWorkerRegistrationObjectHost_EnableNavigationPreload_ResponseParams_Data* object =
      static_cast<const ServiceWorkerRegistrationObjectHost_EnableNavigationPreload_ResponseParams_Data*>(data);


  if (!::blink::mojom::internal::ServiceWorkerErrorType_Data
        ::Validate(object->error, validation_context))
    return false;

  constexpr const mojo::internal::ContainerValidateParams& error_msg_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->error_msg, validation_context,
                                         &error_msg_validate_params)) {
    return false;
  }

  return true;
}

ServiceWorkerRegistrationObjectHost_EnableNavigationPreload_ResponseParams_Data::ServiceWorkerRegistrationObjectHost_EnableNavigationPreload_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ServiceWorkerRegistrationObjectHost_GetNavigationPreloadState_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ServiceWorkerRegistrationObjectHost_GetNavigationPreloadState_Params_Data* object =
      static_cast<const ServiceWorkerRegistrationObjectHost_GetNavigationPreloadState_Params_Data*>(data);

  return true;
}

ServiceWorkerRegistrationObjectHost_GetNavigationPreloadState_Params_Data::ServiceWorkerRegistrationObjectHost_GetNavigationPreloadState_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ServiceWorkerRegistrationObjectHost_GetNavigationPreloadState_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ServiceWorkerRegistrationObjectHost_GetNavigationPreloadState_ResponseParams_Data* object =
      static_cast<const ServiceWorkerRegistrationObjectHost_GetNavigationPreloadState_ResponseParams_Data*>(data);


  if (!::blink::mojom::internal::ServiceWorkerErrorType_Data
        ::Validate(object->error, validation_context))
    return false;

  constexpr const mojo::internal::ContainerValidateParams& error_msg_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->error_msg, validation_context,
                                         &error_msg_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidateStruct(object->state, validation_context))
    return false;

  return true;
}

ServiceWorkerRegistrationObjectHost_GetNavigationPreloadState_ResponseParams_Data::ServiceWorkerRegistrationObjectHost_GetNavigationPreloadState_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ServiceWorkerRegistrationObjectHost_SetNavigationPreloadHeader_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ServiceWorkerRegistrationObjectHost_SetNavigationPreloadHeader_Params_Data* object =
      static_cast<const ServiceWorkerRegistrationObjectHost_SetNavigationPreloadHeader_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->value, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& value_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->value, validation_context,
                                         &value_validate_params)) {
    return false;
  }

  return true;
}

ServiceWorkerRegistrationObjectHost_SetNavigationPreloadHeader_Params_Data::ServiceWorkerRegistrationObjectHost_SetNavigationPreloadHeader_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ServiceWorkerRegistrationObjectHost_SetNavigationPreloadHeader_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ServiceWorkerRegistrationObjectHost_SetNavigationPreloadHeader_ResponseParams_Data* object =
      static_cast<const ServiceWorkerRegistrationObjectHost_SetNavigationPreloadHeader_ResponseParams_Data*>(data);


  if (!::blink::mojom::internal::ServiceWorkerErrorType_Data
        ::Validate(object->error, validation_context))
    return false;

  constexpr const mojo::internal::ContainerValidateParams& error_msg_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->error_msg, validation_context,
                                         &error_msg_validate_params)) {
    return false;
  }

  return true;
}

ServiceWorkerRegistrationObjectHost_SetNavigationPreloadHeader_ResponseParams_Data::ServiceWorkerRegistrationObjectHost_SetNavigationPreloadHeader_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ServiceWorkerRegistrationObject_SetServiceWorkerObjects_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 40, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ServiceWorkerRegistrationObject_SetServiceWorkerObjects_Params_Data* object =
      static_cast<const ServiceWorkerRegistrationObject_SetServiceWorkerObjects_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->changed_mask, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->changed_mask, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->installing, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->waiting, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->active, validation_context))
    return false;

  return true;
}

ServiceWorkerRegistrationObject_SetServiceWorkerObjects_Params_Data::ServiceWorkerRegistrationObject_SetServiceWorkerObjects_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ServiceWorkerRegistrationObject_SetUpdateViaCache_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ServiceWorkerRegistrationObject_SetUpdateViaCache_Params_Data* object =
      static_cast<const ServiceWorkerRegistrationObject_SetUpdateViaCache_Params_Data*>(data);


  if (!::blink::mojom::internal::ServiceWorkerUpdateViaCache_Data
        ::Validate(object->update_via_cache, validation_context))
    return false;

  return true;
}

ServiceWorkerRegistrationObject_SetUpdateViaCache_Params_Data::ServiceWorkerRegistrationObject_SetUpdateViaCache_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ServiceWorkerRegistrationObject_UpdateFound_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ServiceWorkerRegistrationObject_UpdateFound_Params_Data* object =
      static_cast<const ServiceWorkerRegistrationObject_UpdateFound_Params_Data*>(data);

  return true;
}

ServiceWorkerRegistrationObject_UpdateFound_Params_Data::ServiceWorkerRegistrationObject_UpdateFound_Params_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace blink