// ui/events/mojom/event.mojom-shared-internal.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef UI_EVENTS_MOJOM_EVENT_MOJOM_SHARED_INTERNAL_H_
#define UI_EVENTS_MOJOM_EVENT_MOJOM_SHARED_INTERNAL_H_
#include "mojo/public/cpp/bindings/lib/array_internal.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/map_data_internal.h"
#include "mojo/public/cpp/bindings/lib/buffer.h"
#include "mojo/public/mojom/base/time.mojom-shared-internal.h"
#include "ui/events/mojom/event_constants.mojom-shared-internal.h"
#include "ui/events/mojom/keyboard_codes.mojom-shared-internal.h"
#include "ui/gfx/geometry/mojom/geometry.mojom-shared-internal.h"
#include "ui/latency/mojom/latency_info.mojom-shared-internal.h"
#include "mojo/public/cpp/bindings/lib/native_enum_data.h"
#include "mojo/public/interfaces/bindings/native_struct.mojom-shared-internal.h"



namespace mojo {
namespace internal {
class ValidationContext;
}
}


namespace ui::mojom {
namespace internal {
class KeyData_Data;
class LocationData_Data;
class GesturePinchData_Data;
class GestureSwipeData_Data;
class GestureData_Data;
class ScrollData_Data;
class PointerDetails_Data;
class MouseData_Data;
class TouchData_Data;
class Event_Data;
class GestureDataDetails_Data;

#pragma pack(push, 1)


class  GestureDataDetails_Data {
 public:
  // Used to identify Mojom Union Data Classes.
  typedef void MojomUnionDataType;

  GestureDataDetails_Data() = default;
  // Do nothing in the destructor since it won't be called when it is a
  // non-inlined union.
  ~GestureDataDetails_Data() = default;

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context,
                       bool inlined);

  bool is_null() const { return size == 0; }

  void set_null() {
    size = 0U;
    tag = static_cast<GestureDataDetails_Tag>(0);
    data.unknown = 0U;
  }

  // TODO(crbug.com/40731316): SHOUTY_CASE values are being deprecated per C++ code style
  // guidelines (https://google.github.io/styleguide/cppguide.html#Enumerator_Names),
  // please use kCamelCase values instead.  Cleanup NULL_VALUE, BOOL_VALUE, INT_VALUE, etc.
  // generation once codebase is transitioned to kNullValue, kBoolValue, kIntValue, etc.
  enum class GestureDataDetails_Tag : uint32_t {

    
    kPinch,
    
    kSwipe,
  };

  // A note on layout:
  // "Each non-static data member is allocated as if it were the sole member of
  // a struct." - Section 9.5.2 ISO/IEC 14882:2011 (The C++ Spec)
  union MOJO_ALIGNAS(8) Union_ {
    Union_() : unknown(0) {}
    mojo::internal::Pointer<internal::GesturePinchData_Data> f_pinch;
    mojo::internal::Pointer<internal::GestureSwipeData_Data> f_swipe;
    uint64_t unknown;
  };

  uint32_t size;
  GestureDataDetails_Tag tag;
  Union_ data;
};
static_assert(sizeof(GestureDataDetails_Data) == mojo::internal::kUnionDataSize,
              "Bad sizeof(GestureDataDetails_Data)");
class  KeyData_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  int32_t key_code;
  uint32_t dom_code;
  int32_t dom_key;
  uint8_t is_char : 1;
  uint8_t padfinal_[3];

 private:
  friend class mojo::internal::MessageFragment<KeyData_Data>;

  KeyData_Data();
  ~KeyData_Data() = delete;
};
static_assert(sizeof(KeyData_Data) == 24,
              "Bad sizeof(KeyData_Data)");
// Used by KeyData::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct KeyData_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  KeyData_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~KeyData_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::Message& message) override {
    mojo::internal::MessageFragment<KeyData_Data> fragment(message);
    mojo::internal::Serialize<DataView>(user_data_, fragment);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    KeyData_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};
class  LocationData_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<::gfx::mojom::internal::PointF_Data> relative_location;
  mojo::internal::Pointer<::gfx::mojom::internal::PointF_Data> root_location;

 private:
  friend class mojo::internal::MessageFragment<LocationData_Data>;

  LocationData_Data();
  ~LocationData_Data() = delete;
};
static_assert(sizeof(LocationData_Data) == 24,
              "Bad sizeof(LocationData_Data)");
// Used by LocationData::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct LocationData_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  LocationData_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~LocationData_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::Message& message) override {
    mojo::internal::MessageFragment<LocationData_Data> fragment(message);
    mojo::internal::Serialize<DataView>(user_data_, fragment);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    LocationData_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};
class  GesturePinchData_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  float scale;
  uint8_t padfinal_[4];

 private:
  friend class mojo::internal::MessageFragment<GesturePinchData_Data>;

  GesturePinchData_Data();
  ~GesturePinchData_Data() = delete;
};
static_assert(sizeof(GesturePinchData_Data) == 16,
              "Bad sizeof(GesturePinchData_Data)");
// Used by GesturePinchData::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct GesturePinchData_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  GesturePinchData_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~GesturePinchData_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::Message& message) override {
    mojo::internal::MessageFragment<GesturePinchData_Data> fragment(message);
    mojo::internal::Serialize<DataView>(user_data_, fragment);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    GesturePinchData_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};
class  GestureSwipeData_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  uint8_t left : 1;
  uint8_t right : 1;
  uint8_t up : 1;
  uint8_t down : 1;
  uint8_t padfinal_[7];

 private:
  friend class mojo::internal::MessageFragment<GestureSwipeData_Data>;

  GestureSwipeData_Data();
  ~GestureSwipeData_Data() = delete;
};
static_assert(sizeof(GestureSwipeData_Data) == 16,
              "Bad sizeof(GestureSwipeData_Data)");
// Used by GestureSwipeData::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct GestureSwipeData_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  GestureSwipeData_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~GestureSwipeData_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::Message& message) override {
    mojo::internal::MessageFragment<GestureSwipeData_Data> fragment(message);
    mojo::internal::Serialize<DataView>(user_data_, fragment);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    GestureSwipeData_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};
class  GestureData_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<internal::LocationData_Data> location;
  int32_t device_type;
  uint8_t pad1_[4];
  internal::GestureDataDetails_Data details;

 private:
  friend class mojo::internal::MessageFragment<GestureData_Data>;

  GestureData_Data();
  ~GestureData_Data() = delete;
};
static_assert(sizeof(GestureData_Data) == 40,
              "Bad sizeof(GestureData_Data)");
// Used by GestureData::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct GestureData_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  GestureData_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~GestureData_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::Message& message) override {
    mojo::internal::MessageFragment<GestureData_Data> fragment(message);
    mojo::internal::Serialize<DataView>(user_data_, fragment);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    GestureData_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};
class  ScrollData_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<internal::LocationData_Data> location;
  float x_offset;
  float y_offset;
  float x_offset_ordinal;
  float y_offset_ordinal;
  int32_t finger_count;
  int32_t momentum_phase;
  int32_t scroll_event_phase;
  uint8_t padfinal_[4];

 private:
  friend class mojo::internal::MessageFragment<ScrollData_Data>;

  ScrollData_Data();
  ~ScrollData_Data() = delete;
};
static_assert(sizeof(ScrollData_Data) == 48,
              "Bad sizeof(ScrollData_Data)");
// Used by ScrollData::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct ScrollData_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  ScrollData_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~ScrollData_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::Message& message) override {
    mojo::internal::MessageFragment<ScrollData_Data> fragment(message);
    mojo::internal::Serialize<DataView>(user_data_, fragment);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    ScrollData_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};
class  PointerDetails_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  int32_t pointer_type;
  float radius_x;
  float radius_y;
  float force;
  float tilt_x;
  float tilt_y;
  float tangential_pressure;
  float twist;
  int32_t id;
  int32_t offset_x;
  int32_t offset_y;
  uint8_t padfinal_[4];

 private:
  friend class mojo::internal::MessageFragment<PointerDetails_Data>;

  PointerDetails_Data();
  ~PointerDetails_Data() = delete;
};
static_assert(sizeof(PointerDetails_Data) == 56,
              "Bad sizeof(PointerDetails_Data)");
// Used by PointerDetails::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct PointerDetails_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  PointerDetails_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~PointerDetails_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::Message& message) override {
    mojo::internal::MessageFragment<PointerDetails_Data> fragment(message);
    mojo::internal::Serialize<DataView>(user_data_, fragment);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    PointerDetails_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};
class  MouseData_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  int32_t changed_button_flags;
  uint8_t pad0_[4];
  mojo::internal::Pointer<internal::LocationData_Data> location;
  mojo::internal::Pointer<internal::PointerDetails_Data> pointer_details;
  mojo::internal::Pointer<::gfx::mojom::internal::Vector2d_Data> wheel_offset;
  mojo::internal::Pointer<::gfx::mojom::internal::Vector2d_Data> tick_120ths;

 private:
  friend class mojo::internal::MessageFragment<MouseData_Data>;

  MouseData_Data();
  ~MouseData_Data() = delete;
};
static_assert(sizeof(MouseData_Data) == 48,
              "Bad sizeof(MouseData_Data)");
// Used by MouseData::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct MouseData_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  MouseData_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~MouseData_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::Message& message) override {
    mojo::internal::MessageFragment<MouseData_Data> fragment(message);
    mojo::internal::Serialize<DataView>(user_data_, fragment);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    MouseData_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};
class  TouchData_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  uint8_t may_cause_scrolling : 1;
  uint8_t hovering : 1;
  uint8_t pad1_[7];
  mojo::internal::Pointer<internal::LocationData_Data> location;
  mojo::internal::Pointer<internal::PointerDetails_Data> pointer_details;

 private:
  friend class mojo::internal::MessageFragment<TouchData_Data>;

  TouchData_Data();
  ~TouchData_Data() = delete;
};
static_assert(sizeof(TouchData_Data) == 32,
              "Bad sizeof(TouchData_Data)");
// Used by TouchData::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct TouchData_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  TouchData_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~TouchData_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::Message& message) override {
    mojo::internal::MessageFragment<TouchData_Data> fragment(message);
    mojo::internal::Serialize<DataView>(user_data_, fragment);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    TouchData_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};
class  Event_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  int32_t action;
  int32_t flags;
  mojo::internal::Pointer<::mojo_base::mojom::internal::TimeTicks_Data> time_stamp;
  mojo::internal::Pointer<::ui::mojom::internal::LatencyInfo_Data> latency;
  mojo::internal::Pointer<internal::KeyData_Data> key_data;
  mojo::internal::Pointer<internal::GestureData_Data> gesture_data;
  mojo::internal::Pointer<internal::ScrollData_Data> scroll_data;
  mojo::internal::Pointer<internal::TouchData_Data> touch_data;
  mojo::internal::Pointer<internal::MouseData_Data> mouse_data;
  mojo::internal::Pointer<mojo::internal::Map_Data<mojo::internal::Pointer<mojo::internal::String_Data>, mojo::internal::Pointer<mojo::internal::Array_Data<uint8_t>>>> properties;

 private:
  friend class mojo::internal::MessageFragment<Event_Data>;

  Event_Data();
  ~Event_Data() = delete;
};
static_assert(sizeof(Event_Data) == 80,
              "Bad sizeof(Event_Data)");
// Used by Event::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct Event_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  Event_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~Event_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::Message& message) override {
    mojo::internal::MessageFragment<Event_Data> fragment(message);
    mojo::internal::Serialize<DataView>(user_data_, fragment);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    Event_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};

#pragma pack(pop)

}  // namespace internal

}  // ui::mojom

#endif  // UI_EVENTS_MOJOM_EVENT_MOJOM_SHARED_INTERNAL_H_