// ui/gfx/mojom/rrect_f.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef UI_GFX_MOJOM_RRECT_F_MOJOM_SHARED_H_
#define UI_GFX_MOJOM_RRECT_F_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "ui/gfx/mojom/rrect_f.mojom-shared-internal.h"
#include "ui/gfx/geometry/mojom/geometry.mojom-shared.h"







namespace gfx::mojom {
class RRectFDataView;



}  // gfx::mojom

namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::gfx::mojom::RRectFDataView> {
  using Data = ::gfx::mojom::internal::RRectF_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace gfx::mojom {


enum class RRectFType : int32_t {
  
  kEmpty = 0,
  
  kRect = 1,
  
  kSingle = 2,
  
  kSimple = 3,
  
  kOval = 4,
  
  kComplex = 5,
  kMinValue = 0,
  kMaxValue = 5,
};

 std::ostream& operator<<(std::ostream& os, RRectFType value);
inline bool IsKnownEnumValue(RRectFType value) {
  return internal::RRectFType_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


class RRectFDataView {
 public:
  RRectFDataView() = default;

  RRectFDataView(
      internal::RRectF_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  [[nodiscard]] bool ReadType(UserType* output) const {
    auto data_value = data_->type;
    return mojo::internal::Deserialize<::gfx::mojom::RRectFType>(
        data_value, output);
  }
  RRectFType type() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::gfx::mojom::RRectFType>(data_->type));
  }
  inline void GetRectDataView(
      ::gfx::mojom::RectFDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadRect(UserType* output) {
    
    auto* pointer = data_->rect.Get();
    return mojo::internal::Deserialize<::gfx::mojom::RectFDataView>(
        pointer, output, message_);
  }
  inline void GetUpperLeftDataView(
      ::gfx::mojom::Vector2dFDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadUpperLeft(UserType* output) {
    
    auto* pointer = data_->upper_left.Get();
    return mojo::internal::Deserialize<::gfx::mojom::Vector2dFDataView>(
        pointer, output, message_);
  }
  inline void GetUpperRightDataView(
      ::gfx::mojom::Vector2dFDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadUpperRight(UserType* output) {
    
    auto* pointer = data_->upper_right.Get();
    return mojo::internal::Deserialize<::gfx::mojom::Vector2dFDataView>(
        pointer, output, message_);
  }
  inline void GetLowerRightDataView(
      ::gfx::mojom::Vector2dFDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadLowerRight(UserType* output) {
    
    auto* pointer = data_->lower_right.Get();
    return mojo::internal::Deserialize<::gfx::mojom::Vector2dFDataView>(
        pointer, output, message_);
  }
  inline void GetLowerLeftDataView(
      ::gfx::mojom::Vector2dFDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadLowerLeft(UserType* output) {
    
    auto* pointer = data_->lower_left.Get();
    return mojo::internal::Deserialize<::gfx::mojom::Vector2dFDataView>(
        pointer, output, message_);
  }
 private:
  internal::RRectF_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


}  // gfx::mojom

namespace std {

template <>
struct hash<::gfx::mojom::RRectFType>
    : public mojo::internal::EnumHashImpl<::gfx::mojom::RRectFType> {};

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::gfx::mojom::RRectFType, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::gfx::mojom::RRectFType, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::gfx::mojom::RRectFType>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::gfx::mojom::RRectFDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::gfx::mojom::RRectFDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::gfx::mojom::internal::RRectF_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    mojo::internal::Serialize<::gfx::mojom::RRectFType>(
        Traits::type(input), &fragment->type);
    decltype(Traits::rect(input)) in_rect = Traits::rect(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->rect)::BaseType> rect_fragment(
            fragment.message());
    mojo::internal::Serialize<::gfx::mojom::RectFDataView>(
        in_rect, rect_fragment);
    fragment->rect.Set(
        rect_fragment.is_null() ? nullptr : rect_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->rect.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null rect in RRectF struct");
    decltype(Traits::upper_left(input)) in_upper_left = Traits::upper_left(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->upper_left)::BaseType> upper_left_fragment(
            fragment.message());
    mojo::internal::Serialize<::gfx::mojom::Vector2dFDataView>(
        in_upper_left, upper_left_fragment);
    fragment->upper_left.Set(
        upper_left_fragment.is_null() ? nullptr : upper_left_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->upper_left.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null upper_left in RRectF struct");
    decltype(Traits::upper_right(input)) in_upper_right = Traits::upper_right(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->upper_right)::BaseType> upper_right_fragment(
            fragment.message());
    mojo::internal::Serialize<::gfx::mojom::Vector2dFDataView>(
        in_upper_right, upper_right_fragment);
    fragment->upper_right.Set(
        upper_right_fragment.is_null() ? nullptr : upper_right_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->upper_right.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null upper_right in RRectF struct");
    decltype(Traits::lower_right(input)) in_lower_right = Traits::lower_right(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->lower_right)::BaseType> lower_right_fragment(
            fragment.message());
    mojo::internal::Serialize<::gfx::mojom::Vector2dFDataView>(
        in_lower_right, lower_right_fragment);
    fragment->lower_right.Set(
        lower_right_fragment.is_null() ? nullptr : lower_right_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->lower_right.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null lower_right in RRectF struct");
    decltype(Traits::lower_left(input)) in_lower_left = Traits::lower_left(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->lower_left)::BaseType> lower_left_fragment(
            fragment.message());
    mojo::internal::Serialize<::gfx::mojom::Vector2dFDataView>(
        in_lower_left, lower_left_fragment);
    fragment->lower_left.Set(
        lower_left_fragment.is_null() ? nullptr : lower_left_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->lower_left.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null lower_left in RRectF struct");
  }

  static bool Deserialize(::gfx::mojom::internal::RRectF_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::gfx::mojom::RRectFDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace gfx::mojom {

inline void RRectFDataView::GetRectDataView(
    ::gfx::mojom::RectFDataView* output) {
  auto pointer = data_->rect.Get();
  *output = ::gfx::mojom::RectFDataView(pointer, message_);
}
inline void RRectFDataView::GetUpperLeftDataView(
    ::gfx::mojom::Vector2dFDataView* output) {
  auto pointer = data_->upper_left.Get();
  *output = ::gfx::mojom::Vector2dFDataView(pointer, message_);
}
inline void RRectFDataView::GetUpperRightDataView(
    ::gfx::mojom::Vector2dFDataView* output) {
  auto pointer = data_->upper_right.Get();
  *output = ::gfx::mojom::Vector2dFDataView(pointer, message_);
}
inline void RRectFDataView::GetLowerRightDataView(
    ::gfx::mojom::Vector2dFDataView* output) {
  auto pointer = data_->lower_right.Get();
  *output = ::gfx::mojom::Vector2dFDataView(pointer, message_);
}
inline void RRectFDataView::GetLowerLeftDataView(
    ::gfx::mojom::Vector2dFDataView* output) {
  auto pointer = data_->lower_left.Get();
  *output = ::gfx::mojom::Vector2dFDataView(pointer, message_);
}



}  // gfx::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

namespace perfetto {

template <>
struct  TraceFormatTraits<::gfx::mojom::RRectFType> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::gfx::mojom::RRectFType value);
};

} // namespace perfetto

#endif  // UI_GFX_MOJOM_RRECT_F_MOJOM_SHARED_H_