// components/input/render_input_router.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef COMPONENTS_INPUT_RENDER_INPUT_ROUTER_MOJOM_SHARED_H_
#define COMPONENTS_INPUT_RENDER_INPUT_ROUTER_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "components/input/render_input_router.mojom-shared-internal.h"
#include "mojo/public/mojom/base/time.mojom-shared.h"
#include "mojo/public/mojom/base/unguessable_token.mojom-shared.h"
#include "services/viz/public/mojom/compositing/frame_sink_id.mojom-shared.h"
#include "third_party/blink/public/mojom/input/input_event_result.mojom-shared.h"
#include "third_party/blink/public/mojom/input/input_handler.mojom-shared.h"
#include "third_party/blink/public/mojom/widget/platform_widget.mojom-shared.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization.h"
#include "mojo/public/cpp/system/data_pipe.h"



#include "components/input/render_input_router.mojom-data-view.h"
#include "base/component_export.h"




namespace std {

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::input::mojom::RenderInputRouterConfigDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::input::mojom::RenderInputRouterConfigDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::input::mojom::internal::RenderInputRouterConfig_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::rir_client(input)) in_rir_client = Traits::rir_client(input);

    
    mojo::internal::Serialize<mojo::InterfacePtrDataView<::blink::mojom::RenderInputRouterClientInterfaceBase>>(
      in_rir_client,
      &fragment->rir_client,
      &fragment.message());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(!mojo::internal::IsHandleOrInterfaceValid(fragment->rir_client)),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid rir_client in RenderInputRouterConfig struct");

    decltype(Traits::grouping_id(input)) in_grouping_id = Traits::grouping_id(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->grouping_id)::BaseType> grouping_id_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::mojo_base::mojom::UnguessableTokenDataView>(
      in_grouping_id,
      grouping_id_fragment);

    fragment->grouping_id.Set(
        grouping_id_fragment.is_null() ? nullptr : grouping_id_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->grouping_id.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null grouping_id in RenderInputRouterConfig struct");

    fragment->force_enable_zoom = Traits::force_enable_zoom(input);
  }

  static bool Deserialize(::input::mojom::internal::RenderInputRouterConfig_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::input::mojom::RenderInputRouterConfigDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::input::mojom::TouchTransferStateDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::input::mojom::TouchTransferStateDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::input::mojom::internal::TouchTransferState_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::down_time_ms(input)) in_down_time_ms = Traits::down_time_ms(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->down_time_ms)::BaseType> down_time_ms_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::mojo_base::mojom::TimeTicksDataView>(
      in_down_time_ms,
      down_time_ms_fragment);

    fragment->down_time_ms.Set(
        down_time_ms_fragment.is_null() ? nullptr : down_time_ms_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->down_time_ms.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null down_time_ms in TouchTransferState struct");

    decltype(Traits::root_widget_frame_sink_id(input)) in_root_widget_frame_sink_id = Traits::root_widget_frame_sink_id(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->root_widget_frame_sink_id)::BaseType> root_widget_frame_sink_id_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::viz::mojom::FrameSinkIdDataView>(
      in_root_widget_frame_sink_id,
      root_widget_frame_sink_id_fragment);

    fragment->root_widget_frame_sink_id.Set(
        root_widget_frame_sink_id_fragment.is_null() ? nullptr : root_widget_frame_sink_id_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->root_widget_frame_sink_id.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null root_widget_frame_sink_id in TouchTransferState struct");

    fragment->web_contents_y_offset_pix = Traits::web_contents_y_offset_pix(input);

    fragment->dip_scale = Traits::dip_scale(input);

    fragment->browser_would_have_handled = Traits::browser_would_have_handled(input);
  }

  static bool Deserialize(::input::mojom::internal::TouchTransferState_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::input::mojom::TouchTransferStateDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace input::mojom {

inline void RenderInputRouterConfigDataView::GetGroupingIdDataView(
    ::mojo_base::mojom::UnguessableTokenDataView* output) {
  auto pointer = data_->grouping_id.Get();
  *output = ::mojo_base::mojom::UnguessableTokenDataView(pointer, message_);
}


inline void TouchTransferStateDataView::GetDownTimeMsDataView(
    ::mojo_base::mojom::TimeTicksDataView* output) {
  auto pointer = data_->down_time_ms.Get();
  *output = ::mojo_base::mojom::TimeTicksDataView(pointer, message_);
}
inline void TouchTransferStateDataView::GetRootWidgetFrameSinkIdDataView(
    ::viz::mojom::FrameSinkIdDataView* output) {
  auto pointer = data_->root_widget_frame_sink_id.Get();
  *output = ::viz::mojom::FrameSinkIdDataView(pointer, message_);
}



}  // input::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

#endif  // COMPONENTS_INPUT_RENDER_INPUT_ROUTER_MOJOM_SHARED_H_