// components/services/quarantine/public/mojom/quarantine.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "components/services/quarantine/public/mojom/quarantine.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "components/services/quarantine/public/mojom/quarantine.mojom-params-data.h"
namespace quarantine {
namespace mojom {

NOINLINE static const char* QuarantineFileResultToStringHelper(QuarantineFileResult value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case QuarantineFileResult::OK:
      return "OK";
    case QuarantineFileResult::ACCESS_DENIED:
      return "ACCESS_DENIED";
    case QuarantineFileResult::BLOCKED_BY_POLICY:
      return "BLOCKED_BY_POLICY";
    case QuarantineFileResult::ANNOTATION_FAILED:
      return "ANNOTATION_FAILED";
    case QuarantineFileResult::FILE_MISSING:
      return "FILE_MISSING";
    case QuarantineFileResult::SECURITY_CHECK_FAILED:
      return "SECURITY_CHECK_FAILED";
    case QuarantineFileResult::VIRUS_INFECTED:
      return "VIRUS_INFECTED";
    default:
      return nullptr;
  }
}

std::string QuarantineFileResultToString(QuarantineFileResult value) {
  const char *str = QuarantineFileResultToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown QuarantineFileResult value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, QuarantineFileResult value) {
  return os << QuarantineFileResultToString(value);
}

namespace internal {


// static
bool Quarantine_QuarantineFile_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 48, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Quarantine_QuarantineFile_Params_Data* object =
      static_cast<const Quarantine_QuarantineFile_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->full_path, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->full_path, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->source_url, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->source_url, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->referrer_url, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->referrer_url, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->request_initiator, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->client_guid, 5, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& client_guid_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->client_guid, validation_context,
                                         &client_guid_validate_params)) {
    return false;
  }

  return true;
}

Quarantine_QuarantineFile_Params_Data::Quarantine_QuarantineFile_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Quarantine_QuarantineFile_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Quarantine_QuarantineFile_ResponseParams_Data* object =
      static_cast<const Quarantine_QuarantineFile_ResponseParams_Data*>(data);


  if (!::quarantine::mojom::internal::QuarantineFileResult_Data
        ::Validate(object->result, validation_context))
    return false;

  return true;
}

Quarantine_QuarantineFile_ResponseParams_Data::Quarantine_QuarantineFile_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace quarantine

namespace perfetto {

// static
void TraceFormatTraits<::quarantine::mojom::QuarantineFileResult>::WriteIntoTrace(
   perfetto::TracedValue context, ::quarantine::mojom::QuarantineFileResult value) {
  return std::move(context).WriteString(::quarantine::mojom::QuarantineFileResultToString(value));
}

} // namespace perfetto