// content/common/download/mhtml_file_writer.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CONTENT_COMMON_DOWNLOAD_MHTML_FILE_WRITER_MOJOM_H_
#define CONTENT_COMMON_DOWNLOAD_MHTML_FILE_WRITER_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "content/common/download/mhtml_file_writer.mojom-features.h"  // IWYU pragma: export
#include "content/common/download/mhtml_file_writer.mojom-shared.h"  // IWYU pragma: export
#include "content/common/download/mhtml_file_writer.mojom-forward.h"  // IWYU pragma: export
#include "mojo/public/mojom/base/byte_string.mojom.h"
#include "mojo/public/mojom/base/file.mojom.h"
#include "mojo/public/mojom/base/time.mojom-forward.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/lib/message_size_estimator.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"


#include "content/common/content_export.h"




namespace content::mojom {

class MhtmlFileWriterProxy;

template <typename ImplRefTraits>
class MhtmlFileWriterStub;

class MhtmlFileWriterRequestValidator;
class MhtmlFileWriterResponseValidator;


class CONTENT_EXPORT MhtmlFileWriter
    : public MhtmlFileWriterInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "content.mojom.MhtmlFileWriter";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = MhtmlFileWriterInterfaceBase;
  using Proxy_ = MhtmlFileWriterProxy;

  template <typename ImplRefTraits>
  using Stub_ = MhtmlFileWriterStub<ImplRefTraits>;

  using RequestValidator_ = MhtmlFileWriterRequestValidator;
  using ResponseValidator_ = MhtmlFileWriterResponseValidator;
  enum MethodMinVersions : uint32_t {
    kSerializeAsMHTMLMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct SerializeAsMHTML_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~MhtmlFileWriter() = default;

  using SerializeAsMHTMLCallback = base::OnceCallback<void(MhtmlSaveStatus, const std::vector<std::string>&)>;
  using SerializeAsMHTMLMojoCallback = base::OnceCallback<void(MhtmlSaveStatus, const std::vector<std::string>&)>;

  virtual void SerializeAsMHTML(SerializeAsMHTMLParamsPtr params, SerializeAsMHTMLCallback callback) = 0;
};



class CONTENT_EXPORT MhtmlFileWriterProxy
    : public MhtmlFileWriter {
 public:
  using InterfaceType = MhtmlFileWriter;

  explicit MhtmlFileWriterProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void SerializeAsMHTML(SerializeAsMHTMLParamsPtr params, SerializeAsMHTMLCallback callback) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class CONTENT_EXPORT MhtmlFileWriterStubDispatch {
 public:
  static bool Accept(MhtmlFileWriter* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      MhtmlFileWriter* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<MhtmlFileWriter>>
class MhtmlFileWriterStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  MhtmlFileWriterStub() = default;
  ~MhtmlFileWriterStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return MhtmlFileWriterStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return MhtmlFileWriterStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class CONTENT_EXPORT MhtmlFileWriterRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class CONTENT_EXPORT MhtmlFileWriterResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};






class CONTENT_EXPORT MhtmlOutputHandle {
 public:
  using DataView = MhtmlOutputHandleDataView;
  using Data_ = internal::MhtmlOutputHandle_Data;
  using Tag = Data_::MhtmlOutputHandle_Tag;

  template <typename... Args>
  static MhtmlOutputHandlePtr New(Args&&... args) {
    static_assert(
        sizeof...(args) < 0,
        "Do not use Union::New(); to create a union of a given subtype, use "
        "New<SubType>(), not New() followed by set_<sub_type>(). To represent "
        "an empty union, mark the field or parameter as nullable in the mojom "
        "definition.");
    return nullptr;
  }

  // Construct an instance holding |file_handle|.
  static MhtmlOutputHandlePtr NewFileHandle(
      ::base::File value);
  // Construct an instance holding |producer_handle|.
  static MhtmlOutputHandlePtr NewProducerHandle(
      ::mojo::ScopedDataPipeProducerHandle value);

  template <typename U>
  static MhtmlOutputHandlePtr From(const U& u) {
    return mojo::TypeConverter<MhtmlOutputHandlePtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, MhtmlOutputHandle>::Convert(*this);
  }
  ~MhtmlOutputHandle();

  // Delete the copy constructor and copy assignment operators because `data_`
  // contains raw pointers that must not be copied.
  MhtmlOutputHandle(const MhtmlOutputHandle& other) = delete;
  MhtmlOutputHandle& operator=(const MhtmlOutputHandle& other) = delete;

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename UnionPtrType = MhtmlOutputHandlePtr>
  MhtmlOutputHandlePtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T,
            typename std::enable_if<std::is_same<
                T, MhtmlOutputHandle>::value>::type* = nullptr>
  bool Equals(const T& other) const;

  template <typename T,
            typename std::enable_if<std::is_same<
                T, MhtmlOutputHandle>::value>::type* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  Tag which() const {
    return tag_;
  }

  bool is_file_handle() const { return tag_ == Tag::kFileHandle; }
  const ::base::File& get_file_handle() const {
    CHECK(tag_ == Tag::kFileHandle);
    return data_.file_handle;
  }
  ::base::File& get_file_handle() {
    CHECK(tag_ == Tag::kFileHandle);
    return data_.file_handle;
  }
  void set_file_handle(::base::File file_handle);

  bool is_producer_handle() const { return tag_ == Tag::kProducerHandle; }
  const ::mojo::ScopedDataPipeProducerHandle& get_producer_handle() const {
    CHECK(tag_ == Tag::kProducerHandle);
    return data_.producer_handle;
  }
  ::mojo::ScopedDataPipeProducerHandle& get_producer_handle() {
    CHECK(tag_ == Tag::kProducerHandle);
    return data_.producer_handle;
  }
  void set_producer_handle(::mojo::ScopedDataPipeProducerHandle producer_handle);

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        MhtmlOutputHandle::DataView>(input);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    return mojo::internal::DeserializeImpl<MhtmlOutputHandle::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

 private:
  template <typename T>
  friend class ::mojo::InlinedStructPtr;
  template <typename T>
  friend class ::mojo::StructPtr;

  union Union_ {
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kFileHandle)>,
        ::base::File value);
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kProducerHandle)>,
        ::mojo::ScopedDataPipeProducerHandle value);
    // The contents of the union are explicitly destroyed by `DestroyActive()`.
    ~Union_() {}

    ::base::File file_handle;
    ::mojo::ScopedDataPipeProducerHandle producer_handle;
  };

  MhtmlOutputHandle(
      std::in_place_index_t<static_cast<size_t>(Tag::kFileHandle)>,
      ::base::File value);
  MhtmlOutputHandle(
      std::in_place_index_t<static_cast<size_t>(Tag::kProducerHandle)>,
      ::mojo::ScopedDataPipeProducerHandle value);

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  void DestroyActive();
  Tag tag_;
  Union_ data_;
};





class CONTENT_EXPORT SerializeAsMHTMLParams {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<SerializeAsMHTMLParams, T>::value>;
  using DataView = SerializeAsMHTMLParamsDataView;
  using Data_ = internal::SerializeAsMHTMLParams_Data;

  template <typename... Args>
  static SerializeAsMHTMLParamsPtr New(Args&&... args) {
    return SerializeAsMHTMLParamsPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static SerializeAsMHTMLParamsPtr From(const U& u) {
    return mojo::TypeConverter<SerializeAsMHTMLParamsPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, SerializeAsMHTMLParams>::Convert(*this);
  }


  SerializeAsMHTMLParams();

  SerializeAsMHTMLParams(
      const std::string& mhtml_boundary_marker,
      bool mhtml_binary_encoding,
      bool mhtml_popup_overlay_removal,
      std::vector<std::string> digests_of_uris_to_skip,
      const std::string& salt,
      MhtmlOutputHandlePtr output_handle);

SerializeAsMHTMLParams(const SerializeAsMHTMLParams&) = delete;
SerializeAsMHTMLParams& operator=(const SerializeAsMHTMLParams&) = delete;

  ~SerializeAsMHTMLParams();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = SerializeAsMHTMLParamsPtr>
  SerializeAsMHTMLParamsPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, SerializeAsMHTMLParams::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, SerializeAsMHTMLParams::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, SerializeAsMHTMLParams::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        SerializeAsMHTMLParams::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::SerializeAsMHTMLParams_UnserializedMessageContext<
            UserType, SerializeAsMHTMLParams::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<SerializeAsMHTMLParams::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return SerializeAsMHTMLParams::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::SerializeAsMHTMLParams_UnserializedMessageContext<
            UserType, SerializeAsMHTMLParams::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<SerializeAsMHTMLParams::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::string mhtml_boundary_marker;
  
  bool mhtml_binary_encoding;
  
  bool mhtml_popup_overlay_removal;
  
  std::vector<std::string> digests_of_uris_to_skip;
  
  std::string salt;
  
  MhtmlOutputHandlePtr output_handle;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, SerializeAsMHTMLParams::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, SerializeAsMHTMLParams::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, SerializeAsMHTMLParams::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, SerializeAsMHTMLParams::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename UnionPtrType>
MhtmlOutputHandlePtr MhtmlOutputHandle::Clone() const {
  switch (tag_) {
    case Tag::kFileHandle:
      return NewFileHandle(
          mojo::Clone(data_.file_handle));
    case Tag::kProducerHandle:
      return NewProducerHandle(
          mojo::Clone(data_.producer_handle));
  }
  return nullptr;
}

template <typename T,
          typename std::enable_if<std::is_same<
              T, MhtmlOutputHandle>::value>::type*>
bool MhtmlOutputHandle::Equals(const T& other) const {
  if (tag_ != other.which())
    return false;

  switch (tag_) {
    case Tag::kFileHandle:
      return mojo::Equals(data_.file_handle, other.data_.file_handle);
    case Tag::kProducerHandle:
      return mojo::Equals(data_.producer_handle, other.data_.producer_handle);
  }

  return false;
}
template <typename StructPtrType>
SerializeAsMHTMLParamsPtr SerializeAsMHTMLParams::Clone() const {
  return New(
      mojo::Clone(mhtml_boundary_marker),
      mojo::Clone(mhtml_binary_encoding),
      mojo::Clone(mhtml_popup_overlay_removal),
      mojo::Clone(digests_of_uris_to_skip),
      mojo::Clone(salt),
      mojo::Clone(output_handle)
  );
}

template <typename T, SerializeAsMHTMLParams::EnableIfSame<T>*>
bool SerializeAsMHTMLParams::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->mhtml_boundary_marker, other_struct.mhtml_boundary_marker))
    return false;
  if (!mojo::Equals(this->mhtml_binary_encoding, other_struct.mhtml_binary_encoding))
    return false;
  if (!mojo::Equals(this->mhtml_popup_overlay_removal, other_struct.mhtml_popup_overlay_removal))
    return false;
  if (!mojo::Equals(this->digests_of_uris_to_skip, other_struct.digests_of_uris_to_skip))
    return false;
  if (!mojo::Equals(this->salt, other_struct.salt))
    return false;
  if (!mojo::Equals(this->output_handle, other_struct.output_handle))
    return false;
  return true;
}

template <typename T, SerializeAsMHTMLParams::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.mhtml_boundary_marker < rhs.mhtml_boundary_marker)
    return true;
  if (rhs.mhtml_boundary_marker < lhs.mhtml_boundary_marker)
    return false;
  if (lhs.mhtml_binary_encoding < rhs.mhtml_binary_encoding)
    return true;
  if (rhs.mhtml_binary_encoding < lhs.mhtml_binary_encoding)
    return false;
  if (lhs.mhtml_popup_overlay_removal < rhs.mhtml_popup_overlay_removal)
    return true;
  if (rhs.mhtml_popup_overlay_removal < lhs.mhtml_popup_overlay_removal)
    return false;
  if (lhs.digests_of_uris_to_skip < rhs.digests_of_uris_to_skip)
    return true;
  if (rhs.digests_of_uris_to_skip < lhs.digests_of_uris_to_skip)
    return false;
  if (lhs.salt < rhs.salt)
    return true;
  if (rhs.salt < lhs.salt)
    return false;
  if (lhs.output_handle < rhs.output_handle)
    return true;
  if (rhs.output_handle < lhs.output_handle)
    return false;
  return false;
}


}  // content::mojom

namespace mojo {


template <>
struct CONTENT_EXPORT StructTraits<::content::mojom::SerializeAsMHTMLParams::DataView,
                                         ::content::mojom::SerializeAsMHTMLParamsPtr> {
  static bool IsNull(const ::content::mojom::SerializeAsMHTMLParamsPtr& input) { return !input; }
  static void SetToNull(::content::mojom::SerializeAsMHTMLParamsPtr* output) { output->reset(); }

  static const decltype(::content::mojom::SerializeAsMHTMLParams::mhtml_boundary_marker)& mhtml_boundary_marker(
      const ::content::mojom::SerializeAsMHTMLParamsPtr& input) {
    return input->mhtml_boundary_marker;
  }

  static decltype(::content::mojom::SerializeAsMHTMLParams::mhtml_binary_encoding) mhtml_binary_encoding(
      const ::content::mojom::SerializeAsMHTMLParamsPtr& input) {
    return input->mhtml_binary_encoding;
  }

  static decltype(::content::mojom::SerializeAsMHTMLParams::mhtml_popup_overlay_removal) mhtml_popup_overlay_removal(
      const ::content::mojom::SerializeAsMHTMLParamsPtr& input) {
    return input->mhtml_popup_overlay_removal;
  }

  static const decltype(::content::mojom::SerializeAsMHTMLParams::digests_of_uris_to_skip)& digests_of_uris_to_skip(
      const ::content::mojom::SerializeAsMHTMLParamsPtr& input) {
    return input->digests_of_uris_to_skip;
  }

  static const decltype(::content::mojom::SerializeAsMHTMLParams::salt)& salt(
      const ::content::mojom::SerializeAsMHTMLParamsPtr& input) {
    return input->salt;
  }

  static  decltype(::content::mojom::SerializeAsMHTMLParams::output_handle)& output_handle(
       ::content::mojom::SerializeAsMHTMLParamsPtr& input) {
    return input->output_handle;
  }

  static bool Read(::content::mojom::SerializeAsMHTMLParams::DataView input, ::content::mojom::SerializeAsMHTMLParamsPtr* output);
};


template <>
struct CONTENT_EXPORT UnionTraits<::content::mojom::MhtmlOutputHandle::DataView,
                                        ::content::mojom::MhtmlOutputHandlePtr> {
  static bool IsNull(const ::content::mojom::MhtmlOutputHandlePtr& input) { return !input; }
  static void SetToNull(::content::mojom::MhtmlOutputHandlePtr* output) { output->reset(); }

  static ::content::mojom::MhtmlOutputHandle::Tag GetTag(const ::content::mojom::MhtmlOutputHandlePtr& input) {
    return input->which();
  }

  static  ::base::File& file_handle( ::content::mojom::MhtmlOutputHandlePtr& input) {
    return input->get_file_handle();
  }

  static  ::mojo::ScopedDataPipeProducerHandle& producer_handle( ::content::mojom::MhtmlOutputHandlePtr& input) {
    return input->get_producer_handle();
  }

  static bool Read(::content::mojom::MhtmlOutputHandle::DataView input, ::content::mojom::MhtmlOutputHandlePtr* output);
};

}  // namespace mojo

#endif  // CONTENT_COMMON_DOWNLOAD_MHTML_FILE_WRITER_MOJOM_H_