// content/common/memory_coordinator/mojom/memory_coordinator.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "content/common/memory_coordinator/mojom/memory_coordinator.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "content/common/memory_coordinator/mojom/memory_coordinator.mojom-params-data.h"
namespace content {
namespace mojom {

namespace internal {


// static
bool MemoryConsumerTraits_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const MemoryConsumerTraits_Data* object =
      static_cast<const MemoryConsumerTraits_Data*>(data);

  return true;
}

MemoryConsumerTraits_Data::MemoryConsumerTraits_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ChildMemoryConsumer_NotifyReleaseMemory_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ChildMemoryConsumer_NotifyReleaseMemory_Params_Data* object =
      static_cast<const ChildMemoryConsumer_NotifyReleaseMemory_Params_Data*>(data);

  return true;
}

ChildMemoryConsumer_NotifyReleaseMemory_Params_Data::ChildMemoryConsumer_NotifyReleaseMemory_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ChildMemoryConsumer_NotifyUpdateMemoryLimit_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ChildMemoryConsumer_NotifyUpdateMemoryLimit_Params_Data* object =
      static_cast<const ChildMemoryConsumer_NotifyUpdateMemoryLimit_Params_Data*>(data);

  return true;
}

ChildMemoryConsumer_NotifyUpdateMemoryLimit_Params_Data::ChildMemoryConsumer_NotifyUpdateMemoryLimit_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool BrowserMemoryConsumerRegistry_RegisterChildMemoryConsumer_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const BrowserMemoryConsumerRegistry_RegisterChildMemoryConsumer_Params_Data* object =
      static_cast<const BrowserMemoryConsumerRegistry_RegisterChildMemoryConsumer_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->consumer_id, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& consumer_id_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->consumer_id, validation_context,
                                         &consumer_id_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->traits, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->traits, validation_context))
    return false;

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->child_consumer, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->child_consumer,
                                                 validation_context)) {
    return false;
  }

  return true;
}

BrowserMemoryConsumerRegistry_RegisterChildMemoryConsumer_Params_Data::BrowserMemoryConsumerRegistry_RegisterChildMemoryConsumer_Params_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace content