// content/common/renderer_host.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CONTENT_COMMON_RENDERER_HOST_MOJOM_H_
#define CONTENT_COMMON_RENDERER_HOST_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "content/common/renderer_host.mojom-features.h"  // IWYU pragma: export
#include "content/common/renderer_host.mojom-shared.h"  // IWYU pragma: export
#include "content/common/renderer_host.mojom-forward.h"  // IWYU pragma: export
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/lib/message_size_estimator.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"


#include "content/common/content_export.h"




namespace content::mojom {

class RendererHostProxy;

template <typename ImplRefTraits>
class RendererHostStub;

class RendererHostRequestValidator;
class RendererHostResponseValidator;


class CONTENT_EXPORT RendererHost
    : public RendererHostInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "content.mojom.RendererHost";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static inline constexpr uint32_t kSyncMethodOrdinals[] = {
    1603729263, 
    2121472851
  };
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = RendererHostInterfaceBase;
  using Proxy_ = RendererHostProxy;

  template <typename ImplRefTraits>
  using Stub_ = RendererHostStub<ImplRefTraits>;

  using RequestValidator_ = RendererHostRequestValidator;
  using ResponseValidator_ = RendererHostResponseValidator;
  enum MethodMinVersions : uint32_t {
    kGetBrowserHistogramMinVersion = 0,
    kSuddenTerminationChangedMinVersion = 0,
    kRecordUserMetricsActionMinVersion = 0,
    kHasGpuProcessMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct GetBrowserHistogram_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SuddenTerminationChanged_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct RecordUserMetricsAction_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct HasGpuProcess_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~RendererHost() = default;

  // Sync method. This signature is used by the client side; the service side
  // should implement the signature with callback below.
  
  virtual bool GetBrowserHistogram(const std::string& name, std::string* out_histogram_json);
  using GetBrowserHistogramCallback = base::OnceCallback<void(const std::string&)>;
  using GetBrowserHistogramMojoCallback = base::OnceCallback<void(const std::string&)>;

  virtual void GetBrowserHistogram(const std::string& name, GetBrowserHistogramCallback callback) = 0;

  virtual void SuddenTerminationChanged(bool enabled) = 0;

  virtual void RecordUserMetricsAction(const std::string& action) = 0;

  // Sync method. This signature is used by the client side; the service side
  // should implement the signature with callback below.
  
  virtual bool HasGpuProcess(bool* out_has_gpu_process);
  using HasGpuProcessCallback = base::OnceCallback<void(bool)>;
  using HasGpuProcessMojoCallback = base::OnceCallback<void(bool)>;

  virtual void HasGpuProcess(HasGpuProcessCallback callback) = 0;
};



class CONTENT_EXPORT RendererHostProxy
    : public RendererHost {
 public:
  using InterfaceType = RendererHost;

  explicit RendererHostProxy(mojo::MessageReceiverWithResponder* receiver);
  
  bool GetBrowserHistogram(const std::string& name, std::string* out_histogram_json) final;
  
  void GetBrowserHistogram(const std::string& name, GetBrowserHistogramCallback callback) final;
  
  void SuddenTerminationChanged(bool enabled) final;
  
  void RecordUserMetricsAction(const std::string& action) final;
  
  bool HasGpuProcess(bool* out_has_gpu_process) final;
  
  void HasGpuProcess(HasGpuProcessCallback callback) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class CONTENT_EXPORT RendererHostStubDispatch {
 public:
  static bool Accept(RendererHost* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      RendererHost* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<RendererHost>>
class RendererHostStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  RendererHostStub() = default;
  ~RendererHostStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return RendererHostStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return RendererHostStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class CONTENT_EXPORT RendererHostRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class CONTENT_EXPORT RendererHostResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};





}  // content::mojom

namespace mojo {

}  // namespace mojo

#endif  // CONTENT_COMMON_RENDERER_HOST_MOJOM_H_