// content/common/synthetic_trial_configuration.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CONTENT_COMMON_SYNTHETIC_TRIAL_CONFIGURATION_MOJOM_SHARED_H_
#define CONTENT_COMMON_SYNTHETIC_TRIAL_CONFIGURATION_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "content/common/synthetic_trial_configuration.mojom-shared-internal.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization.h"
#include "mojo/public/cpp/system/data_pipe.h"



#include "content/common/synthetic_trial_configuration.mojom-data-view.h"
#include "base/component_export.h"




namespace std {

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::content::mojom::SyntheticTrialGroupDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::content::mojom::SyntheticTrialGroupDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::content::mojom::internal::SyntheticTrialGroup_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::trial_name(input)) in_trial_name = Traits::trial_name(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->trial_name)::BaseType> trial_name_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_trial_name,
      trial_name_fragment);

    fragment->trial_name.Set(
        trial_name_fragment.is_null() ? nullptr : trial_name_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->trial_name.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null trial_name in SyntheticTrialGroup struct");

    decltype(Traits::group_name(input)) in_group_name = Traits::group_name(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->group_name)::BaseType> group_name_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_group_name,
      group_name_fragment);

    fragment->group_name.Set(
        group_name_fragment.is_null() ? nullptr : group_name_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->group_name.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null group_name in SyntheticTrialGroup struct");
  }

  static bool Deserialize(::content::mojom::internal::SyntheticTrialGroup_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::content::mojom::SyntheticTrialGroupDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace content::mojom {

inline void SyntheticTrialGroupDataView::GetTrialNameDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->trial_name.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void SyntheticTrialGroupDataView::GetGroupNameDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->group_name.Get();
  *output = mojo::StringDataView(pointer, message_);
}



}  // content::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

#endif  // CONTENT_COMMON_SYNTHETIC_TRIAL_CONFIGURATION_MOJOM_SHARED_H_