// extensions/common/mojom/event_dispatcher.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "extensions/common/mojom/event_dispatcher.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/features.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "extensions/common/mojom/event_dispatcher.mojom-params-data.h"
#include "extensions/common/mojom/event_dispatcher.mojom-shared-message-ids.h"

#include "extensions/common/mojom/event_dispatcher.mojom-import-headers.h"
#include "extensions/common/mojom/event_dispatcher.mojom-test-utils.h"


namespace extensions::mojom {
EventFilteringInfo::EventFilteringInfo()
    : url(),
      service_type(),
      has_instance_id(),
      instance_id(),
      window_type(),
      has_window_exposed_by_default(),
      window_exposed_by_default() {}

EventFilteringInfo::EventFilteringInfo(
    const std::optional<::GURL>& url_in,
    const std::optional<std::string>& service_type_in,
    bool has_instance_id_in,
    int32_t instance_id_in,
    const std::optional<std::string>& window_type_in,
    bool has_window_exposed_by_default_in,
    bool window_exposed_by_default_in)
    : url(std::move(url_in)),
      service_type(std::move(service_type_in)),
      has_instance_id(std::move(has_instance_id_in)),
      instance_id(std::move(instance_id_in)),
      window_type(std::move(window_type_in)),
      has_window_exposed_by_default(std::move(has_window_exposed_by_default_in)),
      window_exposed_by_default(std::move(window_exposed_by_default_in)) {}

EventFilteringInfo::~EventFilteringInfo() = default;

void EventFilteringInfo::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "url"), this->url,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<::GURL>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "service_type"), this->service_type,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<std::string>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "has_instance_id"), this->has_instance_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "instance_id"), this->instance_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "window_type"), this->window_type,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<std::string>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "has_window_exposed_by_default"), this->has_window_exposed_by_default,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "window_exposed_by_default"), this->window_exposed_by_default,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool EventFilteringInfo::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
DispatchEventParams::DispatchEventParams()
    : worker_thread_id(),
      host_id(),
      event_name(),
      event_id(),
      is_user_gesture(),
      filtering_info() {}

DispatchEventParams::DispatchEventParams(
    int32_t worker_thread_id_in,
    ::extensions::mojom::HostIDPtr host_id_in,
    const std::string& event_name_in,
    int32_t event_id_in,
    bool is_user_gesture_in,
    EventFilteringInfoPtr filtering_info_in)
    : worker_thread_id(std::move(worker_thread_id_in)),
      host_id(std::move(host_id_in)),
      event_name(std::move(event_name_in)),
      event_id(std::move(event_id_in)),
      is_user_gesture(std::move(is_user_gesture_in)),
      filtering_info(std::move(filtering_info_in)) {}

DispatchEventParams::~DispatchEventParams() = default;

void DispatchEventParams::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "worker_thread_id"), this->worker_thread_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "host_id"), this->host_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::extensions::mojom::HostIDPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "event_name"), this->event_name,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "event_id"), this->event_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "is_user_gesture"), this->is_user_gesture,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "filtering_info"), this->filtering_info,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type EventFilteringInfoPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool DispatchEventParams::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
// The declaration includes the definition on other builds.

EventDispatcher::IPCStableHashFunction EventDispatcher::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::EventDispatcher>(message.name())) {
    case messages::EventDispatcher::kDispatchEvent: {
      return &EventDispatcher::DispatchEvent_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* EventDispatcher::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::EventDispatcher>(message.name())) {
      case messages::EventDispatcher::kDispatchEvent:
            return "Receive extensions::mojom::EventDispatcher::DispatchEvent";
    }
  } else {
    switch (static_cast<messages::EventDispatcher>(message.name())) {
      case messages::EventDispatcher::kDispatchEvent:
            return "Receive reply extensions::mojom::EventDispatcher::DispatchEvent";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t EventDispatcher::DispatchEvent_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xa8e20f17;  // IPCStableHash for extensions::mojom::EventDispatcher::DispatchEvent
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

class EventDispatcher_DispatchEvent_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  EventDispatcher_DispatchEvent_ForwardToCallback(
      EventDispatcher::DispatchEventCallback callback
      ) : callback_(std::move(callback)) {
  }

  EventDispatcher_DispatchEvent_ForwardToCallback(const EventDispatcher_DispatchEvent_ForwardToCallback&) = delete;
  EventDispatcher_DispatchEvent_ForwardToCallback& operator=(const EventDispatcher_DispatchEvent_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  EventDispatcher::DispatchEventCallback callback_;
};

EventDispatcherProxy::EventDispatcherProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void EventDispatcherProxy::DispatchEvent(
    DispatchEventParamsPtr in_params, ::base::Value::List in_event_args, DispatchEventCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send extensions::mojom::EventDispatcher::DispatchEvent", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("params"), in_params,
                        "<value of type DispatchEventParamsPtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("event_args"), in_event_args,
                        "<value of type ::base::Value::List>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::EventDispatcher::kDispatchEvent), kFlags,
      MOJO_CREATE_MESSAGE_FLAG_UNLIMITED_SIZE,
      estimated_payload_size);
  mojo::internal::MessageFragment<
      ::extensions::mojom::internal::EventDispatcher_DispatchEvent_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->params)::BaseType> params_fragment(
          params.message());
  
  mojo::internal::Serialize<::extensions::mojom::DispatchEventParamsDataView>(
    in_params,
    params_fragment);

  params->params.Set(
      params_fragment.is_null() ? nullptr : params_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->params.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null params in EventDispatcher.DispatchEvent request");
  mojo::internal::MessageFragment<
      typename decltype(params->event_args)::BaseType> event_args_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::ListValueDataView>(
    in_event_args,
    event_args_fragment);

  params->event_args.Set(
      event_args_fragment.is_null() ? nullptr : event_args_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->event_args.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null event_args in EventDispatcher.DispatchEvent request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(EventDispatcher::Name_);
  message.set_method_name("DispatchEvent");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new EventDispatcher_DispatchEvent_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}
class EventDispatcher_DispatchEvent_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static EventDispatcher::DispatchEventCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<EventDispatcher_DispatchEvent_ProxyToResponder> proxy(
        new EventDispatcher_DispatchEvent_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&EventDispatcher_DispatchEvent_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~EventDispatcher_DispatchEvent_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  EventDispatcher_DispatchEvent_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "EventDispatcher::DispatchEventCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      bool in_event_will_run_in_lazy_background_page_script);
};

bool EventDispatcher_DispatchEvent_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::EventDispatcher_DispatchEvent_ResponseParams_Data* params =
      reinterpret_cast<
          internal::EventDispatcher_DispatchEvent_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for EventDispatcher.0
  bool success = true;
  bool p_event_will_run_in_lazy_background_page_script{};
  EventDispatcher_DispatchEvent_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_event_will_run_in_lazy_background_page_script = input_data_view.event_will_run_in_lazy_background_page_script();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        EventDispatcher::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_event_will_run_in_lazy_background_page_script));
  }
  return true;
}

void EventDispatcher_DispatchEvent_ProxyToResponder::Run(
    bool in_event_will_run_in_lazy_background_page_script) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply extensions::mojom::EventDispatcher::DispatchEvent", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("event_will_run_in_lazy_background_page_script"), in_event_will_run_in_lazy_background_page_script,
                        "<value of type bool>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::EventDispatcher::kDispatchEvent), kFlags,
      MOJO_CREATE_MESSAGE_FLAG_UNLIMITED_SIZE,
      estimated_payload_size);
  mojo::internal::MessageFragment<
      ::extensions::mojom::internal::EventDispatcher_DispatchEvent_ResponseParams_Data> params(
          message);
  params.Allocate();

  params->event_will_run_in_lazy_background_page_script = in_event_will_run_in_lazy_background_page_script;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(EventDispatcher::Name_);
  message.set_method_name("DispatchEvent");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool EventDispatcherStubDispatch::Accept(
    EventDispatcher* impl,
    mojo::Message* message) {
  switch (static_cast<messages::EventDispatcher>(message->header()->name)) {
    case messages::EventDispatcher::kDispatchEvent: {
      break;
    }
  }
  return false;
}

// static
bool EventDispatcherStubDispatch::AcceptWithResponder(
    EventDispatcher* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::EventDispatcher>(message->header()->name)) {
    case messages::EventDispatcher::kDispatchEvent: {
      internal::EventDispatcher_DispatchEvent_Params_Data* params =
          reinterpret_cast<
              internal::EventDispatcher_DispatchEvent_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for EventDispatcher.0
      bool success = true;
      DispatchEventParamsPtr p_params{};
      ::base::Value::List p_event_args{};
      EventDispatcher_DispatchEvent_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadParams(&p_params))
        success = false;
      if (success && !input_data_view.ReadEventArgs(&p_event_args))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            EventDispatcher::Name_, 0, false);
        return false;
      }
      auto callback =
          EventDispatcher_DispatchEvent_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DispatchEvent(        
        std::move(p_params), 
        std::move(p_event_args), std::move(callback));
      return true;
    }
  }
  return false;
}
namespace {
}  // namespace
static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kEventDispatcherValidationInfo[] = {
    {base::to_underlying(messages::EventDispatcher::kDispatchEvent),
     { &internal::EventDispatcher_DispatchEvent_Params_Data::Validate,
      &internal::EventDispatcher_DispatchEvent_ResponseParams_Data::Validate}},
};

bool EventDispatcherRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGeneric(
    message,
    ::extensions::mojom::EventDispatcher::Name_,
    kEventDispatcherValidationInfo);
}

bool EventDispatcherResponseValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateResponseGeneric(
    message,
    ::extensions::mojom::EventDispatcher::Name_,
    kEventDispatcherValidationInfo);

}


}  // extensions::mojom


namespace mojo {


// static
bool StructTraits<::extensions::mojom::EventFilteringInfo::DataView, ::extensions::mojom::EventFilteringInfoPtr>::Read(
    ::extensions::mojom::EventFilteringInfo::DataView input,
    ::extensions::mojom::EventFilteringInfoPtr* output) {
  bool success = true;
  ::extensions::mojom::EventFilteringInfoPtr result(::extensions::mojom::EventFilteringInfo::New());
  
      if (success && !input.ReadUrl(&result->url))
        success = false;
      if (success && !input.ReadServiceType(&result->service_type))
        success = false;
      if (success)
        result->has_instance_id = input.has_instance_id();
      if (success)
        result->instance_id = input.instance_id();
      if (success && !input.ReadWindowType(&result->window_type))
        success = false;
      if (success)
        result->has_window_exposed_by_default = input.has_window_exposed_by_default();
      if (success)
        result->window_exposed_by_default = input.window_exposed_by_default();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::extensions::mojom::DispatchEventParams::DataView, ::extensions::mojom::DispatchEventParamsPtr>::Read(
    ::extensions::mojom::DispatchEventParams::DataView input,
    ::extensions::mojom::DispatchEventParamsPtr* output) {
  bool success = true;
  ::extensions::mojom::DispatchEventParamsPtr result(::extensions::mojom::DispatchEventParams::New());
  
      if (success)
        result->worker_thread_id = input.worker_thread_id();
      if (success && !input.ReadHostId(&result->host_id))
        success = false;
      if (success && !input.ReadEventName(&result->event_name))
        success = false;
      if (success)
        result->event_id = input.event_id();
      if (success)
        result->is_user_gesture = input.is_user_gesture();
      if (success && !input.ReadFilteringInfo(&result->filtering_info))
        success = false;
  *output = std::move(result);
  return success;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace extensions::mojom {


void EventDispatcherInterceptorForTesting::DispatchEvent(DispatchEventParamsPtr params, ::base::Value::List event_args, DispatchEventCallback callback) {
  GetForwardingInterface()->DispatchEvent(
    std::move(params)
    , 
    std::move(event_args)
    , std::move(callback));
}
EventDispatcherAsyncWaiter::EventDispatcherAsyncWaiter(
    EventDispatcher* proxy) : proxy_(proxy) {}

EventDispatcherAsyncWaiter::~EventDispatcherAsyncWaiter() = default;


void EventDispatcherAsyncWaiter::DispatchEvent(
    DispatchEventParamsPtr params, ::base::Value::List event_args, bool* out_event_will_run_in_lazy_background_page_script) {
  base::RunLoop loop;
  proxy_->DispatchEvent(
      std::move(params),
      std::move(event_args),
      base::BindOnce(
          [](base::RunLoop* loop,
             bool* out_event_will_run_in_lazy_background_page_script
,
             bool event_will_run_in_lazy_background_page_script) {*out_event_will_run_in_lazy_background_page_script = std::move(event_will_run_in_lazy_background_page_script);
            loop->Quit();
          },
          &loop,
          out_event_will_run_in_lazy_background_page_script));
  loop.Run();
}

bool EventDispatcherAsyncWaiter::DispatchEvent(
    DispatchEventParamsPtr params, ::base::Value::List event_args) {
  bool async_wait_result;
  DispatchEvent(std::move(params),std::move(event_args),&async_wait_result);
  return async_wait_result;
}






}  // extensions::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif