// media/mojo/mojom/audio_decoder.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "media/mojo/mojom/audio_decoder.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/features.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "media/mojo/mojom/audio_decoder.mojom-params-data.h"
#include "media/mojo/mojom/audio_decoder.mojom-shared-message-ids.h"

#include "media/mojo/mojom/audio_decoder.mojom-import-headers.h"
#include "media/mojo/mojom/audio_decoder.mojom-test-utils.h"
#include "media/mojo/mojom/video_decoder_config_mojom_traits.h"


namespace media::mojom {
SupportedAudioDecoderConfig::SupportedAudioDecoderConfig()
    : codec(),
      profile() {}

SupportedAudioDecoderConfig::SupportedAudioDecoderConfig(
    ::media::AudioCodec codec_in,
    ::media::AudioCodecProfile profile_in)
    : codec(std::move(codec_in)),
      profile(std::move(profile_in)) {}

SupportedAudioDecoderConfig::~SupportedAudioDecoderConfig() = default;

void SupportedAudioDecoderConfig::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "codec"), this->codec,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::media::AudioCodec>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "profile"), this->profile,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::media::AudioCodecProfile>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool SupportedAudioDecoderConfig::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
// The declaration includes the definition on other builds.

AudioDecoder::IPCStableHashFunction AudioDecoder::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::AudioDecoder>(message.name())) {
    case messages::AudioDecoder::kGetSupportedConfigs: {
      return &AudioDecoder::GetSupportedConfigs_Sym::IPCStableHash;
    }
    case messages::AudioDecoder::kConstruct: {
      return &AudioDecoder::Construct_Sym::IPCStableHash;
    }
    case messages::AudioDecoder::kInitialize: {
      return &AudioDecoder::Initialize_Sym::IPCStableHash;
    }
    case messages::AudioDecoder::kSetDataSource: {
      return &AudioDecoder::SetDataSource_Sym::IPCStableHash;
    }
    case messages::AudioDecoder::kDecode: {
      return &AudioDecoder::Decode_Sym::IPCStableHash;
    }
    case messages::AudioDecoder::kReset: {
      return &AudioDecoder::Reset_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* AudioDecoder::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::AudioDecoder>(message.name())) {
      case messages::AudioDecoder::kGetSupportedConfigs:
            return "Receive media::mojom::AudioDecoder::GetSupportedConfigs";
      case messages::AudioDecoder::kConstruct:
            return "Receive media::mojom::AudioDecoder::Construct";
      case messages::AudioDecoder::kInitialize:
            return "Receive media::mojom::AudioDecoder::Initialize";
      case messages::AudioDecoder::kSetDataSource:
            return "Receive media::mojom::AudioDecoder::SetDataSource";
      case messages::AudioDecoder::kDecode:
            return "Receive media::mojom::AudioDecoder::Decode";
      case messages::AudioDecoder::kReset:
            return "Receive media::mojom::AudioDecoder::Reset";
    }
  } else {
    switch (static_cast<messages::AudioDecoder>(message.name())) {
      case messages::AudioDecoder::kGetSupportedConfigs:
            return "Receive reply media::mojom::AudioDecoder::GetSupportedConfigs";
      case messages::AudioDecoder::kConstruct:
            return "Receive reply media::mojom::AudioDecoder::Construct";
      case messages::AudioDecoder::kInitialize:
            return "Receive reply media::mojom::AudioDecoder::Initialize";
      case messages::AudioDecoder::kSetDataSource:
            return "Receive reply media::mojom::AudioDecoder::SetDataSource";
      case messages::AudioDecoder::kDecode:
            return "Receive reply media::mojom::AudioDecoder::Decode";
      case messages::AudioDecoder::kReset:
            return "Receive reply media::mojom::AudioDecoder::Reset";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t AudioDecoder::GetSupportedConfigs_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x8fde92af;  // IPCStableHash for media::mojom::AudioDecoder::GetSupportedConfigs
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t AudioDecoder::Construct_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x581ede0a;  // IPCStableHash for media::mojom::AudioDecoder::Construct
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t AudioDecoder::Initialize_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x829e204a;  // IPCStableHash for media::mojom::AudioDecoder::Initialize
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t AudioDecoder::SetDataSource_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x1fde850f;  // IPCStableHash for media::mojom::AudioDecoder::SetDataSource
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t AudioDecoder::Decode_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xafd70a8a;  // IPCStableHash for media::mojom::AudioDecoder::Decode
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t AudioDecoder::Reset_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x63628bcf;  // IPCStableHash for media::mojom::AudioDecoder::Reset
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)
bool AudioDecoder::GetSupportedConfigs(std::vector<::media::SupportedAudioDecoderConfig>* out_supported_configs) {
  NOTREACHED();
}
class AudioDecoder_GetSupportedConfigs_HandleSyncResponse
    : public mojo::MessageReceiver {
 public:
  AudioDecoder_GetSupportedConfigs_HandleSyncResponse(
      bool* result, std::vector<::media::SupportedAudioDecoderConfig>* out_supported_configs)
      : result_(result), out_supported_configs_(out_supported_configs) {
    DCHECK(!*result_);
  }

  AudioDecoder_GetSupportedConfigs_HandleSyncResponse(const AudioDecoder_GetSupportedConfigs_HandleSyncResponse&) = delete;
  AudioDecoder_GetSupportedConfigs_HandleSyncResponse& operator=(const AudioDecoder_GetSupportedConfigs_HandleSyncResponse&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  bool* result_;
  std::vector<::media::SupportedAudioDecoderConfig>* out_supported_configs_;};

class AudioDecoder_GetSupportedConfigs_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  AudioDecoder_GetSupportedConfigs_ForwardToCallback(
      AudioDecoder::GetSupportedConfigsCallback callback
      ) : callback_(std::move(callback)) {
  }

  AudioDecoder_GetSupportedConfigs_ForwardToCallback(const AudioDecoder_GetSupportedConfigs_ForwardToCallback&) = delete;
  AudioDecoder_GetSupportedConfigs_ForwardToCallback& operator=(const AudioDecoder_GetSupportedConfigs_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  AudioDecoder::GetSupportedConfigsCallback callback_;
};

class AudioDecoder_Initialize_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  AudioDecoder_Initialize_ForwardToCallback(
      AudioDecoder::InitializeCallback callback
      ) : callback_(std::move(callback)) {
  }

  AudioDecoder_Initialize_ForwardToCallback(const AudioDecoder_Initialize_ForwardToCallback&) = delete;
  AudioDecoder_Initialize_ForwardToCallback& operator=(const AudioDecoder_Initialize_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  AudioDecoder::InitializeCallback callback_;
};

class AudioDecoder_Decode_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  AudioDecoder_Decode_ForwardToCallback(
      AudioDecoder::DecodeCallback callback
      ) : callback_(std::move(callback)) {
  }

  AudioDecoder_Decode_ForwardToCallback(const AudioDecoder_Decode_ForwardToCallback&) = delete;
  AudioDecoder_Decode_ForwardToCallback& operator=(const AudioDecoder_Decode_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  AudioDecoder::DecodeCallback callback_;
};

class AudioDecoder_Reset_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  AudioDecoder_Reset_ForwardToCallback(
      AudioDecoder::ResetCallback callback
      ) : callback_(std::move(callback)) {
  }

  AudioDecoder_Reset_ForwardToCallback(const AudioDecoder_Reset_ForwardToCallback&) = delete;
  AudioDecoder_Reset_ForwardToCallback& operator=(const AudioDecoder_Reset_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  AudioDecoder::ResetCallback callback_;
};

AudioDecoderProxy::AudioDecoderProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}
bool AudioDecoderProxy::GetSupportedConfigs(
    std::vector<::media::SupportedAudioDecoderConfig>* out_param_supported_configs) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN0("mojom", "Call media::mojom::AudioDecoder::GetSupportedConfigs (sync)");
#else
  TRACE_EVENT0("mojom", "AudioDecoder::GetSupportedConfigs");
#endif
  
  const bool kExpectsResponse = true;
  const bool kIsSync = true;
  const bool kAllowInterrupt =
      true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::AudioDecoder::kGetSupportedConfigs), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::AudioDecoder_GetSupportedConfigs_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(AudioDecoder::Name_);
  message.set_method_name("GetSupportedConfigs");
#endif

  bool result = false;
  std::unique_ptr<mojo::MessageReceiver> responder(
      new AudioDecoder_GetSupportedConfigs_HandleSyncResponse(
          &result, out_param_supported_configs));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1(
    "mojom", "AudioDecoder::GetSupportedConfigs", "sync_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("supported_configs"), out_param_supported_configs,
                        "<value of type const std::vector<::media::SupportedAudioDecoderConfig>&>");
   });
#endif
  return result;
}

void AudioDecoderProxy::GetSupportedConfigs(
    GetSupportedConfigsCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send media::mojom::AudioDecoder::GetSupportedConfigs");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::AudioDecoder::kGetSupportedConfigs), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::AudioDecoder_GetSupportedConfigs_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(AudioDecoder::Name_);
  message.set_method_name("GetSupportedConfigs");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new AudioDecoder_GetSupportedConfigs_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void AudioDecoderProxy::Construct(
    ::mojo::PendingAssociatedRemote<AudioDecoderClient> in_client, ::mojo::PendingRemote<::media::mojom::MediaLog> in_media_log) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send media::mojom::AudioDecoder::Construct", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("client"), in_client,
                        "<value of type ::mojo::PendingAssociatedRemote<AudioDecoderClient>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("media_log"), in_media_log,
                        "<value of type ::mojo::PendingRemote<::media::mojom::MediaLog>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::AudioDecoder::kConstruct), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::AudioDecoder_Construct_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::media::mojom::AudioDecoderClientAssociatedPtrInfoDataView>(
    in_client,
    &params->client,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->client)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_INTERFACE_ID,
    "invalid client in AudioDecoder.Construct request");

  
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::media::mojom::MediaLogInterfaceBase>>(
    in_media_log,
    &params->media_log,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->media_log)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid media_log in AudioDecoder.Construct request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(AudioDecoder::Name_);
  message.set_method_name("Construct");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void AudioDecoderProxy::Initialize(
    const ::media::AudioDecoderConfig& in_config, const std::optional<::base::UnguessableToken>& in_cdm_id, InitializeCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send media::mojom::AudioDecoder::Initialize", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("config"), in_config,
                        "<value of type const ::media::AudioDecoderConfig&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("cdm_id"), in_cdm_id,
                        "<value of type const std::optional<::base::UnguessableToken>&>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::AudioDecoder::kInitialize), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::AudioDecoder_Initialize_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->config)::BaseType> config_fragment(
          params.message());
  
  mojo::internal::Serialize<::media::mojom::AudioDecoderConfigDataView>(
    in_config,
    config_fragment);

  params->config.Set(
      config_fragment.is_null() ? nullptr : config_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->config.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null config in AudioDecoder.Initialize request");
  mojo::internal::MessageFragment<
      typename decltype(params->cdm_id)::BaseType> cdm_id_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::UnguessableTokenDataView>(
    in_cdm_id,
    cdm_id_fragment);

  params->cdm_id.Set(
      cdm_id_fragment.is_null() ? nullptr : cdm_id_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(AudioDecoder::Name_);
  message.set_method_name("Initialize");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new AudioDecoder_Initialize_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void AudioDecoderProxy::SetDataSource(
    ::mojo::ScopedDataPipeConsumerHandle in_receive_pipe) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send media::mojom::AudioDecoder::SetDataSource", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("receive_pipe"), in_receive_pipe,
                        "<value of type ::mojo::ScopedDataPipeConsumerHandle>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::AudioDecoder::kSetDataSource), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::AudioDecoder_SetDataSource_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<mojo::ScopedDataPipeConsumerHandle>(
    in_receive_pipe,
    &params->receive_pipe,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->receive_pipe)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid receive_pipe in AudioDecoder.SetDataSource request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(AudioDecoder::Name_);
  message.set_method_name("SetDataSource");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void AudioDecoderProxy::Decode(
    ::media::mojom::DecoderBufferPtr in_buffer, DecodeCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send media::mojom::AudioDecoder::Decode", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("buffer"), in_buffer,
                        "<value of type ::media::mojom::DecoderBufferPtr>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::AudioDecoder::kDecode), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::AudioDecoder_Decode_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<decltype(params->buffer)>
      buffer_fragment(params.message());
  buffer_fragment.Claim(&params->buffer);
  
  mojo::internal::Serialize<::media::mojom::DecoderBufferDataView>(
    in_buffer,
    buffer_fragment,
    true);

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->buffer.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null buffer in AudioDecoder.Decode request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(AudioDecoder::Name_);
  message.set_method_name("Decode");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new AudioDecoder_Decode_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void AudioDecoderProxy::Reset(
    ResetCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send media::mojom::AudioDecoder::Reset");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::AudioDecoder::kReset), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::AudioDecoder_Reset_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(AudioDecoder::Name_);
  message.set_method_name("Reset");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new AudioDecoder_Reset_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}
class AudioDecoder_GetSupportedConfigs_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static AudioDecoder::GetSupportedConfigsCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<AudioDecoder_GetSupportedConfigs_ProxyToResponder> proxy(
        new AudioDecoder_GetSupportedConfigs_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&AudioDecoder_GetSupportedConfigs_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~AudioDecoder_GetSupportedConfigs_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  AudioDecoder_GetSupportedConfigs_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "AudioDecoder::GetSupportedConfigsCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      const std::vector<::media::SupportedAudioDecoderConfig>& in_supported_configs);
};

bool AudioDecoder_GetSupportedConfigs_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::AudioDecoder_GetSupportedConfigs_ResponseParams_Data* params =
      reinterpret_cast<
          internal::AudioDecoder_GetSupportedConfigs_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for AudioDecoder.0
  bool success = true;
  std::vector<::media::SupportedAudioDecoderConfig> p_supported_configs{};
  AudioDecoder_GetSupportedConfigs_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadSupportedConfigs(&p_supported_configs))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        AudioDecoder::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_supported_configs));
  }
  return true;
}

void AudioDecoder_GetSupportedConfigs_ProxyToResponder::Run(
    const std::vector<::media::SupportedAudioDecoderConfig>& in_supported_configs) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply media::mojom::AudioDecoder::GetSupportedConfigs", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("supported_configs"), in_supported_configs,
                        "<value of type const std::vector<::media::SupportedAudioDecoderConfig>&>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::AudioDecoder::kGetSupportedConfigs), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::AudioDecoder_GetSupportedConfigs_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->supported_configs)::BaseType>
      supported_configs_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& supported_configs_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<::media::mojom::SupportedAudioDecoderConfigDataView>>(
    in_supported_configs,
    supported_configs_fragment,
    &supported_configs_validate_params);

  params->supported_configs.Set(
      supported_configs_fragment.is_null() ? nullptr : supported_configs_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->supported_configs.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null supported_configs in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(AudioDecoder::Name_);
  message.set_method_name("GetSupportedConfigs");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
bool AudioDecoder_GetSupportedConfigs_HandleSyncResponse::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::AudioDecoder_GetSupportedConfigs_ResponseParams_Data* params =
      reinterpret_cast<internal::AudioDecoder_GetSupportedConfigs_ResponseParams_Data*>(
          message->mutable_payload());
  

  // Validation for AudioDecoder.0
  bool success = true;
  std::vector<::media::SupportedAudioDecoderConfig> p_supported_configs{};
  AudioDecoder_GetSupportedConfigs_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadSupportedConfigs(&p_supported_configs))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        AudioDecoder::Name_, 0, true);
    return false;
  }
  *out_supported_configs_ = std::move(p_supported_configs);
  *result_ = true;
  return true;
}
class AudioDecoder_Initialize_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static AudioDecoder::InitializeCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<AudioDecoder_Initialize_ProxyToResponder> proxy(
        new AudioDecoder_Initialize_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&AudioDecoder_Initialize_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~AudioDecoder_Initialize_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  AudioDecoder_Initialize_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "AudioDecoder::InitializeCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      const ::media::DecoderStatus& in_success, bool in_needs_bitstream_conversion, ::media::AudioDecoderType in_decoder_type);
};

bool AudioDecoder_Initialize_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::AudioDecoder_Initialize_ResponseParams_Data* params =
      reinterpret_cast<
          internal::AudioDecoder_Initialize_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for AudioDecoder.2
  bool success = true;
  ::media::DecoderStatus p_success{};
  bool p_needs_bitstream_conversion{};
  ::media::AudioDecoderType p_decoder_type{};
  AudioDecoder_Initialize_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadSuccess(&p_success))
    success = false;
  if (success)
    p_needs_bitstream_conversion = input_data_view.needs_bitstream_conversion();
  if (success && !input_data_view.ReadDecoderType(&p_decoder_type))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        AudioDecoder::Name_, 2, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_success), 
std::move(p_needs_bitstream_conversion), 
std::move(p_decoder_type));
  }
  return true;
}

void AudioDecoder_Initialize_ProxyToResponder::Run(
    const ::media::DecoderStatus& in_success, bool in_needs_bitstream_conversion, ::media::AudioDecoderType in_decoder_type) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply media::mojom::AudioDecoder::Initialize", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("success"), in_success,
                        "<value of type const ::media::DecoderStatus&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("needs_bitstream_conversion"), in_needs_bitstream_conversion,
                        "<value of type bool>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("decoder_type"), in_decoder_type,
                        "<value of type ::media::AudioDecoderType>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::AudioDecoder::kInitialize), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::AudioDecoder_Initialize_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->success)::BaseType> success_fragment(
          params.message());
  
  mojo::internal::Serialize<::media::mojom::DecoderStatusDataView>(
    in_success,
    success_fragment);

  params->success.Set(
      success_fragment.is_null() ? nullptr : success_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->success.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null success in ");

  params->needs_bitstream_conversion = in_needs_bitstream_conversion;

  
  mojo::internal::Serialize<::media::mojom::AudioDecoderType>(
    in_decoder_type,
    &params->decoder_type);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(AudioDecoder::Name_);
  message.set_method_name("Initialize");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class AudioDecoder_Decode_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static AudioDecoder::DecodeCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<AudioDecoder_Decode_ProxyToResponder> proxy(
        new AudioDecoder_Decode_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&AudioDecoder_Decode_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~AudioDecoder_Decode_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  AudioDecoder_Decode_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "AudioDecoder::DecodeCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      const ::media::DecoderStatus& in_status);
};

bool AudioDecoder_Decode_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::AudioDecoder_Decode_ResponseParams_Data* params =
      reinterpret_cast<
          internal::AudioDecoder_Decode_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for AudioDecoder.4
  bool success = true;
  ::media::DecoderStatus p_status{};
  AudioDecoder_Decode_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadStatus(&p_status))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        AudioDecoder::Name_, 4, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_status));
  }
  return true;
}

void AudioDecoder_Decode_ProxyToResponder::Run(
    const ::media::DecoderStatus& in_status) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply media::mojom::AudioDecoder::Decode", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("status"), in_status,
                        "<value of type const ::media::DecoderStatus&>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::AudioDecoder::kDecode), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::AudioDecoder_Decode_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->status)::BaseType> status_fragment(
          params.message());
  
  mojo::internal::Serialize<::media::mojom::DecoderStatusDataView>(
    in_status,
    status_fragment);

  params->status.Set(
      status_fragment.is_null() ? nullptr : status_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->status.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null status in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(AudioDecoder::Name_);
  message.set_method_name("Decode");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class AudioDecoder_Reset_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static AudioDecoder::ResetCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<AudioDecoder_Reset_ProxyToResponder> proxy(
        new AudioDecoder_Reset_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&AudioDecoder_Reset_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~AudioDecoder_Reset_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  AudioDecoder_Reset_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "AudioDecoder::ResetCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      );
};

bool AudioDecoder_Reset_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::AudioDecoder_Reset_ResponseParams_Data* params =
      reinterpret_cast<
          internal::AudioDecoder_Reset_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for AudioDecoder.5
  bool success = true;
  AudioDecoder_Reset_ResponseParamsDataView input_data_view(params, message);
  
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        AudioDecoder::Name_, 5, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run();
  }
  return true;
}

void AudioDecoder_Reset_ProxyToResponder::Run(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send reply media::mojom::AudioDecoder::Reset");
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::AudioDecoder::kReset), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::AudioDecoder_Reset_ResponseParams_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(AudioDecoder::Name_);
  message.set_method_name("Reset");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool AudioDecoderStubDispatch::Accept(
    AudioDecoder* impl,
    mojo::Message* message) {
  switch (static_cast<messages::AudioDecoder>(message->header()->name)) {
    case messages::AudioDecoder::kGetSupportedConfigs: {
      break;
    }
    case messages::AudioDecoder::kConstruct: {
      DCHECK(message->is_serialized());
      internal::AudioDecoder_Construct_Params_Data* params =
          reinterpret_cast<internal::AudioDecoder_Construct_Params_Data*>(
              message->mutable_payload());
      

      // Validation for AudioDecoder.1
      bool success = true;
      ::mojo::PendingAssociatedRemote<AudioDecoderClient> p_client{};
      ::mojo::PendingRemote<::media::mojom::MediaLog> p_media_log{};
      AudioDecoder_Construct_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_client =
            input_data_view.TakeClient<decltype(p_client)>();
      }
      if (success) {
        p_media_log =
            input_data_view.TakeMediaLog<decltype(p_media_log)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            AudioDecoder::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Construct(        
        std::move(p_client), 
        std::move(p_media_log));
      return true;
    }
    case messages::AudioDecoder::kInitialize: {
      break;
    }
    case messages::AudioDecoder::kSetDataSource: {
      DCHECK(message->is_serialized());
      internal::AudioDecoder_SetDataSource_Params_Data* params =
          reinterpret_cast<internal::AudioDecoder_SetDataSource_Params_Data*>(
              message->mutable_payload());
      

      // Validation for AudioDecoder.3
      bool success = true;
      ::mojo::ScopedDataPipeConsumerHandle p_receive_pipe{};
      AudioDecoder_SetDataSource_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_receive_pipe = input_data_view.TakeReceivePipe();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            AudioDecoder::Name_, 3, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetDataSource(        
        std::move(p_receive_pipe));
      return true;
    }
    case messages::AudioDecoder::kDecode: {
      break;
    }
    case messages::AudioDecoder::kReset: {
      break;
    }
  }
  return false;
}

// static
bool AudioDecoderStubDispatch::AcceptWithResponder(
    AudioDecoder* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::AudioDecoder>(message->header()->name)) {
    case messages::AudioDecoder::kGetSupportedConfigs: {
      internal::AudioDecoder_GetSupportedConfigs_Params_Data* params =
          reinterpret_cast<
              internal::AudioDecoder_GetSupportedConfigs_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for AudioDecoder.0
      bool success = true;
      AudioDecoder_GetSupportedConfigs_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            AudioDecoder::Name_, 0, false);
        return false;
      }
      auto callback =
          AudioDecoder_GetSupportedConfigs_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetSupportedConfigs(std::move(callback));
      return true;
    }
    case messages::AudioDecoder::kConstruct: {
      break;
    }
    case messages::AudioDecoder::kInitialize: {
      internal::AudioDecoder_Initialize_Params_Data* params =
          reinterpret_cast<
              internal::AudioDecoder_Initialize_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for AudioDecoder.2
      bool success = true;
      ::media::AudioDecoderConfig p_config{};
      std::optional<::base::UnguessableToken> p_cdm_id{};
      AudioDecoder_Initialize_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadConfig(&p_config))
        success = false;
      if (success && !input_data_view.ReadCdmId(&p_cdm_id))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            AudioDecoder::Name_, 2, false);
        return false;
      }
      auto callback =
          AudioDecoder_Initialize_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Initialize(        
        std::move(p_config), 
        std::move(p_cdm_id), std::move(callback));
      return true;
    }
    case messages::AudioDecoder::kSetDataSource: {
      break;
    }
    case messages::AudioDecoder::kDecode: {
      internal::AudioDecoder_Decode_Params_Data* params =
          reinterpret_cast<
              internal::AudioDecoder_Decode_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for AudioDecoder.4
      bool success = true;
      ::media::mojom::DecoderBufferPtr p_buffer{};
      AudioDecoder_Decode_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadBuffer(&p_buffer))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            AudioDecoder::Name_, 4, false);
        return false;
      }
      auto callback =
          AudioDecoder_Decode_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Decode(        
        std::move(p_buffer), std::move(callback));
      return true;
    }
    case messages::AudioDecoder::kReset: {
      internal::AudioDecoder_Reset_Params_Data* params =
          reinterpret_cast<
              internal::AudioDecoder_Reset_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for AudioDecoder.5
      bool success = true;
      AudioDecoder_Reset_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            AudioDecoder::Name_, 5, false);
        return false;
      }
      auto callback =
          AudioDecoder_Reset_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Reset(std::move(callback));
      return true;
    }
  }
  return false;
}
namespace {
}  // namespace
static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kAudioDecoderValidationInfo[] = {
    {base::to_underlying(messages::AudioDecoder::kGetSupportedConfigs),
     { &internal::AudioDecoder_GetSupportedConfigs_Params_Data::Validate,
      &internal::AudioDecoder_GetSupportedConfigs_ResponseParams_Data::Validate}},
    {base::to_underlying(messages::AudioDecoder::kConstruct),
     { &internal::AudioDecoder_Construct_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::AudioDecoder::kInitialize),
     { &internal::AudioDecoder_Initialize_Params_Data::Validate,
      &internal::AudioDecoder_Initialize_ResponseParams_Data::Validate}},
    {base::to_underlying(messages::AudioDecoder::kSetDataSource),
     { &internal::AudioDecoder_SetDataSource_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::AudioDecoder::kDecode),
     { &internal::AudioDecoder_Decode_Params_Data::Validate,
      &internal::AudioDecoder_Decode_ResponseParams_Data::Validate}},
    {base::to_underlying(messages::AudioDecoder::kReset),
     { &internal::AudioDecoder_Reset_Params_Data::Validate,
      &internal::AudioDecoder_Reset_ResponseParams_Data::Validate}},
};

bool AudioDecoderRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGeneric(
    message,
    ::media::mojom::AudioDecoder::Name_,
    kAudioDecoderValidationInfo);
}

bool AudioDecoderResponseValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateResponseGeneric(
    message,
    ::media::mojom::AudioDecoder::Name_,
    kAudioDecoderValidationInfo);

}
// The declaration includes the definition on other builds.

AudioDecoderClient::IPCStableHashFunction AudioDecoderClient::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::AudioDecoderClient>(message.name())) {
    case messages::AudioDecoderClient::kOnBufferDecoded: {
      return &AudioDecoderClient::OnBufferDecoded_Sym::IPCStableHash;
    }
    case messages::AudioDecoderClient::kOnWaiting: {
      return &AudioDecoderClient::OnWaiting_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* AudioDecoderClient::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::AudioDecoderClient>(message.name())) {
      case messages::AudioDecoderClient::kOnBufferDecoded:
            return "Receive media::mojom::AudioDecoderClient::OnBufferDecoded";
      case messages::AudioDecoderClient::kOnWaiting:
            return "Receive media::mojom::AudioDecoderClient::OnWaiting";
    }
  } else {
    switch (static_cast<messages::AudioDecoderClient>(message.name())) {
      case messages::AudioDecoderClient::kOnBufferDecoded:
            return "Receive reply media::mojom::AudioDecoderClient::OnBufferDecoded";
      case messages::AudioDecoderClient::kOnWaiting:
            return "Receive reply media::mojom::AudioDecoderClient::OnWaiting";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t AudioDecoderClient::OnBufferDecoded_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x4bc38fe1;  // IPCStableHash for media::mojom::AudioDecoderClient::OnBufferDecoded
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t AudioDecoderClient::OnWaiting_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xc23995f9;  // IPCStableHash for media::mojom::AudioDecoderClient::OnWaiting
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

AudioDecoderClientProxy::AudioDecoderClientProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void AudioDecoderClientProxy::OnBufferDecoded(
    ::media::mojom::AudioBufferPtr in_buffer) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send media::mojom::AudioDecoderClient::OnBufferDecoded", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("buffer"), in_buffer,
                        "<value of type ::media::mojom::AudioBufferPtr>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::AudioDecoderClient::kOnBufferDecoded), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::AudioDecoderClient_OnBufferDecoded_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->buffer)::BaseType> buffer_fragment(
          params.message());
  
  mojo::internal::Serialize<::media::mojom::AudioBufferDataView>(
    in_buffer,
    buffer_fragment);

  params->buffer.Set(
      buffer_fragment.is_null() ? nullptr : buffer_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->buffer.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null buffer in AudioDecoderClient.OnBufferDecoded request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(AudioDecoderClient::Name_);
  message.set_method_name("OnBufferDecoded");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void AudioDecoderClientProxy::OnWaiting(
    ::media::WaitingReason in_reason) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send media::mojom::AudioDecoderClient::OnWaiting", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("reason"), in_reason,
                        "<value of type ::media::WaitingReason>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::AudioDecoderClient::kOnWaiting), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::AudioDecoderClient_OnWaiting_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::media::mojom::WaitingReason>(
    in_reason,
    &params->reason);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(AudioDecoderClient::Name_);
  message.set_method_name("OnWaiting");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool AudioDecoderClientStubDispatch::Accept(
    AudioDecoderClient* impl,
    mojo::Message* message) {
  switch (static_cast<messages::AudioDecoderClient>(message->header()->name)) {
    case messages::AudioDecoderClient::kOnBufferDecoded: {
      DCHECK(message->is_serialized());
      internal::AudioDecoderClient_OnBufferDecoded_Params_Data* params =
          reinterpret_cast<internal::AudioDecoderClient_OnBufferDecoded_Params_Data*>(
              message->mutable_payload());
      

      // Validation for AudioDecoderClient.0
      bool success = true;
      ::media::mojom::AudioBufferPtr p_buffer{};
      AudioDecoderClient_OnBufferDecoded_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadBuffer(&p_buffer))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            AudioDecoderClient::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnBufferDecoded(        
        std::move(p_buffer));
      return true;
    }
    case messages::AudioDecoderClient::kOnWaiting: {
      DCHECK(message->is_serialized());
      internal::AudioDecoderClient_OnWaiting_Params_Data* params =
          reinterpret_cast<internal::AudioDecoderClient_OnWaiting_Params_Data*>(
              message->mutable_payload());
      

      // Validation for AudioDecoderClient.1
      bool success = true;
      ::media::WaitingReason p_reason{};
      AudioDecoderClient_OnWaiting_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadReason(&p_reason))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            AudioDecoderClient::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnWaiting(        
        std::move(p_reason));
      return true;
    }
  }
  return false;
}

// static
bool AudioDecoderClientStubDispatch::AcceptWithResponder(
    AudioDecoderClient* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::AudioDecoderClient>(message->header()->name)) {
    case messages::AudioDecoderClient::kOnBufferDecoded: {
      break;
    }
    case messages::AudioDecoderClient::kOnWaiting: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kAudioDecoderClientValidationInfo[] = {
    {base::to_underlying(messages::AudioDecoderClient::kOnBufferDecoded),
     { &internal::AudioDecoderClient_OnBufferDecoded_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::AudioDecoderClient::kOnWaiting),
     { &internal::AudioDecoderClient_OnWaiting_Params_Data::Validate,
      nullptr /* no response */}},
};

bool AudioDecoderClientRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGeneric(
    message,
    ::media::mojom::AudioDecoderClient::Name_,
    kAudioDecoderClientValidationInfo);
}



}  // media::mojom


namespace mojo {


// static
bool StructTraits<::media::mojom::SupportedAudioDecoderConfig::DataView, ::media::mojom::SupportedAudioDecoderConfigPtr>::Read(
    ::media::mojom::SupportedAudioDecoderConfig::DataView input,
    ::media::mojom::SupportedAudioDecoderConfigPtr* output) {
  bool success = true;
  ::media::mojom::SupportedAudioDecoderConfigPtr result(::media::mojom::SupportedAudioDecoderConfig::New());
  
      if (success && !input.ReadCodec(&result->codec))
        success = false;
      if (success && !input.ReadProfile(&result->profile))
        success = false;
  *output = std::move(result);
  return success;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace media::mojom {


void AudioDecoderInterceptorForTesting::GetSupportedConfigs(GetSupportedConfigsCallback callback) {
  GetForwardingInterface()->GetSupportedConfigs(std::move(callback));
}
void AudioDecoderInterceptorForTesting::Construct(::mojo::PendingAssociatedRemote<AudioDecoderClient> client, ::mojo::PendingRemote<::media::mojom::MediaLog> media_log) {
  GetForwardingInterface()->Construct(
    std::move(client)
    , 
    std::move(media_log)
    );
}
void AudioDecoderInterceptorForTesting::Initialize(const ::media::AudioDecoderConfig& config, const std::optional<::base::UnguessableToken>& cdm_id, InitializeCallback callback) {
  GetForwardingInterface()->Initialize(
    std::move(config)
    , 
    std::move(cdm_id)
    , std::move(callback));
}
void AudioDecoderInterceptorForTesting::SetDataSource(::mojo::ScopedDataPipeConsumerHandle receive_pipe) {
  GetForwardingInterface()->SetDataSource(
    std::move(receive_pipe)
    );
}
void AudioDecoderInterceptorForTesting::Decode(::media::mojom::DecoderBufferPtr buffer, DecodeCallback callback) {
  GetForwardingInterface()->Decode(
    std::move(buffer)
    , std::move(callback));
}
void AudioDecoderInterceptorForTesting::Reset(ResetCallback callback) {
  GetForwardingInterface()->Reset(std::move(callback));
}
AudioDecoderAsyncWaiter::AudioDecoderAsyncWaiter(
    AudioDecoder* proxy) : proxy_(proxy) {}

AudioDecoderAsyncWaiter::~AudioDecoderAsyncWaiter() = default;


void AudioDecoderAsyncWaiter::GetSupportedConfigs(
    std::vector<::media::SupportedAudioDecoderConfig>* out_supported_configs) {
  base::RunLoop loop;
  proxy_->GetSupportedConfigs(
      base::BindOnce(
          [](base::RunLoop* loop,
             std::vector<::media::SupportedAudioDecoderConfig>* out_supported_configs
,
             const std::vector<::media::SupportedAudioDecoderConfig>& supported_configs) {*out_supported_configs = std::move(supported_configs);
            loop->Quit();
          },
          &loop,
          out_supported_configs));
  loop.Run();
}

std::vector<::media::SupportedAudioDecoderConfig> AudioDecoderAsyncWaiter::GetSupportedConfigs(
    ) {
  std::vector<::media::SupportedAudioDecoderConfig> async_wait_result;
  GetSupportedConfigs(&async_wait_result);
  return async_wait_result;
}

void AudioDecoderAsyncWaiter::Initialize(
    const ::media::AudioDecoderConfig& config, const std::optional<::base::UnguessableToken>& cdm_id, ::media::DecoderStatus* out_success, bool* out_needs_bitstream_conversion, ::media::AudioDecoderType* out_decoder_type) {
  base::RunLoop loop;
  proxy_->Initialize(
      std::move(config),
      std::move(cdm_id),
      base::BindOnce(
          [](base::RunLoop* loop,
             ::media::DecoderStatus* out_success
,
             bool* out_needs_bitstream_conversion
,
             ::media::AudioDecoderType* out_decoder_type
,
             const ::media::DecoderStatus& success,
             bool needs_bitstream_conversion,
             ::media::AudioDecoderType decoder_type) {*out_success = std::move(success);*out_needs_bitstream_conversion = std::move(needs_bitstream_conversion);*out_decoder_type = std::move(decoder_type);
            loop->Quit();
          },
          &loop,
          out_success,
          out_needs_bitstream_conversion,
          out_decoder_type));
  loop.Run();
}



void AudioDecoderAsyncWaiter::Decode(
    ::media::mojom::DecoderBufferPtr buffer, ::media::DecoderStatus* out_status) {
  base::RunLoop loop;
  proxy_->Decode(
      std::move(buffer),
      base::BindOnce(
          [](base::RunLoop* loop,
             ::media::DecoderStatus* out_status
,
             const ::media::DecoderStatus& status) {*out_status = std::move(status);
            loop->Quit();
          },
          &loop,
          out_status));
  loop.Run();
}

::media::DecoderStatus AudioDecoderAsyncWaiter::Decode(
    ::media::mojom::DecoderBufferPtr buffer) {
  ::media::DecoderStatus async_wait_result;
  Decode(std::move(buffer),&async_wait_result);
  return async_wait_result;
}

void AudioDecoderAsyncWaiter::Reset(
    ) {
  base::RunLoop loop;
  proxy_->Reset(
      base::BindOnce(
          [](base::RunLoop* loop) {
            loop->Quit();
          },
          &loop));
  loop.Run();
}






void AudioDecoderClientInterceptorForTesting::OnBufferDecoded(::media::mojom::AudioBufferPtr buffer) {
  GetForwardingInterface()->OnBufferDecoded(
    std::move(buffer)
    );
}
void AudioDecoderClientInterceptorForTesting::OnWaiting(::media::WaitingReason reason) {
  GetForwardingInterface()->OnWaiting(
    std::move(reason)
    );
}
AudioDecoderClientAsyncWaiter::AudioDecoderClientAsyncWaiter(
    AudioDecoderClient* proxy) : proxy_(proxy) {}

AudioDecoderClientAsyncWaiter::~AudioDecoderClientAsyncWaiter() = default;







}  // media::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif