// media/mojo/mojom/audio_processing.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef MEDIA_MOJO_MOJOM_AUDIO_PROCESSING_MOJOM_SHARED_H_
#define MEDIA_MOJO_MOJOM_AUDIO_PROCESSING_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "media/mojo/mojom/audio_processing.mojom-shared-internal.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization.h"
#include "mojo/public/cpp/system/data_pipe.h"



#include "media/mojo/mojom/audio_processing.mojom-data-view.h"




namespace std {

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::media::mojom::AudioProcessingStatsDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::media::mojom::AudioProcessingStatsDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::media::mojom::internal::AudioProcessingStats_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    fragment->has_echo_return_loss = Traits::has_echo_return_loss(input);

    fragment->echo_return_loss = Traits::echo_return_loss(input);

    fragment->has_echo_return_loss_enhancement = Traits::has_echo_return_loss_enhancement(input);

    fragment->echo_return_loss_enhancement = Traits::echo_return_loss_enhancement(input);
  }

  static bool Deserialize(::media::mojom::internal::AudioProcessingStats_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::media::mojom::AudioProcessingStatsDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::media::mojom::AudioProcessingSettingsDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::media::mojom::AudioProcessingSettingsDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::media::mojom::internal::AudioProcessingSettings_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    fragment->echo_cancellation = Traits::echo_cancellation(input);

    fragment->noise_suppression = Traits::noise_suppression(input);

    fragment->automatic_gain_control = Traits::automatic_gain_control(input);

    fragment->multi_channel_capture_processing = Traits::multi_channel_capture_processing(input);

    fragment->use_loopback_aec_reference = Traits::use_loopback_aec_reference(input);
  }

  static bool Deserialize(::media::mojom::internal::AudioProcessingSettings_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::media::mojom::AudioProcessingSettingsDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::media::mojom::AudioProcessingConfigDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::media::mojom::AudioProcessingConfigDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::media::mojom::internal::AudioProcessingConfig_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::controls_receiver(input)) in_controls_receiver = Traits::controls_receiver(input);

    
    mojo::internal::Serialize<mojo::InterfaceRequestDataView<::media::mojom::AudioProcessorControlsInterfaceBase>>(
      in_controls_receiver,
      &fragment->controls_receiver,
      &fragment.message());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(!mojo::internal::IsHandleOrInterfaceValid(fragment->controls_receiver)),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid controls_receiver in AudioProcessingConfig struct");

    decltype(Traits::settings(input)) in_settings = Traits::settings(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->settings)::BaseType> settings_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::media::mojom::AudioProcessingSettingsDataView>(
      in_settings,
      settings_fragment);

    fragment->settings.Set(
        settings_fragment.is_null() ? nullptr : settings_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->settings.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null settings in AudioProcessingConfig struct");
  }

  static bool Deserialize(::media::mojom::internal::AudioProcessingConfig_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::media::mojom::AudioProcessingConfigDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace media::mojom {





inline void AudioProcessingConfigDataView::GetSettingsDataView(
    AudioProcessingSettingsDataView* output) {
  auto pointer = data_->settings.Get();
  *output = AudioProcessingSettingsDataView(pointer, message_);
}



}  // media::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

#endif  // MEDIA_MOJO_MOJOM_AUDIO_PROCESSING_MOJOM_SHARED_H_