// media/mojo/mojom/media_types.mojom-data-view.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef MEDIA_MOJO_MOJOM_MEDIA_TYPES_MOJOM_DATA_VIEW_H_
#define MEDIA_MOJO_MOJOM_MEDIA_TYPES_MOJOM_DATA_VIEW_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "media/mojo/mojom/media_types.mojom-shared-internal.h"
#include "gpu/ipc/common/exported_shared_image.mojom-shared.h"
#include "gpu/ipc/common/mailbox.mojom-shared.h"
#include "gpu/ipc/common/sync_token.mojom-shared.h"
#include "gpu/ipc/common/vulkan_ycbcr_info.mojom-shared.h"
#include "media/mojo/mojom/audio_data.mojom-shared.h"
#include "media/mojo/mojom/encryption_pattern.mojom-shared.h"
#include "mojo/public/mojom/base/byte_string.mojom-shared.h"
#include "mojo/public/mojom/base/shared_memory.mojom-shared.h"
#include "mojo/public/mojom/base/time.mojom-shared.h"
#include "mojo/public/mojom/base/values.mojom-shared.h"
#include "mojo/public/mojom/base/unguessable_token.mojom-shared.h"
#include "ui/gfx/geometry/mojom/geometry.mojom-shared.h"
#include "ui/gfx/mojom/buffer_types.mojom-shared.h"
#include "ui/gfx/mojom/color_space.mojom-shared.h"
#include "ui/gfx/mojom/hdr_metadata.mojom-shared.h"


namespace media::mojom {
using MediaLogRecordDataView = mojo::native::NativeStructDataView;

class VideoTransformationDataView;

class VideoAspectRatioDataView;

class VideoColorSpaceDataView;

class AudioDecoderConfigDataView;

class VideoDecoderConfigDataView;

using SubsampleEntryDataView = mojo::native::NativeStructDataView;

class DecryptConfigDataView;

class DecoderBufferSideDataDataView;

class DataDecoderBufferDataView;

class EosDecoderBufferDataView;

class AudioBufferDataView;

class VideoFrameMetadataDataView;

class VideoFrameDataView;

class EosVideoFrameDataDataView;

class SharedMemoryVideoFrameDataDataView;

class GpuMemoryBufferSharedImageVideoFrameDataDataView;

class SharedImageVideoFrameDataDataView;

class OpaqueVideoFrameDataDataView;

class ColorPlaneLayoutDataView;

class DmabufVideoFrameDataDataView;

class PipelineStatisticsDataView;

class PredictionFeaturesDataView;

class PredictionTargetsDataView;

class AudioPipelineInfoDataView;

class VideoPipelineInfoDataView;

class StatusDataDataView;

class EncoderStatusDataView;

class DecoderStatusDataView;

class PipelineStatusDataView;

class AutoPipInfoDataView;

class DecoderBufferSideDataNextConfigDataView;
class DecoderBufferDataView;
class VideoFrameDataDataView;


}  // media::mojom


namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::media::mojom::VideoTransformationDataView> {
  using Data = ::media::mojom::internal::VideoTransformation_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::media::mojom::VideoAspectRatioDataView> {
  using Data = ::media::mojom::internal::VideoAspectRatio_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::media::mojom::VideoColorSpaceDataView> {
  using Data = ::media::mojom::internal::VideoColorSpace_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::media::mojom::AudioDecoderConfigDataView> {
  using Data = ::media::mojom::internal::AudioDecoderConfig_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::media::mojom::VideoDecoderConfigDataView> {
  using Data = ::media::mojom::internal::VideoDecoderConfig_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::media::mojom::DecryptConfigDataView> {
  using Data = ::media::mojom::internal::DecryptConfig_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::media::mojom::DecoderBufferSideDataDataView> {
  using Data = ::media::mojom::internal::DecoderBufferSideData_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::media::mojom::DataDecoderBufferDataView> {
  using Data = ::media::mojom::internal::DataDecoderBuffer_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::media::mojom::EosDecoderBufferDataView> {
  using Data = ::media::mojom::internal::EosDecoderBuffer_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::media::mojom::AudioBufferDataView> {
  using Data = ::media::mojom::internal::AudioBuffer_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::media::mojom::VideoFrameMetadataDataView> {
  using Data = ::media::mojom::internal::VideoFrameMetadata_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::media::mojom::VideoFrameDataView> {
  using Data = ::media::mojom::internal::VideoFrame_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::media::mojom::EosVideoFrameDataDataView> {
  using Data = ::media::mojom::internal::EosVideoFrameData_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::media::mojom::SharedMemoryVideoFrameDataDataView> {
  using Data = ::media::mojom::internal::SharedMemoryVideoFrameData_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::media::mojom::GpuMemoryBufferSharedImageVideoFrameDataDataView> {
  using Data = ::media::mojom::internal::GpuMemoryBufferSharedImageVideoFrameData_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::media::mojom::SharedImageVideoFrameDataDataView> {
  using Data = ::media::mojom::internal::SharedImageVideoFrameData_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::media::mojom::OpaqueVideoFrameDataDataView> {
  using Data = ::media::mojom::internal::OpaqueVideoFrameData_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::media::mojom::ColorPlaneLayoutDataView> {
  using Data = ::media::mojom::internal::ColorPlaneLayout_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::media::mojom::DmabufVideoFrameDataDataView> {
  using Data = ::media::mojom::internal::DmabufVideoFrameData_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::media::mojom::PipelineStatisticsDataView> {
  using Data = ::media::mojom::internal::PipelineStatistics_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::media::mojom::PredictionFeaturesDataView> {
  using Data = ::media::mojom::internal::PredictionFeatures_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::media::mojom::PredictionTargetsDataView> {
  using Data = ::media::mojom::internal::PredictionTargets_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::media::mojom::AudioPipelineInfoDataView> {
  using Data = ::media::mojom::internal::AudioPipelineInfo_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::media::mojom::VideoPipelineInfoDataView> {
  using Data = ::media::mojom::internal::VideoPipelineInfo_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::media::mojom::StatusDataDataView> {
  using Data = ::media::mojom::internal::StatusData_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::media::mojom::EncoderStatusDataView> {
  using Data = ::media::mojom::internal::EncoderStatus_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::media::mojom::DecoderStatusDataView> {
  using Data = ::media::mojom::internal::DecoderStatus_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::media::mojom::PipelineStatusDataView> {
  using Data = ::media::mojom::internal::PipelineStatus_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::media::mojom::AutoPipInfoDataView> {
  using Data = ::media::mojom::internal::AutoPipInfo_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::media::mojom::DecoderBufferSideDataNextConfigDataView> {
  using Data = ::media::mojom::internal::DecoderBufferSideDataNextConfig_Data;
  using DataAsArrayElement = Data;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kUnion;
};

template <>
struct MojomTypeTraits<::media::mojom::DecoderBufferDataView> {
  using Data = ::media::mojom::internal::DecoderBuffer_Data;
  using DataAsArrayElement = Data;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kUnion;
};

template <>
struct MojomTypeTraits<::media::mojom::VideoFrameDataDataView> {
  using Data = ::media::mojom::internal::VideoFrameData_Data;
  using DataAsArrayElement = Data;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kUnion;
};

}  // namespace internal
}  // namespace mojo


namespace media::mojom {
using AudioCodec = mojo::NativeEnum;
using AudioCodecProfile = mojo::NativeEnum;
using BufferingState = mojo::NativeEnum;
using BufferingStateChangeReason = mojo::NativeEnum;
using ChannelLayout = mojo::NativeEnum;
using MediaContentType = mojo::NativeEnum;
using OutputDeviceStatus = mojo::NativeEnum;
using SampleFormat = mojo::NativeEnum;
using VideoCodec = mojo::NativeEnum;
using VideoCodecProfile = mojo::NativeEnum;
using VideoPixelFormat = mojo::NativeEnum;
using VideoDecoderType = mojo::NativeEnum;
using AudioDecoderType = mojo::NativeEnum;


enum class VideoRotation : int32_t {
  
  kVideoRotation0 = 0,
  
  kVideoRotation90 = 1,
  
  kVideoRotation180 = 2,
  
  kVideoRotation270 = 3,
  kMinValue = 0,
  kMaxValue = 3,
};

 std::ostream& operator<<(std::ostream& os, VideoRotation value);
inline bool IsKnownEnumValue(VideoRotation value) {
  return internal::VideoRotation_Data::IsKnownValue(
      static_cast<int32_t>(value));
}
using FullscreenVideoStatus = mojo::NativeEnum;
using WaitingReason = mojo::NativeEnum;
using WatchTimeKey = mojo::NativeEnum;
using MediaContainerName = mojo::NativeEnum;
using MediaStatusState = mojo::NativeEnum;
using EncryptionScheme = mojo::NativeEnum;


enum class EncryptionType : int32_t {
  
  kNone = 0,
  
  kClear = 1,
  
  kEncrypted = 2,
  
  kEncryptedWithClearLead = 3,
  kMinValue = 0,
  kMaxValue = 3,
};

 std::ostream& operator<<(std::ostream& os, EncryptionType value);
inline bool IsKnownEnumValue(EncryptionType value) {
  return internal::EncryptionType_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class SVCScalabilityMode : int32_t {
  
  kUnsupportedMode = 0,
  
  kL1T1 = 1,
  
  kL1T2 = 2,
  
  kL1T3 = 3,
  
  kL2T1 = 4,
  
  kL2T2 = 5,
  
  kL2T3 = 6,
  
  kL3T1 = 7,
  
  kL3T2 = 8,
  
  kL3T3 = 9,
  
  kL2T1Key = 10,
  
  kL2T2Key = 11,
  
  kL2T3Key = 12,
  
  kL3T1Key = 13,
  
  kL3T2Key = 14,
  
  kL3T3Key = 15,
  
  kS2T1 = 16,
  
  kS2T2 = 17,
  
  kS2T3 = 18,
  
  kS3T1 = 19,
  
  kS3T2 = 20,
  
  kS3T3 = 21,
  kMinValue = 0,
  kMaxValue = 21,
};

 std::ostream& operator<<(std::ostream& os, SVCScalabilityMode value);
inline bool IsKnownEnumValue(SVCScalabilityMode value) {
  return internal::SVCScalabilityMode_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class SVCInterLayerPredMode : int32_t {
  
  kOff = 0,
  
  kOn = 1,
  
  kOnKeyPic = 2,
  kMinValue = 0,
  kMaxValue = 2,
};

 std::ostream& operator<<(std::ostream& os, SVCInterLayerPredMode value);
inline bool IsKnownEnumValue(SVCInterLayerPredMode value) {
  return internal::SVCInterLayerPredMode_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class CdmSessionClosedReason : int32_t {
  
  kInternalError = 0,
  
  kClose = 1,
  
  kReleaseAcknowledged = 2,
  
  kHardwareContextReset = 3,
  
  kResourceEvicted = 4,
  kMinValue = 0,
  kMaxValue = 4,
};

 std::ostream& operator<<(std::ostream& os, CdmSessionClosedReason value);
inline bool IsKnownEnumValue(CdmSessionClosedReason value) {
  return internal::CdmSessionClosedReason_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class EffectState : int32_t {
  
  kUnknown = 0,
  
  kDisabled = 1,
  
  kEnabled = 2,
  kMinValue = 0,
  kMaxValue = 2,
};

 std::ostream& operator<<(std::ostream& os, EffectState value);
inline bool IsKnownEnumValue(EffectState value) {
  return internal::EffectState_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class MediaStreamType : int32_t {
  
  kLocalElementCapture = 0,
  
  kLocalDeviceCapture = 1,
  
  kLocalTabCapture = 2,
  
  kLocalDesktopCapture = 3,
  
  kLocalDisplayCapture = 4,
  
  kRemote = 5,
  
  kNone = 6,
  kMinValue = 0,
  kMaxValue = 6,
};

 std::ostream& operator<<(std::ostream& os, MediaStreamType value);
inline bool IsKnownEnumValue(MediaStreamType value) {
  return internal::MediaStreamType_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class InputStreamErrorCode : int32_t {
  
  kUnknown = 0,
  
  kSystemPermissions = 1,
  
  kDeviceInUse = 2,
  kMinValue = 0,
  kMaxValue = 2,
};

 std::ostream& operator<<(std::ostream& os, InputStreamErrorCode value);
inline bool IsKnownEnumValue(InputStreamErrorCode value) {
  return internal::InputStreamErrorCode_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class RendererType : int32_t {
  
  kRendererImpl = 0,
  
  kMojo = 1,
  
  kCourier = 3,
  
  kFlinging = 4,
  
  kCast = 5,
  
  kMediaFoundation = 6,
  
  kRemoting = 8,
  
  kCastStreaming = 9,
  
  kContentEmbedderDefined = 10,
  
  kTest = 11,
  kMinValue = 0,
  kMaxValue = 11,
};

 std::ostream& operator<<(std::ostream& os, RendererType value);
inline bool IsKnownEnumValue(RendererType value) {
  return internal::RendererType_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class DemuxerType : int32_t {
  
  kUnknownDemuxer = 0,
  
  kMockDemuxer = 1,
  
  kFFmpegDemuxer = 2,
  
  kChunkDemuxer = 3,
  
  kFrameInjectingDemuxer = 5,
  
  kStreamProviderDemuxer = 6,
  
  kManifestDemuxer = 7,
  kMinValue = 0,
  kMaxValue = 7,
};

 std::ostream& operator<<(std::ostream& os, DemuxerType value);
inline bool IsKnownEnumValue(DemuxerType value) {
  return internal::DemuxerType_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class CreateCdmStatus : int32_t {
  
  kSuccess = 0,
  
  kUnknownError = 1,
  
  kCdmCreationAborted = 2,
  
  kCreateCdmFuncNotAvailable = 4,
  
  kCdmHelperCreationFailed = 5,
  
  kGetCdmPrefDataFailed = 6,
  
  kGetCdmOriginIdFailed = 7,
  
  kInitCdmFailed = 8,
  
  kCdmFactoryCreationFailed = 9,
  
  kCdmNotSupported = 10,
  
  kInvalidCdmConfig = 11,
  
  kUnsupportedKeySystem = 12,
  
  kDisconnectionError = 13,
  
  kNotAllowedOnUniqueOrigin = 14,
  
  kMediaCryptoNotAvailable = 16,
  
  kNoMoreInstances = 17,
  
  kInsufficientGpuResources = 18,
  
  kCrOsVerifiedAccessDisabled = 19,
  
  kCrOsRemoteFactoryCreationFailed = 20,
  
  kAndroidMediaDrmIllegalArgument = 21,
  
  kAndroidMediaDrmIllegalState = 22,
  
  kAndroidFailedL1SecurityLevel = 23,
  
  kAndroidFailedL3SecurityLevel = 24,
  
  kAndroidFailedSecurityOrigin = 25,
  
  kAndroidFailedMediaCryptoSession = 26,
  
  kAndroidFailedToStartProvisioning = 27,
  
  kAndroidFailedMediaCryptoCreate = 28,
  
  kAndroidUnsupportedMediaCryptoScheme = 29,
  kMinValue = 0,
  kMaxValue = 29,
};

 std::ostream& operator<<(std::ostream& os, CreateCdmStatus value);
inline bool IsKnownEnumValue(CreateCdmStatus value) {
  return internal::CreateCdmStatus_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class AutoPipReason : int32_t {
  
  kUnknown = 0,
  
  kVideoConferencing = 1,
  
  kMediaPlayback = 2,
  kMinValue = 0,
  kMaxValue = 2,
};

 std::ostream& operator<<(std::ostream& os, AutoPipReason value);
inline bool IsKnownEnumValue(AutoPipReason value) {
  return internal::AutoPipReason_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class VideoAspectRatio_Type : int32_t {
  
  kDisplay = 0,
  
  kPixel = 1,
  kMinValue = 0,
  kMaxValue = 1,
};

 std::ostream& operator<<(std::ostream& os, VideoAspectRatio_Type value);
inline bool IsKnownEnumValue(VideoAspectRatio_Type value) {
  return internal::VideoAspectRatio_Type_Data::IsKnownValue(
      static_cast<int32_t>(value));
}
using VideoColorSpace_PrimaryID = mojo::NativeEnum;
using VideoColorSpace_TransferID = mojo::NativeEnum;
using VideoColorSpace_MatrixID = mojo::NativeEnum;
using VideoColorSpace_RangeID = mojo::NativeEnum;


class VideoTransformationDataView {
 public:
  VideoTransformationDataView() = default;

  VideoTransformationDataView(
      internal::VideoTransformation_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  [[nodiscard]] bool ReadRotation(UserType* output) const {
    auto data_value = data_->rotation;
    return mojo::internal::Deserialize<::media::mojom::VideoRotation>(
        data_value, output);
  }
  VideoRotation rotation() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::media::mojom::VideoRotation>(data_->rotation));
  }
  bool mirrored() const {
    return data_->mirrored;
  }
 private:
  internal::VideoTransformation_Data* data_ = nullptr;
};


class VideoAspectRatioDataView {
 public:
  VideoAspectRatioDataView() = default;

  VideoAspectRatioDataView(
      internal::VideoAspectRatio_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  [[nodiscard]] bool ReadType(UserType* output) const {
    auto data_value = data_->type;
    return mojo::internal::Deserialize<::media::mojom::VideoAspectRatio_Type>(
        data_value, output);
  }
  VideoAspectRatio_Type type() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::media::mojom::VideoAspectRatio_Type>(data_->type));
  }
  double value() const {
    return data_->value;
  }
 private:
  internal::VideoAspectRatio_Data* data_ = nullptr;
};


class VideoColorSpaceDataView {
 public:
  VideoColorSpaceDataView() = default;

  VideoColorSpaceDataView(
      internal::VideoColorSpace_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  [[nodiscard]] bool ReadPrimaries(UserType* output) const {
    auto data_value = data_->primaries;
    return mojo::internal::Deserialize<::media::mojom::VideoColorSpace_PrimaryID>(
        data_value, output);
  }
  VideoColorSpace_PrimaryID primaries() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::media::mojom::VideoColorSpace_PrimaryID>(data_->primaries));
  }
  template <typename UserType>
  [[nodiscard]] bool ReadTransfer(UserType* output) const {
    auto data_value = data_->transfer;
    return mojo::internal::Deserialize<::media::mojom::VideoColorSpace_TransferID>(
        data_value, output);
  }
  VideoColorSpace_TransferID transfer() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::media::mojom::VideoColorSpace_TransferID>(data_->transfer));
  }
  template <typename UserType>
  [[nodiscard]] bool ReadMatrix(UserType* output) const {
    auto data_value = data_->matrix;
    return mojo::internal::Deserialize<::media::mojom::VideoColorSpace_MatrixID>(
        data_value, output);
  }
  VideoColorSpace_MatrixID matrix() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::media::mojom::VideoColorSpace_MatrixID>(data_->matrix));
  }
  template <typename UserType>
  [[nodiscard]] bool ReadRange(UserType* output) const {
    auto data_value = data_->range;
    return mojo::internal::Deserialize<::media::mojom::VideoColorSpace_RangeID>(
        data_value, output);
  }
  VideoColorSpace_RangeID range() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::media::mojom::VideoColorSpace_RangeID>(data_->range));
  }
 private:
  internal::VideoColorSpace_Data* data_ = nullptr;
};


class AudioDecoderConfigDataView {
 public:
  AudioDecoderConfigDataView() = default;

  AudioDecoderConfigDataView(
      internal::AudioDecoderConfig_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  [[nodiscard]] bool ReadCodec(UserType* output) const {
    auto data_value = data_->codec;
    return mojo::internal::Deserialize<::media::mojom::AudioCodec>(
        data_value, output);
  }
  AudioCodec codec() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::media::mojom::AudioCodec>(data_->codec));
  }
  template <typename UserType>
  [[nodiscard]] bool ReadSampleFormat(UserType* output) const {
    auto data_value = data_->sample_format;
    return mojo::internal::Deserialize<::media::mojom::SampleFormat>(
        data_value, output);
  }
  SampleFormat sample_format() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::media::mojom::SampleFormat>(data_->sample_format));
  }
  template <typename UserType>
  [[nodiscard]] bool ReadChannelLayout(UserType* output) const {
    auto data_value = data_->channel_layout;
    return mojo::internal::Deserialize<::media::mojom::ChannelLayout>(
        data_value, output);
  }
  ChannelLayout channel_layout() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::media::mojom::ChannelLayout>(data_->channel_layout));
  }
  int32_t samples_per_second() const {
    return data_->samples_per_second;
  }
  inline void GetExtraDataDataView(
      mojo::ArrayDataView<uint8_t>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadExtraData(UserType* output) {
    
    auto* pointer = data_->extra_data.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<uint8_t>>(
        pointer, output, message_);
  }
  template <typename UserType>
  [[nodiscard]] bool ReadEncryptionScheme(UserType* output) const {
    auto data_value = data_->encryption_scheme;
    return mojo::internal::Deserialize<::media::mojom::EncryptionScheme>(
        data_value, output);
  }
  EncryptionScheme encryption_scheme() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::media::mojom::EncryptionScheme>(data_->encryption_scheme));
  }
  inline void GetSeekPrerollDataView(
      ::mojo_base::mojom::TimeDeltaDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSeekPreroll(UserType* output) {
    
    auto* pointer = data_->seek_preroll.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeDeltaDataView>(
        pointer, output, message_);
  }
  int32_t codec_delay() const {
    return data_->codec_delay;
  }
  template <typename UserType>
  [[nodiscard]] bool ReadProfile(UserType* output) const {
    auto data_value = data_->profile;
    return mojo::internal::Deserialize<::media::mojom::AudioCodecProfile>(
        data_value, output);
  }
  AudioCodecProfile profile() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::media::mojom::AudioCodecProfile>(data_->profile));
  }
  template <typename UserType>
  [[nodiscard]] bool ReadTargetOutputChannelLayout(UserType* output) const {
    auto data_value = data_->target_output_channel_layout;
    return mojo::internal::Deserialize<::media::mojom::ChannelLayout>(
        data_value, output);
  }
  ChannelLayout target_output_channel_layout() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::media::mojom::ChannelLayout>(data_->target_output_channel_layout));
  }
  template <typename UserType>
  [[nodiscard]] bool ReadTargetOutputSampleFormat(UserType* output) const {
    auto data_value = data_->target_output_sample_format;
    return mojo::internal::Deserialize<::media::mojom::SampleFormat>(
        data_value, output);
  }
  SampleFormat target_output_sample_format() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::media::mojom::SampleFormat>(data_->target_output_sample_format));
  }
  bool should_discard_decoder_delay() const {
    return data_->should_discard_decoder_delay;
  }
 private:
  internal::AudioDecoderConfig_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class VideoDecoderConfigDataView {
 public:
  VideoDecoderConfigDataView() = default;

  VideoDecoderConfigDataView(
      internal::VideoDecoderConfig_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  [[nodiscard]] bool ReadCodec(UserType* output) const {
    auto data_value = data_->codec;
    return mojo::internal::Deserialize<::media::mojom::VideoCodec>(
        data_value, output);
  }
  VideoCodec codec() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::media::mojom::VideoCodec>(data_->codec));
  }
  template <typename UserType>
  [[nodiscard]] bool ReadProfile(UserType* output) const {
    auto data_value = data_->profile;
    return mojo::internal::Deserialize<::media::mojom::VideoCodecProfile>(
        data_value, output);
  }
  VideoCodecProfile profile() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::media::mojom::VideoCodecProfile>(data_->profile));
  }
  uint32_t level() const {
    return data_->level;
  }
  bool has_alpha() const {
    return data_->has_alpha;
  }
  inline void GetTransformationDataView(
      VideoTransformationDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTransformation(UserType* output) {
    
    auto* pointer = data_->transformation.Get();
    return mojo::internal::Deserialize<::media::mojom::VideoTransformationDataView>(
        pointer, output, message_);
  }
  inline void GetCodedSizeDataView(
      ::gfx::mojom::SizeDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadCodedSize(UserType* output) {
    
    auto* pointer = data_->coded_size.Get();
    return mojo::internal::Deserialize<::gfx::mojom::SizeDataView>(
        pointer, output, message_);
  }
  inline void GetVisibleRectDataView(
      ::gfx::mojom::RectDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadVisibleRect(UserType* output) {
    
    auto* pointer = data_->visible_rect.Get();
    return mojo::internal::Deserialize<::gfx::mojom::RectDataView>(
        pointer, output, message_);
  }
  inline void GetNaturalSizeDataView(
      ::gfx::mojom::SizeDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadNaturalSize(UserType* output) {
    
    auto* pointer = data_->natural_size.Get();
    return mojo::internal::Deserialize<::gfx::mojom::SizeDataView>(
        pointer, output, message_);
  }
  inline void GetAspectRatioDataView(
      VideoAspectRatioDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadAspectRatio(UserType* output) {
    
    auto* pointer = data_->aspect_ratio.Get();
    return mojo::internal::Deserialize<::media::mojom::VideoAspectRatioDataView>(
        pointer, output, message_);
  }
  inline void GetExtraDataDataView(
      mojo::ArrayDataView<uint8_t>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadExtraData(UserType* output) {
    
    auto* pointer = data_->extra_data.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<uint8_t>>(
        pointer, output, message_);
  }
  template <typename UserType>
  [[nodiscard]] bool ReadEncryptionScheme(UserType* output) const {
    auto data_value = data_->encryption_scheme;
    return mojo::internal::Deserialize<::media::mojom::EncryptionScheme>(
        data_value, output);
  }
  EncryptionScheme encryption_scheme() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::media::mojom::EncryptionScheme>(data_->encryption_scheme));
  }
  inline void GetColorSpaceInfoDataView(
      VideoColorSpaceDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadColorSpaceInfo(UserType* output) {
    
    auto* pointer = data_->color_space_info.Get();
    return mojo::internal::Deserialize<::media::mojom::VideoColorSpaceDataView>(
        pointer, output, message_);
  }
  inline void GetHdrMetadataDataView(
      ::gfx::mojom::HDRMetadataDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadHdrMetadata(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::gfx::mojom::HDRMetadataDataView, UserType>(),
    "Attempting to read the optional `hdr_metadata` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadHdrMetadata` instead "
    "of `ReadHdrMetadata if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->hdr_metadata.Get();
    return mojo::internal::Deserialize<::gfx::mojom::HDRMetadataDataView>(
        pointer, output, message_);
  }
 private:
  internal::VideoDecoderConfig_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class DecryptConfigDataView {
 public:
  DecryptConfigDataView() = default;

  DecryptConfigDataView(
      internal::DecryptConfig_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  [[nodiscard]] bool ReadEncryptionScheme(UserType* output) const {
    auto data_value = data_->encryption_scheme;
    return mojo::internal::Deserialize<::media::mojom::EncryptionScheme>(
        data_value, output);
  }
  EncryptionScheme encryption_scheme() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::media::mojom::EncryptionScheme>(data_->encryption_scheme));
  }
  inline void GetKeyIdDataView(
      ::mojo_base::mojom::ByteStringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadKeyId(UserType* output) {
    
    auto* pointer = data_->key_id.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::ByteStringDataView>(
        pointer, output, message_);
  }
  inline void GetIvDataView(
      ::mojo_base::mojom::ByteStringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadIv(UserType* output) {
    
    auto* pointer = data_->iv.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::ByteStringDataView>(
        pointer, output, message_);
  }
  inline void GetSubsamplesDataView(
      mojo::ArrayDataView<SubsampleEntryDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSubsamples(UserType* output) {
    
    auto* pointer = data_->subsamples.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::media::mojom::SubsampleEntryDataView>>(
        pointer, output, message_);
  }
  inline void GetEncryptionPatternDataView(
      ::media::mojom::EncryptionPatternDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadEncryptionPattern(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::media::mojom::EncryptionPatternDataView, UserType>(),
    "Attempting to read the optional `encryption_pattern` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadEncryptionPattern` instead "
    "of `ReadEncryptionPattern if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->encryption_pattern.Get();
    return mojo::internal::Deserialize<::media::mojom::EncryptionPatternDataView>(
        pointer, output, message_);
  }
 private:
  internal::DecryptConfig_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class DecoderBufferSideDataDataView {
 public:
  DecoderBufferSideDataDataView() = default;

  DecoderBufferSideDataDataView(
      internal::DecoderBufferSideData_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetSpatialLayersDataView(
      mojo::ArrayDataView<uint32_t>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSpatialLayers(UserType* output) {
    
    auto* pointer = data_->spatial_layers.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<uint32_t>>(
        pointer, output, message_);
  }
  inline void GetAlphaDataDataView(
      mojo::ArrayDataView<uint8_t>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadAlphaData(UserType* output) {
    
    auto* pointer = data_->alpha_data.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<uint8_t>>(
        pointer, output, message_);
  }
  uint64_t secure_handle() const {
    return data_->secure_handle;
  }
  inline void GetFrontDiscardDataView(
      ::mojo_base::mojom::TimeDeltaDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadFrontDiscard(UserType* output) {
    
    auto* pointer = data_->front_discard.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeDeltaDataView>(
        pointer, output, message_);
  }
  inline void GetBackDiscardDataView(
      ::mojo_base::mojom::TimeDeltaDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadBackDiscard(UserType* output) {
    
    auto* pointer = data_->back_discard.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeDeltaDataView>(
        pointer, output, message_);
  }
 private:
  internal::DecoderBufferSideData_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class DataDecoderBufferDataView {
 public:
  DataDecoderBufferDataView() = default;

  DataDecoderBufferDataView(
      internal::DataDecoderBuffer_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetTimestampDataView(
      ::mojo_base::mojom::TimeDeltaDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTimestamp(UserType* output) {
    
    auto* pointer = data_->timestamp.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeDeltaDataView>(
        pointer, output, message_);
  }
  inline void GetDurationDataView(
      ::mojo_base::mojom::TimeDeltaDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDuration(UserType* output) {
    
    auto* pointer = data_->duration.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeDeltaDataView>(
        pointer, output, message_);
  }
  uint32_t data_size() const {
    return data_->data_size;
  }
  bool is_key_frame() const {
    return data_->is_key_frame;
  }
  inline void GetDecryptConfigDataView(
      DecryptConfigDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDecryptConfig(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::media::mojom::DecryptConfigDataView, UserType>(),
    "Attempting to read the optional `decrypt_config` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadDecryptConfig` instead "
    "of `ReadDecryptConfig if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->decrypt_config.Get();
    return mojo::internal::Deserialize<::media::mojom::DecryptConfigDataView>(
        pointer, output, message_);
  }
  inline void GetSideDataDataView(
      DecoderBufferSideDataDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSideData(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::media::mojom::DecoderBufferSideDataDataView, UserType>(),
    "Attempting to read the optional `side_data` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadSideData` instead "
    "of `ReadSideData if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->side_data.Get();
    return mojo::internal::Deserialize<::media::mojom::DecoderBufferSideDataDataView>(
        pointer, output, message_);
  }
 private:
  internal::DataDecoderBuffer_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class EosDecoderBufferDataView {
 public:
  EosDecoderBufferDataView() = default;

  EosDecoderBufferDataView(
      internal::EosDecoderBuffer_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetNextConfigDataView(
      DecoderBufferSideDataNextConfigDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadNextConfig(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::media::mojom::DecoderBufferSideDataNextConfigDataView, UserType>(),
    "Attempting to read the optional `next_config` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadNextConfig` instead "
    "of `ReadNextConfig if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = !data_->next_config.is_null() ? &data_->next_config : nullptr;
    return mojo::internal::Deserialize<::media::mojom::DecoderBufferSideDataNextConfigDataView>(
        pointer, output, message_);
  }
 private:
  internal::EosDecoderBuffer_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class AudioBufferDataView {
 public:
  AudioBufferDataView() = default;

  AudioBufferDataView(
      internal::AudioBuffer_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  [[nodiscard]] bool ReadSampleFormat(UserType* output) const {
    auto data_value = data_->sample_format;
    return mojo::internal::Deserialize<::media::mojom::SampleFormat>(
        data_value, output);
  }
  SampleFormat sample_format() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::media::mojom::SampleFormat>(data_->sample_format));
  }
  template <typename UserType>
  [[nodiscard]] bool ReadChannelLayout(UserType* output) const {
    auto data_value = data_->channel_layout;
    return mojo::internal::Deserialize<::media::mojom::ChannelLayout>(
        data_value, output);
  }
  ChannelLayout channel_layout() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::media::mojom::ChannelLayout>(data_->channel_layout));
  }
  int32_t channel_count() const {
    return data_->channel_count;
  }
  int32_t sample_rate() const {
    return data_->sample_rate;
  }
  int32_t frame_count() const {
    return data_->frame_count;
  }
  bool end_of_stream() const {
    return data_->end_of_stream;
  }
  inline void GetTimestampDataView(
      ::mojo_base::mojom::TimeDeltaDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTimestamp(UserType* output) {
    
    auto* pointer = data_->timestamp.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeDeltaDataView>(
        pointer, output, message_);
  }
  inline void GetDataDataView(
      mojo::ArrayDataView<uint8_t>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadData(UserType* output) {
    
    auto* pointer = data_->data.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<uint8_t>>(
        pointer, output, message_);
  }
 private:
  internal::AudioBuffer_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class VideoFrameMetadataDataView {
 public:
  VideoFrameMetadataDataView() = default;

  VideoFrameMetadataDataView(
      internal::VideoFrameMetadata_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  bool allow_overlay() const {
    return data_->allow_overlay;
  }
  inline void GetCaptureBeginTimeDataView(
      ::mojo_base::mojom::TimeTicksDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadCaptureBeginTime(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::mojo_base::mojom::TimeTicksDataView, UserType>(),
    "Attempting to read the optional `capture_begin_time` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadCaptureBeginTime` instead "
    "of `ReadCaptureBeginTime if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->capture_begin_time.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeTicksDataView>(
        pointer, output, message_);
  }
  inline void GetCaptureEndTimeDataView(
      ::mojo_base::mojom::TimeTicksDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadCaptureEndTime(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::mojo_base::mojom::TimeTicksDataView, UserType>(),
    "Attempting to read the optional `capture_end_time` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadCaptureEndTime` instead "
    "of `ReadCaptureEndTime if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->capture_end_time.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeTicksDataView>(
        pointer, output, message_);
  }
  bool has_capture_counter() const {
    return data_->has_capture_counter;
  }
  int32_t capture_counter() const {
    return data_->capture_counter;
  }
  inline void GetCaptureUpdateRectDataView(
      ::gfx::mojom::RectDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadCaptureUpdateRect(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::gfx::mojom::RectDataView, UserType>(),
    "Attempting to read the optional `capture_update_rect` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadCaptureUpdateRect` instead "
    "of `ReadCaptureUpdateRect if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->capture_update_rect.Get();
    return mojo::internal::Deserialize<::gfx::mojom::RectDataView>(
        pointer, output, message_);
  }
  inline void GetSourceSizeDataView(
      ::gfx::mojom::SizeDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSourceSize(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::gfx::mojom::SizeDataView, UserType>(),
    "Attempting to read the optional `source_size` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadSourceSize` instead "
    "of `ReadSourceSize if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->source_size.Get();
    return mojo::internal::Deserialize<::gfx::mojom::SizeDataView>(
        pointer, output, message_);
  }
  inline void GetRegionCaptureRectDataView(
      ::gfx::mojom::RectDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadRegionCaptureRect(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::gfx::mojom::RectDataView, UserType>(),
    "Attempting to read the optional `region_capture_rect` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadRegionCaptureRect` instead "
    "of `ReadRegionCaptureRect if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->region_capture_rect.Get();
    return mojo::internal::Deserialize<::gfx::mojom::RectDataView>(
        pointer, output, message_);
  }
  uint32_t sub_capture_target_version() const {
    return data_->sub_capture_target_version;
  }
  bool copy_required() const {
    return data_->copy_required;
  }
  bool end_of_stream() const {
    return data_->end_of_stream;
  }
  inline void GetFrameDurationDataView(
      ::mojo_base::mojom::TimeDeltaDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadFrameDuration(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::mojo_base::mojom::TimeDeltaDataView, UserType>(),
    "Attempting to read the optional `frame_duration` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadFrameDuration` instead "
    "of `ReadFrameDuration if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->frame_duration.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeDeltaDataView>(
        pointer, output, message_);
  }
  bool has_frame_rate() const {
    return data_->has_frame_rate;
  }
  double frame_rate() const {
    return data_->frame_rate;
  }
  bool interactive_content() const {
    return data_->interactive_content;
  }
  inline void GetReferenceTimeDataView(
      ::mojo_base::mojom::TimeTicksDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadReferenceTime(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::mojo_base::mojom::TimeTicksDataView, UserType>(),
    "Attempting to read the optional `reference_time` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadReferenceTime` instead "
    "of `ReadReferenceTime if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->reference_time.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeTicksDataView>(
        pointer, output, message_);
  }
  bool read_lock_fences_enabled() const {
    return data_->read_lock_fences_enabled;
  }
  inline void GetTransformationDataView(
      VideoTransformationDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTransformation(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::media::mojom::VideoTransformationDataView, UserType>(),
    "Attempting to read the optional `transformation` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadTransformation` instead "
    "of `ReadTransformation if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->transformation.Get();
    return mojo::internal::Deserialize<::media::mojom::VideoTransformationDataView>(
        pointer, output, message_);
  }
  bool in_surface_view() const {
    return data_->in_surface_view;
  }
  bool wants_promotion_hint() const {
    return data_->wants_promotion_hint;
  }
  bool protected_video() const {
    return data_->protected_video;
  }
  bool hw_protected() const {
    return data_->hw_protected;
  }
  bool needs_detiling() const {
    return data_->needs_detiling;
  }
  bool is_webgpu_compatible() const {
    return data_->is_webgpu_compatible;
  }
  inline void GetTrackingTokenDataView(
      ::mojo_base::mojom::UnguessableTokenDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTrackingToken(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::mojo_base::mojom::UnguessableTokenDataView, UserType>(),
    "Attempting to read the optional `tracking_token` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadTrackingToken` instead "
    "of `ReadTrackingToken if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->tracking_token.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::UnguessableTokenDataView>(
        pointer, output, message_);
  }
  bool power_efficient() const {
    return data_->power_efficient;
  }
  bool has_device_scale_factor() const {
    return data_->has_device_scale_factor;
  }
  double device_scale_factor() const {
    return data_->device_scale_factor;
  }
  bool has_page_scale_factor() const {
    return data_->has_page_scale_factor;
  }
  double page_scale_factor() const {
    return data_->page_scale_factor;
  }
  bool has_root_scroll_offset_x() const {
    return data_->has_root_scroll_offset_x;
  }
  double root_scroll_offset_x() const {
    return data_->root_scroll_offset_x;
  }
  bool has_root_scroll_offset_y() const {
    return data_->has_root_scroll_offset_y;
  }
  double root_scroll_offset_y() const {
    return data_->root_scroll_offset_y;
  }
  bool has_top_controls_visible_height() const {
    return data_->has_top_controls_visible_height;
  }
  double top_controls_visible_height() const {
    return data_->top_controls_visible_height;
  }
  inline void GetDecodeBeginTimeDataView(
      ::mojo_base::mojom::TimeTicksDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDecodeBeginTime(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::mojo_base::mojom::TimeTicksDataView, UserType>(),
    "Attempting to read the optional `decode_begin_time` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadDecodeBeginTime` instead "
    "of `ReadDecodeBeginTime if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->decode_begin_time.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeTicksDataView>(
        pointer, output, message_);
  }
  inline void GetDecodeEndTimeDataView(
      ::mojo_base::mojom::TimeTicksDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDecodeEndTime(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::mojo_base::mojom::TimeTicksDataView, UserType>(),
    "Attempting to read the optional `decode_end_time` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadDecodeEndTime` instead "
    "of `ReadDecodeEndTime if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->decode_end_time.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeTicksDataView>(
        pointer, output, message_);
  }
  inline void GetProcessingTimeDataView(
      ::mojo_base::mojom::TimeDeltaDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadProcessingTime(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::mojo_base::mojom::TimeDeltaDataView, UserType>(),
    "Attempting to read the optional `processing_time` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadProcessingTime` instead "
    "of `ReadProcessingTime if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->processing_time.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeDeltaDataView>(
        pointer, output, message_);
  }
  bool has_rtp_timestamp() const {
    return data_->has_rtp_timestamp;
  }
  double rtp_timestamp() const {
    return data_->rtp_timestamp;
  }
  inline void GetReceiveTimeDataView(
      ::mojo_base::mojom::TimeTicksDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadReceiveTime(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::mojo_base::mojom::TimeTicksDataView, UserType>(),
    "Attempting to read the optional `receive_time` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadReceiveTime` instead "
    "of `ReadReceiveTime if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->receive_time.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeTicksDataView>(
        pointer, output, message_);
  }
  inline void GetWallclockFrameDurationDataView(
      ::mojo_base::mojom::TimeDeltaDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadWallclockFrameDuration(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::mojo_base::mojom::TimeDeltaDataView, UserType>(),
    "Attempting to read the optional `wallclock_frame_duration` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadWallclockFrameDuration` instead "
    "of `ReadWallclockFrameDuration if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->wallclock_frame_duration.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeDeltaDataView>(
        pointer, output, message_);
  }
  std::optional<uint64_t> frame_sequence() const {

    return data_->frame_sequence_$flag
        ? std::make_optional(data_->frame_sequence_$value)
        : std::nullopt;
  }
  std::optional<uint64_t> source_id() const {

    return data_->source_id_$flag
        ? std::make_optional(data_->source_id_$value)
        : std::nullopt;
  }
  template <typename UserType>
  [[nodiscard]] bool ReadBackgroundBlur(UserType* output) const {
    auto data_value = data_->background_blur;
    return mojo::internal::Deserialize<::media::mojom::EffectState>(
        data_value, output);
  }
  EffectState background_blur() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::media::mojom::EffectState>(data_->background_blur));
  }
 private:
  internal::VideoFrameMetadata_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class VideoFrameDataView {
 public:
  VideoFrameDataView() = default;

  VideoFrameDataView(
      internal::VideoFrame_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  [[nodiscard]] bool ReadFormat(UserType* output) const {
    auto data_value = data_->format;
    return mojo::internal::Deserialize<::media::mojom::VideoPixelFormat>(
        data_value, output);
  }
  VideoPixelFormat format() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::media::mojom::VideoPixelFormat>(data_->format));
  }
  inline void GetCodedSizeDataView(
      ::gfx::mojom::SizeDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadCodedSize(UserType* output) {
    
    auto* pointer = data_->coded_size.Get();
    return mojo::internal::Deserialize<::gfx::mojom::SizeDataView>(
        pointer, output, message_);
  }
  inline void GetVisibleRectDataView(
      ::gfx::mojom::RectDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadVisibleRect(UserType* output) {
    
    auto* pointer = data_->visible_rect.Get();
    return mojo::internal::Deserialize<::gfx::mojom::RectDataView>(
        pointer, output, message_);
  }
  inline void GetNaturalSizeDataView(
      ::gfx::mojom::SizeDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadNaturalSize(UserType* output) {
    
    auto* pointer = data_->natural_size.Get();
    return mojo::internal::Deserialize<::gfx::mojom::SizeDataView>(
        pointer, output, message_);
  }
  inline void GetTimestampDataView(
      ::mojo_base::mojom::TimeDeltaDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTimestamp(UserType* output) {
    
    auto* pointer = data_->timestamp.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeDeltaDataView>(
        pointer, output, message_);
  }
  inline void GetDataDataView(
      VideoFrameDataDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadData(UserType* output) {
    
    auto* pointer = !data_->data.is_null() ? &data_->data : nullptr;
    return mojo::internal::Deserialize<::media::mojom::VideoFrameDataDataView>(
        pointer, output, message_);
  }
  inline void GetMetadataDataView(
      VideoFrameMetadataDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadMetadata(UserType* output) {
    
    auto* pointer = data_->metadata.Get();
    return mojo::internal::Deserialize<::media::mojom::VideoFrameMetadataDataView>(
        pointer, output, message_);
  }
  inline void GetColorSpaceDataView(
      ::gfx::mojom::ColorSpaceDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadColorSpace(UserType* output) {
    
    auto* pointer = data_->color_space.Get();
    return mojo::internal::Deserialize<::gfx::mojom::ColorSpaceDataView>(
        pointer, output, message_);
  }
  inline void GetHdrMetadataDataView(
      ::gfx::mojom::HDRMetadataDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadHdrMetadata(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::gfx::mojom::HDRMetadataDataView, UserType>(),
    "Attempting to read the optional `hdr_metadata` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadHdrMetadata` instead "
    "of `ReadHdrMetadata if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->hdr_metadata.Get();
    return mojo::internal::Deserialize<::gfx::mojom::HDRMetadataDataView>(
        pointer, output, message_);
  }
 private:
  internal::VideoFrame_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class EosVideoFrameDataDataView {
 public:
  EosVideoFrameDataDataView() = default;

  EosVideoFrameDataDataView(
      internal::EosVideoFrameData_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
 private:
  internal::EosVideoFrameData_Data* data_ = nullptr;
};


class SharedMemoryVideoFrameDataDataView {
 public:
  SharedMemoryVideoFrameDataDataView() = default;

  SharedMemoryVideoFrameDataDataView(
      internal::SharedMemoryVideoFrameData_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetFrameDataDataView(
      ::mojo_base::mojom::ReadOnlySharedMemoryRegionDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadFrameData(UserType* output) {
    
    auto* pointer = data_->frame_data.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::ReadOnlySharedMemoryRegionDataView>(
        pointer, output, message_);
  }
  inline void GetStridesDataView(
      mojo::ArrayDataView<int32_t>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadStrides(UserType* output) {
    
    auto* pointer = data_->strides.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<int32_t>>(
        pointer, output, message_);
  }
  inline void GetOffsetsDataView(
      mojo::ArrayDataView<uint32_t>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadOffsets(UserType* output) {
    
    auto* pointer = data_->offsets.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<uint32_t>>(
        pointer, output, message_);
  }
 private:
  internal::SharedMemoryVideoFrameData_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class GpuMemoryBufferSharedImageVideoFrameDataDataView {
 public:
  GpuMemoryBufferSharedImageVideoFrameDataDataView() = default;

  GpuMemoryBufferSharedImageVideoFrameDataDataView(
      internal::GpuMemoryBufferSharedImageVideoFrameData_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetGpuMemoryBufferHandleDataView(
      ::gfx::mojom::GpuMemoryBufferHandleDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadGpuMemoryBufferHandle(UserType* output) {
    
    auto* pointer = data_->gpu_memory_buffer_handle.Get();
    return mojo::internal::Deserialize<::gfx::mojom::GpuMemoryBufferHandleDataView>(
        pointer, output, message_);
  }
  inline void GetSharedImageDataView(
      ::gpu::mojom::ExportedSharedImageDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSharedImage(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::gpu::mojom::ExportedSharedImageDataView, UserType>(),
    "Attempting to read the optional `shared_image` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadSharedImage` instead "
    "of `ReadSharedImage if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->shared_image.Get();
    return mojo::internal::Deserialize<::gpu::mojom::ExportedSharedImageDataView>(
        pointer, output, message_);
  }
  inline void GetSyncTokenDataView(
      ::gpu::mojom::SyncTokenDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSyncToken(UserType* output) {
    
    auto* pointer = data_->sync_token.Get();
    return mojo::internal::Deserialize<::gpu::mojom::SyncTokenDataView>(
        pointer, output, message_);
  }
 private:
  internal::GpuMemoryBufferSharedImageVideoFrameData_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class SharedImageVideoFrameDataDataView {
 public:
  SharedImageVideoFrameDataDataView() = default;

  SharedImageVideoFrameDataDataView(
      internal::SharedImageVideoFrameData_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetSharedImageDataView(
      ::gpu::mojom::ExportedSharedImageDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSharedImage(UserType* output) {
    
    auto* pointer = data_->shared_image.Get();
    return mojo::internal::Deserialize<::gpu::mojom::ExportedSharedImageDataView>(
        pointer, output, message_);
  }
  inline void GetSyncTokenDataView(
      ::gpu::mojom::SyncTokenDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSyncToken(UserType* output) {
    
    auto* pointer = data_->sync_token.Get();
    return mojo::internal::Deserialize<::gpu::mojom::SyncTokenDataView>(
        pointer, output, message_);
  }
  bool is_mappable_si_enabled() const {
    return data_->is_mappable_si_enabled;
  }
 private:
  internal::SharedImageVideoFrameData_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class OpaqueVideoFrameDataDataView {
 public:
  OpaqueVideoFrameDataDataView() = default;

  OpaqueVideoFrameDataDataView(
      internal::OpaqueVideoFrameData_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
 private:
  internal::OpaqueVideoFrameData_Data* data_ = nullptr;
};


class ColorPlaneLayoutDataView {
 public:
  ColorPlaneLayoutDataView() = default;

  ColorPlaneLayoutDataView(
      internal::ColorPlaneLayout_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  uint64_t stride() const {
    return data_->stride;
  }
  uint64_t offset() const {
    return data_->offset;
  }
  uint64_t size() const {
    return data_->size;
  }
 private:
  internal::ColorPlaneLayout_Data* data_ = nullptr;
};


class DmabufVideoFrameDataDataView {
 public:
  DmabufVideoFrameDataDataView() = default;

  DmabufVideoFrameDataDataView(
      internal::DmabufVideoFrameData_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetPlanesDataView(
      mojo::ArrayDataView<ColorPlaneLayoutDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPlanes(UserType* output) {
    
    auto* pointer = data_->planes.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::media::mojom::ColorPlaneLayoutDataView>>(
        pointer, output, message_);
  }
  bool is_multi_planar() const {
    return data_->is_multi_planar;
  }
  uint64_t buffer_addr_align() const {
    return data_->buffer_addr_align;
  }
  uint64_t modifier() const {
    return data_->modifier;
  }
  inline void GetFdsDataView(
      mojo::ArrayDataView<mojo::PlatformHandle>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadFds(UserType* output) {
    
    auto* pointer = data_->fds.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<mojo::PlatformHandle>>(
        pointer, output, message_);
  }
 private:
  internal::DmabufVideoFrameData_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class PipelineStatisticsDataView {
 public:
  PipelineStatisticsDataView() = default;

  PipelineStatisticsDataView(
      internal::PipelineStatistics_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  uint64_t audio_bytes_decoded() const {
    return data_->audio_bytes_decoded;
  }
  uint64_t video_bytes_decoded() const {
    return data_->video_bytes_decoded;
  }
  uint32_t video_frames_decoded() const {
    return data_->video_frames_decoded;
  }
  uint32_t video_frames_dropped() const {
    return data_->video_frames_dropped;
  }
  int64_t audio_memory_usage() const {
    return data_->audio_memory_usage;
  }
  int64_t video_memory_usage() const {
    return data_->video_memory_usage;
  }
 private:
  internal::PipelineStatistics_Data* data_ = nullptr;
};


class PredictionFeaturesDataView {
 public:
  PredictionFeaturesDataView() = default;

  PredictionFeaturesDataView(
      internal::PredictionFeatures_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  [[nodiscard]] bool ReadProfile(UserType* output) const {
    auto data_value = data_->profile;
    return mojo::internal::Deserialize<::media::mojom::VideoCodecProfile>(
        data_value, output);
  }
  VideoCodecProfile profile() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::media::mojom::VideoCodecProfile>(data_->profile));
  }
  inline void GetVideoSizeDataView(
      ::gfx::mojom::SizeDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadVideoSize(UserType* output) {
    
    auto* pointer = data_->video_size.Get();
    return mojo::internal::Deserialize<::gfx::mojom::SizeDataView>(
        pointer, output, message_);
  }
  double frames_per_sec() const {
    return data_->frames_per_sec;
  }
  inline void GetKeySystemDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadKeySystem(UserType* output) {
    
    auto* pointer = data_->key_system.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  bool use_hw_secure_codecs() const {
    return data_->use_hw_secure_codecs;
  }
 private:
  internal::PredictionFeatures_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class PredictionTargetsDataView {
 public:
  PredictionTargetsDataView() = default;

  PredictionTargetsDataView(
      internal::PredictionTargets_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  uint32_t frames_decoded() const {
    return data_->frames_decoded;
  }
  uint32_t frames_dropped() const {
    return data_->frames_dropped;
  }
  uint32_t frames_power_efficient() const {
    return data_->frames_power_efficient;
  }
 private:
  internal::PredictionTargets_Data* data_ = nullptr;
};


class AudioPipelineInfoDataView {
 public:
  AudioPipelineInfoDataView() = default;

  AudioPipelineInfoDataView(
      internal::AudioPipelineInfo_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  [[nodiscard]] bool ReadDecoderType(UserType* output) const {
    auto data_value = data_->decoder_type;
    return mojo::internal::Deserialize<::media::mojom::AudioDecoderType>(
        data_value, output);
  }
  AudioDecoderType decoder_type() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::media::mojom::AudioDecoderType>(data_->decoder_type));
  }
  bool is_platform_decoder() const {
    return data_->is_platform_decoder;
  }
  bool has_decrypting_demuxer_stream() const {
    return data_->has_decrypting_demuxer_stream;
  }
  template <typename UserType>
  [[nodiscard]] bool ReadEncryptionType(UserType* output) const {
    auto data_value = data_->encryption_type;
    return mojo::internal::Deserialize<::media::mojom::EncryptionType>(
        data_value, output);
  }
  EncryptionType encryption_type() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::media::mojom::EncryptionType>(data_->encryption_type));
  }
 private:
  internal::AudioPipelineInfo_Data* data_ = nullptr;
};


class VideoPipelineInfoDataView {
 public:
  VideoPipelineInfoDataView() = default;

  VideoPipelineInfoDataView(
      internal::VideoPipelineInfo_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  [[nodiscard]] bool ReadDecoderType(UserType* output) const {
    auto data_value = data_->decoder_type;
    return mojo::internal::Deserialize<::media::mojom::VideoDecoderType>(
        data_value, output);
  }
  VideoDecoderType decoder_type() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::media::mojom::VideoDecoderType>(data_->decoder_type));
  }
  bool is_platform_decoder() const {
    return data_->is_platform_decoder;
  }
  bool has_decrypting_demuxer_stream() const {
    return data_->has_decrypting_demuxer_stream;
  }
  template <typename UserType>
  [[nodiscard]] bool ReadEncryptionType(UserType* output) const {
    auto data_value = data_->encryption_type;
    return mojo::internal::Deserialize<::media::mojom::EncryptionType>(
        data_value, output);
  }
  EncryptionType encryption_type() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::media::mojom::EncryptionType>(data_->encryption_type));
  }
 private:
  internal::VideoPipelineInfo_Data* data_ = nullptr;
};


class StatusDataDataView {
 public:
  StatusDataDataView() = default;

  StatusDataDataView(
      internal::StatusData_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetGroupDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadGroup(UserType* output) {
    
    auto* pointer = data_->group.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  uint16_t code() const {
    return data_->code;
  }
  inline void GetMessageDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadMessage(UserType* output) {
    
    auto* pointer = data_->message.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetFramesDataView(
      ::mojo_base::mojom::ListValueDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadFrames(UserType* output) {
    
    auto* pointer = data_->frames.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::ListValueDataView>(
        pointer, output, message_);
  }
  inline void GetCauseDataView(
      StatusDataDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadCause(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::media::mojom::StatusDataDataView, UserType>(),
    "Attempting to read the optional `cause` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadCause` instead "
    "of `ReadCause if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->cause.Get();
    return mojo::internal::Deserialize<::media::mojom::StatusDataDataView>(
        pointer, output, message_);
  }
  inline void GetDataDataView(
      ::mojo_base::mojom::ValueDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadData(UserType* output) {
    
    auto* pointer = !data_->data.is_null() ? &data_->data : nullptr;
    return mojo::internal::Deserialize<::mojo_base::mojom::ValueDataView>(
        pointer, output, message_);
  }
 private:
  internal::StatusData_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class EncoderStatusDataView {
 public:
  EncoderStatusDataView() = default;

  EncoderStatusDataView(
      internal::EncoderStatus_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetInternalDataView(
      StatusDataDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadInternal(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::media::mojom::StatusDataDataView, UserType>(),
    "Attempting to read the optional `internal` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadInternal` instead "
    "of `ReadInternal if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->internal.Get();
    return mojo::internal::Deserialize<::media::mojom::StatusDataDataView>(
        pointer, output, message_);
  }
 private:
  internal::EncoderStatus_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class DecoderStatusDataView {
 public:
  DecoderStatusDataView() = default;

  DecoderStatusDataView(
      internal::DecoderStatus_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetInternalDataView(
      StatusDataDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadInternal(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::media::mojom::StatusDataDataView, UserType>(),
    "Attempting to read the optional `internal` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadInternal` instead "
    "of `ReadInternal if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->internal.Get();
    return mojo::internal::Deserialize<::media::mojom::StatusDataDataView>(
        pointer, output, message_);
  }
 private:
  internal::DecoderStatus_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class PipelineStatusDataView {
 public:
  PipelineStatusDataView() = default;

  PipelineStatusDataView(
      internal::PipelineStatus_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetInternalDataView(
      StatusDataDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadInternal(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::media::mojom::StatusDataDataView, UserType>(),
    "Attempting to read the optional `internal` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadInternal` instead "
    "of `ReadInternal if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->internal.Get();
    return mojo::internal::Deserialize<::media::mojom::StatusDataDataView>(
        pointer, output, message_);
  }
 private:
  internal::PipelineStatus_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class AutoPipInfoDataView {
 public:
  AutoPipInfoDataView() = default;

  AutoPipInfoDataView(
      internal::AutoPipInfo_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  [[nodiscard]] bool ReadAutoPipReason(UserType* output) const {
    auto data_value = data_->auto_pip_reason;
    return mojo::internal::Deserialize<::media::mojom::AutoPipReason>(
        data_value, output);
  }
  AutoPipReason auto_pip_reason() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::media::mojom::AutoPipReason>(data_->auto_pip_reason));
  }
  bool has_audio_focus() const {
    return data_->has_audio_focus;
  }
  bool is_playing() const {
    return data_->is_playing;
  }
  bool was_recently_audible() const {
    return data_->was_recently_audible;
  }
  bool has_safe_url() const {
    return data_->has_safe_url;
  }
  bool meets_media_engagement_conditions() const {
    return data_->meets_media_engagement_conditions;
  }
  bool blocked_due_to_content_setting() const {
    return data_->blocked_due_to_content_setting;
  }
 private:
  internal::AutoPipInfo_Data* data_ = nullptr;
};


class DecoderBufferSideDataNextConfigDataView {
 public:
  using Tag = internal::DecoderBufferSideDataNextConfig_Data::DecoderBufferSideDataNextConfig_Tag;

  DecoderBufferSideDataNextConfigDataView() = default;

  DecoderBufferSideDataNextConfigDataView(
      internal::DecoderBufferSideDataNextConfig_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const {
    // For inlined unions, |data_| is always non-null. In that case we need to
    // check |data_->is_null()|.
    return !data_ || data_->is_null();
  }

  Tag tag() const { return data_->tag; }
  bool is_next_audio_config() const { return data_->tag == Tag::kNextAudioConfig; }
  inline void GetNextAudioConfigDataView(
      AudioDecoderConfigDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadNextAudioConfig(UserType* output) const {
    
    CHECK(is_next_audio_config());
    return mojo::internal::Deserialize<::media::mojom::AudioDecoderConfigDataView>(
        data_->data.f_next_audio_config.Get(), output, message_);
  }
  bool is_next_video_config() const { return data_->tag == Tag::kNextVideoConfig; }
  inline void GetNextVideoConfigDataView(
      VideoDecoderConfigDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadNextVideoConfig(UserType* output) const {
    
    CHECK(is_next_video_config());
    return mojo::internal::Deserialize<::media::mojom::VideoDecoderConfigDataView>(
        data_->data.f_next_video_config.Get(), output, message_);
  }

 private:
  internal::DecoderBufferSideDataNextConfig_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};



class DecoderBufferDataView {
 public:
  using Tag = internal::DecoderBuffer_Data::DecoderBuffer_Tag;

  DecoderBufferDataView() = default;

  DecoderBufferDataView(
      internal::DecoderBuffer_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const {
    // For inlined unions, |data_| is always non-null. In that case we need to
    // check |data_->is_null()|.
    return !data_ || data_->is_null();
  }

  Tag tag() const { return data_->tag; }
  bool is_eos() const { return data_->tag == Tag::kEos; }
  inline void GetEosDataView(
      EosDecoderBufferDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadEos(UserType* output) const {
    
    CHECK(is_eos());
    return mojo::internal::Deserialize<::media::mojom::EosDecoderBufferDataView>(
        data_->data.f_eos.Get(), output, message_);
  }
  bool is_data() const { return data_->tag == Tag::kData; }
  inline void GetDataDataView(
      DataDecoderBufferDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadData(UserType* output) const {
    
    CHECK(is_data());
    return mojo::internal::Deserialize<::media::mojom::DataDecoderBufferDataView>(
        data_->data.f_data.Get(), output, message_);
  }

 private:
  internal::DecoderBuffer_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};



class VideoFrameDataDataView {
 public:
  using Tag = internal::VideoFrameData_Data::VideoFrameData_Tag;

  VideoFrameDataDataView() = default;

  VideoFrameDataDataView(
      internal::VideoFrameData_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const {
    // For inlined unions, |data_| is always non-null. In that case we need to
    // check |data_->is_null()|.
    return !data_ || data_->is_null();
  }

  Tag tag() const { return data_->tag; }
  bool is_eos_data() const { return data_->tag == Tag::kEosData; }
  inline void GetEosDataDataView(
      EosVideoFrameDataDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadEosData(UserType* output) const {
    
    CHECK(is_eos_data());
    return mojo::internal::Deserialize<::media::mojom::EosVideoFrameDataDataView>(
        data_->data.f_eos_data.Get(), output, message_);
  }
  bool is_shared_memory_data() const { return data_->tag == Tag::kSharedMemoryData; }
  inline void GetSharedMemoryDataDataView(
      SharedMemoryVideoFrameDataDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadSharedMemoryData(UserType* output) const {
    
    CHECK(is_shared_memory_data());
    return mojo::internal::Deserialize<::media::mojom::SharedMemoryVideoFrameDataDataView>(
        data_->data.f_shared_memory_data.Get(), output, message_);
  }
  bool is_gpu_memory_buffer_shared_image_data() const { return data_->tag == Tag::kGpuMemoryBufferSharedImageData; }
  inline void GetGpuMemoryBufferSharedImageDataDataView(
      GpuMemoryBufferSharedImageVideoFrameDataDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadGpuMemoryBufferSharedImageData(UserType* output) const {
    
    CHECK(is_gpu_memory_buffer_shared_image_data());
    return mojo::internal::Deserialize<::media::mojom::GpuMemoryBufferSharedImageVideoFrameDataDataView>(
        data_->data.f_gpu_memory_buffer_shared_image_data.Get(), output, message_);
  }
  bool is_shared_image_data() const { return data_->tag == Tag::kSharedImageData; }
  inline void GetSharedImageDataDataView(
      SharedImageVideoFrameDataDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadSharedImageData(UserType* output) const {
    
    CHECK(is_shared_image_data());
    return mojo::internal::Deserialize<::media::mojom::SharedImageVideoFrameDataDataView>(
        data_->data.f_shared_image_data.Get(), output, message_);
  }
  bool is_opaque_data() const { return data_->tag == Tag::kOpaqueData; }
  inline void GetOpaqueDataDataView(
      OpaqueVideoFrameDataDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadOpaqueData(UserType* output) const {
    
    CHECK(is_opaque_data());
    return mojo::internal::Deserialize<::media::mojom::OpaqueVideoFrameDataDataView>(
        data_->data.f_opaque_data.Get(), output, message_);
  }
  bool is_dmabuf_data() const { return data_->tag == Tag::kDmabufData; }
  inline void GetDmabufDataDataView(
      DmabufVideoFrameDataDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadDmabufData(UserType* output) const {
    
    CHECK(is_dmabuf_data());
    return mojo::internal::Deserialize<::media::mojom::DmabufVideoFrameDataDataView>(
        data_->data.f_dmabuf_data.Get(), output, message_);
  }

 private:
  internal::VideoFrameData_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};



}  // media::mojom

#endif  // MEDIA_MOJO_MOJOM_MEDIA_TYPES_MOJOM_DATA_VIEW_H_