// media/mojo/mojom/media_types.mojom-shared-internal.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef MEDIA_MOJO_MOJOM_MEDIA_TYPES_MOJOM_SHARED_INTERNAL_H_
#define MEDIA_MOJO_MOJOM_MEDIA_TYPES_MOJOM_SHARED_INTERNAL_H_
#include "mojo/public/cpp/bindings/lib/array_internal.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/map_data_internal.h"
#include "mojo/public/cpp/bindings/lib/buffer.h"
#include "gpu/ipc/common/exported_shared_image.mojom-shared-internal.h"
#include "gpu/ipc/common/mailbox.mojom-shared-internal.h"
#include "gpu/ipc/common/sync_token.mojom-shared-internal.h"
#include "gpu/ipc/common/vulkan_ycbcr_info.mojom-shared-internal.h"
#include "media/mojo/mojom/audio_data.mojom-shared-internal.h"
#include "media/mojo/mojom/encryption_pattern.mojom-shared-internal.h"
#include "mojo/public/mojom/base/byte_string.mojom-shared-internal.h"
#include "mojo/public/mojom/base/shared_memory.mojom-shared-internal.h"
#include "mojo/public/mojom/base/time.mojom-shared-internal.h"
#include "mojo/public/mojom/base/values.mojom-shared-internal.h"
#include "mojo/public/mojom/base/unguessable_token.mojom-shared-internal.h"
#include "ui/gfx/geometry/mojom/geometry.mojom-shared-internal.h"
#include "ui/gfx/mojom/buffer_types.mojom-shared-internal.h"
#include "ui/gfx/mojom/color_space.mojom-shared-internal.h"
#include "ui/gfx/mojom/hdr_metadata.mojom-shared-internal.h"
#include "mojo/public/cpp/bindings/lib/native_enum_data.h"
#include "mojo/public/interfaces/bindings/native_struct.mojom-shared-internal.h"



namespace mojo {
namespace internal {
class ValidationContext;
}
}


namespace media::mojom {
namespace internal {
using MediaLogRecord_Data = mojo::native::internal::NativeStruct_Data;
class VideoTransformation_Data;
class VideoAspectRatio_Data;
class VideoColorSpace_Data;
class AudioDecoderConfig_Data;
class VideoDecoderConfig_Data;
using SubsampleEntry_Data = mojo::native::internal::NativeStruct_Data;
class DecryptConfig_Data;
class DecoderBufferSideData_Data;
class DataDecoderBuffer_Data;
class EosDecoderBuffer_Data;
class AudioBuffer_Data;
class VideoFrameMetadata_Data;
class VideoFrame_Data;
class EosVideoFrameData_Data;
class SharedMemoryVideoFrameData_Data;
class GpuMemoryBufferSharedImageVideoFrameData_Data;
class SharedImageVideoFrameData_Data;
class OpaqueVideoFrameData_Data;
class ColorPlaneLayout_Data;
class DmabufVideoFrameData_Data;
class PipelineStatistics_Data;
class PredictionFeatures_Data;
class PredictionTargets_Data;
class AudioPipelineInfo_Data;
class VideoPipelineInfo_Data;
class StatusData_Data;
class EncoderStatus_Data;
class DecoderStatus_Data;
class PipelineStatus_Data;
class AutoPipInfo_Data;
class DecoderBufferSideDataNextConfig_Data;
class DecoderBuffer_Data;
class VideoFrameData_Data;
using AudioCodec_Data =
    mojo::internal::NativeEnum_Data;
using AudioCodecProfile_Data =
    mojo::internal::NativeEnum_Data;
using BufferingState_Data =
    mojo::internal::NativeEnum_Data;
using BufferingStateChangeReason_Data =
    mojo::internal::NativeEnum_Data;
using ChannelLayout_Data =
    mojo::internal::NativeEnum_Data;
using MediaContentType_Data =
    mojo::internal::NativeEnum_Data;
using OutputDeviceStatus_Data =
    mojo::internal::NativeEnum_Data;
using SampleFormat_Data =
    mojo::internal::NativeEnum_Data;
using VideoCodec_Data =
    mojo::internal::NativeEnum_Data;
using VideoCodecProfile_Data =
    mojo::internal::NativeEnum_Data;
using VideoPixelFormat_Data =
    mojo::internal::NativeEnum_Data;
using VideoDecoderType_Data =
    mojo::internal::NativeEnum_Data;
using AudioDecoderType_Data =
    mojo::internal::NativeEnum_Data;

struct VideoRotation_Data {
 public:
  static bool constexpr kIsExtensible = false;

  static bool IsKnownValue(int32_t value) {
    switch (value) {
      case 0:
      case 1:
      case 2:
      case 3:
        return true;
    }
    return false;
  }

  static bool Validate(int32_t value,
                       mojo::internal::ValidationContext* validation_context) {
    if (kIsExtensible || IsKnownValue(value))
      return true;

    ReportValidationError(validation_context,
                          mojo::internal::VALIDATION_ERROR_UNKNOWN_ENUM_VALUE);
    return false;
  }
};
using FullscreenVideoStatus_Data =
    mojo::internal::NativeEnum_Data;
using WaitingReason_Data =
    mojo::internal::NativeEnum_Data;
using WatchTimeKey_Data =
    mojo::internal::NativeEnum_Data;
using MediaContainerName_Data =
    mojo::internal::NativeEnum_Data;
using MediaStatusState_Data =
    mojo::internal::NativeEnum_Data;
using EncryptionScheme_Data =
    mojo::internal::NativeEnum_Data;

struct EncryptionType_Data {
 public:
  static bool constexpr kIsExtensible = false;

  static bool IsKnownValue(int32_t value) {
    switch (value) {
      case 0:
      case 1:
      case 2:
      case 3:
        return true;
    }
    return false;
  }

  static bool Validate(int32_t value,
                       mojo::internal::ValidationContext* validation_context) {
    if (kIsExtensible || IsKnownValue(value))
      return true;

    ReportValidationError(validation_context,
                          mojo::internal::VALIDATION_ERROR_UNKNOWN_ENUM_VALUE);
    return false;
  }
};

struct SVCScalabilityMode_Data {
 public:
  static bool constexpr kIsExtensible = false;

  static bool IsKnownValue(int32_t value) {
    switch (value) {
      case 0:
      case 1:
      case 2:
      case 3:
      case 4:
      case 5:
      case 6:
      case 7:
      case 8:
      case 9:
      case 10:
      case 11:
      case 12:
      case 13:
      case 14:
      case 15:
      case 16:
      case 17:
      case 18:
      case 19:
      case 20:
      case 21:
        return true;
    }
    return false;
  }

  static bool Validate(int32_t value,
                       mojo::internal::ValidationContext* validation_context) {
    if (kIsExtensible || IsKnownValue(value))
      return true;

    ReportValidationError(validation_context,
                          mojo::internal::VALIDATION_ERROR_UNKNOWN_ENUM_VALUE);
    return false;
  }
};

struct SVCInterLayerPredMode_Data {
 public:
  static bool constexpr kIsExtensible = false;

  static bool IsKnownValue(int32_t value) {
    switch (value) {
      case 0:
      case 1:
      case 2:
        return true;
    }
    return false;
  }

  static bool Validate(int32_t value,
                       mojo::internal::ValidationContext* validation_context) {
    if (kIsExtensible || IsKnownValue(value))
      return true;

    ReportValidationError(validation_context,
                          mojo::internal::VALIDATION_ERROR_UNKNOWN_ENUM_VALUE);
    return false;
  }
};

struct CdmSessionClosedReason_Data {
 public:
  static bool constexpr kIsExtensible = false;

  static bool IsKnownValue(int32_t value) {
    switch (value) {
      case 0:
      case 1:
      case 2:
      case 3:
      case 4:
        return true;
    }
    return false;
  }

  static bool Validate(int32_t value,
                       mojo::internal::ValidationContext* validation_context) {
    if (kIsExtensible || IsKnownValue(value))
      return true;

    ReportValidationError(validation_context,
                          mojo::internal::VALIDATION_ERROR_UNKNOWN_ENUM_VALUE);
    return false;
  }
};

struct EffectState_Data {
 public:
  static bool constexpr kIsExtensible = false;

  static bool IsKnownValue(int32_t value) {
    switch (value) {
      case 0:
      case 1:
      case 2:
        return true;
    }
    return false;
  }

  static bool Validate(int32_t value,
                       mojo::internal::ValidationContext* validation_context) {
    if (kIsExtensible || IsKnownValue(value))
      return true;

    ReportValidationError(validation_context,
                          mojo::internal::VALIDATION_ERROR_UNKNOWN_ENUM_VALUE);
    return false;
  }
};

struct MediaStreamType_Data {
 public:
  static bool constexpr kIsExtensible = false;

  static bool IsKnownValue(int32_t value) {
    switch (value) {
      case 0:
      case 1:
      case 2:
      case 3:
      case 4:
      case 5:
      case 6:
        return true;
    }
    return false;
  }

  static bool Validate(int32_t value,
                       mojo::internal::ValidationContext* validation_context) {
    if (kIsExtensible || IsKnownValue(value))
      return true;

    ReportValidationError(validation_context,
                          mojo::internal::VALIDATION_ERROR_UNKNOWN_ENUM_VALUE);
    return false;
  }
};

struct InputStreamErrorCode_Data {
 public:
  static bool constexpr kIsExtensible = false;

  static bool IsKnownValue(int32_t value) {
    switch (value) {
      case 0:
      case 1:
      case 2:
        return true;
    }
    return false;
  }

  static bool Validate(int32_t value,
                       mojo::internal::ValidationContext* validation_context) {
    if (kIsExtensible || IsKnownValue(value))
      return true;

    ReportValidationError(validation_context,
                          mojo::internal::VALIDATION_ERROR_UNKNOWN_ENUM_VALUE);
    return false;
  }
};

struct RendererType_Data {
 public:
  static bool constexpr kIsExtensible = false;

  static bool IsKnownValue(int32_t value) {
    switch (value) {
      case 0:
      case 1:
      case 3:
      case 4:
      case 5:
      case 6:
      case 8:
      case 9:
      case 10:
      case 11:
        return true;
    }
    return false;
  }

  static bool Validate(int32_t value,
                       mojo::internal::ValidationContext* validation_context) {
    if (kIsExtensible || IsKnownValue(value))
      return true;

    ReportValidationError(validation_context,
                          mojo::internal::VALIDATION_ERROR_UNKNOWN_ENUM_VALUE);
    return false;
  }
};

struct DemuxerType_Data {
 public:
  static bool constexpr kIsExtensible = false;

  static bool IsKnownValue(int32_t value) {
    switch (value) {
      case 0:
      case 1:
      case 2:
      case 3:
      case 5:
      case 6:
      case 7:
        return true;
    }
    return false;
  }

  static bool Validate(int32_t value,
                       mojo::internal::ValidationContext* validation_context) {
    if (kIsExtensible || IsKnownValue(value))
      return true;

    ReportValidationError(validation_context,
                          mojo::internal::VALIDATION_ERROR_UNKNOWN_ENUM_VALUE);
    return false;
  }
};

struct CreateCdmStatus_Data {
 public:
  static bool constexpr kIsExtensible = false;

  static bool IsKnownValue(int32_t value) {
    switch (value) {
      case 0:
      case 1:
      case 2:
      case 4:
      case 5:
      case 6:
      case 7:
      case 8:
      case 9:
      case 10:
      case 11:
      case 12:
      case 13:
      case 14:
      case 16:
      case 17:
      case 18:
      case 19:
      case 20:
      case 21:
      case 22:
      case 23:
      case 24:
      case 25:
      case 26:
      case 27:
      case 28:
      case 29:
        return true;
    }
    return false;
  }

  static bool Validate(int32_t value,
                       mojo::internal::ValidationContext* validation_context) {
    if (kIsExtensible || IsKnownValue(value))
      return true;

    ReportValidationError(validation_context,
                          mojo::internal::VALIDATION_ERROR_UNKNOWN_ENUM_VALUE);
    return false;
  }
};

struct AutoPipReason_Data {
 public:
  static bool constexpr kIsExtensible = false;

  static bool IsKnownValue(int32_t value) {
    switch (value) {
      case 0:
      case 1:
      case 2:
        return true;
    }
    return false;
  }

  static bool Validate(int32_t value,
                       mojo::internal::ValidationContext* validation_context) {
    if (kIsExtensible || IsKnownValue(value))
      return true;

    ReportValidationError(validation_context,
                          mojo::internal::VALIDATION_ERROR_UNKNOWN_ENUM_VALUE);
    return false;
  }
};

struct VideoAspectRatio_Type_Data {
 public:
  static bool constexpr kIsExtensible = false;

  static bool IsKnownValue(int32_t value) {
    switch (value) {
      case 0:
      case 1:
        return true;
    }
    return false;
  }

  static bool Validate(int32_t value,
                       mojo::internal::ValidationContext* validation_context) {
    if (kIsExtensible || IsKnownValue(value))
      return true;

    ReportValidationError(validation_context,
                          mojo::internal::VALIDATION_ERROR_UNKNOWN_ENUM_VALUE);
    return false;
  }
};
using VideoColorSpace_PrimaryID_Data =
    mojo::internal::NativeEnum_Data;
using VideoColorSpace_TransferID_Data =
    mojo::internal::NativeEnum_Data;
using VideoColorSpace_MatrixID_Data =
    mojo::internal::NativeEnum_Data;
using VideoColorSpace_RangeID_Data =
    mojo::internal::NativeEnum_Data;

#pragma pack(push, 1)


class  DecoderBufferSideDataNextConfig_Data {
 public:
  // Used to identify Mojom Union Data Classes.
  typedef void MojomUnionDataType;

  DecoderBufferSideDataNextConfig_Data() = default;
  // Do nothing in the destructor since it won't be called when it is a
  // non-inlined union.
  ~DecoderBufferSideDataNextConfig_Data() = default;

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context,
                       bool inlined);

  bool is_null() const { return size == 0; }

  void set_null() {
    size = 0U;
    tag = static_cast<DecoderBufferSideDataNextConfig_Tag>(0);
    data.unknown = 0U;
  }

  // TODO(crbug.com/40731316): SHOUTY_CASE values are being deprecated per C++ code style
  // guidelines (https://google.github.io/styleguide/cppguide.html#Enumerator_Names),
  // please use kCamelCase values instead.  Cleanup NULL_VALUE, BOOL_VALUE, INT_VALUE, etc.
  // generation once codebase is transitioned to kNullValue, kBoolValue, kIntValue, etc.
  enum class DecoderBufferSideDataNextConfig_Tag : uint32_t {

    
    kNextAudioConfig,
    
    kNextVideoConfig,
  };

  // A note on layout:
  // "Each non-static data member is allocated as if it were the sole member of
  // a struct." - Section 9.5.2 ISO/IEC 14882:2011 (The C++ Spec)
  union MOJO_ALIGNAS(8) Union_ {
    Union_() : unknown(0) {}
    mojo::internal::Pointer<internal::AudioDecoderConfig_Data> f_next_audio_config;
    mojo::internal::Pointer<internal::VideoDecoderConfig_Data> f_next_video_config;
    uint64_t unknown;
  };

  uint32_t size;
  DecoderBufferSideDataNextConfig_Tag tag;
  Union_ data;
};
static_assert(sizeof(DecoderBufferSideDataNextConfig_Data) == mojo::internal::kUnionDataSize,
              "Bad sizeof(DecoderBufferSideDataNextConfig_Data)");


class  DecoderBuffer_Data {
 public:
  // Used to identify Mojom Union Data Classes.
  typedef void MojomUnionDataType;

  DecoderBuffer_Data() = default;
  // Do nothing in the destructor since it won't be called when it is a
  // non-inlined union.
  ~DecoderBuffer_Data() = default;

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context,
                       bool inlined);

  bool is_null() const { return size == 0; }

  void set_null() {
    size = 0U;
    tag = static_cast<DecoderBuffer_Tag>(0);
    data.unknown = 0U;
  }

  // TODO(crbug.com/40731316): SHOUTY_CASE values are being deprecated per C++ code style
  // guidelines (https://google.github.io/styleguide/cppguide.html#Enumerator_Names),
  // please use kCamelCase values instead.  Cleanup NULL_VALUE, BOOL_VALUE, INT_VALUE, etc.
  // generation once codebase is transitioned to kNullValue, kBoolValue, kIntValue, etc.
  enum class DecoderBuffer_Tag : uint32_t {

    
    kEos,
    
    kData,
  };

  // A note on layout:
  // "Each non-static data member is allocated as if it were the sole member of
  // a struct." - Section 9.5.2 ISO/IEC 14882:2011 (The C++ Spec)
  union MOJO_ALIGNAS(8) Union_ {
    Union_() : unknown(0) {}
    mojo::internal::Pointer<internal::EosDecoderBuffer_Data> f_eos;
    mojo::internal::Pointer<internal::DataDecoderBuffer_Data> f_data;
    uint64_t unknown;
  };

  uint32_t size;
  DecoderBuffer_Tag tag;
  Union_ data;
};
static_assert(sizeof(DecoderBuffer_Data) == mojo::internal::kUnionDataSize,
              "Bad sizeof(DecoderBuffer_Data)");


class  VideoFrameData_Data {
 public:
  // Used to identify Mojom Union Data Classes.
  typedef void MojomUnionDataType;

  VideoFrameData_Data() = default;
  // Do nothing in the destructor since it won't be called when it is a
  // non-inlined union.
  ~VideoFrameData_Data() = default;

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context,
                       bool inlined);

  bool is_null() const { return size == 0; }

  void set_null() {
    size = 0U;
    tag = static_cast<VideoFrameData_Tag>(0);
    data.unknown = 0U;
  }

  // TODO(crbug.com/40731316): SHOUTY_CASE values are being deprecated per C++ code style
  // guidelines (https://google.github.io/styleguide/cppguide.html#Enumerator_Names),
  // please use kCamelCase values instead.  Cleanup NULL_VALUE, BOOL_VALUE, INT_VALUE, etc.
  // generation once codebase is transitioned to kNullValue, kBoolValue, kIntValue, etc.
  enum class VideoFrameData_Tag : uint32_t {

    
    kEosData,
    
    kSharedMemoryData,
    
    kGpuMemoryBufferSharedImageData,
    
    kSharedImageData,
    
    kOpaqueData,
    
    kDmabufData,
  };

  // A note on layout:
  // "Each non-static data member is allocated as if it were the sole member of
  // a struct." - Section 9.5.2 ISO/IEC 14882:2011 (The C++ Spec)
  union MOJO_ALIGNAS(8) Union_ {
    Union_() : unknown(0) {}
    mojo::internal::Pointer<internal::EosVideoFrameData_Data> f_eos_data;
    mojo::internal::Pointer<internal::SharedMemoryVideoFrameData_Data> f_shared_memory_data;
    mojo::internal::Pointer<internal::GpuMemoryBufferSharedImageVideoFrameData_Data> f_gpu_memory_buffer_shared_image_data;
    mojo::internal::Pointer<internal::SharedImageVideoFrameData_Data> f_shared_image_data;
    mojo::internal::Pointer<internal::OpaqueVideoFrameData_Data> f_opaque_data;
    mojo::internal::Pointer<internal::DmabufVideoFrameData_Data> f_dmabuf_data;
    uint64_t unknown;
  };

  uint32_t size;
  VideoFrameData_Tag tag;
  Union_ data;
};
static_assert(sizeof(VideoFrameData_Data) == mojo::internal::kUnionDataSize,
              "Bad sizeof(VideoFrameData_Data)");
class  VideoTransformation_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  int32_t rotation;
  uint8_t mirrored : 1;
  uint8_t padfinal_[3];

 private:
  friend class mojo::internal::MessageFragment<VideoTransformation_Data>;

  VideoTransformation_Data();
  ~VideoTransformation_Data() = delete;
};
static_assert(sizeof(VideoTransformation_Data) == 16,
              "Bad sizeof(VideoTransformation_Data)");
// Used by VideoTransformation::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct VideoTransformation_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  VideoTransformation_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~VideoTransformation_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::Message& message) override {
    mojo::internal::MessageFragment<VideoTransformation_Data> fragment(message);
    mojo::internal::Serialize<DataView>(user_data_, fragment);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    VideoTransformation_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};
class  VideoAspectRatio_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  int32_t type;
  uint8_t pad0_[4];
  double value;

 private:
  friend class mojo::internal::MessageFragment<VideoAspectRatio_Data>;

  VideoAspectRatio_Data();
  ~VideoAspectRatio_Data() = delete;
};
static_assert(sizeof(VideoAspectRatio_Data) == 24,
              "Bad sizeof(VideoAspectRatio_Data)");
// Used by VideoAspectRatio::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct VideoAspectRatio_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  VideoAspectRatio_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~VideoAspectRatio_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::Message& message) override {
    mojo::internal::MessageFragment<VideoAspectRatio_Data> fragment(message);
    mojo::internal::Serialize<DataView>(user_data_, fragment);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    VideoAspectRatio_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};
class  VideoColorSpace_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  int32_t primaries;
  int32_t transfer;
  int32_t matrix;
  int32_t range;

 private:
  friend class mojo::internal::MessageFragment<VideoColorSpace_Data>;

  VideoColorSpace_Data();
  ~VideoColorSpace_Data() = delete;
};
static_assert(sizeof(VideoColorSpace_Data) == 24,
              "Bad sizeof(VideoColorSpace_Data)");
// Used by VideoColorSpace::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct VideoColorSpace_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  VideoColorSpace_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~VideoColorSpace_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::Message& message) override {
    mojo::internal::MessageFragment<VideoColorSpace_Data> fragment(message);
    mojo::internal::Serialize<DataView>(user_data_, fragment);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    VideoColorSpace_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};
class  AudioDecoderConfig_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  int32_t codec;
  int32_t sample_format;
  int32_t channel_layout;
  int32_t samples_per_second;
  mojo::internal::Pointer<mojo::internal::Array_Data<uint8_t>> extra_data;
  int32_t encryption_scheme;
  int32_t codec_delay;
  mojo::internal::Pointer<::mojo_base::mojom::internal::TimeDelta_Data> seek_preroll;
  int32_t profile;
  int32_t target_output_channel_layout;
  int32_t target_output_sample_format;
  uint8_t should_discard_decoder_delay : 1;
  uint8_t padfinal_[3];

 private:
  friend class mojo::internal::MessageFragment<AudioDecoderConfig_Data>;

  AudioDecoderConfig_Data();
  ~AudioDecoderConfig_Data() = delete;
};
static_assert(sizeof(AudioDecoderConfig_Data) == 64,
              "Bad sizeof(AudioDecoderConfig_Data)");
// Used by AudioDecoderConfig::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct AudioDecoderConfig_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  AudioDecoderConfig_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~AudioDecoderConfig_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::Message& message) override {
    mojo::internal::MessageFragment<AudioDecoderConfig_Data> fragment(message);
    mojo::internal::Serialize<DataView>(user_data_, fragment);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    AudioDecoderConfig_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};
class  VideoDecoderConfig_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  int32_t codec;
  int32_t profile;
  uint32_t level;
  uint8_t has_alpha : 1;
  uint8_t pad3_[3];
  mojo::internal::Pointer<internal::VideoTransformation_Data> transformation;
  mojo::internal::Pointer<::gfx::mojom::internal::Size_Data> coded_size;
  mojo::internal::Pointer<::gfx::mojom::internal::Rect_Data> visible_rect;
  mojo::internal::Pointer<::gfx::mojom::internal::Size_Data> natural_size;
  mojo::internal::Pointer<internal::VideoAspectRatio_Data> aspect_ratio;
  mojo::internal::Pointer<mojo::internal::Array_Data<uint8_t>> extra_data;
  int32_t encryption_scheme;
  uint8_t pad10_[4];
  mojo::internal::Pointer<internal::VideoColorSpace_Data> color_space_info;
  mojo::internal::Pointer<::gfx::mojom::internal::HDRMetadata_Data> hdr_metadata;

 private:
  friend class mojo::internal::MessageFragment<VideoDecoderConfig_Data>;

  VideoDecoderConfig_Data();
  ~VideoDecoderConfig_Data() = delete;
};
static_assert(sizeof(VideoDecoderConfig_Data) == 96,
              "Bad sizeof(VideoDecoderConfig_Data)");
// Used by VideoDecoderConfig::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct VideoDecoderConfig_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  VideoDecoderConfig_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~VideoDecoderConfig_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::Message& message) override {
    mojo::internal::MessageFragment<VideoDecoderConfig_Data> fragment(message);
    mojo::internal::Serialize<DataView>(user_data_, fragment);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    VideoDecoderConfig_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};
class  DecryptConfig_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  int32_t encryption_scheme;
  uint8_t pad0_[4];
  mojo::internal::Pointer<::mojo_base::mojom::internal::ByteString_Data> key_id;
  mojo::internal::Pointer<::mojo_base::mojom::internal::ByteString_Data> iv;
  mojo::internal::Pointer<mojo::internal::Array_Data<mojo::internal::Pointer<internal::SubsampleEntry_Data>>> subsamples;
  mojo::internal::Pointer<::media::mojom::internal::EncryptionPattern_Data> encryption_pattern;

 private:
  friend class mojo::internal::MessageFragment<DecryptConfig_Data>;

  DecryptConfig_Data();
  ~DecryptConfig_Data() = delete;
};
static_assert(sizeof(DecryptConfig_Data) == 48,
              "Bad sizeof(DecryptConfig_Data)");
// Used by DecryptConfig::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct DecryptConfig_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  DecryptConfig_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~DecryptConfig_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::Message& message) override {
    mojo::internal::MessageFragment<DecryptConfig_Data> fragment(message);
    mojo::internal::Serialize<DataView>(user_data_, fragment);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    DecryptConfig_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};
class  DecoderBufferSideData_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<mojo::internal::Array_Data<uint32_t>> spatial_layers;
  mojo::internal::Pointer<mojo::internal::Array_Data<uint8_t>> alpha_data;
  uint64_t secure_handle;
  mojo::internal::Pointer<::mojo_base::mojom::internal::TimeDelta_Data> front_discard;
  mojo::internal::Pointer<::mojo_base::mojom::internal::TimeDelta_Data> back_discard;

 private:
  friend class mojo::internal::MessageFragment<DecoderBufferSideData_Data>;

  DecoderBufferSideData_Data();
  ~DecoderBufferSideData_Data() = delete;
};
static_assert(sizeof(DecoderBufferSideData_Data) == 48,
              "Bad sizeof(DecoderBufferSideData_Data)");
// Used by DecoderBufferSideData::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct DecoderBufferSideData_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  DecoderBufferSideData_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~DecoderBufferSideData_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::Message& message) override {
    mojo::internal::MessageFragment<DecoderBufferSideData_Data> fragment(message);
    mojo::internal::Serialize<DataView>(user_data_, fragment);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    DecoderBufferSideData_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};
class  DataDecoderBuffer_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<::mojo_base::mojom::internal::TimeDelta_Data> timestamp;
  mojo::internal::Pointer<::mojo_base::mojom::internal::TimeDelta_Data> duration;
  uint32_t data_size;
  uint8_t is_key_frame : 1;
  uint8_t pad3_[3];
  mojo::internal::Pointer<internal::DecryptConfig_Data> decrypt_config;
  mojo::internal::Pointer<internal::DecoderBufferSideData_Data> side_data;

 private:
  friend class mojo::internal::MessageFragment<DataDecoderBuffer_Data>;

  DataDecoderBuffer_Data();
  ~DataDecoderBuffer_Data() = delete;
};
static_assert(sizeof(DataDecoderBuffer_Data) == 48,
              "Bad sizeof(DataDecoderBuffer_Data)");
// Used by DataDecoderBuffer::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct DataDecoderBuffer_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  DataDecoderBuffer_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~DataDecoderBuffer_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::Message& message) override {
    mojo::internal::MessageFragment<DataDecoderBuffer_Data> fragment(message);
    mojo::internal::Serialize<DataView>(user_data_, fragment);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    DataDecoderBuffer_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};
class  EosDecoderBuffer_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  internal::DecoderBufferSideDataNextConfig_Data next_config;

 private:
  friend class mojo::internal::MessageFragment<EosDecoderBuffer_Data>;

  EosDecoderBuffer_Data();
  ~EosDecoderBuffer_Data() = delete;
};
static_assert(sizeof(EosDecoderBuffer_Data) == 24,
              "Bad sizeof(EosDecoderBuffer_Data)");
// Used by EosDecoderBuffer::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct EosDecoderBuffer_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  EosDecoderBuffer_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~EosDecoderBuffer_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::Message& message) override {
    mojo::internal::MessageFragment<EosDecoderBuffer_Data> fragment(message);
    mojo::internal::Serialize<DataView>(user_data_, fragment);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    EosDecoderBuffer_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};
class  AudioBuffer_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  int32_t sample_format;
  int32_t channel_layout;
  int32_t channel_count;
  int32_t sample_rate;
  int32_t frame_count;
  uint8_t end_of_stream : 1;
  uint8_t pad5_[3];
  mojo::internal::Pointer<::mojo_base::mojom::internal::TimeDelta_Data> timestamp;
  mojo::internal::Pointer<mojo::internal::Array_Data<uint8_t>> data;

 private:
  friend class mojo::internal::MessageFragment<AudioBuffer_Data>;

  AudioBuffer_Data();
  ~AudioBuffer_Data() = delete;
};
static_assert(sizeof(AudioBuffer_Data) == 48,
              "Bad sizeof(AudioBuffer_Data)");
// Used by AudioBuffer::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct AudioBuffer_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  AudioBuffer_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~AudioBuffer_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::Message& message) override {
    mojo::internal::MessageFragment<AudioBuffer_Data> fragment(message);
    mojo::internal::Serialize<DataView>(user_data_, fragment);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    AudioBuffer_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};
class  VideoFrameMetadata_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  uint8_t allow_overlay : 1;
  uint8_t has_capture_counter : 1;
  uint8_t copy_required : 1;
  uint8_t end_of_stream : 1;
  uint8_t has_frame_rate : 1;
  uint8_t interactive_content : 1;
  uint8_t read_lock_fences_enabled : 1;
  uint8_t in_surface_view : 1;
  uint8_t wants_promotion_hint : 1;
  uint8_t protected_video : 1;
  uint8_t hw_protected : 1;
  uint8_t needs_detiling : 1;
  uint8_t is_webgpu_compatible : 1;
  uint8_t power_efficient : 1;
  uint8_t has_device_scale_factor : 1;
  uint8_t has_page_scale_factor : 1;
  uint8_t has_root_scroll_offset_x : 1;
  uint8_t has_root_scroll_offset_y : 1;
  uint8_t has_top_controls_visible_height : 1;
  uint8_t has_rtp_timestamp : 1;
  uint8_t frame_sequence_$flag : 1;
  uint8_t source_id_$flag : 1;
  uint8_t pad21_[1];
  int32_t capture_counter;
  mojo::internal::Pointer<::mojo_base::mojom::internal::TimeTicks_Data> capture_begin_time;
  mojo::internal::Pointer<::mojo_base::mojom::internal::TimeTicks_Data> capture_end_time;
  mojo::internal::Pointer<::gfx::mojom::internal::Rect_Data> capture_update_rect;
  mojo::internal::Pointer<::gfx::mojom::internal::Size_Data> source_size;
  mojo::internal::Pointer<::gfx::mojom::internal::Rect_Data> region_capture_rect;
  uint32_t sub_capture_target_version;
  int32_t background_blur;
  mojo::internal::Pointer<::mojo_base::mojom::internal::TimeDelta_Data> frame_duration;
  double frame_rate;
  mojo::internal::Pointer<::mojo_base::mojom::internal::TimeTicks_Data> reference_time;
  mojo::internal::Pointer<internal::VideoTransformation_Data> transformation;
  mojo::internal::Pointer<::mojo_base::mojom::internal::UnguessableToken_Data> tracking_token;
  double device_scale_factor;
  double page_scale_factor;
  double root_scroll_offset_x;
  double root_scroll_offset_y;
  double top_controls_visible_height;
  mojo::internal::Pointer<::mojo_base::mojom::internal::TimeTicks_Data> decode_begin_time;
  mojo::internal::Pointer<::mojo_base::mojom::internal::TimeTicks_Data> decode_end_time;
  mojo::internal::Pointer<::mojo_base::mojom::internal::TimeDelta_Data> processing_time;
  double rtp_timestamp;
  mojo::internal::Pointer<::mojo_base::mojom::internal::TimeTicks_Data> receive_time;
  mojo::internal::Pointer<::mojo_base::mojom::internal::TimeDelta_Data> wallclock_frame_duration;
  uint64_t frame_sequence_$value;
  uint64_t source_id_$value;

 private:
  friend class mojo::internal::MessageFragment<VideoFrameMetadata_Data>;

  VideoFrameMetadata_Data();
  ~VideoFrameMetadata_Data() = delete;
};
static_assert(sizeof(VideoFrameMetadata_Data) == 208,
              "Bad sizeof(VideoFrameMetadata_Data)");
// Used by VideoFrameMetadata::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct VideoFrameMetadata_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  VideoFrameMetadata_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~VideoFrameMetadata_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::Message& message) override {
    mojo::internal::MessageFragment<VideoFrameMetadata_Data> fragment(message);
    mojo::internal::Serialize<DataView>(user_data_, fragment);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    VideoFrameMetadata_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};
class  VideoFrame_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  int32_t format;
  uint8_t pad0_[4];
  mojo::internal::Pointer<::gfx::mojom::internal::Size_Data> coded_size;
  mojo::internal::Pointer<::gfx::mojom::internal::Rect_Data> visible_rect;
  mojo::internal::Pointer<::gfx::mojom::internal::Size_Data> natural_size;
  mojo::internal::Pointer<::mojo_base::mojom::internal::TimeDelta_Data> timestamp;
  internal::VideoFrameData_Data data;
  mojo::internal::Pointer<internal::VideoFrameMetadata_Data> metadata;
  mojo::internal::Pointer<::gfx::mojom::internal::ColorSpace_Data> color_space;
  mojo::internal::Pointer<::gfx::mojom::internal::HDRMetadata_Data> hdr_metadata;

 private:
  friend class mojo::internal::MessageFragment<VideoFrame_Data>;

  VideoFrame_Data();
  ~VideoFrame_Data() = delete;
};
static_assert(sizeof(VideoFrame_Data) == 88,
              "Bad sizeof(VideoFrame_Data)");
// Used by VideoFrame::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct VideoFrame_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  VideoFrame_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~VideoFrame_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::Message& message) override {
    mojo::internal::MessageFragment<VideoFrame_Data> fragment(message);
    mojo::internal::Serialize<DataView>(user_data_, fragment);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    VideoFrame_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};
class  EosVideoFrameData_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;

 private:
  friend class mojo::internal::MessageFragment<EosVideoFrameData_Data>;

  EosVideoFrameData_Data();
  ~EosVideoFrameData_Data() = delete;
};
static_assert(sizeof(EosVideoFrameData_Data) == 8,
              "Bad sizeof(EosVideoFrameData_Data)");
// Used by EosVideoFrameData::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct EosVideoFrameData_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  EosVideoFrameData_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~EosVideoFrameData_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::Message& message) override {
    mojo::internal::MessageFragment<EosVideoFrameData_Data> fragment(message);
    mojo::internal::Serialize<DataView>(user_data_, fragment);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    EosVideoFrameData_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};
class  SharedMemoryVideoFrameData_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<::mojo_base::mojom::internal::ReadOnlySharedMemoryRegion_Data> frame_data;
  mojo::internal::Pointer<mojo::internal::Array_Data<int32_t>> strides;
  mojo::internal::Pointer<mojo::internal::Array_Data<uint32_t>> offsets;

 private:
  friend class mojo::internal::MessageFragment<SharedMemoryVideoFrameData_Data>;

  SharedMemoryVideoFrameData_Data();
  ~SharedMemoryVideoFrameData_Data() = delete;
};
static_assert(sizeof(SharedMemoryVideoFrameData_Data) == 32,
              "Bad sizeof(SharedMemoryVideoFrameData_Data)");
// Used by SharedMemoryVideoFrameData::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct SharedMemoryVideoFrameData_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  SharedMemoryVideoFrameData_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~SharedMemoryVideoFrameData_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::Message& message) override {
    mojo::internal::MessageFragment<SharedMemoryVideoFrameData_Data> fragment(message);
    mojo::internal::Serialize<DataView>(user_data_, fragment);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    SharedMemoryVideoFrameData_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};
class  GpuMemoryBufferSharedImageVideoFrameData_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<::gfx::mojom::internal::GpuMemoryBufferHandle_Data> gpu_memory_buffer_handle;
  mojo::internal::Pointer<::gpu::mojom::internal::ExportedSharedImage_Data> shared_image;
  mojo::internal::Pointer<::gpu::mojom::internal::SyncToken_Data> sync_token;

 private:
  friend class mojo::internal::MessageFragment<GpuMemoryBufferSharedImageVideoFrameData_Data>;

  GpuMemoryBufferSharedImageVideoFrameData_Data();
  ~GpuMemoryBufferSharedImageVideoFrameData_Data() = delete;
};
static_assert(sizeof(GpuMemoryBufferSharedImageVideoFrameData_Data) == 32,
              "Bad sizeof(GpuMemoryBufferSharedImageVideoFrameData_Data)");
// Used by GpuMemoryBufferSharedImageVideoFrameData::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct GpuMemoryBufferSharedImageVideoFrameData_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  GpuMemoryBufferSharedImageVideoFrameData_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~GpuMemoryBufferSharedImageVideoFrameData_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::Message& message) override {
    mojo::internal::MessageFragment<GpuMemoryBufferSharedImageVideoFrameData_Data> fragment(message);
    mojo::internal::Serialize<DataView>(user_data_, fragment);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    GpuMemoryBufferSharedImageVideoFrameData_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};
class  SharedImageVideoFrameData_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<::gpu::mojom::internal::ExportedSharedImage_Data> shared_image;
  mojo::internal::Pointer<::gpu::mojom::internal::SyncToken_Data> sync_token;
  uint8_t is_mappable_si_enabled : 1;
  uint8_t padfinal_[7];

 private:
  friend class mojo::internal::MessageFragment<SharedImageVideoFrameData_Data>;

  SharedImageVideoFrameData_Data();
  ~SharedImageVideoFrameData_Data() = delete;
};
static_assert(sizeof(SharedImageVideoFrameData_Data) == 32,
              "Bad sizeof(SharedImageVideoFrameData_Data)");
// Used by SharedImageVideoFrameData::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct SharedImageVideoFrameData_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  SharedImageVideoFrameData_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~SharedImageVideoFrameData_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::Message& message) override {
    mojo::internal::MessageFragment<SharedImageVideoFrameData_Data> fragment(message);
    mojo::internal::Serialize<DataView>(user_data_, fragment);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    SharedImageVideoFrameData_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};
class  OpaqueVideoFrameData_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;

 private:
  friend class mojo::internal::MessageFragment<OpaqueVideoFrameData_Data>;

  OpaqueVideoFrameData_Data();
  ~OpaqueVideoFrameData_Data() = delete;
};
static_assert(sizeof(OpaqueVideoFrameData_Data) == 8,
              "Bad sizeof(OpaqueVideoFrameData_Data)");
// Used by OpaqueVideoFrameData::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct OpaqueVideoFrameData_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  OpaqueVideoFrameData_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~OpaqueVideoFrameData_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::Message& message) override {
    mojo::internal::MessageFragment<OpaqueVideoFrameData_Data> fragment(message);
    mojo::internal::Serialize<DataView>(user_data_, fragment);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    OpaqueVideoFrameData_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};
class  ColorPlaneLayout_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  uint64_t stride;
  uint64_t offset;
  uint64_t size;

 private:
  friend class mojo::internal::MessageFragment<ColorPlaneLayout_Data>;

  ColorPlaneLayout_Data();
  ~ColorPlaneLayout_Data() = delete;
};
static_assert(sizeof(ColorPlaneLayout_Data) == 32,
              "Bad sizeof(ColorPlaneLayout_Data)");
// Used by ColorPlaneLayout::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct ColorPlaneLayout_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  ColorPlaneLayout_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~ColorPlaneLayout_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::Message& message) override {
    mojo::internal::MessageFragment<ColorPlaneLayout_Data> fragment(message);
    mojo::internal::Serialize<DataView>(user_data_, fragment);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    ColorPlaneLayout_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};
class  DmabufVideoFrameData_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<mojo::internal::Array_Data<mojo::internal::Pointer<internal::ColorPlaneLayout_Data>>> planes;
  uint8_t is_multi_planar : 1;
  uint8_t pad1_[7];
  uint64_t buffer_addr_align;
  uint64_t modifier;
  mojo::internal::Pointer<mojo::internal::Array_Data<mojo::internal::Handle_Data>> fds;

 private:
  friend class mojo::internal::MessageFragment<DmabufVideoFrameData_Data>;

  DmabufVideoFrameData_Data();
  ~DmabufVideoFrameData_Data() = delete;
};
static_assert(sizeof(DmabufVideoFrameData_Data) == 48,
              "Bad sizeof(DmabufVideoFrameData_Data)");
// Used by DmabufVideoFrameData::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct DmabufVideoFrameData_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  DmabufVideoFrameData_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~DmabufVideoFrameData_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::Message& message) override {
    mojo::internal::MessageFragment<DmabufVideoFrameData_Data> fragment(message);
    mojo::internal::Serialize<DataView>(user_data_, fragment);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    DmabufVideoFrameData_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};
class  PipelineStatistics_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  uint64_t audio_bytes_decoded;
  uint64_t video_bytes_decoded;
  uint32_t video_frames_decoded;
  uint32_t video_frames_dropped;
  int64_t audio_memory_usage;
  int64_t video_memory_usage;

 private:
  friend class mojo::internal::MessageFragment<PipelineStatistics_Data>;

  PipelineStatistics_Data();
  ~PipelineStatistics_Data() = delete;
};
static_assert(sizeof(PipelineStatistics_Data) == 48,
              "Bad sizeof(PipelineStatistics_Data)");
// Used by PipelineStatistics::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct PipelineStatistics_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  PipelineStatistics_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~PipelineStatistics_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::Message& message) override {
    mojo::internal::MessageFragment<PipelineStatistics_Data> fragment(message);
    mojo::internal::Serialize<DataView>(user_data_, fragment);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    PipelineStatistics_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};
class  PredictionFeatures_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  int32_t profile;
  uint8_t use_hw_secure_codecs : 1;
  uint8_t pad1_[3];
  mojo::internal::Pointer<::gfx::mojom::internal::Size_Data> video_size;
  double frames_per_sec;
  mojo::internal::Pointer<mojo::internal::String_Data> key_system;

 private:
  friend class mojo::internal::MessageFragment<PredictionFeatures_Data>;

  PredictionFeatures_Data();
  ~PredictionFeatures_Data() = delete;
};
static_assert(sizeof(PredictionFeatures_Data) == 40,
              "Bad sizeof(PredictionFeatures_Data)");
// Used by PredictionFeatures::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct PredictionFeatures_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  PredictionFeatures_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~PredictionFeatures_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::Message& message) override {
    mojo::internal::MessageFragment<PredictionFeatures_Data> fragment(message);
    mojo::internal::Serialize<DataView>(user_data_, fragment);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    PredictionFeatures_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};
class  PredictionTargets_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  uint32_t frames_decoded;
  uint32_t frames_dropped;
  uint32_t frames_power_efficient;
  uint8_t padfinal_[4];

 private:
  friend class mojo::internal::MessageFragment<PredictionTargets_Data>;

  PredictionTargets_Data();
  ~PredictionTargets_Data() = delete;
};
static_assert(sizeof(PredictionTargets_Data) == 24,
              "Bad sizeof(PredictionTargets_Data)");
// Used by PredictionTargets::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct PredictionTargets_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  PredictionTargets_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~PredictionTargets_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::Message& message) override {
    mojo::internal::MessageFragment<PredictionTargets_Data> fragment(message);
    mojo::internal::Serialize<DataView>(user_data_, fragment);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    PredictionTargets_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};
class  AudioPipelineInfo_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  int32_t decoder_type;
  uint8_t is_platform_decoder : 1;
  uint8_t has_decrypting_demuxer_stream : 1;
  uint8_t pad2_[3];
  int32_t encryption_type;
  uint8_t padfinal_[4];

 private:
  friend class mojo::internal::MessageFragment<AudioPipelineInfo_Data>;

  AudioPipelineInfo_Data();
  ~AudioPipelineInfo_Data() = delete;
};
static_assert(sizeof(AudioPipelineInfo_Data) == 24,
              "Bad sizeof(AudioPipelineInfo_Data)");
// Used by AudioPipelineInfo::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct AudioPipelineInfo_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  AudioPipelineInfo_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~AudioPipelineInfo_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::Message& message) override {
    mojo::internal::MessageFragment<AudioPipelineInfo_Data> fragment(message);
    mojo::internal::Serialize<DataView>(user_data_, fragment);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    AudioPipelineInfo_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};
class  VideoPipelineInfo_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  int32_t decoder_type;
  uint8_t is_platform_decoder : 1;
  uint8_t has_decrypting_demuxer_stream : 1;
  uint8_t pad2_[3];
  int32_t encryption_type;
  uint8_t padfinal_[4];

 private:
  friend class mojo::internal::MessageFragment<VideoPipelineInfo_Data>;

  VideoPipelineInfo_Data();
  ~VideoPipelineInfo_Data() = delete;
};
static_assert(sizeof(VideoPipelineInfo_Data) == 24,
              "Bad sizeof(VideoPipelineInfo_Data)");
// Used by VideoPipelineInfo::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct VideoPipelineInfo_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  VideoPipelineInfo_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~VideoPipelineInfo_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::Message& message) override {
    mojo::internal::MessageFragment<VideoPipelineInfo_Data> fragment(message);
    mojo::internal::Serialize<DataView>(user_data_, fragment);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    VideoPipelineInfo_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};
class  StatusData_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<mojo::internal::String_Data> group;
  uint16_t code;
  uint8_t pad1_[6];
  mojo::internal::Pointer<mojo::internal::String_Data> message;
  mojo::internal::Pointer<::mojo_base::mojom::internal::ListValue_Data> frames;
  mojo::internal::Pointer<internal::StatusData_Data> cause;
  ::mojo_base::mojom::internal::Value_Data data;

 private:
  friend class mojo::internal::MessageFragment<StatusData_Data>;

  StatusData_Data();
  ~StatusData_Data() = delete;
};
static_assert(sizeof(StatusData_Data) == 64,
              "Bad sizeof(StatusData_Data)");
// Used by StatusData::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct StatusData_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  StatusData_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~StatusData_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::Message& message) override {
    mojo::internal::MessageFragment<StatusData_Data> fragment(message);
    mojo::internal::Serialize<DataView>(user_data_, fragment);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    StatusData_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};
class  EncoderStatus_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<internal::StatusData_Data> internal;

 private:
  friend class mojo::internal::MessageFragment<EncoderStatus_Data>;

  EncoderStatus_Data();
  ~EncoderStatus_Data() = delete;
};
static_assert(sizeof(EncoderStatus_Data) == 16,
              "Bad sizeof(EncoderStatus_Data)");
// Used by EncoderStatus::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct EncoderStatus_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  EncoderStatus_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~EncoderStatus_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::Message& message) override {
    mojo::internal::MessageFragment<EncoderStatus_Data> fragment(message);
    mojo::internal::Serialize<DataView>(user_data_, fragment);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    EncoderStatus_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};
class  DecoderStatus_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<internal::StatusData_Data> internal;

 private:
  friend class mojo::internal::MessageFragment<DecoderStatus_Data>;

  DecoderStatus_Data();
  ~DecoderStatus_Data() = delete;
};
static_assert(sizeof(DecoderStatus_Data) == 16,
              "Bad sizeof(DecoderStatus_Data)");
// Used by DecoderStatus::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct DecoderStatus_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  DecoderStatus_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~DecoderStatus_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::Message& message) override {
    mojo::internal::MessageFragment<DecoderStatus_Data> fragment(message);
    mojo::internal::Serialize<DataView>(user_data_, fragment);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    DecoderStatus_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};
class  PipelineStatus_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<internal::StatusData_Data> internal;

 private:
  friend class mojo::internal::MessageFragment<PipelineStatus_Data>;

  PipelineStatus_Data();
  ~PipelineStatus_Data() = delete;
};
static_assert(sizeof(PipelineStatus_Data) == 16,
              "Bad sizeof(PipelineStatus_Data)");
// Used by PipelineStatus::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct PipelineStatus_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  PipelineStatus_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~PipelineStatus_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::Message& message) override {
    mojo::internal::MessageFragment<PipelineStatus_Data> fragment(message);
    mojo::internal::Serialize<DataView>(user_data_, fragment);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    PipelineStatus_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};
class  AutoPipInfo_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  int32_t auto_pip_reason;
  uint8_t has_audio_focus : 1;
  uint8_t is_playing : 1;
  uint8_t was_recently_audible : 1;
  uint8_t has_safe_url : 1;
  uint8_t meets_media_engagement_conditions : 1;
  uint8_t blocked_due_to_content_setting : 1;
  uint8_t padfinal_[3];

 private:
  friend class mojo::internal::MessageFragment<AutoPipInfo_Data>;

  AutoPipInfo_Data();
  ~AutoPipInfo_Data() = delete;
};
static_assert(sizeof(AutoPipInfo_Data) == 16,
              "Bad sizeof(AutoPipInfo_Data)");
// Used by AutoPipInfo::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct AutoPipInfo_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  AutoPipInfo_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~AutoPipInfo_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::Message& message) override {
    mojo::internal::MessageFragment<AutoPipInfo_Data> fragment(message);
    mojo::internal::Serialize<DataView>(user_data_, fragment);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    AutoPipInfo_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};

#pragma pack(pop)

}  // namespace internal

}  // media::mojom

#endif  // MEDIA_MOJO_MOJOM_MEDIA_TYPES_MOJOM_SHARED_INTERNAL_H_