// media/mojo/mojom/renderer_extensions.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "media/mojo/mojom/renderer_extensions.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "media/mojo/mojom/renderer_extensions.mojom-params-data.h"
namespace media {
namespace mojom {

NOINLINE static const char* MediaFoundationRenderingModeToStringHelper(MediaFoundationRenderingMode value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case MediaFoundationRenderingMode::DirectComposition:
      return "DirectComposition";
    case MediaFoundationRenderingMode::FrameServer:
      return "FrameServer";
    default:
      return nullptr;
  }
}

std::string MediaFoundationRenderingModeToString(MediaFoundationRenderingMode value) {
  const char *str = MediaFoundationRenderingModeToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown MediaFoundationRenderingMode value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, MediaFoundationRenderingMode value) {
  return os << MediaFoundationRenderingModeToString(value);
}

namespace internal {


// static
bool FlingingRendererClientExtension_OnRemotePlayStateChange_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const FlingingRendererClientExtension_OnRemotePlayStateChange_Params_Data* object =
      static_cast<const FlingingRendererClientExtension_OnRemotePlayStateChange_Params_Data*>(data);


  if (!::media::mojom::internal::MediaStatusState_Data
        ::Validate(object->state, validation_context))
    return false;

  return true;
}

FlingingRendererClientExtension_OnRemotePlayStateChange_Params_Data::FlingingRendererClientExtension_OnRemotePlayStateChange_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool MediaFoundationRendererNotifier_MediaFoundationRendererCreated_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const MediaFoundationRendererNotifier_MediaFoundationRendererCreated_Params_Data* object =
      static_cast<const MediaFoundationRendererNotifier_MediaFoundationRendererCreated_Params_Data*>(data);

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->observer, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->observer,
                                                 validation_context)) {
    return false;
  }

  return true;
}

MediaFoundationRendererNotifier_MediaFoundationRendererCreated_Params_Data::MediaFoundationRendererNotifier_MediaFoundationRendererCreated_Params_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace media

namespace perfetto {

// static
void TraceFormatTraits<::media::mojom::MediaFoundationRenderingMode>::WriteIntoTrace(
   perfetto::TracedValue context, ::media::mojom::MediaFoundationRenderingMode value) {
  return std::move(context).WriteString(::media::mojom::MediaFoundationRenderingModeToString(value));
}

} // namespace perfetto