// media/mojo/mojom/speech_recognition.mojom-data-view.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef MEDIA_MOJO_MOJOM_SPEECH_RECOGNITION_MOJOM_DATA_VIEW_H_
#define MEDIA_MOJO_MOJOM_SPEECH_RECOGNITION_MOJOM_DATA_VIEW_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "media/mojo/mojom/speech_recognition.mojom-shared-internal.h"
#include "media/mojo/mojom/audio_data.mojom-shared.h"
#include "media/mojo/mojom/speech_recognition_audio_forwarder.mojom-shared.h"
#include "media/mojo/mojom/speech_recognition_recognition_context.mojom-shared.h"
#include "media/mojo/mojom/speech_recognizer.mojom-shared.h"
#include "mojo/public/mojom/base/time.mojom-shared.h"
#include "mojo/public/mojom/base/unguessable_token.mojom-shared.h"
#include "ui/gfx/geometry/mojom/geometry.mojom-shared.h"


namespace media::mojom {
class HypothesisPartsDataView;

class MediaTimestampRangeDataView;

class TimingInformationDataView;

class SpeechRecognitionResultDataView;

class LanguageIdentificationEventDataView;

class SpeechRecognitionOptionsDataView;



}  // media::mojom


namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::media::mojom::HypothesisPartsDataView> {
  using Data = ::media::mojom::internal::HypothesisParts_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::media::mojom::MediaTimestampRangeDataView> {
  using Data = ::media::mojom::internal::MediaTimestampRange_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::media::mojom::TimingInformationDataView> {
  using Data = ::media::mojom::internal::TimingInformation_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::media::mojom::SpeechRecognitionResultDataView> {
  using Data = ::media::mojom::internal::SpeechRecognitionResult_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::media::mojom::LanguageIdentificationEventDataView> {
  using Data = ::media::mojom::internal::LanguageIdentificationEvent_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::media::mojom::SpeechRecognitionOptionsDataView> {
  using Data = ::media::mojom::internal::SpeechRecognitionOptions_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace media::mojom {


enum class ConfidenceLevel : int32_t {
  
  kUnknown = 0,
  
  kNotConfident = 1,
  
  kConfident = 2,
  
  kHighlyConfident = 3,
  kMinValue = 0,
  kMaxValue = 3,
  kDefaultValue = 0
};

 std::ostream& operator<<(std::ostream& os, ConfidenceLevel value);
inline bool IsKnownEnumValue(ConfidenceLevel value) {
  return internal::ConfidenceLevel_Data::IsKnownValue(
      static_cast<int32_t>(value));
}
inline ConfidenceLevel ToKnownEnumValue(ConfidenceLevel value) {
  if (IsKnownEnumValue(value)) {
    return value;
  }
  return ConfidenceLevel::kDefaultValue;
}


enum class AsrSwitchResult : int32_t {
  
  kDefaultNoSwitch = 0,
  
  kSwitchSucceeded = 1,
  
  kSwitchFailed = 2,
  
  kSwitchSkipedNoLp = 3,
  kMinValue = 0,
  kMaxValue = 3,
  kDefaultValue = 0
};

 std::ostream& operator<<(std::ostream& os, AsrSwitchResult value);
inline bool IsKnownEnumValue(AsrSwitchResult value) {
  return internal::AsrSwitchResult_Data::IsKnownValue(
      static_cast<int32_t>(value));
}
inline AsrSwitchResult ToKnownEnumValue(AsrSwitchResult value) {
  if (IsKnownEnumValue(value)) {
    return value;
  }
  return AsrSwitchResult::kDefaultValue;
}


enum class SpeechRecognitionMode : int32_t {
  
  kUnknown = 0,
  
  kIme = 1,
  
  kCaption = 2,
  kMinValue = 0,
  kMaxValue = 2,
  kDefaultValue = 0
};

 std::ostream& operator<<(std::ostream& os, SpeechRecognitionMode value);
inline bool IsKnownEnumValue(SpeechRecognitionMode value) {
  return internal::SpeechRecognitionMode_Data::IsKnownValue(
      static_cast<int32_t>(value));
}
inline SpeechRecognitionMode ToKnownEnumValue(SpeechRecognitionMode value) {
  if (IsKnownEnumValue(value)) {
    return value;
  }
  return SpeechRecognitionMode::kDefaultValue;
}


enum class RecognizerClientType : int32_t {
  
  kUnknown = 0,
  
  kDictation = 1,
  
  kLiveCaption = 2,
  
  kProjector = 3,
  
  kCastModerator = 4,
  
  kSchoolTools = 5,
  kMinValue = 0,
  kMaxValue = 5,
  kDefaultValue = 0
};

 std::ostream& operator<<(std::ostream& os, RecognizerClientType value);
inline bool IsKnownEnumValue(RecognizerClientType value) {
  return internal::RecognizerClientType_Data::IsKnownValue(
      static_cast<int32_t>(value));
}
inline RecognizerClientType ToKnownEnumValue(RecognizerClientType value) {
  if (IsKnownEnumValue(value)) {
    return value;
  }
  return RecognizerClientType::kDefaultValue;
}
// Interface base classes. They are used for type safety check.
class SpeechRecognitionContextInterfaceBase {};

using SpeechRecognitionContextPtrDataView =
    mojo::InterfacePtrDataView<SpeechRecognitionContextInterfaceBase>;
using SpeechRecognitionContextRequestDataView =
    mojo::InterfaceRequestDataView<SpeechRecognitionContextInterfaceBase>;
using SpeechRecognitionContextAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<SpeechRecognitionContextInterfaceBase>;
using SpeechRecognitionContextAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<SpeechRecognitionContextInterfaceBase>;
class SpeechRecognitionRecognizerInterfaceBase {};

using SpeechRecognitionRecognizerPtrDataView =
    mojo::InterfacePtrDataView<SpeechRecognitionRecognizerInterfaceBase>;
using SpeechRecognitionRecognizerRequestDataView =
    mojo::InterfaceRequestDataView<SpeechRecognitionRecognizerInterfaceBase>;
using SpeechRecognitionRecognizerAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<SpeechRecognitionRecognizerInterfaceBase>;
using SpeechRecognitionRecognizerAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<SpeechRecognitionRecognizerInterfaceBase>;
class SpeechRecognitionRecognizerClientInterfaceBase {};

using SpeechRecognitionRecognizerClientPtrDataView =
    mojo::InterfacePtrDataView<SpeechRecognitionRecognizerClientInterfaceBase>;
using SpeechRecognitionRecognizerClientRequestDataView =
    mojo::InterfaceRequestDataView<SpeechRecognitionRecognizerClientInterfaceBase>;
using SpeechRecognitionRecognizerClientAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<SpeechRecognitionRecognizerClientInterfaceBase>;
using SpeechRecognitionRecognizerClientAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<SpeechRecognitionRecognizerClientInterfaceBase>;
class SpeechRecognitionBrowserObserverInterfaceBase {};

using SpeechRecognitionBrowserObserverPtrDataView =
    mojo::InterfacePtrDataView<SpeechRecognitionBrowserObserverInterfaceBase>;
using SpeechRecognitionBrowserObserverRequestDataView =
    mojo::InterfaceRequestDataView<SpeechRecognitionBrowserObserverInterfaceBase>;
using SpeechRecognitionBrowserObserverAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<SpeechRecognitionBrowserObserverInterfaceBase>;
using SpeechRecognitionBrowserObserverAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<SpeechRecognitionBrowserObserverInterfaceBase>;
class SpeechRecognitionSurfaceInterfaceBase {};

using SpeechRecognitionSurfacePtrDataView =
    mojo::InterfacePtrDataView<SpeechRecognitionSurfaceInterfaceBase>;
using SpeechRecognitionSurfaceRequestDataView =
    mojo::InterfaceRequestDataView<SpeechRecognitionSurfaceInterfaceBase>;
using SpeechRecognitionSurfaceAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<SpeechRecognitionSurfaceInterfaceBase>;
using SpeechRecognitionSurfaceAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<SpeechRecognitionSurfaceInterfaceBase>;
class SpeechRecognitionSurfaceClientInterfaceBase {};

using SpeechRecognitionSurfaceClientPtrDataView =
    mojo::InterfacePtrDataView<SpeechRecognitionSurfaceClientInterfaceBase>;
using SpeechRecognitionSurfaceClientRequestDataView =
    mojo::InterfaceRequestDataView<SpeechRecognitionSurfaceClientInterfaceBase>;
using SpeechRecognitionSurfaceClientAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<SpeechRecognitionSurfaceClientInterfaceBase>;
using SpeechRecognitionSurfaceClientAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<SpeechRecognitionSurfaceClientInterfaceBase>;
class SpeechRecognitionClientBrowserInterfaceInterfaceBase {};

using SpeechRecognitionClientBrowserInterfacePtrDataView =
    mojo::InterfacePtrDataView<SpeechRecognitionClientBrowserInterfaceInterfaceBase>;
using SpeechRecognitionClientBrowserInterfaceRequestDataView =
    mojo::InterfaceRequestDataView<SpeechRecognitionClientBrowserInterfaceInterfaceBase>;
using SpeechRecognitionClientBrowserInterfaceAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<SpeechRecognitionClientBrowserInterfaceInterfaceBase>;
using SpeechRecognitionClientBrowserInterfaceAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<SpeechRecognitionClientBrowserInterfaceInterfaceBase>;


class HypothesisPartsDataView {
 public:
  HypothesisPartsDataView() = default;

  HypothesisPartsDataView(
      internal::HypothesisParts_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetTextDataView(
      mojo::ArrayDataView<mojo::StringDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadText(UserType* output) {
    
    auto* pointer = data_->text.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<mojo::StringDataView>>(
        pointer, output, message_);
  }
  inline void GetHypothesisPartOffsetDataView(
      ::mojo_base::mojom::TimeDeltaDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadHypothesisPartOffset(UserType* output) {
    
    auto* pointer = data_->hypothesis_part_offset.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeDeltaDataView>(
        pointer, output, message_);
  }
 private:
  internal::HypothesisParts_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class MediaTimestampRangeDataView {
 public:
  MediaTimestampRangeDataView() = default;

  MediaTimestampRangeDataView(
      internal::MediaTimestampRange_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetStartDataView(
      ::mojo_base::mojom::TimeDeltaDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadStart(UserType* output) {
    
    auto* pointer = data_->start.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeDeltaDataView>(
        pointer, output, message_);
  }
  inline void GetEndDataView(
      ::mojo_base::mojom::TimeDeltaDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadEnd(UserType* output) {
    
    auto* pointer = data_->end.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeDeltaDataView>(
        pointer, output, message_);
  }
 private:
  internal::MediaTimestampRange_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class TimingInformationDataView {
 public:
  TimingInformationDataView() = default;

  TimingInformationDataView(
      internal::TimingInformation_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetAudioStartTimeDataView(
      ::mojo_base::mojom::TimeDeltaDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadAudioStartTime(UserType* output) {
    
    auto* pointer = data_->audio_start_time.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeDeltaDataView>(
        pointer, output, message_);
  }
  inline void GetAudioEndTimeDataView(
      ::mojo_base::mojom::TimeDeltaDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadAudioEndTime(UserType* output) {
    
    auto* pointer = data_->audio_end_time.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeDeltaDataView>(
        pointer, output, message_);
  }
  inline void GetHypothesisPartsDataView(
      mojo::ArrayDataView<HypothesisPartsDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadHypothesisParts(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::ArrayDataView<::media::mojom::HypothesisPartsDataView>, UserType>(),
    "Attempting to read the optional `hypothesis_parts` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadHypothesisParts` instead "
    "of `ReadHypothesisParts if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->hypothesis_parts.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::media::mojom::HypothesisPartsDataView>>(
        pointer, output, message_);
  }
  inline void GetOriginatingMediaTimestampsDataView(
      mojo::ArrayDataView<MediaTimestampRangeDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadOriginatingMediaTimestamps(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::ArrayDataView<::media::mojom::MediaTimestampRangeDataView>, UserType>(),
    "Attempting to read the optional `originating_media_timestamps` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadOriginatingMediaTimestamps` instead "
    "of `ReadOriginatingMediaTimestamps if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->header_.version >= 11
                    ? data_->originating_media_timestamps.Get() : nullptr;
    return mojo::internal::Deserialize<mojo::ArrayDataView<::media::mojom::MediaTimestampRangeDataView>>(
        pointer, output, message_);
  }
 private:
  internal::TimingInformation_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class SpeechRecognitionResultDataView {
 public:
  SpeechRecognitionResultDataView() = default;

  SpeechRecognitionResultDataView(
      internal::SpeechRecognitionResult_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetTranscriptionDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTranscription(UserType* output) {
    
    auto* pointer = data_->transcription.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  bool is_final() const {
    return data_->is_final;
  }
  inline void GetTimingInformationDataView(
      TimingInformationDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTimingInformation(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::media::mojom::TimingInformationDataView, UserType>(),
    "Attempting to read the optional `timing_information` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadTimingInformation` instead "
    "of `ReadTimingInformation if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->timing_information.Get();
    return mojo::internal::Deserialize<::media::mojom::TimingInformationDataView>(
        pointer, output, message_);
  }
 private:
  internal::SpeechRecognitionResult_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class LanguageIdentificationEventDataView {
 public:
  LanguageIdentificationEventDataView() = default;

  LanguageIdentificationEventDataView(
      internal::LanguageIdentificationEvent_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetLanguageDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadLanguage(UserType* output) {
    
    auto* pointer = data_->language.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  template <typename UserType>
  [[nodiscard]] bool ReadConfidenceLevel(UserType* output) const {
    auto data_value = data_->confidence_level;
    return mojo::internal::Deserialize<::media::mojom::ConfidenceLevel>(
        data_value, output);
  }
  ConfidenceLevel confidence_level() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::media::mojom::ConfidenceLevel>(data_->confidence_level));
  }
  template <typename UserType>
  [[nodiscard]] bool ReadAsrSwitchResult(UserType* output) const {
    if (data_->header_.version < 1) {
      *output = std::nullopt;
      return true;
    }
    if (!data_->asr_switch_result_$flag) {
      *output = std::nullopt;
      return true;
    }

    return mojo::internal::Deserialize<::media::mojom::AsrSwitchResult>(
        data_->asr_switch_result_$value, &output->emplace());
  }
  std::optional<AsrSwitchResult> asr_switch_result() const {
    if (data_->header_.version < 1) {
      return std::nullopt;
    }
    if (!data_->asr_switch_result_$flag) {
      return std::nullopt;
    }
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::media::mojom::AsrSwitchResult>(data_->asr_switch_result_$value));
  }
 private:
  internal::LanguageIdentificationEvent_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class SpeechRecognitionOptionsDataView {
 public:
  SpeechRecognitionOptionsDataView() = default;

  SpeechRecognitionOptionsDataView(
      internal::SpeechRecognitionOptions_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  [[nodiscard]] bool ReadRecognitionMode(UserType* output) const {
    auto data_value = data_->recognition_mode;
    return mojo::internal::Deserialize<::media::mojom::SpeechRecognitionMode>(
        data_value, output);
  }
  SpeechRecognitionMode recognition_mode() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::media::mojom::SpeechRecognitionMode>(data_->recognition_mode));
  }
  bool enable_formatting() const {
    return data_->enable_formatting;
  }
  inline void GetLanguageDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadLanguage(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::StringDataView, UserType>(),
    "Attempting to read the optional `language` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadLanguage` instead "
    "of `ReadLanguage if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->language.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  bool is_server_based() const {
    if (data_->header_.version < 1)
      return bool{};
    return data_->is_server_based;
  }
  template <typename UserType>
  [[nodiscard]] bool ReadRecognizerClientType(UserType* output) const {
    auto data_value = data_->header_.version >= 1
                      ? data_->recognizer_client_type : 0;
    return mojo::internal::Deserialize<::media::mojom::RecognizerClientType>(
        data_value, output);
  }
  RecognizerClientType recognizer_client_type() const {
    if (data_->header_.version < 1)
      return RecognizerClientType{};
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::media::mojom::RecognizerClientType>(data_->recognizer_client_type));
  }
  bool skip_continuously_empty_audio() const {
    if (data_->header_.version < 4)
      return bool{};
    return data_->skip_continuously_empty_audio;
  }
  inline void GetExperimentRecognizerRoutingKeyDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadExperimentRecognizerRoutingKey(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::StringDataView, UserType>(),
    "Attempting to read the optional `experiment_recognizer_routing_key` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadExperimentRecognizerRoutingKey` instead "
    "of `ReadExperimentRecognizerRoutingKey if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->header_.version >= 5
                    ? data_->experiment_recognizer_routing_key.Get() : nullptr;
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  int32_t channel_count() const {
    if (data_->header_.version < 6)
      return int32_t{};
    return data_->channel_count;
  }
  int32_t sample_rate() const {
    if (data_->header_.version < 6)
      return int32_t{};
    return data_->sample_rate;
  }
  inline void GetRecognitionContextDataView(
      ::media::mojom::SpeechRecognitionRecognitionContextDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadRecognitionContext(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::media::mojom::SpeechRecognitionRecognitionContextDataView, UserType>(),
    "Attempting to read the optional `recognition_context` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadRecognitionContext` instead "
    "of `ReadRecognitionContext if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->header_.version >= 8
                    ? data_->recognition_context.Get() : nullptr;
    return mojo::internal::Deserialize<::media::mojom::SpeechRecognitionRecognitionContextDataView>(
        pointer, output, message_);
  }
 private:
  internal::SpeechRecognitionOptions_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


}  // media::mojom

#endif  // MEDIA_MOJO_MOJOM_SPEECH_RECOGNITION_MOJOM_DATA_VIEW_H_