// media/mojo/mojom/video_decoder.mojom-blink.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef MEDIA_MOJO_MOJOM_VIDEO_DECODER_MOJOM_BLINK_H_
#define MEDIA_MOJO_MOJOM_VIDEO_DECODER_MOJOM_BLINK_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "media/mojo/mojom/video_decoder.mojom-features.h"  // IWYU pragma: export
#include "media/mojo/mojom/video_decoder.mojom-shared.h"  // IWYU pragma: export
#include "media/mojo/mojom/video_decoder.mojom-blink-forward.h"  // IWYU pragma: export
#include "gpu/ipc/common/sync_token.mojom-blink.h"
#include "media/mojo/mojom/media_log.mojom-blink-forward.h"
#include "media/mojo/mojom/media_types.mojom-blink.h"
#include "mojo/public/mojom/base/unguessable_token.mojom-blink.h"
#include "ui/gfx/geometry/mojom/geometry.mojom-blink.h"
#include "ui/gfx/mojom/color_space.mojom-blink.h"
#include "media/mojo/mojom/cdm_context_for_oopvd.mojom-blink-forward.h"

#include "mojo/public/cpp/bindings/lib/wtf_clone_equals_util.h"
#include "mojo/public/cpp/bindings/lib/wtf_hash_util.h"
#include "third_party/blink/renderer/platform/wtf/hash_functions.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/lib/message_size_estimator.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"


#include "mojo/public/cpp/bindings/lib/native_enum_serialization.h"
#include "mojo/public/cpp/bindings/lib/native_struct_serialization.h"
#include "third_party/blink/public/platform/web_common.h"
#if !BLINK_MOJO_IMPL && !INSIDE_BLINK
#error "File must only be imported inside blink"
#endif




namespace media::mojom::blink {

class VideoFrameHandleReleaserProxy;

template <typename ImplRefTraits>
class VideoFrameHandleReleaserStub;

class VideoFrameHandleReleaserRequestValidator;


class BLINK_PLATFORM_EXPORT VideoFrameHandleReleaser
    : public VideoFrameHandleReleaserInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "media.mojom.VideoFrameHandleReleaser";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = VideoFrameHandleReleaserInterfaceBase;
  using Proxy_ = VideoFrameHandleReleaserProxy;

  template <typename ImplRefTraits>
  using Stub_ = VideoFrameHandleReleaserStub<ImplRefTraits>;

  using RequestValidator_ = VideoFrameHandleReleaserRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kReleaseVideoFrameMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct ReleaseVideoFrame_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~VideoFrameHandleReleaser() = default;

  virtual void ReleaseVideoFrame(const ::base::UnguessableToken& release_token, const std::optional<::gpu::SyncToken>& release_sync_token) = 0;
};

class VideoDecoderProxy;

template <typename ImplRefTraits>
class VideoDecoderStub;

class VideoDecoderRequestValidator;
class VideoDecoderResponseValidator;


class BLINK_PLATFORM_EXPORT VideoDecoder
    : public VideoDecoderInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "media.mojom.VideoDecoder";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = true;
  static inline constexpr uint32_t kSyncMethodOrdinals[] = {
    1936461098
  };
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = VideoDecoderInterfaceBase;
  using Proxy_ = VideoDecoderProxy;

  template <typename ImplRefTraits>
  using Stub_ = VideoDecoderStub<ImplRefTraits>;

  using RequestValidator_ = VideoDecoderRequestValidator;
  using ResponseValidator_ = VideoDecoderResponseValidator;
  enum MethodMinVersions : uint32_t {
    kGetSupportedConfigsMinVersion = 0,
    kConstructMinVersion = 0,
    kInitializeMinVersion = 0,
    kDecodeMinVersion = 0,
    kResetMinVersion = 0,
    kOnOverlayInfoChangedMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct GetSupportedConfigs_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct Construct_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct Initialize_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct Decode_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct Reset_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnOverlayInfoChanged_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~VideoDecoder() = default;

  // Sync method. This signature is used by the client side; the service side
  // should implement the signature with callback below.
  
  virtual bool GetSupportedConfigs(::blink::Vector<SupportedVideoDecoderConfigPtr>* out_supported_configs, ::media::VideoDecoderType* out_decoder_type);
  using GetSupportedConfigsCallback = base::OnceCallback<void(::blink::Vector<SupportedVideoDecoderConfigPtr>, ::media::VideoDecoderType)>;
  using GetSupportedConfigsMojoCallback = base::OnceCallback<void(::blink::Vector<SupportedVideoDecoderConfigPtr>, ::media::VideoDecoderType)>;

  virtual void GetSupportedConfigs(GetSupportedConfigsCallback callback) = 0;

  virtual void Construct(::mojo::PendingAssociatedRemote<VideoDecoderClient> client, ::mojo::PendingRemote<::media::mojom::blink::MediaLog> media_log, ::mojo::PendingReceiver<VideoFrameHandleReleaser> video_frame_handle_releaser, ::mojo::ScopedDataPipeConsumerHandle decoder_buffer_pipe, CommandBufferIdPtr command_buffer_id, const ::gfx::ColorSpace& target_color_space) = 0;

  using InitializeCallback = base::OnceCallback<void(::media::mojom::blink::DecoderStatusPtr, bool, int32_t, ::media::VideoDecoderType, bool)>;
  using InitializeMojoCallback = base::OnceCallback<void(::media::mojom::blink::DecoderStatusPtr, bool, int32_t, ::media::VideoDecoderType, bool)>;

  virtual void Initialize(::media::mojom::blink::VideoDecoderConfigPtr config, bool low_delay, CdmPtr cdm, InitializeCallback callback) = 0;

  using DecodeCallback = base::OnceCallback<void(::media::mojom::blink::DecoderStatusPtr)>;
  using DecodeMojoCallback = base::OnceCallback<void(::media::mojom::blink::DecoderStatusPtr)>;

  virtual void Decode(::media::mojom::blink::DecoderBufferPtr buffer, DecodeCallback callback) = 0;

  using ResetCallback = base::OnceCallback<void()>;
  using ResetMojoCallback = base::OnceCallback<void()>;

  virtual void Reset(ResetCallback callback) = 0;

  virtual void OnOverlayInfoChanged(OverlayInfoPtr overlay_info) = 0;
};

class VideoDecoderClientProxy;

template <typename ImplRefTraits>
class VideoDecoderClientStub;

class VideoDecoderClientRequestValidator;


class BLINK_PLATFORM_EXPORT VideoDecoderClient
    : public VideoDecoderClientInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "media.mojom.VideoDecoderClient";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = VideoDecoderClientInterfaceBase;
  using Proxy_ = VideoDecoderClientProxy;

  template <typename ImplRefTraits>
  using Stub_ = VideoDecoderClientStub<ImplRefTraits>;

  using RequestValidator_ = VideoDecoderClientRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kOnVideoFrameDecodedMinVersion = 0,
    kOnWaitingMinVersion = 0,
    kRequestOverlayInfoMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct OnVideoFrameDecoded_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnWaiting_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct RequestOverlayInfo_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~VideoDecoderClient() = default;

  virtual void OnVideoFrameDecoded(::media::mojom::blink::VideoFramePtr frame, bool can_read_without_stalling, const std::optional<::base::UnguessableToken>& release_token) = 0;

  virtual void OnWaiting(::media::mojom::blink::WaitingReason reason) = 0;

  virtual void RequestOverlayInfo(bool restart_for_transitions) = 0;
};



class BLINK_PLATFORM_EXPORT VideoFrameHandleReleaserProxy
    : public VideoFrameHandleReleaser {
 public:
  using InterfaceType = VideoFrameHandleReleaser;

  explicit VideoFrameHandleReleaserProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void ReleaseVideoFrame(const ::base::UnguessableToken& release_token, const std::optional<::gpu::SyncToken>& release_sync_token) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class BLINK_PLATFORM_EXPORT VideoDecoderProxy
    : public VideoDecoder {
 public:
  using InterfaceType = VideoDecoder;

  explicit VideoDecoderProxy(mojo::MessageReceiverWithResponder* receiver);
  
  bool GetSupportedConfigs(::blink::Vector<SupportedVideoDecoderConfigPtr>* out_supported_configs, ::media::VideoDecoderType* out_decoder_type) final;
  
  void GetSupportedConfigs(GetSupportedConfigsCallback callback) final;
  
  void Construct(::mojo::PendingAssociatedRemote<VideoDecoderClient> client, ::mojo::PendingRemote<::media::mojom::blink::MediaLog> media_log, ::mojo::PendingReceiver<VideoFrameHandleReleaser> video_frame_handle_releaser, ::mojo::ScopedDataPipeConsumerHandle decoder_buffer_pipe, CommandBufferIdPtr command_buffer_id, const ::gfx::ColorSpace& target_color_space) final;
  
  void Initialize(::media::mojom::blink::VideoDecoderConfigPtr config, bool low_delay, CdmPtr cdm, InitializeCallback callback) final;
  
  void Decode(::media::mojom::blink::DecoderBufferPtr buffer, DecodeCallback callback) final;
  
  void Reset(ResetCallback callback) final;
  
  void OnOverlayInfoChanged(OverlayInfoPtr overlay_info) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class BLINK_PLATFORM_EXPORT VideoDecoderClientProxy
    : public VideoDecoderClient {
 public:
  using InterfaceType = VideoDecoderClient;

  explicit VideoDecoderClientProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void OnVideoFrameDecoded(::media::mojom::blink::VideoFramePtr frame, bool can_read_without_stalling, const std::optional<::base::UnguessableToken>& release_token) final;
  
  void OnWaiting(::media::mojom::blink::WaitingReason reason) final;
  
  void RequestOverlayInfo(bool restart_for_transitions) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class BLINK_PLATFORM_EXPORT VideoFrameHandleReleaserStubDispatch {
 public:
  static bool Accept(VideoFrameHandleReleaser* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      VideoFrameHandleReleaser* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<VideoFrameHandleReleaser>>
class VideoFrameHandleReleaserStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  VideoFrameHandleReleaserStub() = default;
  ~VideoFrameHandleReleaserStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return VideoFrameHandleReleaserStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return VideoFrameHandleReleaserStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class BLINK_PLATFORM_EXPORT VideoDecoderStubDispatch {
 public:
  static bool Accept(VideoDecoder* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      VideoDecoder* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<VideoDecoder>>
class VideoDecoderStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  VideoDecoderStub() = default;
  ~VideoDecoderStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return VideoDecoderStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return VideoDecoderStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class BLINK_PLATFORM_EXPORT VideoDecoderClientStubDispatch {
 public:
  static bool Accept(VideoDecoderClient* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      VideoDecoderClient* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<VideoDecoderClient>>
class VideoDecoderClientStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  VideoDecoderClientStub() = default;
  ~VideoDecoderClientStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return VideoDecoderClientStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return VideoDecoderClientStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class BLINK_PLATFORM_EXPORT VideoFrameHandleReleaserRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class BLINK_PLATFORM_EXPORT VideoDecoderRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class BLINK_PLATFORM_EXPORT VideoDecoderClientRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class BLINK_PLATFORM_EXPORT VideoDecoderResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};








class BLINK_PLATFORM_EXPORT Cdm {
 public:
  using DataView = CdmDataView;
  using Data_ = internal::Cdm_Data;
  using Tag = Data_::Cdm_Tag;

  template <typename... Args>
  static CdmPtr New(Args&&... args) {
    static_assert(
        sizeof...(args) < 0,
        "Do not use Union::New(); to create a union of a given subtype, use "
        "New<SubType>(), not New() followed by set_<sub_type>(). To represent "
        "an empty union, mark the field or parameter as nullable in the mojom "
        "definition.");
    return nullptr;
  }

  // Construct an instance holding |cdm_id|.
  static CdmPtr NewCdmId(
      const ::base::UnguessableToken& value);
  // Construct an instance holding |cdm_context|.
  static CdmPtr NewCdmContext(
      ::mojo::PendingRemote<::media::mojom::blink::CdmContextForOOPVD> value);

  template <typename U>
  static CdmPtr From(const U& u) {
    return mojo::TypeConverter<CdmPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, Cdm>::Convert(*this);
  }
  ~Cdm();

  // Delete the copy constructor and copy assignment operators because `data_`
  // contains raw pointers that must not be copied.
  Cdm(const Cdm& other) = delete;
  Cdm& operator=(const Cdm& other) = delete;

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename UnionPtrType = CdmPtr>
  CdmPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T,
            typename std::enable_if<std::is_same<
                T, Cdm>::value>::type* = nullptr>
  bool Equals(const T& other) const;

  template <typename T,
            typename std::enable_if<std::is_same<
                T, Cdm>::value>::type* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  Tag which() const {
    return tag_;
  }

  bool is_cdm_id() const { return tag_ == Tag::kCdmId; }
  const ::base::UnguessableToken& get_cdm_id() const {
    CHECK(tag_ == Tag::kCdmId);
    return data_.cdm_id;
  }
  ::base::UnguessableToken& get_cdm_id() {
    CHECK(tag_ == Tag::kCdmId);
    return data_.cdm_id;
  }
  void set_cdm_id(const ::base::UnguessableToken& cdm_id);

  bool is_cdm_context() const { return tag_ == Tag::kCdmContext; }
  const ::mojo::PendingRemote<::media::mojom::blink::CdmContextForOOPVD>& get_cdm_context() const {
    CHECK(tag_ == Tag::kCdmContext);
    return data_.cdm_context;
  }
  ::mojo::PendingRemote<::media::mojom::blink::CdmContextForOOPVD>& get_cdm_context() {
    CHECK(tag_ == Tag::kCdmContext);
    return data_.cdm_context;
  }
  void set_cdm_context(::mojo::PendingRemote<::media::mojom::blink::CdmContextForOOPVD> cdm_context);

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        Cdm::DataView>(input);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    return mojo::internal::DeserializeImpl<Cdm::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

 private:
  template <typename T>
  friend class ::mojo::InlinedStructPtr;
  template <typename T>
  friend class ::mojo::StructPtr;

  union Union_ {
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kCdmId)>,
        const ::base::UnguessableToken& value);
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kCdmContext)>,
        ::mojo::PendingRemote<::media::mojom::blink::CdmContextForOOPVD> value);
    // The contents of the union are explicitly destroyed by `DestroyActive()`.
    ~Union_() {}

    ::base::UnguessableToken cdm_id;
    ::mojo::PendingRemote<::media::mojom::blink::CdmContextForOOPVD> cdm_context;
  };

  Cdm(
      std::in_place_index_t<static_cast<size_t>(Tag::kCdmId)>,
      const ::base::UnguessableToken& value);
  Cdm(
      std::in_place_index_t<static_cast<size_t>(Tag::kCdmContext)>,
      ::mojo::PendingRemote<::media::mojom::blink::CdmContextForOOPVD> value);

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  void DestroyActive();
  Tag tag_;
  Union_ data_;
};





class BLINK_PLATFORM_EXPORT SupportedVideoDecoderConfig {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<SupportedVideoDecoderConfig, T>::value>;
  using DataView = SupportedVideoDecoderConfigDataView;
  using Data_ = internal::SupportedVideoDecoderConfig_Data;

  template <typename... Args>
  static SupportedVideoDecoderConfigPtr New(Args&&... args) {
    return SupportedVideoDecoderConfigPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static SupportedVideoDecoderConfigPtr From(const U& u) {
    return mojo::TypeConverter<SupportedVideoDecoderConfigPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, SupportedVideoDecoderConfig>::Convert(*this);
  }


  SupportedVideoDecoderConfig();

  SupportedVideoDecoderConfig(
      ::media::VideoCodecProfile profile_min,
      ::media::VideoCodecProfile profile_max,
      const ::gfx::Size& coded_size_min,
      const ::gfx::Size& coded_size_max,
      bool allow_encrypted,
      bool require_encrypted);


  ~SupportedVideoDecoderConfig();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = SupportedVideoDecoderConfigPtr>
  SupportedVideoDecoderConfigPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, SupportedVideoDecoderConfig::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, SupportedVideoDecoderConfig::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, SupportedVideoDecoderConfig::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        SupportedVideoDecoderConfig::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        SupportedVideoDecoderConfig::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        SupportedVideoDecoderConfig::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::SupportedVideoDecoderConfig_UnserializedMessageContext<
            UserType, SupportedVideoDecoderConfig::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<SupportedVideoDecoderConfig::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return SupportedVideoDecoderConfig::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::SupportedVideoDecoderConfig_UnserializedMessageContext<
            UserType, SupportedVideoDecoderConfig::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<SupportedVideoDecoderConfig::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::media::VideoCodecProfile profile_min;
  
  ::media::VideoCodecProfile profile_max;
  
  ::gfx::Size coded_size_min;
  
  ::gfx::Size coded_size_max;
  
  bool allow_encrypted;
  
  bool require_encrypted;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, SupportedVideoDecoderConfig::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, SupportedVideoDecoderConfig::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, SupportedVideoDecoderConfig::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, SupportedVideoDecoderConfig::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class BLINK_PLATFORM_EXPORT CommandBufferId {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<CommandBufferId, T>::value>;
  using DataView = CommandBufferIdDataView;
  using Data_ = internal::CommandBufferId_Data;

  template <typename... Args>
  static CommandBufferIdPtr New(Args&&... args) {
    return CommandBufferIdPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static CommandBufferIdPtr From(const U& u) {
    return mojo::TypeConverter<CommandBufferIdPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, CommandBufferId>::Convert(*this);
  }


  CommandBufferId();

  CommandBufferId(
      const ::base::UnguessableToken& channel_token,
      int32_t route_id);


  ~CommandBufferId();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = CommandBufferIdPtr>
  CommandBufferIdPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, CommandBufferId::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, CommandBufferId::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, CommandBufferId::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        CommandBufferId::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        CommandBufferId::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        CommandBufferId::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::CommandBufferId_UnserializedMessageContext<
            UserType, CommandBufferId::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<CommandBufferId::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return CommandBufferId::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::CommandBufferId_UnserializedMessageContext<
            UserType, CommandBufferId::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<CommandBufferId::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::base::UnguessableToken channel_token;
  
  int32_t route_id;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, CommandBufferId::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, CommandBufferId::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, CommandBufferId::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, CommandBufferId::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}


template <typename UnionPtrType>
CdmPtr Cdm::Clone() const {
  switch (tag_) {
    case Tag::kCdmId:
      return NewCdmId(
          mojo::Clone(data_.cdm_id));
    case Tag::kCdmContext:
      return NewCdmContext(
          mojo::Clone(data_.cdm_context));
  }
  return nullptr;
}

template <typename T,
          typename std::enable_if<std::is_same<
              T, Cdm>::value>::type*>
bool Cdm::Equals(const T& other) const {
  if (tag_ != other.which())
    return false;

  switch (tag_) {
    case Tag::kCdmId:
      return mojo::Equals(data_.cdm_id, other.data_.cdm_id);
    case Tag::kCdmContext:
      return mojo::Equals(data_.cdm_context, other.data_.cdm_context);
  }

  return false;
}
template <typename StructPtrType>
SupportedVideoDecoderConfigPtr SupportedVideoDecoderConfig::Clone() const {
  return New(
      mojo::Clone(profile_min),
      mojo::Clone(profile_max),
      mojo::Clone(coded_size_min),
      mojo::Clone(coded_size_max),
      mojo::Clone(allow_encrypted),
      mojo::Clone(require_encrypted)
  );
}

template <typename T, SupportedVideoDecoderConfig::EnableIfSame<T>*>
bool SupportedVideoDecoderConfig::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->profile_min, other_struct.profile_min))
    return false;
  if (!mojo::Equals(this->profile_max, other_struct.profile_max))
    return false;
  if (!mojo::Equals(this->coded_size_min, other_struct.coded_size_min))
    return false;
  if (!mojo::Equals(this->coded_size_max, other_struct.coded_size_max))
    return false;
  if (!mojo::Equals(this->allow_encrypted, other_struct.allow_encrypted))
    return false;
  if (!mojo::Equals(this->require_encrypted, other_struct.require_encrypted))
    return false;
  return true;
}

template <typename T, SupportedVideoDecoderConfig::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.profile_min < rhs.profile_min)
    return true;
  if (rhs.profile_min < lhs.profile_min)
    return false;
  if (lhs.profile_max < rhs.profile_max)
    return true;
  if (rhs.profile_max < lhs.profile_max)
    return false;
  if (lhs.coded_size_min < rhs.coded_size_min)
    return true;
  if (rhs.coded_size_min < lhs.coded_size_min)
    return false;
  if (lhs.coded_size_max < rhs.coded_size_max)
    return true;
  if (rhs.coded_size_max < lhs.coded_size_max)
    return false;
  if (lhs.allow_encrypted < rhs.allow_encrypted)
    return true;
  if (rhs.allow_encrypted < lhs.allow_encrypted)
    return false;
  if (lhs.require_encrypted < rhs.require_encrypted)
    return true;
  if (rhs.require_encrypted < lhs.require_encrypted)
    return false;
  return false;
}
template <typename StructPtrType>
CommandBufferIdPtr CommandBufferId::Clone() const {
  return New(
      mojo::Clone(channel_token),
      mojo::Clone(route_id)
  );
}

template <typename T, CommandBufferId::EnableIfSame<T>*>
bool CommandBufferId::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->channel_token, other_struct.channel_token))
    return false;
  if (!mojo::Equals(this->route_id, other_struct.route_id))
    return false;
  return true;
}

template <typename T, CommandBufferId::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.channel_token < rhs.channel_token)
    return true;
  if (rhs.channel_token < lhs.channel_token)
    return false;
  if (lhs.route_id < rhs.route_id)
    return true;
  if (rhs.route_id < lhs.route_id)
    return false;
  return false;
}


}  // media::mojom::blink

namespace mojo {


template <>
struct BLINK_PLATFORM_EXPORT StructTraits<::media::mojom::blink::SupportedVideoDecoderConfig::DataView,
                                         ::media::mojom::blink::SupportedVideoDecoderConfigPtr> {
  static bool IsNull(const ::media::mojom::blink::SupportedVideoDecoderConfigPtr& input) { return !input; }
  static void SetToNull(::media::mojom::blink::SupportedVideoDecoderConfigPtr* output) { output->reset(); }

  static decltype(::media::mojom::blink::SupportedVideoDecoderConfig::profile_min) profile_min(
      const ::media::mojom::blink::SupportedVideoDecoderConfigPtr& input) {
    return input->profile_min;
  }

  static decltype(::media::mojom::blink::SupportedVideoDecoderConfig::profile_max) profile_max(
      const ::media::mojom::blink::SupportedVideoDecoderConfigPtr& input) {
    return input->profile_max;
  }

  static const decltype(::media::mojom::blink::SupportedVideoDecoderConfig::coded_size_min)& coded_size_min(
      const ::media::mojom::blink::SupportedVideoDecoderConfigPtr& input) {
    return input->coded_size_min;
  }

  static const decltype(::media::mojom::blink::SupportedVideoDecoderConfig::coded_size_max)& coded_size_max(
      const ::media::mojom::blink::SupportedVideoDecoderConfigPtr& input) {
    return input->coded_size_max;
  }

  static decltype(::media::mojom::blink::SupportedVideoDecoderConfig::allow_encrypted) allow_encrypted(
      const ::media::mojom::blink::SupportedVideoDecoderConfigPtr& input) {
    return input->allow_encrypted;
  }

  static decltype(::media::mojom::blink::SupportedVideoDecoderConfig::require_encrypted) require_encrypted(
      const ::media::mojom::blink::SupportedVideoDecoderConfigPtr& input) {
    return input->require_encrypted;
  }

  static bool Read(::media::mojom::blink::SupportedVideoDecoderConfig::DataView input, ::media::mojom::blink::SupportedVideoDecoderConfigPtr* output);
};


template <>
struct BLINK_PLATFORM_EXPORT StructTraits<::media::mojom::blink::CommandBufferId::DataView,
                                         ::media::mojom::blink::CommandBufferIdPtr> {
  static bool IsNull(const ::media::mojom::blink::CommandBufferIdPtr& input) { return !input; }
  static void SetToNull(::media::mojom::blink::CommandBufferIdPtr* output) { output->reset(); }

  static const decltype(::media::mojom::blink::CommandBufferId::channel_token)& channel_token(
      const ::media::mojom::blink::CommandBufferIdPtr& input) {
    return input->channel_token;
  }

  static decltype(::media::mojom::blink::CommandBufferId::route_id) route_id(
      const ::media::mojom::blink::CommandBufferIdPtr& input) {
    return input->route_id;
  }

  static bool Read(::media::mojom::blink::CommandBufferId::DataView input, ::media::mojom::blink::CommandBufferIdPtr* output);
};


template <>
struct BLINK_PLATFORM_EXPORT UnionTraits<::media::mojom::blink::Cdm::DataView,
                                        ::media::mojom::blink::CdmPtr> {
  static bool IsNull(const ::media::mojom::blink::CdmPtr& input) { return !input; }
  static void SetToNull(::media::mojom::blink::CdmPtr* output) { output->reset(); }

  static ::media::mojom::blink::Cdm::Tag GetTag(const ::media::mojom::blink::CdmPtr& input) {
    return input->which();
  }

  static const ::base::UnguessableToken& cdm_id(const ::media::mojom::blink::CdmPtr& input) {
    return input->get_cdm_id();
  }

  static  ::mojo::PendingRemote<::media::mojom::blink::CdmContextForOOPVD>& cdm_context( ::media::mojom::blink::CdmPtr& input) {
    return input->get_cdm_context();
  }

  static bool Read(::media::mojom::blink::Cdm::DataView input, ::media::mojom::blink::CdmPtr* output);
};

}  // namespace mojo

#endif  // MEDIA_MOJO_MOJOM_VIDEO_DECODER_MOJOM_BLINK_H_