// media/mojo/mojom/video_decoder_factory_process.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef MEDIA_MOJO_MOJOM_VIDEO_DECODER_FACTORY_PROCESS_MOJOM_H_
#define MEDIA_MOJO_MOJOM_VIDEO_DECODER_FACTORY_PROCESS_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "media/mojo/mojom/video_decoder_factory_process.mojom-features.h"  // IWYU pragma: export
#include "media/mojo/mojom/video_decoder_factory_process.mojom-shared.h"  // IWYU pragma: export
#include "media/mojo/mojom/video_decoder_factory_process.mojom-forward.h"  // IWYU pragma: export
#include "gpu/ipc/common/gpu_feature_info.mojom.h"
#include "media/mojo/mojom/interface_factory.mojom-forward.h"
#include "sandbox/policy/mojom/sandbox.mojom-forward.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/lib/message_size_estimator.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"






namespace media::mojom {

class VideoDecoderFactoryProcessProxy;

template <typename ImplRefTraits>
class VideoDecoderFactoryProcessStub;

class VideoDecoderFactoryProcessRequestValidator;


class VideoDecoderFactoryProcess
    : public VideoDecoderFactoryProcessInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "media.mojom.VideoDecoderFactoryProcess";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr auto kServiceSandbox = sandbox::mojom::Sandbox::kHardwareVideoDecoding;
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = VideoDecoderFactoryProcessInterfaceBase;
  using Proxy_ = VideoDecoderFactoryProcessProxy;

  template <typename ImplRefTraits>
  using Stub_ = VideoDecoderFactoryProcessStub<ImplRefTraits>;

  using RequestValidator_ = VideoDecoderFactoryProcessRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kInitializeVideoDecoderFactoryMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct InitializeVideoDecoderFactory_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~VideoDecoderFactoryProcess() = default;

  virtual void InitializeVideoDecoderFactory(const ::gpu::GpuFeatureInfo& gpu_feature_info, ::mojo::PendingReceiver<::media::mojom::InterfaceFactory> receiver) = 0;
};



class  VideoDecoderFactoryProcessProxy
    : public VideoDecoderFactoryProcess {
 public:
  using InterfaceType = VideoDecoderFactoryProcess;

  explicit VideoDecoderFactoryProcessProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void InitializeVideoDecoderFactory(const ::gpu::GpuFeatureInfo& gpu_feature_info, ::mojo::PendingReceiver<::media::mojom::InterfaceFactory> receiver) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class  VideoDecoderFactoryProcessStubDispatch {
 public:
  static bool Accept(VideoDecoderFactoryProcess* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      VideoDecoderFactoryProcess* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<VideoDecoderFactoryProcess>>
class VideoDecoderFactoryProcessStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  VideoDecoderFactoryProcessStub() = default;
  ~VideoDecoderFactoryProcessStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return VideoDecoderFactoryProcessStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return VideoDecoderFactoryProcessStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  VideoDecoderFactoryProcessRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};





}  // media::mojom

namespace mojo {

}  // namespace mojo

#endif  // MEDIA_MOJO_MOJOM_VIDEO_DECODER_FACTORY_PROCESS_MOJOM_H_