// mojo/public/mojom/base/file_info.mojom-data-view.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef MOJO_PUBLIC_MOJOM_BASE_FILE_INFO_MOJOM_DATA_VIEW_H_
#define MOJO_PUBLIC_MOJOM_BASE_FILE_INFO_MOJOM_DATA_VIEW_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "mojo/public/mojom/base/file_info.mojom-shared-internal.h"
#include "mojo/public/mojom/base/time.mojom-shared.h"


namespace mojo_base::mojom {
class FileInfoDataView;



}  // mojo_base::mojom


namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::mojo_base::mojom::FileInfoDataView> {
  using Data = ::mojo_base::mojom::internal::FileInfo_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace mojo_base::mojom {


class FileInfoDataView {
 public:
  FileInfoDataView() = default;

  FileInfoDataView(
      internal::FileInfo_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  int64_t size() const {
    return data_->size;
  }
  bool is_directory() const {
    return data_->is_directory;
  }
  bool is_symbolic_link() const {
    return data_->is_symbolic_link;
  }
  inline void GetLastModifiedDataView(
      ::mojo_base::mojom::TimeDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadLastModified(UserType* output) {
    
    auto* pointer = data_->last_modified.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeDataView>(
        pointer, output, message_);
  }
  inline void GetLastAccessedDataView(
      ::mojo_base::mojom::TimeDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadLastAccessed(UserType* output) {
    
    auto* pointer = data_->last_accessed.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeDataView>(
        pointer, output, message_);
  }
  inline void GetCreationTimeDataView(
      ::mojo_base::mojom::TimeDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadCreationTime(UserType* output) {
    
    auto* pointer = data_->creation_time.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeDataView>(
        pointer, output, message_);
  }
 private:
  internal::FileInfo_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


}  // mojo_base::mojom

#endif  // MOJO_PUBLIC_MOJOM_BASE_FILE_INFO_MOJOM_DATA_VIEW_H_