// pdf/mojom/pdf.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "pdf/mojom/pdf.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/features.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "pdf/mojom/pdf.mojom-params-data.h"
#include "pdf/mojom/pdf.mojom-shared-message-ids.h"

#include "pdf/mojom/pdf.mojom-import-headers.h"
#include "pdf/mojom/pdf.mojom-test-utils.h"


namespace pdf::mojom {
// The declaration includes the definition on other builds.

PdfListener::IPCStableHashFunction PdfListener::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::PdfListener>(message.name())) {
    case messages::PdfListener::kSetCaretPosition: {
      return &PdfListener::SetCaretPosition_Sym::IPCStableHash;
    }
    case messages::PdfListener::kMoveRangeSelectionExtent: {
      return &PdfListener::MoveRangeSelectionExtent_Sym::IPCStableHash;
    }
    case messages::PdfListener::kSetSelectionBounds: {
      return &PdfListener::SetSelectionBounds_Sym::IPCStableHash;
    }
    case messages::PdfListener::kGetPdfBytes: {
      return &PdfListener::GetPdfBytes_Sym::IPCStableHash;
    }
    case messages::PdfListener::kGetPageText: {
      return &PdfListener::GetPageText_Sym::IPCStableHash;
    }
    case messages::PdfListener::kGetMostVisiblePageIndex: {
      return &PdfListener::GetMostVisiblePageIndex_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* PdfListener::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::PdfListener>(message.name())) {
      case messages::PdfListener::kSetCaretPosition:
            return "Receive pdf::mojom::PdfListener::SetCaretPosition";
      case messages::PdfListener::kMoveRangeSelectionExtent:
            return "Receive pdf::mojom::PdfListener::MoveRangeSelectionExtent";
      case messages::PdfListener::kSetSelectionBounds:
            return "Receive pdf::mojom::PdfListener::SetSelectionBounds";
      case messages::PdfListener::kGetPdfBytes:
            return "Receive pdf::mojom::PdfListener::GetPdfBytes";
      case messages::PdfListener::kGetPageText:
            return "Receive pdf::mojom::PdfListener::GetPageText";
      case messages::PdfListener::kGetMostVisiblePageIndex:
            return "Receive pdf::mojom::PdfListener::GetMostVisiblePageIndex";
    }
  } else {
    switch (static_cast<messages::PdfListener>(message.name())) {
      case messages::PdfListener::kSetCaretPosition:
            return "Receive reply pdf::mojom::PdfListener::SetCaretPosition";
      case messages::PdfListener::kMoveRangeSelectionExtent:
            return "Receive reply pdf::mojom::PdfListener::MoveRangeSelectionExtent";
      case messages::PdfListener::kSetSelectionBounds:
            return "Receive reply pdf::mojom::PdfListener::SetSelectionBounds";
      case messages::PdfListener::kGetPdfBytes:
            return "Receive reply pdf::mojom::PdfListener::GetPdfBytes";
      case messages::PdfListener::kGetPageText:
            return "Receive reply pdf::mojom::PdfListener::GetPageText";
      case messages::PdfListener::kGetMostVisiblePageIndex:
            return "Receive reply pdf::mojom::PdfListener::GetMostVisiblePageIndex";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t PdfListener::SetCaretPosition_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x92ed3027;  // IPCStableHash for pdf::mojom::PdfListener::SetCaretPosition
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PdfListener::MoveRangeSelectionExtent_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xabe44cf9;  // IPCStableHash for pdf::mojom::PdfListener::MoveRangeSelectionExtent
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PdfListener::SetSelectionBounds_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xc76cd17c;  // IPCStableHash for pdf::mojom::PdfListener::SetSelectionBounds
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PdfListener::GetPdfBytes_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xf175ba5d;  // IPCStableHash for pdf::mojom::PdfListener::GetPdfBytes
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PdfListener::GetPageText_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xb7ebac6e;  // IPCStableHash for pdf::mojom::PdfListener::GetPageText
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PdfListener::GetMostVisiblePageIndex_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x25dee587;  // IPCStableHash for pdf::mojom::PdfListener::GetMostVisiblePageIndex
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

class PdfListener_GetPdfBytes_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  PdfListener_GetPdfBytes_ForwardToCallback(
      PdfListener::GetPdfBytesCallback callback
      ) : callback_(std::move(callback)) {
  }

  PdfListener_GetPdfBytes_ForwardToCallback(const PdfListener_GetPdfBytes_ForwardToCallback&) = delete;
  PdfListener_GetPdfBytes_ForwardToCallback& operator=(const PdfListener_GetPdfBytes_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  PdfListener::GetPdfBytesCallback callback_;
};

class PdfListener_GetPageText_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  PdfListener_GetPageText_ForwardToCallback(
      PdfListener::GetPageTextCallback callback
      ) : callback_(std::move(callback)) {
  }

  PdfListener_GetPageText_ForwardToCallback(const PdfListener_GetPageText_ForwardToCallback&) = delete;
  PdfListener_GetPageText_ForwardToCallback& operator=(const PdfListener_GetPageText_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  PdfListener::GetPageTextCallback callback_;
};

class PdfListener_GetMostVisiblePageIndex_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  PdfListener_GetMostVisiblePageIndex_ForwardToCallback(
      PdfListener::GetMostVisiblePageIndexCallback callback
      ) : callback_(std::move(callback)) {
  }

  PdfListener_GetMostVisiblePageIndex_ForwardToCallback(const PdfListener_GetMostVisiblePageIndex_ForwardToCallback&) = delete;
  PdfListener_GetMostVisiblePageIndex_ForwardToCallback& operator=(const PdfListener_GetMostVisiblePageIndex_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  PdfListener::GetMostVisiblePageIndexCallback callback_;
};

PdfListenerProxy::PdfListenerProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void PdfListenerProxy::SetCaretPosition(
    const ::gfx::PointF& in_position) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send pdf::mojom::PdfListener::SetCaretPosition", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("position"), in_position,
                        "<value of type const ::gfx::PointF&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PdfListener::kSetCaretPosition), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::pdf::mojom::internal::PdfListener_SetCaretPosition_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->position)::BaseType> position_fragment(
          params.message());
  
  mojo::internal::Serialize<::gfx::mojom::PointFDataView>(
    in_position,
    position_fragment);

  params->position.Set(
      position_fragment.is_null() ? nullptr : position_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->position.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null position in PdfListener.SetCaretPosition request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PdfListener::Name_);
  message.set_method_name("SetCaretPosition");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PdfListenerProxy::MoveRangeSelectionExtent(
    const ::gfx::PointF& in_extent) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send pdf::mojom::PdfListener::MoveRangeSelectionExtent", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("extent"), in_extent,
                        "<value of type const ::gfx::PointF&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PdfListener::kMoveRangeSelectionExtent), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::pdf::mojom::internal::PdfListener_MoveRangeSelectionExtent_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->extent)::BaseType> extent_fragment(
          params.message());
  
  mojo::internal::Serialize<::gfx::mojom::PointFDataView>(
    in_extent,
    extent_fragment);

  params->extent.Set(
      extent_fragment.is_null() ? nullptr : extent_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->extent.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null extent in PdfListener.MoveRangeSelectionExtent request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PdfListener::Name_);
  message.set_method_name("MoveRangeSelectionExtent");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PdfListenerProxy::SetSelectionBounds(
    const ::gfx::PointF& in_base, const ::gfx::PointF& in_extent) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send pdf::mojom::PdfListener::SetSelectionBounds", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("base"), in_base,
                        "<value of type const ::gfx::PointF&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("extent"), in_extent,
                        "<value of type const ::gfx::PointF&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PdfListener::kSetSelectionBounds), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::pdf::mojom::internal::PdfListener_SetSelectionBounds_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->base)::BaseType> base_fragment(
          params.message());
  
  mojo::internal::Serialize<::gfx::mojom::PointFDataView>(
    in_base,
    base_fragment);

  params->base.Set(
      base_fragment.is_null() ? nullptr : base_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->base.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null base in PdfListener.SetSelectionBounds request");
  mojo::internal::MessageFragment<
      typename decltype(params->extent)::BaseType> extent_fragment(
          params.message());
  
  mojo::internal::Serialize<::gfx::mojom::PointFDataView>(
    in_extent,
    extent_fragment);

  params->extent.Set(
      extent_fragment.is_null() ? nullptr : extent_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->extent.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null extent in PdfListener.SetSelectionBounds request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PdfListener::Name_);
  message.set_method_name("SetSelectionBounds");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PdfListenerProxy::GetPdfBytes(
    uint32_t in_size_limit, GetPdfBytesCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send pdf::mojom::PdfListener::GetPdfBytes", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("size_limit"), in_size_limit,
                        "<value of type uint32_t>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PdfListener::kGetPdfBytes), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::pdf::mojom::internal::PdfListener_GetPdfBytes_Params_Data> params(
          message);
  params.Allocate();

  params->size_limit = in_size_limit;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PdfListener::Name_);
  message.set_method_name("GetPdfBytes");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new PdfListener_GetPdfBytes_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void PdfListenerProxy::GetPageText(
    int32_t in_page_index, GetPageTextCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send pdf::mojom::PdfListener::GetPageText", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("page_index"), in_page_index,
                        "<value of type int32_t>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PdfListener::kGetPageText), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::pdf::mojom::internal::PdfListener_GetPageText_Params_Data> params(
          message);
  params.Allocate();

  params->page_index = in_page_index;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PdfListener::Name_);
  message.set_method_name("GetPageText");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new PdfListener_GetPageText_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void PdfListenerProxy::GetMostVisiblePageIndex(
    GetMostVisiblePageIndexCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send pdf::mojom::PdfListener::GetMostVisiblePageIndex");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PdfListener::kGetMostVisiblePageIndex), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::pdf::mojom::internal::PdfListener_GetMostVisiblePageIndex_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PdfListener::Name_);
  message.set_method_name("GetMostVisiblePageIndex");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new PdfListener_GetMostVisiblePageIndex_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}
class PdfListener_GetPdfBytes_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static PdfListener::GetPdfBytesCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<PdfListener_GetPdfBytes_ProxyToResponder> proxy(
        new PdfListener_GetPdfBytes_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&PdfListener_GetPdfBytes_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~PdfListener_GetPdfBytes_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  PdfListener_GetPdfBytes_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "PdfListener::GetPdfBytesCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      PdfListener::GetPdfBytesStatus in_status, const std::vector<uint8_t>& in_bytes, uint32_t in_page_count);
};

bool PdfListener_GetPdfBytes_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::PdfListener_GetPdfBytes_ResponseParams_Data* params =
      reinterpret_cast<
          internal::PdfListener_GetPdfBytes_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for PdfListener.3
  bool success = true;
  PdfListener::GetPdfBytesStatus p_status{};
  std::vector<uint8_t> p_bytes{};
  uint32_t p_page_count{};
  PdfListener_GetPdfBytes_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadStatus(&p_status))
    success = false;
  if (success && !input_data_view.ReadBytes(&p_bytes))
    success = false;
  if (success)
    p_page_count = input_data_view.page_count();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        PdfListener::Name_, 3, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_status), 
std::move(p_bytes), 
std::move(p_page_count));
  }
  return true;
}

void PdfListener_GetPdfBytes_ProxyToResponder::Run(
    PdfListener::GetPdfBytesStatus in_status, const std::vector<uint8_t>& in_bytes, uint32_t in_page_count) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply pdf::mojom::PdfListener::GetPdfBytes", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("status"), in_status,
                        "<value of type PdfListener::GetPdfBytesStatus>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("bytes"), in_bytes,
                        "<value of type const std::vector<uint8_t>&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("page_count"), in_page_count,
                        "<value of type uint32_t>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PdfListener::kGetPdfBytes), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::pdf::mojom::internal::PdfListener_GetPdfBytes_ResponseParams_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::pdf::mojom::PdfListener_GetPdfBytesStatus>(
    in_status,
    &params->status);
  mojo::internal::MessageFragment<
      typename decltype(params->bytes)::BaseType>
      bytes_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& bytes_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<uint8_t>>(
    in_bytes,
    bytes_fragment,
    &bytes_validate_params);

  params->bytes.Set(
      bytes_fragment.is_null() ? nullptr : bytes_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->bytes.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null bytes in ");

  params->page_count = in_page_count;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PdfListener::Name_);
  message.set_method_name("GetPdfBytes");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class PdfListener_GetPageText_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static PdfListener::GetPageTextCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<PdfListener_GetPageText_ProxyToResponder> proxy(
        new PdfListener_GetPageText_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&PdfListener_GetPageText_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~PdfListener_GetPageText_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  PdfListener_GetPageText_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "PdfListener::GetPageTextCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      const ::std::u16string& in_text);
};

bool PdfListener_GetPageText_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::PdfListener_GetPageText_ResponseParams_Data* params =
      reinterpret_cast<
          internal::PdfListener_GetPageText_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for PdfListener.4
  bool success = true;
  ::std::u16string p_text{};
  PdfListener_GetPageText_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadText(&p_text))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        PdfListener::Name_, 4, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_text));
  }
  return true;
}

void PdfListener_GetPageText_ProxyToResponder::Run(
    const ::std::u16string& in_text) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply pdf::mojom::PdfListener::GetPageText", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("text"), in_text,
                        "<value of type const ::std::u16string&>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PdfListener::kGetPageText), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::pdf::mojom::internal::PdfListener_GetPageText_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->text)::BaseType> text_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::String16DataView>(
    in_text,
    text_fragment);

  params->text.Set(
      text_fragment.is_null() ? nullptr : text_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->text.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null text in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PdfListener::Name_);
  message.set_method_name("GetPageText");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class PdfListener_GetMostVisiblePageIndex_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static PdfListener::GetMostVisiblePageIndexCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<PdfListener_GetMostVisiblePageIndex_ProxyToResponder> proxy(
        new PdfListener_GetMostVisiblePageIndex_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&PdfListener_GetMostVisiblePageIndex_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~PdfListener_GetMostVisiblePageIndex_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  PdfListener_GetMostVisiblePageIndex_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "PdfListener::GetMostVisiblePageIndexCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      std::optional<uint32_t> in_page_index);
};

bool PdfListener_GetMostVisiblePageIndex_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::PdfListener_GetMostVisiblePageIndex_ResponseParams_Data* params =
      reinterpret_cast<
          internal::PdfListener_GetMostVisiblePageIndex_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for PdfListener.5
  bool success = true;
  std::optional<uint32_t> p_page_index{};
  PdfListener_GetMostVisiblePageIndex_ResponseParamsDataView input_data_view(params, message);
  
  if (success) {
    p_page_index = input_data_view.page_index();
  }
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        PdfListener::Name_, 5, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_page_index));
  }
  return true;
}

void PdfListener_GetMostVisiblePageIndex_ProxyToResponder::Run(
    std::optional<uint32_t> in_page_index) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply pdf::mojom::PdfListener::GetMostVisiblePageIndex", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("page_index"), in_page_index,
                        "<value of type std::optional<uint32_t>>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PdfListener::kGetMostVisiblePageIndex), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::pdf::mojom::internal::PdfListener_GetMostVisiblePageIndex_ResponseParams_Data> params(
          message);
  params.Allocate();
  params->page_index_$flag = in_page_index.has_value();
  if (in_page_index.has_value()) {
    params->page_index_$value = in_page_index.value();
  }

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PdfListener::Name_);
  message.set_method_name("GetMostVisiblePageIndex");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool PdfListenerStubDispatch::Accept(
    PdfListener* impl,
    mojo::Message* message) {
  switch (static_cast<messages::PdfListener>(message->header()->name)) {
    case messages::PdfListener::kSetCaretPosition: {
      DCHECK(message->is_serialized());
      internal::PdfListener_SetCaretPosition_Params_Data* params =
          reinterpret_cast<internal::PdfListener_SetCaretPosition_Params_Data*>(
              message->mutable_payload());
      

      // Validation for PdfListener.0
      bool success = true;
      ::gfx::PointF p_position{};
      PdfListener_SetCaretPosition_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadPosition(&p_position))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PdfListener::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetCaretPosition(        
        std::move(p_position));
      return true;
    }
    case messages::PdfListener::kMoveRangeSelectionExtent: {
      DCHECK(message->is_serialized());
      internal::PdfListener_MoveRangeSelectionExtent_Params_Data* params =
          reinterpret_cast<internal::PdfListener_MoveRangeSelectionExtent_Params_Data*>(
              message->mutable_payload());
      

      // Validation for PdfListener.1
      bool success = true;
      ::gfx::PointF p_extent{};
      PdfListener_MoveRangeSelectionExtent_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadExtent(&p_extent))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PdfListener::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->MoveRangeSelectionExtent(        
        std::move(p_extent));
      return true;
    }
    case messages::PdfListener::kSetSelectionBounds: {
      DCHECK(message->is_serialized());
      internal::PdfListener_SetSelectionBounds_Params_Data* params =
          reinterpret_cast<internal::PdfListener_SetSelectionBounds_Params_Data*>(
              message->mutable_payload());
      

      // Validation for PdfListener.2
      bool success = true;
      ::gfx::PointF p_base{};
      ::gfx::PointF p_extent{};
      PdfListener_SetSelectionBounds_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadBase(&p_base))
        success = false;
      if (success && !input_data_view.ReadExtent(&p_extent))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PdfListener::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetSelectionBounds(        
        std::move(p_base), 
        std::move(p_extent));
      return true;
    }
    case messages::PdfListener::kGetPdfBytes: {
      break;
    }
    case messages::PdfListener::kGetPageText: {
      break;
    }
    case messages::PdfListener::kGetMostVisiblePageIndex: {
      break;
    }
  }
  return false;
}

// static
bool PdfListenerStubDispatch::AcceptWithResponder(
    PdfListener* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::PdfListener>(message->header()->name)) {
    case messages::PdfListener::kSetCaretPosition: {
      break;
    }
    case messages::PdfListener::kMoveRangeSelectionExtent: {
      break;
    }
    case messages::PdfListener::kSetSelectionBounds: {
      break;
    }
    case messages::PdfListener::kGetPdfBytes: {
      internal::PdfListener_GetPdfBytes_Params_Data* params =
          reinterpret_cast<
              internal::PdfListener_GetPdfBytes_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for PdfListener.3
      bool success = true;
      uint32_t p_size_limit{};
      PdfListener_GetPdfBytes_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_size_limit = input_data_view.size_limit();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PdfListener::Name_, 3, false);
        return false;
      }
      auto callback =
          PdfListener_GetPdfBytes_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetPdfBytes(        
        std::move(p_size_limit), std::move(callback));
      return true;
    }
    case messages::PdfListener::kGetPageText: {
      internal::PdfListener_GetPageText_Params_Data* params =
          reinterpret_cast<
              internal::PdfListener_GetPageText_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for PdfListener.4
      bool success = true;
      int32_t p_page_index{};
      PdfListener_GetPageText_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_page_index = input_data_view.page_index();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PdfListener::Name_, 4, false);
        return false;
      }
      auto callback =
          PdfListener_GetPageText_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetPageText(        
        std::move(p_page_index), std::move(callback));
      return true;
    }
    case messages::PdfListener::kGetMostVisiblePageIndex: {
      internal::PdfListener_GetMostVisiblePageIndex_Params_Data* params =
          reinterpret_cast<
              internal::PdfListener_GetMostVisiblePageIndex_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for PdfListener.5
      bool success = true;
      PdfListener_GetMostVisiblePageIndex_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PdfListener::Name_, 5, false);
        return false;
      }
      auto callback =
          PdfListener_GetMostVisiblePageIndex_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetMostVisiblePageIndex(std::move(callback));
      return true;
    }
  }
  return false;
}
namespace {
}  // namespace
static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kPdfListenerValidationInfo[] = {
    {base::to_underlying(messages::PdfListener::kSetCaretPosition),
     { &internal::PdfListener_SetCaretPosition_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::PdfListener::kMoveRangeSelectionExtent),
     { &internal::PdfListener_MoveRangeSelectionExtent_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::PdfListener::kSetSelectionBounds),
     { &internal::PdfListener_SetSelectionBounds_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::PdfListener::kGetPdfBytes),
     { &internal::PdfListener_GetPdfBytes_Params_Data::Validate,
      &internal::PdfListener_GetPdfBytes_ResponseParams_Data::Validate}},
    {base::to_underlying(messages::PdfListener::kGetPageText),
     { &internal::PdfListener_GetPageText_Params_Data::Validate,
      &internal::PdfListener_GetPageText_ResponseParams_Data::Validate}},
    {base::to_underlying(messages::PdfListener::kGetMostVisiblePageIndex),
     { &internal::PdfListener_GetMostVisiblePageIndex_Params_Data::Validate,
      &internal::PdfListener_GetMostVisiblePageIndex_ResponseParams_Data::Validate}},
};

bool PdfListenerRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGeneric(
    message,
    ::pdf::mojom::PdfListener::Name_,
    kPdfListenerValidationInfo);
}

bool PdfListenerResponseValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateResponseGeneric(
    message,
    ::pdf::mojom::PdfListener::Name_,
    kPdfListenerValidationInfo);

}
// The declaration includes the definition on other builds.

PdfHost::IPCStableHashFunction PdfHost::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::PdfHost>(message.name())) {
    case messages::PdfHost::kSetListener: {
      return &PdfHost::SetListener_Sym::IPCStableHash;
    }
    case messages::PdfHost::kOnDocumentLoadComplete: {
      return &PdfHost::OnDocumentLoadComplete_Sym::IPCStableHash;
    }
    case messages::PdfHost::kUpdateContentRestrictions: {
      return &PdfHost::UpdateContentRestrictions_Sym::IPCStableHash;
    }
    case messages::PdfHost::kSaveUrlAs: {
      return &PdfHost::SaveUrlAs_Sym::IPCStableHash;
    }
    case messages::PdfHost::kSelectionChanged: {
      return &PdfHost::SelectionChanged_Sym::IPCStableHash;
    }
    case messages::PdfHost::kSetPluginCanSave: {
      return &PdfHost::SetPluginCanSave_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* PdfHost::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::PdfHost>(message.name())) {
      case messages::PdfHost::kSetListener:
            return "Receive pdf::mojom::PdfHost::SetListener";
      case messages::PdfHost::kOnDocumentLoadComplete:
            return "Receive pdf::mojom::PdfHost::OnDocumentLoadComplete";
      case messages::PdfHost::kUpdateContentRestrictions:
            return "Receive pdf::mojom::PdfHost::UpdateContentRestrictions";
      case messages::PdfHost::kSaveUrlAs:
            return "Receive pdf::mojom::PdfHost::SaveUrlAs";
      case messages::PdfHost::kSelectionChanged:
            return "Receive pdf::mojom::PdfHost::SelectionChanged";
      case messages::PdfHost::kSetPluginCanSave:
            return "Receive pdf::mojom::PdfHost::SetPluginCanSave";
    }
  } else {
    switch (static_cast<messages::PdfHost>(message.name())) {
      case messages::PdfHost::kSetListener:
            return "Receive reply pdf::mojom::PdfHost::SetListener";
      case messages::PdfHost::kOnDocumentLoadComplete:
            return "Receive reply pdf::mojom::PdfHost::OnDocumentLoadComplete";
      case messages::PdfHost::kUpdateContentRestrictions:
            return "Receive reply pdf::mojom::PdfHost::UpdateContentRestrictions";
      case messages::PdfHost::kSaveUrlAs:
            return "Receive reply pdf::mojom::PdfHost::SaveUrlAs";
      case messages::PdfHost::kSelectionChanged:
            return "Receive reply pdf::mojom::PdfHost::SelectionChanged";
      case messages::PdfHost::kSetPluginCanSave:
            return "Receive reply pdf::mojom::PdfHost::SetPluginCanSave";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t PdfHost::SetListener_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x005052f0;  // IPCStableHash for pdf::mojom::PdfHost::SetListener
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PdfHost::OnDocumentLoadComplete_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x7303ca59;  // IPCStableHash for pdf::mojom::PdfHost::OnDocumentLoadComplete
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PdfHost::UpdateContentRestrictions_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xba63b81a;  // IPCStableHash for pdf::mojom::PdfHost::UpdateContentRestrictions
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PdfHost::SaveUrlAs_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x843734a9;  // IPCStableHash for pdf::mojom::PdfHost::SaveUrlAs
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PdfHost::SelectionChanged_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x7c319f8d;  // IPCStableHash for pdf::mojom::PdfHost::SelectionChanged
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PdfHost::SetPluginCanSave_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x595e43a7;  // IPCStableHash for pdf::mojom::PdfHost::SetPluginCanSave
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

PdfHostProxy::PdfHostProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void PdfHostProxy::SetListener(
    ::mojo::PendingRemote<PdfListener> in_client) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send pdf::mojom::PdfHost::SetListener", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("client"), in_client,
                        "<value of type ::mojo::PendingRemote<PdfListener>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PdfHost::kSetListener), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::pdf::mojom::internal::PdfHost_SetListener_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::pdf::mojom::PdfListenerInterfaceBase>>(
    in_client,
    &params->client,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->client)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid client in PdfHost.SetListener request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PdfHost::Name_);
  message.set_method_name("SetListener");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PdfHostProxy::OnDocumentLoadComplete(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send pdf::mojom::PdfHost::OnDocumentLoadComplete");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PdfHost::kOnDocumentLoadComplete), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::pdf::mojom::internal::PdfHost_OnDocumentLoadComplete_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PdfHost::Name_);
  message.set_method_name("OnDocumentLoadComplete");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PdfHostProxy::UpdateContentRestrictions(
    int32_t in_restrictions) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send pdf::mojom::PdfHost::UpdateContentRestrictions", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("restrictions"), in_restrictions,
                        "<value of type int32_t>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PdfHost::kUpdateContentRestrictions), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::pdf::mojom::internal::PdfHost_UpdateContentRestrictions_Params_Data> params(
          message);
  params.Allocate();

  params->restrictions = in_restrictions;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PdfHost::Name_);
  message.set_method_name("UpdateContentRestrictions");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PdfHostProxy::SaveUrlAs(
    const ::GURL& in_url, ::network::mojom::ReferrerPolicy in_policy) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send pdf::mojom::PdfHost::SaveUrlAs", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("url"), in_url,
                        "<value of type const ::GURL&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("policy"), in_policy,
                        "<value of type ::network::mojom::ReferrerPolicy>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PdfHost::kSaveUrlAs), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::pdf::mojom::internal::PdfHost_SaveUrlAs_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->url)::BaseType> url_fragment(
          params.message());
  
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
    in_url,
    url_fragment);

  params->url.Set(
      url_fragment.is_null() ? nullptr : url_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->url.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null url in PdfHost.SaveUrlAs request");

  
  mojo::internal::Serialize<::network::mojom::ReferrerPolicy>(
    in_policy,
    &params->policy);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PdfHost::Name_);
  message.set_method_name("SaveUrlAs");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PdfHostProxy::SelectionChanged(
    const ::gfx::PointF& in_left, int32_t in_left_height, const ::gfx::PointF& in_right, int32_t in_right_height) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send pdf::mojom::PdfHost::SelectionChanged", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("left"), in_left,
                        "<value of type const ::gfx::PointF&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("left_height"), in_left_height,
                        "<value of type int32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("right"), in_right,
                        "<value of type const ::gfx::PointF&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("right_height"), in_right_height,
                        "<value of type int32_t>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PdfHost::kSelectionChanged), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::pdf::mojom::internal::PdfHost_SelectionChanged_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->left)::BaseType> left_fragment(
          params.message());
  
  mojo::internal::Serialize<::gfx::mojom::PointFDataView>(
    in_left,
    left_fragment);

  params->left.Set(
      left_fragment.is_null() ? nullptr : left_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->left.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null left in PdfHost.SelectionChanged request");

  params->left_height = in_left_height;
  mojo::internal::MessageFragment<
      typename decltype(params->right)::BaseType> right_fragment(
          params.message());
  
  mojo::internal::Serialize<::gfx::mojom::PointFDataView>(
    in_right,
    right_fragment);

  params->right.Set(
      right_fragment.is_null() ? nullptr : right_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->right.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null right in PdfHost.SelectionChanged request");

  params->right_height = in_right_height;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PdfHost::Name_);
  message.set_method_name("SelectionChanged");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PdfHostProxy::SetPluginCanSave(
    bool in_can_save) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send pdf::mojom::PdfHost::SetPluginCanSave", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("can_save"), in_can_save,
                        "<value of type bool>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PdfHost::kSetPluginCanSave), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::pdf::mojom::internal::PdfHost_SetPluginCanSave_Params_Data> params(
          message);
  params.Allocate();

  params->can_save = in_can_save;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PdfHost::Name_);
  message.set_method_name("SetPluginCanSave");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool PdfHostStubDispatch::Accept(
    PdfHost* impl,
    mojo::Message* message) {
  switch (static_cast<messages::PdfHost>(message->header()->name)) {
    case messages::PdfHost::kSetListener: {
      DCHECK(message->is_serialized());
      internal::PdfHost_SetListener_Params_Data* params =
          reinterpret_cast<internal::PdfHost_SetListener_Params_Data*>(
              message->mutable_payload());
      

      // Validation for PdfHost.0
      bool success = true;
      ::mojo::PendingRemote<PdfListener> p_client{};
      PdfHost_SetListener_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_client =
            input_data_view.TakeClient<decltype(p_client)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PdfHost::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetListener(        
        std::move(p_client));
      return true;
    }
    case messages::PdfHost::kOnDocumentLoadComplete: {
      DCHECK(message->is_serialized());
      internal::PdfHost_OnDocumentLoadComplete_Params_Data* params =
          reinterpret_cast<internal::PdfHost_OnDocumentLoadComplete_Params_Data*>(
              message->mutable_payload());
      

      // Validation for PdfHost.1
      bool success = true;
      PdfHost_OnDocumentLoadComplete_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PdfHost::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnDocumentLoadComplete(        );
      return true;
    }
    case messages::PdfHost::kUpdateContentRestrictions: {
      DCHECK(message->is_serialized());
      internal::PdfHost_UpdateContentRestrictions_Params_Data* params =
          reinterpret_cast<internal::PdfHost_UpdateContentRestrictions_Params_Data*>(
              message->mutable_payload());
      

      // Validation for PdfHost.2
      bool success = true;
      int32_t p_restrictions{};
      PdfHost_UpdateContentRestrictions_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_restrictions = input_data_view.restrictions();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PdfHost::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->UpdateContentRestrictions(        
        std::move(p_restrictions));
      return true;
    }
    case messages::PdfHost::kSaveUrlAs: {
      DCHECK(message->is_serialized());
      internal::PdfHost_SaveUrlAs_Params_Data* params =
          reinterpret_cast<internal::PdfHost_SaveUrlAs_Params_Data*>(
              message->mutable_payload());
      

      // Validation for PdfHost.3
      bool success = true;
      ::GURL p_url{};
      ::network::mojom::ReferrerPolicy p_policy{};
      PdfHost_SaveUrlAs_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadUrl(&p_url))
        success = false;
      if (success && !input_data_view.ReadPolicy(&p_policy))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PdfHost::Name_, 3, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SaveUrlAs(        
        std::move(p_url), 
        std::move(p_policy));
      return true;
    }
    case messages::PdfHost::kSelectionChanged: {
      DCHECK(message->is_serialized());
      internal::PdfHost_SelectionChanged_Params_Data* params =
          reinterpret_cast<internal::PdfHost_SelectionChanged_Params_Data*>(
              message->mutable_payload());
      

      // Validation for PdfHost.4
      bool success = true;
      ::gfx::PointF p_left{};
      int32_t p_left_height{};
      ::gfx::PointF p_right{};
      int32_t p_right_height{};
      PdfHost_SelectionChanged_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadLeft(&p_left))
        success = false;
      if (success)
        p_left_height = input_data_view.left_height();
      if (success && !input_data_view.ReadRight(&p_right))
        success = false;
      if (success)
        p_right_height = input_data_view.right_height();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PdfHost::Name_, 4, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SelectionChanged(        
        std::move(p_left), 
        std::move(p_left_height), 
        std::move(p_right), 
        std::move(p_right_height));
      return true;
    }
    case messages::PdfHost::kSetPluginCanSave: {
      DCHECK(message->is_serialized());
      internal::PdfHost_SetPluginCanSave_Params_Data* params =
          reinterpret_cast<internal::PdfHost_SetPluginCanSave_Params_Data*>(
              message->mutable_payload());
      

      // Validation for PdfHost.5
      bool success = true;
      bool p_can_save{};
      PdfHost_SetPluginCanSave_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_can_save = input_data_view.can_save();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PdfHost::Name_, 5, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetPluginCanSave(        
        std::move(p_can_save));
      return true;
    }
  }
  return false;
}

// static
bool PdfHostStubDispatch::AcceptWithResponder(
    PdfHost* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::PdfHost>(message->header()->name)) {
    case messages::PdfHost::kSetListener: {
      break;
    }
    case messages::PdfHost::kOnDocumentLoadComplete: {
      break;
    }
    case messages::PdfHost::kUpdateContentRestrictions: {
      break;
    }
    case messages::PdfHost::kSaveUrlAs: {
      break;
    }
    case messages::PdfHost::kSelectionChanged: {
      break;
    }
    case messages::PdfHost::kSetPluginCanSave: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kPdfHostValidationInfo[] = {
    {base::to_underlying(messages::PdfHost::kSetListener),
     { &internal::PdfHost_SetListener_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::PdfHost::kOnDocumentLoadComplete),
     { &internal::PdfHost_OnDocumentLoadComplete_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::PdfHost::kUpdateContentRestrictions),
     { &internal::PdfHost_UpdateContentRestrictions_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::PdfHost::kSaveUrlAs),
     { &internal::PdfHost_SaveUrlAs_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::PdfHost::kSelectionChanged),
     { &internal::PdfHost_SelectionChanged_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::PdfHost::kSetPluginCanSave),
     { &internal::PdfHost_SetPluginCanSave_Params_Data::Validate,
      nullptr /* no response */}},
};

bool PdfHostRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGeneric(
    message,
    ::pdf::mojom::PdfHost::Name_,
    kPdfHostValidationInfo);
}



}  // pdf::mojom


namespace mojo {

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace pdf::mojom {


void PdfListenerInterceptorForTesting::SetCaretPosition(const ::gfx::PointF& position) {
  GetForwardingInterface()->SetCaretPosition(
    std::move(position)
    );
}
void PdfListenerInterceptorForTesting::MoveRangeSelectionExtent(const ::gfx::PointF& extent) {
  GetForwardingInterface()->MoveRangeSelectionExtent(
    std::move(extent)
    );
}
void PdfListenerInterceptorForTesting::SetSelectionBounds(const ::gfx::PointF& base, const ::gfx::PointF& extent) {
  GetForwardingInterface()->SetSelectionBounds(
    std::move(base)
    , 
    std::move(extent)
    );
}
void PdfListenerInterceptorForTesting::GetPdfBytes(uint32_t size_limit, GetPdfBytesCallback callback) {
  GetForwardingInterface()->GetPdfBytes(
    std::move(size_limit)
    , std::move(callback));
}
void PdfListenerInterceptorForTesting::GetPageText(int32_t page_index, GetPageTextCallback callback) {
  GetForwardingInterface()->GetPageText(
    std::move(page_index)
    , std::move(callback));
}
void PdfListenerInterceptorForTesting::GetMostVisiblePageIndex(GetMostVisiblePageIndexCallback callback) {
  GetForwardingInterface()->GetMostVisiblePageIndex(std::move(callback));
}
PdfListenerAsyncWaiter::PdfListenerAsyncWaiter(
    PdfListener* proxy) : proxy_(proxy) {}

PdfListenerAsyncWaiter::~PdfListenerAsyncWaiter() = default;


void PdfListenerAsyncWaiter::GetPdfBytes(
    uint32_t size_limit, PdfListener::GetPdfBytesStatus* out_status, std::vector<uint8_t>* out_bytes, uint32_t* out_page_count) {
  base::RunLoop loop;
  proxy_->GetPdfBytes(
      std::move(size_limit),
      base::BindOnce(
          [](base::RunLoop* loop,
             PdfListener::GetPdfBytesStatus* out_status
,
             std::vector<uint8_t>* out_bytes
,
             uint32_t* out_page_count
,
             PdfListener::GetPdfBytesStatus status,
             const std::vector<uint8_t>& bytes,
             uint32_t page_count) {*out_status = std::move(status);*out_bytes = std::move(bytes);*out_page_count = std::move(page_count);
            loop->Quit();
          },
          &loop,
          out_status,
          out_bytes,
          out_page_count));
  loop.Run();
}



void PdfListenerAsyncWaiter::GetPageText(
    int32_t page_index, ::std::u16string* out_text) {
  base::RunLoop loop;
  proxy_->GetPageText(
      std::move(page_index),
      base::BindOnce(
          [](base::RunLoop* loop,
             ::std::u16string* out_text
,
             const ::std::u16string& text) {*out_text = std::move(text);
            loop->Quit();
          },
          &loop,
          out_text));
  loop.Run();
}

::std::u16string PdfListenerAsyncWaiter::GetPageText(
    int32_t page_index) {
  ::std::u16string async_wait_result;
  GetPageText(std::move(page_index),&async_wait_result);
  return async_wait_result;
}

void PdfListenerAsyncWaiter::GetMostVisiblePageIndex(
    std::optional<uint32_t>* out_page_index) {
  base::RunLoop loop;
  proxy_->GetMostVisiblePageIndex(
      base::BindOnce(
          [](base::RunLoop* loop,
             std::optional<uint32_t>* out_page_index
,
             std::optional<uint32_t> page_index) {*out_page_index = std::move(page_index);
            loop->Quit();
          },
          &loop,
          out_page_index));
  loop.Run();
}

std::optional<uint32_t> PdfListenerAsyncWaiter::GetMostVisiblePageIndex(
    ) {
  std::optional<uint32_t> async_wait_result;
  GetMostVisiblePageIndex(&async_wait_result);
  return async_wait_result;
}




void PdfHostInterceptorForTesting::SetListener(::mojo::PendingRemote<PdfListener> client) {
  GetForwardingInterface()->SetListener(
    std::move(client)
    );
}
void PdfHostInterceptorForTesting::OnDocumentLoadComplete() {
  GetForwardingInterface()->OnDocumentLoadComplete();
}
void PdfHostInterceptorForTesting::UpdateContentRestrictions(int32_t restrictions) {
  GetForwardingInterface()->UpdateContentRestrictions(
    std::move(restrictions)
    );
}
void PdfHostInterceptorForTesting::SaveUrlAs(const ::GURL& url, ::network::mojom::ReferrerPolicy policy) {
  GetForwardingInterface()->SaveUrlAs(
    std::move(url)
    , 
    std::move(policy)
    );
}
void PdfHostInterceptorForTesting::SelectionChanged(const ::gfx::PointF& left, int32_t left_height, const ::gfx::PointF& right, int32_t right_height) {
  GetForwardingInterface()->SelectionChanged(
    std::move(left)
    , 
    std::move(left_height)
    , 
    std::move(right)
    , 
    std::move(right_height)
    );
}
void PdfHostInterceptorForTesting::SetPluginCanSave(bool can_save) {
  GetForwardingInterface()->SetPluginCanSave(
    std::move(can_save)
    );
}
PdfHostAsyncWaiter::PdfHostAsyncWaiter(
    PdfHost* proxy) : proxy_(proxy) {}

PdfHostAsyncWaiter::~PdfHostAsyncWaiter() = default;







}  // pdf::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif