// services/cert_verifier/public/mojom/cert_verifier_service_factory.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "services/cert_verifier/public/mojom/cert_verifier_service_factory.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "services/cert_verifier/public/mojom/cert_verifier_service_factory.mojom-params-data.h"
namespace cert_verifier {
namespace mojom {

NOINLINE static const char* CertificateTrustToStringHelper(CertificateTrust value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case CertificateTrust::kUnspecified:
      return "kUnspecified";
    case CertificateTrust::kDistrusted:
      return "kDistrusted";
    case CertificateTrust::kTrusted:
      return "kTrusted";
    default:
      return nullptr;
  }
}

std::string CertificateTrustToString(CertificateTrust value) {
  const char *str = CertificateTrustToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown CertificateTrust value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, CertificateTrust value) {
  return os << CertificateTrustToString(value);
}

namespace internal {


// static
bool CertVerifierCreationParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const CertVerifierCreationParams_Data* object =
      static_cast<const CertVerifierCreationParams_Data*>(data);

  if (!mojo::internal::ValidateStruct(object->initial_additional_certificates, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->ct_policy, validation_context))
    return false;

  return true;
}

CertVerifierCreationParams_Data::CertVerifierCreationParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ChromeRootCertInfo_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ChromeRootCertInfo_Data* object =
      static_cast<const ChromeRootCertInfo_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->sha256hash_hex, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& sha256hash_hex_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->sha256hash_hex, validation_context,
                                         &sha256hash_hex_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->cert, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& cert_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->cert, validation_context,
                                         &cert_validate_params)) {
    return false;
  }

  return true;
}

ChromeRootCertInfo_Data::ChromeRootCertInfo_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ChromeRootStoreInfo_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ChromeRootStoreInfo_Data* object =
      static_cast<const ChromeRootStoreInfo_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->root_cert_info, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& root_cert_info_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->root_cert_info, validation_context,
                                         &root_cert_info_validate_params)) {
    return false;
  }

  return true;
}

ChromeRootStoreInfo_Data::ChromeRootStoreInfo_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PlatformCertInfo_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PlatformCertInfo_Data* object =
      static_cast<const PlatformCertInfo_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->cert, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& cert_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->cert, validation_context,
                                         &cert_validate_params)) {
    return false;
  }


  if (!::cert_verifier::mojom::internal::CertificateTrust_Data
        ::Validate(object->trust_setting, validation_context))
    return false;

  return true;
}

PlatformCertInfo_Data::PlatformCertInfo_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PlatformRootStoreInfo_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PlatformRootStoreInfo_Data* object =
      static_cast<const PlatformRootStoreInfo_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->user_added_certs, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& user_added_certs_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->user_added_certs, validation_context,
                                         &user_added_certs_validate_params)) {
    return false;
  }

  return true;
}

PlatformRootStoreInfo_Data::PlatformRootStoreInfo_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool CertVerifierServiceFactory_GetNewCertVerifier_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const CertVerifierServiceFactory_GetNewCertVerifier_Params_Data* object =
      static_cast<const CertVerifierServiceFactory_GetNewCertVerifier_Params_Data*>(data);

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->receiver, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->receiver,
                                                 validation_context)) {
    return false;
  }

  if (!mojo::internal::ValidateHandleOrInterface(object->updater,
                                                 validation_context)) {
    return false;
  }

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->client, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->client,
                                                 validation_context)) {
    return false;
  }

  if (!mojo::internal::ValidateStruct(object->creation_params, validation_context))
    return false;

  return true;
}

CertVerifierServiceFactory_GetNewCertVerifier_Params_Data::CertVerifierServiceFactory_GetNewCertVerifier_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool CertVerifierServiceFactory_UpdateCRLSet_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const CertVerifierServiceFactory_UpdateCRLSet_Params_Data* object =
      static_cast<const CertVerifierServiceFactory_UpdateCRLSet_Params_Data*>(data);

  if (!mojo::internal::ValidateInlinedUnionNonNullable(
          object->crl_set, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateInlinedUnion(object->crl_set, validation_context))
    return false;

  return true;
}

CertVerifierServiceFactory_UpdateCRLSet_Params_Data::CertVerifierServiceFactory_UpdateCRLSet_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool CertVerifierServiceFactory_UpdateCRLSet_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const CertVerifierServiceFactory_UpdateCRLSet_ResponseParams_Data* object =
      static_cast<const CertVerifierServiceFactory_UpdateCRLSet_ResponseParams_Data*>(data);

  return true;
}

CertVerifierServiceFactory_UpdateCRLSet_ResponseParams_Data::CertVerifierServiceFactory_UpdateCRLSet_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool CertVerifierServiceFactory_UpdateCtLogList_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const CertVerifierServiceFactory_UpdateCtLogList_Params_Data* object =
      static_cast<const CertVerifierServiceFactory_UpdateCtLogList_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->log_list, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& log_list_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->log_list, validation_context,
                                         &log_list_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->update_time, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->update_time, validation_context))
    return false;

  return true;
}

CertVerifierServiceFactory_UpdateCtLogList_Params_Data::CertVerifierServiceFactory_UpdateCtLogList_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool CertVerifierServiceFactory_UpdateCtLogList_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const CertVerifierServiceFactory_UpdateCtLogList_ResponseParams_Data* object =
      static_cast<const CertVerifierServiceFactory_UpdateCtLogList_ResponseParams_Data*>(data);

  return true;
}

CertVerifierServiceFactory_UpdateCtLogList_ResponseParams_Data::CertVerifierServiceFactory_UpdateCtLogList_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool CertVerifierServiceFactory_DisableCtEnforcement_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const CertVerifierServiceFactory_DisableCtEnforcement_Params_Data* object =
      static_cast<const CertVerifierServiceFactory_DisableCtEnforcement_Params_Data*>(data);

  return true;
}

CertVerifierServiceFactory_DisableCtEnforcement_Params_Data::CertVerifierServiceFactory_DisableCtEnforcement_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool CertVerifierServiceFactory_DisableCtEnforcement_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const CertVerifierServiceFactory_DisableCtEnforcement_ResponseParams_Data* object =
      static_cast<const CertVerifierServiceFactory_DisableCtEnforcement_ResponseParams_Data*>(data);

  return true;
}

CertVerifierServiceFactory_DisableCtEnforcement_ResponseParams_Data::CertVerifierServiceFactory_DisableCtEnforcement_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool CertVerifierServiceFactory_UpdateChromeRootStore_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const CertVerifierServiceFactory_UpdateChromeRootStore_Params_Data* object =
      static_cast<const CertVerifierServiceFactory_UpdateChromeRootStore_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->new_root_store, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->new_root_store, validation_context))
    return false;

  return true;
}

CertVerifierServiceFactory_UpdateChromeRootStore_Params_Data::CertVerifierServiceFactory_UpdateChromeRootStore_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool CertVerifierServiceFactory_UpdateChromeRootStore_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const CertVerifierServiceFactory_UpdateChromeRootStore_ResponseParams_Data* object =
      static_cast<const CertVerifierServiceFactory_UpdateChromeRootStore_ResponseParams_Data*>(data);

  return true;
}

CertVerifierServiceFactory_UpdateChromeRootStore_ResponseParams_Data::CertVerifierServiceFactory_UpdateChromeRootStore_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool CertVerifierServiceFactory_GetChromeRootStoreInfo_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const CertVerifierServiceFactory_GetChromeRootStoreInfo_Params_Data* object =
      static_cast<const CertVerifierServiceFactory_GetChromeRootStoreInfo_Params_Data*>(data);

  return true;
}

CertVerifierServiceFactory_GetChromeRootStoreInfo_Params_Data::CertVerifierServiceFactory_GetChromeRootStoreInfo_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool CertVerifierServiceFactory_GetChromeRootStoreInfo_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const CertVerifierServiceFactory_GetChromeRootStoreInfo_ResponseParams_Data* object =
      static_cast<const CertVerifierServiceFactory_GetChromeRootStoreInfo_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->root_store_info, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->root_store_info, validation_context))
    return false;

  return true;
}

CertVerifierServiceFactory_GetChromeRootStoreInfo_ResponseParams_Data::CertVerifierServiceFactory_GetChromeRootStoreInfo_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool CertVerifierServiceFactory_GetPlatformRootStoreInfo_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const CertVerifierServiceFactory_GetPlatformRootStoreInfo_Params_Data* object =
      static_cast<const CertVerifierServiceFactory_GetPlatformRootStoreInfo_Params_Data*>(data);

  return true;
}

CertVerifierServiceFactory_GetPlatformRootStoreInfo_Params_Data::CertVerifierServiceFactory_GetPlatformRootStoreInfo_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool CertVerifierServiceFactory_GetPlatformRootStoreInfo_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const CertVerifierServiceFactory_GetPlatformRootStoreInfo_ResponseParams_Data* object =
      static_cast<const CertVerifierServiceFactory_GetPlatformRootStoreInfo_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->root_store_info, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->root_store_info, validation_context))
    return false;

  return true;
}

CertVerifierServiceFactory_GetPlatformRootStoreInfo_ResponseParams_Data::CertVerifierServiceFactory_GetPlatformRootStoreInfo_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool CertVerifierServiceFactory_UpdateNetworkTime_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const CertVerifierServiceFactory_UpdateNetworkTime_Params_Data* object =
      static_cast<const CertVerifierServiceFactory_UpdateNetworkTime_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->system_time, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->system_time, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->system_ticks, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->system_ticks, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->current_time, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->current_time, validation_context))
    return false;

  return true;
}

CertVerifierServiceFactory_UpdateNetworkTime_Params_Data::CertVerifierServiceFactory_UpdateNetworkTime_Params_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace cert_verifier

namespace perfetto {

// static
void TraceFormatTraits<::cert_verifier::mojom::CertificateTrust>::WriteIntoTrace(
   perfetto::TracedValue context, ::cert_verifier::mojom::CertificateTrust value) {
  return std::move(context).WriteString(::cert_verifier::mojom::CertificateTrustToString(value));
}

} // namespace perfetto