// services/device/public/mojom/geolocation_context.mojom-blink.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_DEVICE_PUBLIC_MOJOM_GEOLOCATION_CONTEXT_MOJOM_BLINK_H_
#define SERVICES_DEVICE_PUBLIC_MOJOM_GEOLOCATION_CONTEXT_MOJOM_BLINK_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "services/device/public/mojom/geolocation_context.mojom-features.h"  // IWYU pragma: export
#include "services/device/public/mojom/geolocation_context.mojom-shared.h"  // IWYU pragma: export
#include "services/device/public/mojom/geolocation_context.mojom-blink-forward.h"  // IWYU pragma: export
#include "services/device/public/mojom/geolocation.mojom-blink-forward.h"
#include "services/device/public/mojom/geolocation_client_id.mojom-blink-forward.h"
#include "services/device/public/mojom/geoposition.mojom-blink-forward.h"
#include "url/mojom/url.mojom-blink.h"
#include "url/mojom/origin.mojom-blink.h"

#include "mojo/public/cpp/bindings/lib/wtf_clone_equals_util.h"
#include "mojo/public/cpp/bindings/lib/wtf_hash_util.h"
#include "third_party/blink/renderer/platform/wtf/hash_functions.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/lib/message_size_estimator.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"


#include "third_party/blink/public/platform/web_common.h"
#if !BLINK_MOJO_IMPL && !INSIDE_BLINK
#error "File must only be imported inside blink"
#endif




namespace device::mojom::blink {

class GeolocationContextProxy;

template <typename ImplRefTraits>
class GeolocationContextStub;

class GeolocationContextRequestValidator;


class BLINK_PLATFORM_EXPORT GeolocationContext
    : public GeolocationContextInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "device.mojom.GeolocationContext";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = GeolocationContextInterfaceBase;
  using Proxy_ = GeolocationContextProxy;

  template <typename ImplRefTraits>
  using Stub_ = GeolocationContextStub<ImplRefTraits>;

  using RequestValidator_ = GeolocationContextRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kBindGeolocationMinVersion = 0,
    kOnPermissionRevokedMinVersion = 0,
    kSetOverrideMinVersion = 0,
    kClearOverrideMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct BindGeolocation_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnPermissionRevoked_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SetOverride_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct ClearOverride_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~GeolocationContext() = default;

  virtual void BindGeolocation(::mojo::PendingReceiver<::device::mojom::blink::Geolocation> receiver, const ::blink::KURL& requesting_url, ::device::mojom::blink::GeolocationClientId client_id) = 0;

  virtual void OnPermissionRevoked(const ::scoped_refptr<const ::blink::SecurityOrigin>& origin) = 0;

  virtual void SetOverride(::device::mojom::blink::GeopositionResultPtr result) = 0;

  virtual void ClearOverride() = 0;
};



class BLINK_PLATFORM_EXPORT GeolocationContextProxy
    : public GeolocationContext {
 public:
  using InterfaceType = GeolocationContext;

  explicit GeolocationContextProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void BindGeolocation(::mojo::PendingReceiver<::device::mojom::blink::Geolocation> receiver, const ::blink::KURL& requesting_url, ::device::mojom::blink::GeolocationClientId client_id) final;
  
  void OnPermissionRevoked(const ::scoped_refptr<const ::blink::SecurityOrigin>& origin) final;
  
  void SetOverride(::device::mojom::blink::GeopositionResultPtr result) final;
  
  void ClearOverride() final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class BLINK_PLATFORM_EXPORT GeolocationContextStubDispatch {
 public:
  static bool Accept(GeolocationContext* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      GeolocationContext* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<GeolocationContext>>
class GeolocationContextStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  GeolocationContextStub() = default;
  ~GeolocationContextStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return GeolocationContextStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return GeolocationContextStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class BLINK_PLATFORM_EXPORT GeolocationContextRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};





}  // device::mojom::blink

namespace mojo {

}  // namespace mojo

#endif  // SERVICES_DEVICE_PUBLIC_MOJOM_GEOLOCATION_CONTEXT_MOJOM_BLINK_H_