// services/device/public/mojom/nfc.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_DEVICE_PUBLIC_MOJOM_NFC_MOJOM_SHARED_H_
#define SERVICES_DEVICE_PUBLIC_MOJOM_NFC_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "services/device/public/mojom/nfc.mojom-shared-internal.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization.h"
#include "mojo/public/cpp/system/data_pipe.h"



#include "services/device/public/mojom/nfc.mojom-data-view.h"




namespace std {

template <>
struct hash<::device::mojom::NDEFErrorType>
    : public mojo::internal::EnumHashImpl<::device::mojom::NDEFErrorType> {};

template <>
struct hash<::device::mojom::NDEFRecordTypeCategory>
    : public mojo::internal::EnumHashImpl<::device::mojom::NDEFRecordTypeCategory> {};

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::device::mojom::NDEFErrorType, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::device::mojom::NDEFErrorType, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::device::mojom::NDEFErrorType>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::device::mojom::NDEFRecordTypeCategory, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::device::mojom::NDEFRecordTypeCategory, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::device::mojom::NDEFRecordTypeCategory>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::device::mojom::NDEFErrorDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::device::mojom::NDEFErrorDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::device::mojom::internal::NDEFError_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    
    mojo::internal::Serialize<::device::mojom::NDEFErrorType>(
      Traits::error_type(input),
      &fragment->error_type);

    decltype(Traits::error_message(input)) in_error_message = Traits::error_message(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->error_message)::BaseType> error_message_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_error_message,
      error_message_fragment);

    fragment->error_message.Set(
        error_message_fragment.is_null() ? nullptr : error_message_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->error_message.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null error_message in NDEFError struct");
  }

  static bool Deserialize(::device::mojom::internal::NDEFError_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::device::mojom::NDEFErrorDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::device::mojom::NDEFRecordDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::device::mojom::NDEFRecordDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::device::mojom::internal::NDEFRecord_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    
    mojo::internal::Serialize<::device::mojom::NDEFRecordTypeCategory>(
      Traits::category(input),
      &fragment->category);

    decltype(Traits::record_type(input)) in_record_type = Traits::record_type(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->record_type)::BaseType> record_type_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_record_type,
      record_type_fragment);

    fragment->record_type.Set(
        record_type_fragment.is_null() ? nullptr : record_type_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->record_type.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null record_type in NDEFRecord struct");

    decltype(Traits::media_type(input)) in_media_type = Traits::media_type(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->media_type)::BaseType> media_type_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_media_type,
      media_type_fragment);

    fragment->media_type.Set(
        media_type_fragment.is_null() ? nullptr : media_type_fragment.data());

    decltype(Traits::id(input)) in_id = Traits::id(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->id)::BaseType> id_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_id,
      id_fragment);

    fragment->id.Set(
        id_fragment.is_null() ? nullptr : id_fragment.data());

    decltype(Traits::encoding(input)) in_encoding = Traits::encoding(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->encoding)::BaseType> encoding_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_encoding,
      encoding_fragment);

    fragment->encoding.Set(
        encoding_fragment.is_null() ? nullptr : encoding_fragment.data());

    decltype(Traits::lang(input)) in_lang = Traits::lang(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->lang)::BaseType> lang_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_lang,
      lang_fragment);

    fragment->lang.Set(
        lang_fragment.is_null() ? nullptr : lang_fragment.data());

    decltype(Traits::data(input)) in_data = Traits::data(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->data)::BaseType>
        data_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& data_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<uint8_t>>(
      in_data,
      data_fragment,
      &data_validate_params);

    fragment->data.Set(
        data_fragment.is_null() ? nullptr : data_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->data.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null data in NDEFRecord struct");

    decltype(Traits::payload_message(input)) in_payload_message = Traits::payload_message(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->payload_message)::BaseType> payload_message_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::device::mojom::NDEFMessageDataView>(
      in_payload_message,
      payload_message_fragment);

    fragment->payload_message.Set(
        payload_message_fragment.is_null() ? nullptr : payload_message_fragment.data());
  }

  static bool Deserialize(::device::mojom::internal::NDEFRecord_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::device::mojom::NDEFRecordDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::device::mojom::NDEFMessageDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::device::mojom::NDEFMessageDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::device::mojom::internal::NDEFMessage_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::data(input)) in_data = Traits::data(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->data)::BaseType>
        data_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& data_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<::device::mojom::NDEFRecordDataView>>(
      in_data,
      data_fragment,
      &data_validate_params);

    fragment->data.Set(
        data_fragment.is_null() ? nullptr : data_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->data.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null data in NDEFMessage struct");
  }

  static bool Deserialize(::device::mojom::internal::NDEFMessage_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::device::mojom::NDEFMessageDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::device::mojom::NDEFWriteOptionsDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::device::mojom::NDEFWriteOptionsDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::device::mojom::internal::NDEFWriteOptions_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    fragment->overwrite = Traits::overwrite(input);
  }

  static bool Deserialize(::device::mojom::internal::NDEFWriteOptions_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::device::mojom::NDEFWriteOptionsDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace device::mojom {

inline void NDEFErrorDataView::GetErrorMessageDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->error_message.Get();
  *output = mojo::StringDataView(pointer, message_);
}


inline void NDEFRecordDataView::GetRecordTypeDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->record_type.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void NDEFRecordDataView::GetMediaTypeDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->media_type.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void NDEFRecordDataView::GetIdDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->id.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void NDEFRecordDataView::GetEncodingDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->encoding.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void NDEFRecordDataView::GetLangDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->lang.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void NDEFRecordDataView::GetDataDataView(
    mojo::ArrayDataView<uint8_t>* output) {
  auto pointer = data_->data.Get();
  *output = mojo::ArrayDataView<uint8_t>(pointer, message_);
}
inline void NDEFRecordDataView::GetPayloadMessageDataView(
    NDEFMessageDataView* output) {
  auto pointer = data_->payload_message.Get();
  *output = NDEFMessageDataView(pointer, message_);
}


inline void NDEFMessageDataView::GetDataDataView(
    mojo::ArrayDataView<NDEFRecordDataView>* output) {
  auto pointer = data_->data.Get();
  *output = mojo::ArrayDataView<NDEFRecordDataView>(pointer, message_);
}





}  // device::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

namespace perfetto {

template <>
struct  TraceFormatTraits<::device::mojom::NDEFErrorType> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::device::mojom::NDEFErrorType value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct  TraceFormatTraits<::device::mojom::NDEFRecordTypeCategory> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::device::mojom::NDEFRecordTypeCategory value);
};

} // namespace perfetto

#endif  // SERVICES_DEVICE_PUBLIC_MOJOM_NFC_MOJOM_SHARED_H_