// services/network/public/mojom/cookie_manager.mojom-data-view.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_NETWORK_PUBLIC_MOJOM_COOKIE_MANAGER_MOJOM_DATA_VIEW_H_
#define SERVICES_NETWORK_PUBLIC_MOJOM_COOKIE_MANAGER_MOJOM_DATA_VIEW_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "services/network/public/mojom/cookie_manager.mojom-shared-internal.h"
#include "components/content_settings/core/common/content_settings.mojom-shared.h"
#include "components/content_settings/core/common/content_settings_types.mojom-shared.h"
#include "mojo/public/mojom/base/time.mojom-shared.h"
#include "sandbox/policy/mojom/context.mojom-shared.h"
#include "services/network/public/mojom/cookie_partition_key.mojom-shared.h"
#include "services/network/public/mojom/first_party_sets.mojom-shared.h"
#include "services/network/public/mojom/schemeful_site.mojom-shared.h"
#include "services/network/public/mojom/site_for_cookies.mojom-shared.h"
#include "url/mojom/url.mojom-shared.h"


namespace network::mojom {
class CookieManagerParamsDataView;

class CookieSameSiteContextMetadataDataView;

class CookieSameSiteContextDataView;

class CookieOptionsDataView;

class CanonicalCookieDataView;

class ExclusionReasonsDataView;

class WarningReasonsDataView;

class CookieInclusionStatusDataView;

class CookieAndLineWithAccessResultDataView;

class CookieOrLineWithAccessResultDataView;

class CookieAccessResultDataView;

class CookieWithAccessResultDataView;

class CookieChangeInfoDataView;

class CookieDeletionFilterDataView;

class CookieOrLineDataView;


}  // network::mojom


namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::network::mojom::CookieManagerParamsDataView> {
  using Data = ::network::mojom::internal::CookieManagerParams_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::network::mojom::CookieSameSiteContextMetadataDataView> {
  using Data = ::network::mojom::internal::CookieSameSiteContextMetadata_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::network::mojom::CookieSameSiteContextDataView> {
  using Data = ::network::mojom::internal::CookieSameSiteContext_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::network::mojom::CookieOptionsDataView> {
  using Data = ::network::mojom::internal::CookieOptions_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::network::mojom::CanonicalCookieDataView> {
  using Data = ::network::mojom::internal::CanonicalCookie_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::network::mojom::ExclusionReasonsDataView> {
  using Data = ::network::mojom::internal::ExclusionReasons_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::network::mojom::WarningReasonsDataView> {
  using Data = ::network::mojom::internal::WarningReasons_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::network::mojom::CookieInclusionStatusDataView> {
  using Data = ::network::mojom::internal::CookieInclusionStatus_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::network::mojom::CookieAndLineWithAccessResultDataView> {
  using Data = ::network::mojom::internal::CookieAndLineWithAccessResult_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::network::mojom::CookieOrLineWithAccessResultDataView> {
  using Data = ::network::mojom::internal::CookieOrLineWithAccessResult_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::network::mojom::CookieAccessResultDataView> {
  using Data = ::network::mojom::internal::CookieAccessResult_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::network::mojom::CookieWithAccessResultDataView> {
  using Data = ::network::mojom::internal::CookieWithAccessResult_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::network::mojom::CookieChangeInfoDataView> {
  using Data = ::network::mojom::internal::CookieChangeInfo_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::network::mojom::CookieDeletionFilterDataView> {
  using Data = ::network::mojom::internal::CookieDeletionFilter_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::network::mojom::CookieOrLineDataView> {
  using Data = ::network::mojom::internal::CookieOrLine_Data;
  using DataAsArrayElement = Data;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kUnion;
};

}  // namespace internal
}  // namespace mojo


namespace network::mojom {


enum class CookieAccessDelegateType : int32_t {
  
  USE_CONTENT_SETTINGS = 0,
  
  ALWAYS_LEGACY = 1,
  
  ALWAYS_NONLEGACY = 2,
  kMinValue = 0,
  kMaxValue = 2,
};

 std::ostream& operator<<(std::ostream& os, CookieAccessDelegateType value);
inline bool IsKnownEnumValue(CookieAccessDelegateType value) {
  return internal::CookieAccessDelegateType_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class CookiePriority : int32_t {
  
  LOW = 0,
  
  MEDIUM = 1,
  
  HIGH = 2,
  kMinValue = 0,
  kMaxValue = 2,
};

 std::ostream& operator<<(std::ostream& os, CookiePriority value);
inline bool IsKnownEnumValue(CookiePriority value) {
  return internal::CookiePriority_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class CookieSourceScheme : int32_t {
  
  kUnset = 0,
  
  kNonSecure = 1,
  
  kSecure = 2,
  kMinValue = 0,
  kMaxValue = 2,
};

 std::ostream& operator<<(std::ostream& os, CookieSourceScheme value);
inline bool IsKnownEnumValue(CookieSourceScheme value) {
  return internal::CookieSourceScheme_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class CookieSameSite : int32_t {
  
  UNSPECIFIED = -1,
  
  NO_RESTRICTION = 0,
  
  LAX_MODE = 1,
  
  STRICT_MODE = 2,
  kMinValue = -1,
  kMaxValue = 2,
};

 std::ostream& operator<<(std::ostream& os, CookieSameSite value);
inline bool IsKnownEnumValue(CookieSameSite value) {
  return internal::CookieSameSite_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class CookieEffectiveSameSite : int32_t {
  
  kNoRestriction = 0,
  
  kLaxMode = 1,
  
  kStrictMode = 2,
  
  kLaxModeAllowUnsafe = 3,
  
  kUndefined = 4,
  kMinValue = 0,
  kMaxValue = 4,
};

 std::ostream& operator<<(std::ostream& os, CookieEffectiveSameSite value);
inline bool IsKnownEnumValue(CookieEffectiveSameSite value) {
  return internal::CookieEffectiveSameSite_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class CookieExemptionReason : int32_t {
  
  kNone = 0,
  
  kUserSetting = 1,
  
  k3PCDMetadata = 2,
  
  k3PCDDeprecationTrial = 3,
  
  kTopLevel3PCDDeprecationTrial = 4,
  
  k3PCDHeuristics = 5,
  
  kEnterprisePolicy = 6,
  
  kStorageAccess = 7,
  
  kTopLevelStorageAccess = 8,
  
  kScheme = 9,
  
  kSameSiteNoneCookiesInSandbox = 10,
  kMinValue = 0,
  kMaxValue = 10,
};

 std::ostream& operator<<(std::ostream& os, CookieExemptionReason value);
inline bool IsKnownEnumValue(CookieExemptionReason value) {
  return internal::CookieExemptionReason_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class ContextType : int32_t {
  
  CROSS_SITE = 0,
  
  SAME_SITE_LAX_METHOD_UNSAFE = 1,
  
  SAME_SITE_LAX = 2,
  
  SAME_SITE_STRICT = 3,
  kMinValue = 0,
  kMaxValue = 3,
};

 std::ostream& operator<<(std::ostream& os, ContextType value);
inline bool IsKnownEnumValue(ContextType value) {
  return internal::ContextType_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class CookieSameSiteContextMetadataDowngradeType : int32_t {
  
  kNoDowngrade = 0,
  
  kStrictToLax = 1,
  
  kStrictToCross = 2,
  
  kLaxToCross = 3,
  kMinValue = 0,
  kMaxValue = 3,
};

 std::ostream& operator<<(std::ostream& os, CookieSameSiteContextMetadataDowngradeType value);
inline bool IsKnownEnumValue(CookieSameSiteContextMetadataDowngradeType value) {
  return internal::CookieSameSiteContextMetadataDowngradeType_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class CookieSourceType : int32_t {
  
  kUnknown = 0,
  
  kHTTP = 1,
  
  kScript = 2,
  
  kOther = 3,
  kMinValue = 0,
  kMaxValue = 3,
};

 std::ostream& operator<<(std::ostream& os, CookieSourceType value);
inline bool IsKnownEnumValue(CookieSourceType value) {
  return internal::CookieSourceType_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class ContextRedirectTypeBug1221316 : int32_t {
  
  kUnset = 0,
  
  kNoRedirect = 1,
  
  kCrossSiteRedirect = 2,
  
  kPartialSameSiteRedirect = 3,
  
  kAllSameSiteRedirect = 4,
  kMinValue = 0,
  kMaxValue = 4,
};

 std::ostream& operator<<(std::ostream& os, ContextRedirectTypeBug1221316 value);
inline bool IsKnownEnumValue(ContextRedirectTypeBug1221316 value) {
  return internal::ContextRedirectTypeBug1221316_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class HttpMethod : int32_t {
  
  kUnset = 0,
  
  kUnknown = 1,
  
  kGet = 2,
  
  kHead = 3,
  
  kPost = 4,
  
  KPut = 5,
  
  kDelete = 6,
  
  kConnect = 7,
  
  kOptions = 8,
  
  kTrace = 9,
  
  kPatch = 10,
  kMinValue = 0,
  kMaxValue = 10,
};

 std::ostream& operator<<(std::ostream& os, HttpMethod value);
inline bool IsKnownEnumValue(HttpMethod value) {
  return internal::HttpMethod_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class CookieAccessSemantics : int32_t {
  
  UNKNOWN = -1,
  
  NONLEGACY = 0,
  
  LEGACY = 1,
  kMinValue = -1,
  kMaxValue = 1,
};

 std::ostream& operator<<(std::ostream& os, CookieAccessSemantics value);
inline bool IsKnownEnumValue(CookieAccessSemantics value) {
  return internal::CookieAccessSemantics_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class CookieScopeSemantics : int32_t {
  
  UNKNOWN = -1,
  
  NONLEGACY = 0,
  
  LEGACY = 1,
  kMinValue = -1,
  kMaxValue = 1,
};

 std::ostream& operator<<(std::ostream& os, CookieScopeSemantics value);
inline bool IsKnownEnumValue(CookieScopeSemantics value) {
  return internal::CookieScopeSemantics_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class CookieChangeCause : int32_t {
  
  INSERTED = 0,
  
  EXPLICIT = 1,
  
  UNKNOWN_DELETION = 2,
  
  OVERWRITE = 3,
  
  EXPIRED = 4,
  
  EVICTED = 5,
  
  EXPIRED_OVERWRITE = 6,
  
  INSERTED_NO_CHANGE_OVERWRITE = 7,
  kMinValue = 0,
  kMaxValue = 7,
};

 std::ostream& operator<<(std::ostream& os, CookieChangeCause value);
inline bool IsKnownEnumValue(CookieChangeCause value) {
  return internal::CookieChangeCause_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class CookieDeletionSessionControl : int32_t {
  
  IGNORE_CONTROL = 0,
  
  SESSION_COOKIES = 1,
  
  PERSISTENT_COOKIES = 2,
  kMinValue = 0,
  kMaxValue = 2,
};

 std::ostream& operator<<(std::ostream& os, CookieDeletionSessionControl value);
inline bool IsKnownEnumValue(CookieDeletionSessionControl value) {
  return internal::CookieDeletionSessionControl_Data::IsKnownValue(
      static_cast<int32_t>(value));
}
// Interface base classes. They are used for type safety check.
class CookieChangeListenerInterfaceBase {};

using CookieChangeListenerPtrDataView =
    mojo::InterfacePtrDataView<CookieChangeListenerInterfaceBase>;
using CookieChangeListenerRequestDataView =
    mojo::InterfaceRequestDataView<CookieChangeListenerInterfaceBase>;
using CookieChangeListenerAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<CookieChangeListenerInterfaceBase>;
using CookieChangeListenerAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<CookieChangeListenerInterfaceBase>;
class CookieRemoteAccessFilterInterfaceBase {};

using CookieRemoteAccessFilterPtrDataView =
    mojo::InterfacePtrDataView<CookieRemoteAccessFilterInterfaceBase>;
using CookieRemoteAccessFilterRequestDataView =
    mojo::InterfaceRequestDataView<CookieRemoteAccessFilterInterfaceBase>;
using CookieRemoteAccessFilterAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<CookieRemoteAccessFilterInterfaceBase>;
using CookieRemoteAccessFilterAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<CookieRemoteAccessFilterInterfaceBase>;
class CookieManagerInterfaceBase {};

using CookieManagerPtrDataView =
    mojo::InterfacePtrDataView<CookieManagerInterfaceBase>;
using CookieManagerRequestDataView =
    mojo::InterfaceRequestDataView<CookieManagerInterfaceBase>;
using CookieManagerAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<CookieManagerInterfaceBase>;
using CookieManagerAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<CookieManagerInterfaceBase>;


class CookieManagerParamsDataView {
 public:
  CookieManagerParamsDataView() = default;

  CookieManagerParamsDataView(
      internal::CookieManagerParams_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  bool block_third_party_cookies() const {
    return data_->block_third_party_cookies;
  }
  bool tracking_protection_enabled_for_3pcd() const {
    return data_->tracking_protection_enabled_for_3pcd;
  }
  bool mitigations_enabled_for_3pcd() const {
    return data_->mitigations_enabled_for_3pcd;
  }
  inline void GetContentSettingsDataView(
      mojo::MapDataView<::content_settings::mojom::ContentSettingsType, mojo::ArrayDataView<::content_settings::mojom::ContentSettingPatternSourceDataView>>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadContentSettings(UserType* output) {
    
    auto* pointer = data_->content_settings.Get();
    return mojo::internal::Deserialize<mojo::MapDataView<::content_settings::mojom::ContentSettingsType, mojo::ArrayDataView<::content_settings::mojom::ContentSettingPatternSourceDataView>>>(
        pointer, output, message_);
  }
  inline void GetSecureOriginCookiesAllowedSchemesDataView(
      mojo::ArrayDataView<mojo::StringDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSecureOriginCookiesAllowedSchemes(UserType* output) {
    
    auto* pointer = data_->secure_origin_cookies_allowed_schemes.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<mojo::StringDataView>>(
        pointer, output, message_);
  }
  inline void GetMatchingSchemeCookiesAllowedSchemesDataView(
      mojo::ArrayDataView<mojo::StringDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadMatchingSchemeCookiesAllowedSchemes(UserType* output) {
    
    auto* pointer = data_->matching_scheme_cookies_allowed_schemes.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<mojo::StringDataView>>(
        pointer, output, message_);
  }
  inline void GetThirdPartyCookiesAllowedSchemesDataView(
      mojo::ArrayDataView<mojo::StringDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadThirdPartyCookiesAllowedSchemes(UserType* output) {
    
    auto* pointer = data_->third_party_cookies_allowed_schemes.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<mojo::StringDataView>>(
        pointer, output, message_);
  }
  bool allow_file_scheme_cookies() const {
    return data_->allow_file_scheme_cookies;
  }
  template <typename UserType>
  [[nodiscard]] bool ReadCookieAccessDelegateType(UserType* output) const {
    auto data_value = data_->cookie_access_delegate_type;
    return mojo::internal::Deserialize<::network::mojom::CookieAccessDelegateType>(
        data_value, output);
  }
  CookieAccessDelegateType cookie_access_delegate_type() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::network::mojom::CookieAccessDelegateType>(data_->cookie_access_delegate_type));
  }
 private:
  internal::CookieManagerParams_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class CookieSameSiteContextMetadataDataView {
 public:
  CookieSameSiteContextMetadataDataView() = default;

  CookieSameSiteContextMetadataDataView(
      internal::CookieSameSiteContextMetadata_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  [[nodiscard]] bool ReadCrossSiteRedirectDowngrade(UserType* output) const {
    auto data_value = data_->cross_site_redirect_downgrade;
    return mojo::internal::Deserialize<::network::mojom::CookieSameSiteContextMetadataDowngradeType>(
        data_value, output);
  }
  CookieSameSiteContextMetadataDowngradeType cross_site_redirect_downgrade() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::network::mojom::CookieSameSiteContextMetadataDowngradeType>(data_->cross_site_redirect_downgrade));
  }
  template <typename UserType>
  [[nodiscard]] bool ReadRedirectTypeBug1221316(UserType* output) const {
    auto data_value = data_->redirect_type_bug_1221316;
    return mojo::internal::Deserialize<::network::mojom::ContextRedirectTypeBug1221316>(
        data_value, output);
  }
  ContextRedirectTypeBug1221316 redirect_type_bug_1221316() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::network::mojom::ContextRedirectTypeBug1221316>(data_->redirect_type_bug_1221316));
  }
 private:
  internal::CookieSameSiteContextMetadata_Data* data_ = nullptr;
};


class CookieSameSiteContextDataView {
 public:
  CookieSameSiteContextDataView() = default;

  CookieSameSiteContextDataView(
      internal::CookieSameSiteContext_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  [[nodiscard]] bool ReadContext(UserType* output) const {
    auto data_value = data_->context;
    return mojo::internal::Deserialize<::network::mojom::ContextType>(
        data_value, output);
  }
  ContextType context() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::network::mojom::ContextType>(data_->context));
  }
  template <typename UserType>
  [[nodiscard]] bool ReadSchemefulContext(UserType* output) const {
    auto data_value = data_->schemeful_context;
    return mojo::internal::Deserialize<::network::mojom::ContextType>(
        data_value, output);
  }
  ContextType schemeful_context() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::network::mojom::ContextType>(data_->schemeful_context));
  }
  inline void GetMetadataDataView(
      CookieSameSiteContextMetadataDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadMetadata(UserType* output) {
    
    auto* pointer = data_->metadata.Get();
    return mojo::internal::Deserialize<::network::mojom::CookieSameSiteContextMetadataDataView>(
        pointer, output, message_);
  }
  inline void GetSchemefulMetadataDataView(
      CookieSameSiteContextMetadataDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSchemefulMetadata(UserType* output) {
    
    auto* pointer = data_->schemeful_metadata.Get();
    return mojo::internal::Deserialize<::network::mojom::CookieSameSiteContextMetadataDataView>(
        pointer, output, message_);
  }
 private:
  internal::CookieSameSiteContext_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class CookieOptionsDataView {
 public:
  CookieOptionsDataView() = default;

  CookieOptionsDataView(
      internal::CookieOptions_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  bool exclude_httponly() const {
    return data_->exclude_httponly;
  }
  inline void GetSameSiteCookieContextDataView(
      CookieSameSiteContextDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSameSiteCookieContext(UserType* output) {
    
    auto* pointer = data_->same_site_cookie_context.Get();
    return mojo::internal::Deserialize<::network::mojom::CookieSameSiteContextDataView>(
        pointer, output, message_);
  }
  bool update_access_time() const {
    return data_->update_access_time;
  }
  bool return_excluded_cookies() const {
    return data_->return_excluded_cookies;
  }
 private:
  internal::CookieOptions_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class CanonicalCookieDataView {
 public:
  CanonicalCookieDataView() = default;

  CanonicalCookieDataView(
      internal::CanonicalCookie_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetNameDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadName(UserType* output) {
    
    auto* pointer = data_->name.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetValueDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadValue(UserType* output) {
    
    auto* pointer = data_->value.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetDomainDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDomain(UserType* output) {
    
    auto* pointer = data_->domain.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetPathDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPath(UserType* output) {
    
    auto* pointer = data_->path.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetCreationDataView(
      ::mojo_base::mojom::TimeDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadCreation(UserType* output) {
    
    auto* pointer = data_->creation.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeDataView>(
        pointer, output, message_);
  }
  inline void GetExpiryDataView(
      ::mojo_base::mojom::TimeDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadExpiry(UserType* output) {
    
    auto* pointer = data_->expiry.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeDataView>(
        pointer, output, message_);
  }
  inline void GetLastAccessDataView(
      ::mojo_base::mojom::TimeDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadLastAccess(UserType* output) {
    
    auto* pointer = data_->last_access.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeDataView>(
        pointer, output, message_);
  }
  inline void GetLastUpdateDataView(
      ::mojo_base::mojom::TimeDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadLastUpdate(UserType* output) {
    
    auto* pointer = data_->last_update.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeDataView>(
        pointer, output, message_);
  }
  bool secure() const {
    return data_->secure;
  }
  bool httponly() const {
    return data_->httponly;
  }
  template <typename UserType>
  [[nodiscard]] bool ReadSiteRestrictions(UserType* output) const {
    auto data_value = data_->site_restrictions;
    return mojo::internal::Deserialize<::network::mojom::CookieSameSite>(
        data_value, output);
  }
  CookieSameSite site_restrictions() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::network::mojom::CookieSameSite>(data_->site_restrictions));
  }
  template <typename UserType>
  [[nodiscard]] bool ReadPriority(UserType* output) const {
    auto data_value = data_->priority;
    return mojo::internal::Deserialize<::network::mojom::CookiePriority>(
        data_value, output);
  }
  CookiePriority priority() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::network::mojom::CookiePriority>(data_->priority));
  }
  template <typename UserType>
  [[nodiscard]] bool ReadSourceScheme(UserType* output) const {
    auto data_value = data_->source_scheme;
    return mojo::internal::Deserialize<::network::mojom::CookieSourceScheme>(
        data_value, output);
  }
  CookieSourceScheme source_scheme() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::network::mojom::CookieSourceScheme>(data_->source_scheme));
  }
  inline void GetPartitionKeyDataView(
      ::network::mojom::CookiePartitionKeyDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPartitionKey(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::network::mojom::CookiePartitionKeyDataView, UserType>(),
    "Attempting to read the optional `partition_key` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadPartitionKey` instead "
    "of `ReadPartitionKey if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->partition_key.Get();
    return mojo::internal::Deserialize<::network::mojom::CookiePartitionKeyDataView>(
        pointer, output, message_);
  }
  int32_t source_port() const {
    return data_->source_port;
  }
  template <typename UserType>
  [[nodiscard]] bool ReadSourceType(UserType* output) const {
    auto data_value = data_->source_type;
    return mojo::internal::Deserialize<::network::mojom::CookieSourceType>(
        data_value, output);
  }
  CookieSourceType source_type() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::network::mojom::CookieSourceType>(data_->source_type));
  }
 private:
  internal::CanonicalCookie_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class ExclusionReasonsDataView {
 public:
  ExclusionReasonsDataView() = default;

  ExclusionReasonsDataView(
      internal::ExclusionReasons_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  uint64_t exclusions_bitmask() const {
    return data_->exclusions_bitmask;
  }
 private:
  internal::ExclusionReasons_Data* data_ = nullptr;
};


class WarningReasonsDataView {
 public:
  WarningReasonsDataView() = default;

  WarningReasonsDataView(
      internal::WarningReasons_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  uint64_t warnings_bitmask() const {
    return data_->warnings_bitmask;
  }
 private:
  internal::WarningReasons_Data* data_ = nullptr;
};


class CookieInclusionStatusDataView {
 public:
  CookieInclusionStatusDataView() = default;

  CookieInclusionStatusDataView(
      internal::CookieInclusionStatus_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetExclusionReasonsDataView(
      ExclusionReasonsDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadExclusionReasons(UserType* output) {
    
    auto* pointer = data_->exclusion_reasons.Get();
    return mojo::internal::Deserialize<::network::mojom::ExclusionReasonsDataView>(
        pointer, output, message_);
  }
  inline void GetWarningReasonsDataView(
      WarningReasonsDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadWarningReasons(UserType* output) {
    
    auto* pointer = data_->warning_reasons.Get();
    return mojo::internal::Deserialize<::network::mojom::WarningReasonsDataView>(
        pointer, output, message_);
  }
  template <typename UserType>
  [[nodiscard]] bool ReadExemptionReason(UserType* output) const {
    auto data_value = data_->exemption_reason;
    return mojo::internal::Deserialize<::network::mojom::CookieExemptionReason>(
        data_value, output);
  }
  CookieExemptionReason exemption_reason() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::network::mojom::CookieExemptionReason>(data_->exemption_reason));
  }
 private:
  internal::CookieInclusionStatus_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class CookieAndLineWithAccessResultDataView {
 public:
  CookieAndLineWithAccessResultDataView() = default;

  CookieAndLineWithAccessResultDataView(
      internal::CookieAndLineWithAccessResult_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetCookieDataView(
      CanonicalCookieDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadCookie(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::network::mojom::CanonicalCookieDataView, UserType>(),
    "Attempting to read the optional `cookie` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadCookie` instead "
    "of `ReadCookie if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->cookie.Get();
    return mojo::internal::Deserialize<::network::mojom::CanonicalCookieDataView>(
        pointer, output, message_);
  }
  inline void GetCookieStringDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadCookieString(UserType* output) {
    
    auto* pointer = data_->cookie_string.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetAccessResultDataView(
      CookieAccessResultDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadAccessResult(UserType* output) {
    
    auto* pointer = data_->access_result.Get();
    return mojo::internal::Deserialize<::network::mojom::CookieAccessResultDataView>(
        pointer, output, message_);
  }
 private:
  internal::CookieAndLineWithAccessResult_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class CookieOrLineWithAccessResultDataView {
 public:
  CookieOrLineWithAccessResultDataView() = default;

  CookieOrLineWithAccessResultDataView(
      internal::CookieOrLineWithAccessResult_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetCookieOrLineDataView(
      CookieOrLineDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadCookieOrLine(UserType* output) {
    
    auto* pointer = !data_->cookie_or_line.is_null() ? &data_->cookie_or_line : nullptr;
    return mojo::internal::Deserialize<::network::mojom::CookieOrLineDataView>(
        pointer, output, message_);
  }
  inline void GetAccessResultDataView(
      CookieAccessResultDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadAccessResult(UserType* output) {
    
    auto* pointer = data_->access_result.Get();
    return mojo::internal::Deserialize<::network::mojom::CookieAccessResultDataView>(
        pointer, output, message_);
  }
 private:
  internal::CookieOrLineWithAccessResult_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class CookieAccessResultDataView {
 public:
  CookieAccessResultDataView() = default;

  CookieAccessResultDataView(
      internal::CookieAccessResult_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  [[nodiscard]] bool ReadEffectiveSameSite(UserType* output) const {
    auto data_value = data_->effective_same_site;
    return mojo::internal::Deserialize<::network::mojom::CookieEffectiveSameSite>(
        data_value, output);
  }
  CookieEffectiveSameSite effective_same_site() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::network::mojom::CookieEffectiveSameSite>(data_->effective_same_site));
  }
  template <typename UserType>
  [[nodiscard]] bool ReadAccessSemantics(UserType* output) const {
    auto data_value = data_->access_semantics;
    return mojo::internal::Deserialize<::network::mojom::CookieAccessSemantics>(
        data_value, output);
  }
  CookieAccessSemantics access_semantics() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::network::mojom::CookieAccessSemantics>(data_->access_semantics));
  }
  template <typename UserType>
  [[nodiscard]] bool ReadScopeSemantics(UserType* output) const {
    auto data_value = data_->scope_semantics;
    return mojo::internal::Deserialize<::network::mojom::CookieScopeSemantics>(
        data_value, output);
  }
  CookieScopeSemantics scope_semantics() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::network::mojom::CookieScopeSemantics>(data_->scope_semantics));
  }
  inline void GetStatusDataView(
      CookieInclusionStatusDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadStatus(UserType* output) {
    
    auto* pointer = data_->status.Get();
    return mojo::internal::Deserialize<::network::mojom::CookieInclusionStatusDataView>(
        pointer, output, message_);
  }
  bool is_allowed_to_access_secure_cookies() const {
    return data_->is_allowed_to_access_secure_cookies;
  }
 private:
  internal::CookieAccessResult_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class CookieWithAccessResultDataView {
 public:
  CookieWithAccessResultDataView() = default;

  CookieWithAccessResultDataView(
      internal::CookieWithAccessResult_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetCookieDataView(
      CanonicalCookieDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadCookie(UserType* output) {
    
    auto* pointer = data_->cookie.Get();
    return mojo::internal::Deserialize<::network::mojom::CanonicalCookieDataView>(
        pointer, output, message_);
  }
  inline void GetAccessResultDataView(
      CookieAccessResultDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadAccessResult(UserType* output) {
    
    auto* pointer = data_->access_result.Get();
    return mojo::internal::Deserialize<::network::mojom::CookieAccessResultDataView>(
        pointer, output, message_);
  }
 private:
  internal::CookieWithAccessResult_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class CookieChangeInfoDataView {
 public:
  CookieChangeInfoDataView() = default;

  CookieChangeInfoDataView(
      internal::CookieChangeInfo_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetCookieDataView(
      CanonicalCookieDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadCookie(UserType* output) {
    
    auto* pointer = data_->cookie.Get();
    return mojo::internal::Deserialize<::network::mojom::CanonicalCookieDataView>(
        pointer, output, message_);
  }
  inline void GetAccessResultDataView(
      CookieAccessResultDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadAccessResult(UserType* output) {
    
    auto* pointer = data_->access_result.Get();
    return mojo::internal::Deserialize<::network::mojom::CookieAccessResultDataView>(
        pointer, output, message_);
  }
  template <typename UserType>
  [[nodiscard]] bool ReadCause(UserType* output) const {
    auto data_value = data_->cause;
    return mojo::internal::Deserialize<::network::mojom::CookieChangeCause>(
        data_value, output);
  }
  CookieChangeCause cause() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::network::mojom::CookieChangeCause>(data_->cause));
  }
 private:
  internal::CookieChangeInfo_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class CookieDeletionFilterDataView {
 public:
  CookieDeletionFilterDataView() = default;

  CookieDeletionFilterDataView(
      internal::CookieDeletionFilter_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetCreatedAfterTimeDataView(
      ::mojo_base::mojom::TimeDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadCreatedAfterTime(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::mojo_base::mojom::TimeDataView, UserType>(),
    "Attempting to read the optional `created_after_time` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadCreatedAfterTime` instead "
    "of `ReadCreatedAfterTime if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->created_after_time.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeDataView>(
        pointer, output, message_);
  }
  inline void GetCreatedBeforeTimeDataView(
      ::mojo_base::mojom::TimeDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadCreatedBeforeTime(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::mojo_base::mojom::TimeDataView, UserType>(),
    "Attempting to read the optional `created_before_time` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadCreatedBeforeTime` instead "
    "of `ReadCreatedBeforeTime if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->created_before_time.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeDataView>(
        pointer, output, message_);
  }
  inline void GetExcludingDomainsDataView(
      mojo::ArrayDataView<mojo::StringDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadExcludingDomains(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::ArrayDataView<mojo::StringDataView>, UserType>(),
    "Attempting to read the optional `excluding_domains` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadExcludingDomains` instead "
    "of `ReadExcludingDomains if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->excluding_domains.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<mojo::StringDataView>>(
        pointer, output, message_);
  }
  inline void GetIncludingDomainsDataView(
      mojo::ArrayDataView<mojo::StringDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadIncludingDomains(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::ArrayDataView<mojo::StringDataView>, UserType>(),
    "Attempting to read the optional `including_domains` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadIncludingDomains` instead "
    "of `ReadIncludingDomains if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->including_domains.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<mojo::StringDataView>>(
        pointer, output, message_);
  }
  inline void GetCookieNameDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadCookieName(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::StringDataView, UserType>(),
    "Attempting to read the optional `cookie_name` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadCookieName` instead "
    "of `ReadCookieName if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->cookie_name.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetHostNameDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadHostName(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::StringDataView, UserType>(),
    "Attempting to read the optional `host_name` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadHostName` instead "
    "of `ReadHostName if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->host_name.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetUrlDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadUrl(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::url::mojom::UrlDataView, UserType>(),
    "Attempting to read the optional `url` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadUrl` instead "
    "of `ReadUrl if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->url.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, message_);
  }
  template <typename UserType>
  [[nodiscard]] bool ReadSessionControl(UserType* output) const {
    auto data_value = data_->session_control;
    return mojo::internal::Deserialize<::network::mojom::CookieDeletionSessionControl>(
        data_value, output);
  }
  CookieDeletionSessionControl session_control() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::network::mojom::CookieDeletionSessionControl>(data_->session_control));
  }
  inline void GetCookiePartitionKeyCollectionDataView(
      ::network::mojom::CookiePartitionKeyCollectionDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadCookiePartitionKeyCollection(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::network::mojom::CookiePartitionKeyCollectionDataView, UserType>(),
    "Attempting to read the optional `cookie_partition_key_collection` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadCookiePartitionKeyCollection` instead "
    "of `ReadCookiePartitionKeyCollection if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->cookie_partition_key_collection.Get();
    return mojo::internal::Deserialize<::network::mojom::CookiePartitionKeyCollectionDataView>(
        pointer, output, message_);
  }
  bool partitioned_state_only() const {
    return data_->partitioned_state_only;
  }
 private:
  internal::CookieDeletionFilter_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class CookieOrLineDataView {
 public:
  using Tag = internal::CookieOrLine_Data::CookieOrLine_Tag;

  CookieOrLineDataView() = default;

  CookieOrLineDataView(
      internal::CookieOrLine_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const {
    // For inlined unions, |data_| is always non-null. In that case we need to
    // check |data_->is_null()|.
    return !data_ || data_->is_null();
  }

  Tag tag() const { return data_->tag; }
  bool is_cookie() const { return data_->tag == Tag::kCookie; }
  inline void GetCookieDataView(
      CanonicalCookieDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadCookie(UserType* output) const {
    
    CHECK(is_cookie());
    return mojo::internal::Deserialize<::network::mojom::CanonicalCookieDataView>(
        data_->data.f_cookie.Get(), output, message_);
  }
  bool is_cookie_string() const { return data_->tag == Tag::kCookieString; }
  inline void GetCookieStringDataView(
      mojo::StringDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadCookieString(UserType* output) const {
    
    CHECK(is_cookie_string());
    return mojo::internal::Deserialize<mojo::StringDataView>(
        data_->data.f_cookie_string.Get(), output, message_);
  }

 private:
  internal::CookieOrLine_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};



}  // network::mojom

#endif  // SERVICES_NETWORK_PUBLIC_MOJOM_COOKIE_MANAGER_MOJOM_DATA_VIEW_H_