// services/network/public/mojom/host_resolver.mojom-data-view.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_NETWORK_PUBLIC_MOJOM_HOST_RESOLVER_MOJOM_DATA_VIEW_H_
#define SERVICES_NETWORK_PUBLIC_MOJOM_HOST_RESOLVER_MOJOM_DATA_VIEW_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "services/network/public/mojom/host_resolver.mojom-shared-internal.h"
#include "mojo/public/mojom/base/time.mojom-shared.h"
#include "services/network/public/mojom/address_list.mojom-shared.h"
#include "services/network/public/mojom/host_resolver_endpoint_result.mojom-shared.h"
#include "services/network/public/mojom/ip_address.mojom-shared.h"
#include "services/network/public/mojom/ip_endpoint.mojom-shared.h"
#include "services/network/public/mojom/network_anonymization_key.mojom-shared.h"
#include "services/network/public/mojom/network_param.mojom-shared.h"
#include "services/network/public/mojom/request_priority.mojom-shared.h"
#include "url/mojom/scheme_host_port.mojom-shared.h"


namespace network::mojom {
class DnsOverHttpsServerConfigDataView;

class DnsOverHttpsConfigDataView;

class DnsConfigOverridesDataView;

class ResolveHostParametersDataView;

class HostResolverHostDataView;


}  // network::mojom


namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::network::mojom::DnsOverHttpsServerConfigDataView> {
  using Data = ::network::mojom::internal::DnsOverHttpsServerConfig_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::network::mojom::DnsOverHttpsConfigDataView> {
  using Data = ::network::mojom::internal::DnsOverHttpsConfig_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::network::mojom::DnsConfigOverridesDataView> {
  using Data = ::network::mojom::internal::DnsConfigOverrides_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::network::mojom::ResolveHostParametersDataView> {
  using Data = ::network::mojom::internal::ResolveHostParameters_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::network::mojom::HostResolverHostDataView> {
  using Data = ::network::mojom::internal::HostResolverHost_Data;
  using DataAsArrayElement = Data;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kUnion;
};

}  // namespace internal
}  // namespace mojo


namespace network::mojom {


enum class OptionalSecureDnsMode : int32_t {
  
  NO_OVERRIDE = 0,
  
  OFF = 1,
  
  AUTOMATIC = 2,
  
  SECURE = 3,
  kMinValue = 0,
  kMaxValue = 3,
};

 std::ostream& operator<<(std::ostream& os, OptionalSecureDnsMode value);
inline bool IsKnownEnumValue(OptionalSecureDnsMode value) {
  return internal::OptionalSecureDnsMode_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class SecureDnsMode : int32_t {
  
  OFF = 0,
  
  AUTOMATIC = 1,
  
  SECURE = 2,
  kMinValue = 0,
  kMaxValue = 2,
};

 std::ostream& operator<<(std::ostream& os, SecureDnsMode value);
inline bool IsKnownEnumValue(SecureDnsMode value) {
  return internal::SecureDnsMode_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class SecureDnsPolicy : int32_t {
  
  ALLOW = 0,
  
  DISABLE = 1,
  kMinValue = 0,
  kMaxValue = 1,
};

 std::ostream& operator<<(std::ostream& os, SecureDnsPolicy value);
inline bool IsKnownEnumValue(SecureDnsPolicy value) {
  return internal::SecureDnsPolicy_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class DnsQueryType : int32_t {
  
  UNSPECIFIED = 0,
  
  A = 1,
  
  AAAA = 2,
  
  TXT = 3,
  
  PTR = 4,
  
  SRV = 5,
  
  HTTPS = 6,
  kMinValue = 0,
  kMaxValue = 6,
};

 std::ostream& operator<<(std::ostream& os, DnsQueryType value);
inline bool IsKnownEnumValue(DnsQueryType value) {
  return internal::DnsQueryType_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class DnsConfigOverrides_Tristate : int32_t {
  
  NO_OVERRIDE = 0,
  
  TRISTATE_TRUE = 1,
  
  TRISTATE_FALSE = 2,
  kMinValue = 0,
  kMaxValue = 2,
};

 std::ostream& operator<<(std::ostream& os, DnsConfigOverrides_Tristate value);
inline bool IsKnownEnumValue(DnsConfigOverrides_Tristate value) {
  return internal::DnsConfigOverrides_Tristate_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class ResolveHostParameters_Source : int32_t {
  
  ANY = 0,
  
  SYSTEM = 1,
  
  DNS = 2,
  
  MULTICAST_DNS = 3,
  
  LOCAL_ONLY = 4,
  kMinValue = 0,
  kMaxValue = 4,
};

 std::ostream& operator<<(std::ostream& os, ResolveHostParameters_Source value);
inline bool IsKnownEnumValue(ResolveHostParameters_Source value) {
  return internal::ResolveHostParameters_Source_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class ResolveHostParameters_CacheUsage : int32_t {
  
  ALLOWED = 0,
  
  STALE_ALLOWED = 1,
  
  DISALLOWED = 2,
  kMinValue = 0,
  kMaxValue = 2,
};

 std::ostream& operator<<(std::ostream& os, ResolveHostParameters_CacheUsage value);
inline bool IsKnownEnumValue(ResolveHostParameters_CacheUsage value) {
  return internal::ResolveHostParameters_CacheUsage_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class ResolveHostParameters_Purpose : int32_t {
  
  kUnspecified = 0,
  
  kPreconnect = 1,
  kMinValue = 0,
  kMaxValue = 1,
};

 std::ostream& operator<<(std::ostream& os, ResolveHostParameters_Purpose value);
inline bool IsKnownEnumValue(ResolveHostParameters_Purpose value) {
  return internal::ResolveHostParameters_Purpose_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class MdnsListenClient_UpdateType : int32_t {
  
  ADDED = 0,
  
  CHANGED = 1,
  
  REMOVED = 2,
  kMinValue = 0,
  kMaxValue = 2,
};

 std::ostream& operator<<(std::ostream& os, MdnsListenClient_UpdateType value);
inline bool IsKnownEnumValue(MdnsListenClient_UpdateType value) {
  return internal::MdnsListenClient_UpdateType_Data::IsKnownValue(
      static_cast<int32_t>(value));
}
// Interface base classes. They are used for type safety check.
class ResolveHostHandleInterfaceBase {};

using ResolveHostHandlePtrDataView =
    mojo::InterfacePtrDataView<ResolveHostHandleInterfaceBase>;
using ResolveHostHandleRequestDataView =
    mojo::InterfaceRequestDataView<ResolveHostHandleInterfaceBase>;
using ResolveHostHandleAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<ResolveHostHandleInterfaceBase>;
using ResolveHostHandleAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<ResolveHostHandleInterfaceBase>;
class ResolveHostClientInterfaceBase {};

using ResolveHostClientPtrDataView =
    mojo::InterfacePtrDataView<ResolveHostClientInterfaceBase>;
using ResolveHostClientRequestDataView =
    mojo::InterfaceRequestDataView<ResolveHostClientInterfaceBase>;
using ResolveHostClientAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<ResolveHostClientInterfaceBase>;
using ResolveHostClientAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<ResolveHostClientInterfaceBase>;
class MdnsListenClientInterfaceBase {};

using MdnsListenClientPtrDataView =
    mojo::InterfacePtrDataView<MdnsListenClientInterfaceBase>;
using MdnsListenClientRequestDataView =
    mojo::InterfaceRequestDataView<MdnsListenClientInterfaceBase>;
using MdnsListenClientAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<MdnsListenClientInterfaceBase>;
using MdnsListenClientAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<MdnsListenClientInterfaceBase>;
class HostResolverInterfaceBase {};

using HostResolverPtrDataView =
    mojo::InterfacePtrDataView<HostResolverInterfaceBase>;
using HostResolverRequestDataView =
    mojo::InterfaceRequestDataView<HostResolverInterfaceBase>;
using HostResolverAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<HostResolverInterfaceBase>;
using HostResolverAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<HostResolverInterfaceBase>;
class DnsConfigChangeManagerClientInterfaceBase {};

using DnsConfigChangeManagerClientPtrDataView =
    mojo::InterfacePtrDataView<DnsConfigChangeManagerClientInterfaceBase>;
using DnsConfigChangeManagerClientRequestDataView =
    mojo::InterfaceRequestDataView<DnsConfigChangeManagerClientInterfaceBase>;
using DnsConfigChangeManagerClientAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<DnsConfigChangeManagerClientInterfaceBase>;
using DnsConfigChangeManagerClientAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<DnsConfigChangeManagerClientInterfaceBase>;
class DnsConfigChangeManagerInterfaceBase {};

using DnsConfigChangeManagerPtrDataView =
    mojo::InterfacePtrDataView<DnsConfigChangeManagerInterfaceBase>;
using DnsConfigChangeManagerRequestDataView =
    mojo::InterfaceRequestDataView<DnsConfigChangeManagerInterfaceBase>;
using DnsConfigChangeManagerAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<DnsConfigChangeManagerInterfaceBase>;
using DnsConfigChangeManagerAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<DnsConfigChangeManagerInterfaceBase>;


class DnsOverHttpsServerConfigDataView {
 public:
  DnsOverHttpsServerConfigDataView() = default;

  DnsOverHttpsServerConfigDataView(
      internal::DnsOverHttpsServerConfig_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetServerTemplateDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadServerTemplate(UserType* output) {
    
    auto* pointer = data_->server_template.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetEndpointsDataView(
      mojo::ArrayDataView<mojo::ArrayDataView<::network::mojom::IPAddressDataView>>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadEndpoints(UserType* output) {
    
    auto* pointer = data_->endpoints.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<mojo::ArrayDataView<::network::mojom::IPAddressDataView>>>(
        pointer, output, message_);
  }
 private:
  internal::DnsOverHttpsServerConfig_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class DnsOverHttpsConfigDataView {
 public:
  DnsOverHttpsConfigDataView() = default;

  DnsOverHttpsConfigDataView(
      internal::DnsOverHttpsConfig_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetServersDataView(
      mojo::ArrayDataView<DnsOverHttpsServerConfigDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadServers(UserType* output) {
    
    auto* pointer = data_->servers.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::network::mojom::DnsOverHttpsServerConfigDataView>>(
        pointer, output, message_);
  }
 private:
  internal::DnsOverHttpsConfig_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class DnsConfigOverridesDataView {
 public:
  DnsConfigOverridesDataView() = default;

  DnsConfigOverridesDataView(
      internal::DnsConfigOverrides_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetNameserversDataView(
      mojo::ArrayDataView<::network::mojom::IPEndPointDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadNameservers(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::ArrayDataView<::network::mojom::IPEndPointDataView>, UserType>(),
    "Attempting to read the optional `nameservers` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadNameservers` instead "
    "of `ReadNameservers if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->nameservers.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::network::mojom::IPEndPointDataView>>(
        pointer, output, message_);
  }
  inline void GetSearchDataView(
      mojo::ArrayDataView<mojo::StringDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSearch(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::ArrayDataView<mojo::StringDataView>, UserType>(),
    "Attempting to read the optional `search` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadSearch` instead "
    "of `ReadSearch if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->search.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<mojo::StringDataView>>(
        pointer, output, message_);
  }
  template <typename UserType>
  [[nodiscard]] bool ReadAppendToMultiLabelName(UserType* output) const {
    auto data_value = data_->append_to_multi_label_name;
    return mojo::internal::Deserialize<::network::mojom::DnsConfigOverrides_Tristate>(
        data_value, output);
  }
  DnsConfigOverrides_Tristate append_to_multi_label_name() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::network::mojom::DnsConfigOverrides_Tristate>(data_->append_to_multi_label_name));
  }
  int8_t ndots() const {
    return data_->ndots;
  }
  inline void GetFallbackPeriodDataView(
      ::mojo_base::mojom::TimeDeltaDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadFallbackPeriod(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::mojo_base::mojom::TimeDeltaDataView, UserType>(),
    "Attempting to read the optional `fallback_period` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadFallbackPeriod` instead "
    "of `ReadFallbackPeriod if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->fallback_period.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeDeltaDataView>(
        pointer, output, message_);
  }
  int32_t attempts() const {
    return data_->attempts;
  }
  template <typename UserType>
  [[nodiscard]] bool ReadRotate(UserType* output) const {
    auto data_value = data_->rotate;
    return mojo::internal::Deserialize<::network::mojom::DnsConfigOverrides_Tristate>(
        data_value, output);
  }
  DnsConfigOverrides_Tristate rotate() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::network::mojom::DnsConfigOverrides_Tristate>(data_->rotate));
  }
  template <typename UserType>
  [[nodiscard]] bool ReadUseLocalIpv6(UserType* output) const {
    auto data_value = data_->use_local_ipv6;
    return mojo::internal::Deserialize<::network::mojom::DnsConfigOverrides_Tristate>(
        data_value, output);
  }
  DnsConfigOverrides_Tristate use_local_ipv6() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::network::mojom::DnsConfigOverrides_Tristate>(data_->use_local_ipv6));
  }
  inline void GetDnsOverHttpsConfigDataView(
      DnsOverHttpsConfigDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDnsOverHttpsConfig(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::network::mojom::DnsOverHttpsConfigDataView, UserType>(),
    "Attempting to read the optional `dns_over_https_config` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadDnsOverHttpsConfig` instead "
    "of `ReadDnsOverHttpsConfig if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->dns_over_https_config.Get();
    return mojo::internal::Deserialize<::network::mojom::DnsOverHttpsConfigDataView>(
        pointer, output, message_);
  }
  template <typename UserType>
  [[nodiscard]] bool ReadSecureDnsMode(UserType* output) const {
    auto data_value = data_->secure_dns_mode;
    return mojo::internal::Deserialize<::network::mojom::OptionalSecureDnsMode>(
        data_value, output);
  }
  OptionalSecureDnsMode secure_dns_mode() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::network::mojom::OptionalSecureDnsMode>(data_->secure_dns_mode));
  }
  template <typename UserType>
  [[nodiscard]] bool ReadAllowDnsOverHttpsUpgrade(UserType* output) const {
    auto data_value = data_->allow_dns_over_https_upgrade;
    return mojo::internal::Deserialize<::network::mojom::DnsConfigOverrides_Tristate>(
        data_value, output);
  }
  DnsConfigOverrides_Tristate allow_dns_over_https_upgrade() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::network::mojom::DnsConfigOverrides_Tristate>(data_->allow_dns_over_https_upgrade));
  }
  bool clear_hosts() const {
    return data_->clear_hosts;
  }
 private:
  internal::DnsConfigOverrides_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class ResolveHostParametersDataView {
 public:
  ResolveHostParametersDataView() = default;

  ResolveHostParametersDataView(
      internal::ResolveHostParameters_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  [[nodiscard]] bool ReadDnsQueryType(UserType* output) const {
    auto data_value = data_->dns_query_type;
    return mojo::internal::Deserialize<::network::mojom::DnsQueryType>(
        data_value, output);
  }
  DnsQueryType dns_query_type() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::network::mojom::DnsQueryType>(data_->dns_query_type));
  }
  template <typename UserType>
  [[nodiscard]] bool ReadInitialPriority(UserType* output) const {
    auto data_value = data_->initial_priority;
    return mojo::internal::Deserialize<::network::mojom::RequestPriority>(
        data_value, output);
  }
  ::network::mojom::RequestPriority initial_priority() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::network::mojom::RequestPriority>(data_->initial_priority));
  }
  template <typename UserType>
  [[nodiscard]] bool ReadSource(UserType* output) const {
    auto data_value = data_->source;
    return mojo::internal::Deserialize<::network::mojom::ResolveHostParameters_Source>(
        data_value, output);
  }
  ResolveHostParameters_Source source() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::network::mojom::ResolveHostParameters_Source>(data_->source));
  }
  template <typename UserType>
  [[nodiscard]] bool ReadCacheUsage(UserType* output) const {
    auto data_value = data_->cache_usage;
    return mojo::internal::Deserialize<::network::mojom::ResolveHostParameters_CacheUsage>(
        data_value, output);
  }
  ResolveHostParameters_CacheUsage cache_usage() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::network::mojom::ResolveHostParameters_CacheUsage>(data_->cache_usage));
  }
  template <typename UserType>
  UserType TakeControlHandle() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<mojo::InterfaceRequestDataView<::network::mojom::ResolveHostHandleInterfaceBase>>(
            &data_->control_handle, &result, message_);
    DCHECK(ret);
    return result;
  }
  bool include_canonical_name() const {
    return data_->include_canonical_name;
  }
  bool loopback_only() const {
    return data_->loopback_only;
  }
  bool is_speculative() const {
    return data_->is_speculative;
  }
  template <typename UserType>
  [[nodiscard]] bool ReadSecureDnsPolicy(UserType* output) const {
    auto data_value = data_->secure_dns_policy;
    return mojo::internal::Deserialize<::network::mojom::SecureDnsPolicy>(
        data_value, output);
  }
  SecureDnsPolicy secure_dns_policy() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::network::mojom::SecureDnsPolicy>(data_->secure_dns_policy));
  }
  template <typename UserType>
  [[nodiscard]] bool ReadPurpose(UserType* output) const {
    auto data_value = data_->purpose;
    return mojo::internal::Deserialize<::network::mojom::ResolveHostParameters_Purpose>(
        data_value, output);
  }
  ResolveHostParameters_Purpose purpose() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::network::mojom::ResolveHostParameters_Purpose>(data_->purpose));
  }
 private:
  internal::ResolveHostParameters_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class HostResolverHostDataView {
 public:
  using Tag = internal::HostResolverHost_Data::HostResolverHost_Tag;

  HostResolverHostDataView() = default;

  HostResolverHostDataView(
      internal::HostResolverHost_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const {
    // For inlined unions, |data_| is always non-null. In that case we need to
    // check |data_->is_null()|.
    return !data_ || data_->is_null();
  }

  Tag tag() const { return data_->tag; }
  bool is_scheme_host_port() const { return data_->tag == Tag::kSchemeHostPort; }
  inline void GetSchemeHostPortDataView(
      ::url::mojom::SchemeHostPortDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadSchemeHostPort(UserType* output) const {
    
    CHECK(is_scheme_host_port());
    return mojo::internal::Deserialize<::url::mojom::SchemeHostPortDataView>(
        data_->data.f_scheme_host_port.Get(), output, message_);
  }
  bool is_host_port_pair() const { return data_->tag == Tag::kHostPortPair; }
  inline void GetHostPortPairDataView(
      ::network::mojom::HostPortPairDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadHostPortPair(UserType* output) const {
    
    CHECK(is_host_port_pair());
    return mojo::internal::Deserialize<::network::mojom::HostPortPairDataView>(
        data_->data.f_host_port_pair.Get(), output, message_);
  }

 private:
  internal::HostResolverHost_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};



}  // network::mojom

#endif  // SERVICES_NETWORK_PUBLIC_MOJOM_HOST_RESOLVER_MOJOM_DATA_VIEW_H_