// services/network/public/mojom/link_header.mojom-blink.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "services/network/public/mojom/link_header.mojom-blink.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/features.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "services/network/public/mojom/link_header.mojom-params-data.h"
#include "services/network/public/mojom/link_header.mojom-shared-message-ids.h"

#include "services/network/public/mojom/link_header.mojom-blink-import-headers.h"
#include "services/network/public/mojom/link_header.mojom-blink-test-utils.h"
#include "mojo/public/cpp/bindings/lib/wtf_serialization.h"


namespace network::mojom::blink {
LinkHeader::LinkHeader()
    : href(),
      rel(),
      as(LinkAsAttribute::kUnspecified),
      cross_origin(CrossOriginAttribute::kUnspecified),
      fetch_priority(::network::mojom::blink::FetchPriorityAttribute::kAuto),
      mime_type() {}

LinkHeader::LinkHeader(
    const ::blink::KURL& href_in,
    LinkRelAttribute rel_in,
    LinkAsAttribute as_in,
    CrossOriginAttribute cross_origin_in,
    ::network::mojom::blink::FetchPriorityAttribute fetch_priority_in,
    const ::blink::String& mime_type_in)
    : href(std::move(href_in)),
      rel(std::move(rel_in)),
      as(std::move(as_in)),
      cross_origin(std::move(cross_origin_in)),
      fetch_priority(std::move(fetch_priority_in)),
      mime_type(std::move(mime_type_in)) {}

LinkHeader::~LinkHeader() = default;

void LinkHeader::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "href"), this->href,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::blink::KURL&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "rel"), this->rel,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type LinkRelAttribute>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "as"), this->as,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type LinkAsAttribute>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "cross_origin"), this->cross_origin,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type CrossOriginAttribute>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "fetch_priority"), this->fetch_priority,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::network::mojom::blink::FetchPriorityAttribute>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "mime_type"), this->mime_type,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::blink::String&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool LinkHeader::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}


}  // network::mojom::blink


namespace mojo {


// static
bool StructTraits<::network::mojom::blink::LinkHeader::DataView, ::network::mojom::blink::LinkHeaderPtr>::Read(
    ::network::mojom::blink::LinkHeader::DataView input,
    ::network::mojom::blink::LinkHeaderPtr* output) {
  bool success = true;
  ::network::mojom::blink::LinkHeaderPtr result(::network::mojom::blink::LinkHeader::New());
  
      if (success && !input.ReadHref(&result->href))
        success = false;
      if (success && !input.ReadRel(&result->rel))
        success = false;
      if (success && !input.ReadAs(&result->as))
        success = false;
      if (success && !input.ReadCrossOrigin(&result->cross_origin))
        success = false;
      if (success && !input.ReadFetchPriority(&result->fetch_priority))
        success = false;
      if (success && !input.ReadMimeType(&result->mime_type))
        success = false;
  *output = std::move(result);
  return success;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace network::mojom::blink {




}  // network::mojom::blink


#if defined(__clang__)
#pragma clang diagnostic pop
#endif