// services/network/public/mojom/link_header.mojom-data-view.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_NETWORK_PUBLIC_MOJOM_LINK_HEADER_MOJOM_DATA_VIEW_H_
#define SERVICES_NETWORK_PUBLIC_MOJOM_LINK_HEADER_MOJOM_DATA_VIEW_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "services/network/public/mojom/link_header.mojom-shared-internal.h"
#include "services/network/public/mojom/request_priority.mojom-shared.h"
#include "url/mojom/url.mojom-shared.h"


namespace network::mojom {
class LinkHeaderDataView;



}  // network::mojom


namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::network::mojom::LinkHeaderDataView> {
  using Data = ::network::mojom::internal::LinkHeader_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace network::mojom {


enum class LinkRelAttribute : int32_t {
  
  kDnsPrefetch = 0,
  
  kPreconnect = 1,
  
  kPreload = 2,
  
  kModulePreload = 3,
  kMinValue = 0,
  kMaxValue = 3,
};

 std::ostream& operator<<(std::ostream& os, LinkRelAttribute value);
inline bool IsKnownEnumValue(LinkRelAttribute value) {
  return internal::LinkRelAttribute_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class LinkAsAttribute : int32_t {
  
  kUnspecified = 0,
  
  kFont = 1,
  
  kImage = 2,
  
  kScript = 3,
  
  kStyleSheet = 4,
  
  kFetch = 5,
  kMinValue = 0,
  kMaxValue = 5,
};

 std::ostream& operator<<(std::ostream& os, LinkAsAttribute value);
inline bool IsKnownEnumValue(LinkAsAttribute value) {
  return internal::LinkAsAttribute_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class CrossOriginAttribute : int32_t {
  
  kUnspecified = 0,
  
  kAnonymous = 1,
  
  kUseCredentials = 2,
  kMinValue = 0,
  kMaxValue = 2,
};

 std::ostream& operator<<(std::ostream& os, CrossOriginAttribute value);
inline bool IsKnownEnumValue(CrossOriginAttribute value) {
  return internal::CrossOriginAttribute_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


class LinkHeaderDataView {
 public:
  LinkHeaderDataView() = default;

  LinkHeaderDataView(
      internal::LinkHeader_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetHrefDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadHref(UserType* output) {
    
    auto* pointer = data_->href.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, message_);
  }
  template <typename UserType>
  [[nodiscard]] bool ReadRel(UserType* output) const {
    auto data_value = data_->rel;
    return mojo::internal::Deserialize<::network::mojom::LinkRelAttribute>(
        data_value, output);
  }
  LinkRelAttribute rel() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::network::mojom::LinkRelAttribute>(data_->rel));
  }
  template <typename UserType>
  [[nodiscard]] bool ReadAs(UserType* output) const {
    auto data_value = data_->as;
    return mojo::internal::Deserialize<::network::mojom::LinkAsAttribute>(
        data_value, output);
  }
  LinkAsAttribute as() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::network::mojom::LinkAsAttribute>(data_->as));
  }
  template <typename UserType>
  [[nodiscard]] bool ReadCrossOrigin(UserType* output) const {
    auto data_value = data_->cross_origin;
    return mojo::internal::Deserialize<::network::mojom::CrossOriginAttribute>(
        data_value, output);
  }
  CrossOriginAttribute cross_origin() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::network::mojom::CrossOriginAttribute>(data_->cross_origin));
  }
  template <typename UserType>
  [[nodiscard]] bool ReadFetchPriority(UserType* output) const {
    auto data_value = data_->fetch_priority;
    return mojo::internal::Deserialize<::network::mojom::FetchPriorityAttribute>(
        data_value, output);
  }
  ::network::mojom::FetchPriorityAttribute fetch_priority() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::network::mojom::FetchPriorityAttribute>(data_->fetch_priority));
  }
  inline void GetMimeTypeDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadMimeType(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::StringDataView, UserType>(),
    "Attempting to read the optional `mime_type` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadMimeType` instead "
    "of `ReadMimeType if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->mime_type.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
 private:
  internal::LinkHeader_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


}  // network::mojom

#endif  // SERVICES_NETWORK_PUBLIC_MOJOM_LINK_HEADER_MOJOM_DATA_VIEW_H_