// services/network/public/mojom/network_context_client.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_NETWORK_PUBLIC_MOJOM_NETWORK_CONTEXT_CLIENT_MOJOM_H_
#define SERVICES_NETWORK_PUBLIC_MOJOM_NETWORK_CONTEXT_CLIENT_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "services/network/public/mojom/network_context_client.mojom-features.h"  // IWYU pragma: export
#include "services/network/public/mojom/network_context_client.mojom-shared.h"  // IWYU pragma: export
#include "services/network/public/mojom/network_context_client.mojom-forward.h"  // IWYU pragma: export
#include "mojo/public/mojom/base/file.mojom.h"
#include "mojo/public/mojom/base/file_path.mojom.h"
#include "url/mojom/origin.mojom.h"
#include "url/mojom/url.mojom.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/lib/message_size_estimator.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"






namespace network::mojom {

class NetworkContextClientProxy;

template <typename ImplRefTraits>
class NetworkContextClientStub;

class NetworkContextClientRequestValidator;
class NetworkContextClientResponseValidator;


class NetworkContextClient
    : public NetworkContextClientInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "network.mojom.NetworkContextClient";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = NetworkContextClientInterfaceBase;
  using Proxy_ = NetworkContextClientProxy;

  template <typename ImplRefTraits>
  using Stub_ = NetworkContextClientStub<ImplRefTraits>;

  using RequestValidator_ = NetworkContextClientRequestValidator;
  using ResponseValidator_ = NetworkContextClientResponseValidator;
  enum MethodMinVersions : uint32_t {
    kOnFileUploadRequestedMinVersion = 0,
    kOnCanSendReportingReportsMinVersion = 0,
    kOnCanSendDomainReliabilityUploadMinVersion = 0,
    kOnCanSendSCTAuditingReportMinVersion = 0,
    kOnNewSCTAuditingReportSentMinVersion = 0,
    kOnNetworkContextCreatedMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct OnFileUploadRequested_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnCanSendReportingReports_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnCanSendDomainReliabilityUpload_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnCanSendSCTAuditingReport_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnNewSCTAuditingReportSent_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnNetworkContextCreated_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~NetworkContextClient() = default;

  using OnFileUploadRequestedCallback = base::OnceCallback<void(int32_t, std::vector<::base::File>)>;
  using OnFileUploadRequestedMojoCallback = base::OnceCallback<void(int32_t, std::vector<::base::File>)>;

  virtual void OnFileUploadRequested(int32_t process_id, bool async, const std::vector<::base::FilePath>& file_paths, const ::GURL& destination_url, OnFileUploadRequestedCallback callback) = 0;

  using OnCanSendReportingReportsCallback = base::OnceCallback<void(const std::vector<::url::Origin>&)>;
  using OnCanSendReportingReportsMojoCallback = base::OnceCallback<void(const std::vector<::url::Origin>&)>;

  virtual void OnCanSendReportingReports(const std::vector<::url::Origin>& origins, OnCanSendReportingReportsCallback callback) = 0;

  using OnCanSendDomainReliabilityUploadCallback = base::OnceCallback<void(bool)>;
  using OnCanSendDomainReliabilityUploadMojoCallback = base::OnceCallback<void(bool)>;

  virtual void OnCanSendDomainReliabilityUpload(const ::url::Origin& origin, OnCanSendDomainReliabilityUploadCallback callback) = 0;

  using OnCanSendSCTAuditingReportCallback = base::OnceCallback<void(bool)>;
  using OnCanSendSCTAuditingReportMojoCallback = base::OnceCallback<void(bool)>;

  virtual void OnCanSendSCTAuditingReport(OnCanSendSCTAuditingReportCallback callback) = 0;

  virtual void OnNewSCTAuditingReportSent() = 0;

  virtual void OnNetworkContextCreated() = 0;
};



class  NetworkContextClientProxy
    : public NetworkContextClient {
 public:
  using InterfaceType = NetworkContextClient;

  explicit NetworkContextClientProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void OnFileUploadRequested(int32_t process_id, bool async, const std::vector<::base::FilePath>& file_paths, const ::GURL& destination_url, OnFileUploadRequestedCallback callback) final;
  
  void OnCanSendReportingReports(const std::vector<::url::Origin>& origins, OnCanSendReportingReportsCallback callback) final;
  
  void OnCanSendDomainReliabilityUpload(const ::url::Origin& origin, OnCanSendDomainReliabilityUploadCallback callback) final;
  
  void OnCanSendSCTAuditingReport(OnCanSendSCTAuditingReportCallback callback) final;
  
  void OnNewSCTAuditingReportSent() final;
  
  void OnNetworkContextCreated() final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class  NetworkContextClientStubDispatch {
 public:
  static bool Accept(NetworkContextClient* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      NetworkContextClient* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<NetworkContextClient>>
class NetworkContextClientStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  NetworkContextClientStub() = default;
  ~NetworkContextClientStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return NetworkContextClientStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return NetworkContextClientStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  NetworkContextClientRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  NetworkContextClientResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};





}  // network::mojom

namespace mojo {

}  // namespace mojo

#endif  // SERVICES_NETWORK_PUBLIC_MOJOM_NETWORK_CONTEXT_CLIENT_MOJOM_H_