// services/network/public/mojom/proxy_config.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "services/network/public/mojom/proxy_config.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/features.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "services/network/public/mojom/proxy_config.mojom-params-data.h"
#include "services/network/public/mojom/proxy_config.mojom-shared-message-ids.h"

#include "services/network/public/mojom/proxy_config.mojom-import-headers.h"
#include "services/network/public/mojom/proxy_config.mojom-test-utils.h"
#include "net/cert/cert_verify_result.h"


namespace network::mojom {
ProxyBypassRules::ProxyBypassRules()
    : rules() {}

ProxyBypassRules::ProxyBypassRules(
    std::vector<std::string> rules_in)
    : rules(std::move(rules_in)) {}

ProxyBypassRules::~ProxyBypassRules() = default;

void ProxyBypassRules::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "rules"), this->rules,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::vector<std::string>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool ProxyBypassRules::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
ProxyList::ProxyList()
    : proxies() {}

ProxyList::ProxyList(
    std::vector<::net::ProxyChain> proxies_in)
    : proxies(std::move(proxies_in)) {}

ProxyList::~ProxyList() = default;

void ProxyList::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "proxies"), this->proxies,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::vector<::net::ProxyChain>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool ProxyList::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
ProxyRules::ProxyRules()
    : bypass_rules(),
      reverse_bypass(),
      type(),
      single_proxies(),
      proxies_for_http(),
      proxies_for_https(),
      proxies_for_ftp(),
      fallback_proxies() {}

ProxyRules::ProxyRules(
    const ::net::ProxyBypassRules& bypass_rules_in,
    bool reverse_bypass_in,
    ::net::ProxyConfig::ProxyRules::Type type_in,
    const ::net::ProxyList& single_proxies_in,
    const ::net::ProxyList& proxies_for_http_in,
    const ::net::ProxyList& proxies_for_https_in,
    const ::net::ProxyList& proxies_for_ftp_in,
    const ::net::ProxyList& fallback_proxies_in)
    : bypass_rules(std::move(bypass_rules_in)),
      reverse_bypass(std::move(reverse_bypass_in)),
      type(std::move(type_in)),
      single_proxies(std::move(single_proxies_in)),
      proxies_for_http(std::move(proxies_for_http_in)),
      proxies_for_https(std::move(proxies_for_https_in)),
      proxies_for_ftp(std::move(proxies_for_ftp_in)),
      fallback_proxies(std::move(fallback_proxies_in)) {}

ProxyRules::~ProxyRules() = default;

void ProxyRules::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "bypass_rules"), this->bypass_rules,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::net::ProxyBypassRules&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "reverse_bypass"), this->reverse_bypass,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "type"), this->type,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::net::ProxyConfig::ProxyRules::Type>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "single_proxies"), this->single_proxies,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::net::ProxyList&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "proxies_for_http"), this->proxies_for_http,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::net::ProxyList&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "proxies_for_https"), this->proxies_for_https,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::net::ProxyList&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "proxies_for_ftp"), this->proxies_for_ftp,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::net::ProxyList&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "fallback_proxies"), this->fallback_proxies,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::net::ProxyList&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool ProxyRules::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
ProxyConfig::ProxyConfig()
    : auto_detect(),
      from_system(),
      pac_url(),
      pac_mandatory(),
      proxy_rules() {}

ProxyConfig::ProxyConfig(
    bool auto_detect_in,
    bool from_system_in,
    const ::std::string& pac_url_in,
    bool pac_mandatory_in,
    const ::net::ProxyConfig::ProxyRules& proxy_rules_in)
    : auto_detect(std::move(auto_detect_in)),
      from_system(std::move(from_system_in)),
      pac_url(std::move(pac_url_in)),
      pac_mandatory(std::move(pac_mandatory_in)),
      proxy_rules(std::move(proxy_rules_in)) {}

ProxyConfig::~ProxyConfig() = default;

void ProxyConfig::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "auto_detect"), this->auto_detect,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "from_system"), this->from_system,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "pac_url"), this->pac_url,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "pac_mandatory"), this->pac_mandatory,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "proxy_rules"), this->proxy_rules,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::net::ProxyConfig::ProxyRules&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool ProxyConfig::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}


}  // network::mojom


namespace mojo {


// static
bool StructTraits<::network::mojom::ProxyBypassRules::DataView, ::network::mojom::ProxyBypassRulesPtr>::Read(
    ::network::mojom::ProxyBypassRules::DataView input,
    ::network::mojom::ProxyBypassRulesPtr* output) {
  bool success = true;
  ::network::mojom::ProxyBypassRulesPtr result(::network::mojom::ProxyBypassRules::New());
  
      if (success && !input.ReadRules(&result->rules))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::network::mojom::ProxyList::DataView, ::network::mojom::ProxyListPtr>::Read(
    ::network::mojom::ProxyList::DataView input,
    ::network::mojom::ProxyListPtr* output) {
  bool success = true;
  ::network::mojom::ProxyListPtr result(::network::mojom::ProxyList::New());
  
      if (success && !input.ReadProxies(&result->proxies))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::network::mojom::ProxyRules::DataView, ::network::mojom::ProxyRulesPtr>::Read(
    ::network::mojom::ProxyRules::DataView input,
    ::network::mojom::ProxyRulesPtr* output) {
  bool success = true;
  ::network::mojom::ProxyRulesPtr result(::network::mojom::ProxyRules::New());
  
      if (success && !input.ReadBypassRules(&result->bypass_rules))
        success = false;
      if (success)
        result->reverse_bypass = input.reverse_bypass();
      if (success && !input.ReadType(&result->type))
        success = false;
      if (success && !input.ReadSingleProxies(&result->single_proxies))
        success = false;
      if (success && !input.ReadProxiesForHttp(&result->proxies_for_http))
        success = false;
      if (success && !input.ReadProxiesForHttps(&result->proxies_for_https))
        success = false;
      if (success && !input.ReadProxiesForFtp(&result->proxies_for_ftp))
        success = false;
      if (success && !input.ReadFallbackProxies(&result->fallback_proxies))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::network::mojom::ProxyConfig::DataView, ::network::mojom::ProxyConfigPtr>::Read(
    ::network::mojom::ProxyConfig::DataView input,
    ::network::mojom::ProxyConfigPtr* output) {
  bool success = true;
  ::network::mojom::ProxyConfigPtr result(::network::mojom::ProxyConfig::New());
  
      if (success)
        result->auto_detect = input.auto_detect();
      if (success)
        result->from_system = input.from_system();
      if (success && !input.ReadPacUrl(&result->pac_url))
        success = false;
      if (success)
        result->pac_mandatory = input.pac_mandatory();
      if (success && !input.ReadProxyRules(&result->proxy_rules))
        success = false;
  *output = std::move(result);
  return success;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace network::mojom {




}  // network::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif