// services/resource_coordinator/public/mojom/memory_instrumentation/memory_instrumentation.mojom-data-view.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_RESOURCE_COORDINATOR_PUBLIC_MOJOM_MEMORY_INSTRUMENTATION_MEMORY_INSTRUMENTATION_MOJOM_DATA_VIEW_H_
#define SERVICES_RESOURCE_COORDINATOR_PUBLIC_MOJOM_MEMORY_INSTRUMENTATION_MEMORY_INSTRUMENTATION_MOJOM_DATA_VIEW_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "services/resource_coordinator/public/mojom/memory_instrumentation/memory_instrumentation.mojom-shared-internal.h"
#include "mojo/public/mojom/base/big_string.mojom-shared.h"
#include "mojo/public/mojom/base/process_id.mojom-shared.h"
#include "mojo/public/mojom/base/time.mojom-shared.h"


namespace memory_instrumentation::mojom {
class RequestArgsDataView;

class RawAllocatorDumpEdgeDataView;

class RawAllocatorDumpEntryDataView;

class RawAllocatorDumpDataView;

class RawProcessMemoryDumpDataView;

class VmRegionDataView;

class PlatformPrivateFootprintDataView;

class RawOSMemDumpDataView;

class OSMemDumpDataView;

class AllocatorMemDumpDataView;

class ProcessMemoryDumpDataView;

class AggregatedMetricsDataView;

class GlobalMemoryDumpDataView;

class HeapProfileResultDataView;

class RawAllocatorDumpEntryValueDataView;


}  // memory_instrumentation::mojom


namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::memory_instrumentation::mojom::RequestArgsDataView> {
  using Data = ::memory_instrumentation::mojom::internal::RequestArgs_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::memory_instrumentation::mojom::RawAllocatorDumpEdgeDataView> {
  using Data = ::memory_instrumentation::mojom::internal::RawAllocatorDumpEdge_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::memory_instrumentation::mojom::RawAllocatorDumpEntryDataView> {
  using Data = ::memory_instrumentation::mojom::internal::RawAllocatorDumpEntry_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::memory_instrumentation::mojom::RawAllocatorDumpDataView> {
  using Data = ::memory_instrumentation::mojom::internal::RawAllocatorDump_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::memory_instrumentation::mojom::RawProcessMemoryDumpDataView> {
  using Data = ::memory_instrumentation::mojom::internal::RawProcessMemoryDump_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::memory_instrumentation::mojom::VmRegionDataView> {
  using Data = ::memory_instrumentation::mojom::internal::VmRegion_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::memory_instrumentation::mojom::PlatformPrivateFootprintDataView> {
  using Data = ::memory_instrumentation::mojom::internal::PlatformPrivateFootprint_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::memory_instrumentation::mojom::RawOSMemDumpDataView> {
  using Data = ::memory_instrumentation::mojom::internal::RawOSMemDump_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::memory_instrumentation::mojom::OSMemDumpDataView> {
  using Data = ::memory_instrumentation::mojom::internal::OSMemDump_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::memory_instrumentation::mojom::AllocatorMemDumpDataView> {
  using Data = ::memory_instrumentation::mojom::internal::AllocatorMemDump_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::memory_instrumentation::mojom::ProcessMemoryDumpDataView> {
  using Data = ::memory_instrumentation::mojom::internal::ProcessMemoryDump_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::memory_instrumentation::mojom::AggregatedMetricsDataView> {
  using Data = ::memory_instrumentation::mojom::internal::AggregatedMetrics_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::memory_instrumentation::mojom::GlobalMemoryDumpDataView> {
  using Data = ::memory_instrumentation::mojom::internal::GlobalMemoryDump_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::memory_instrumentation::mojom::HeapProfileResultDataView> {
  using Data = ::memory_instrumentation::mojom::internal::HeapProfileResult_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::memory_instrumentation::mojom::RawAllocatorDumpEntryValueDataView> {
  using Data = ::memory_instrumentation::mojom::internal::RawAllocatorDumpEntryValue_Data;
  using DataAsArrayElement = Data;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kUnion;
};

}  // namespace internal
}  // namespace mojo


namespace memory_instrumentation::mojom {


enum class DumpType : int32_t {
  
  PERIODIC_INTERVAL = 0,
  
  EXPLICITLY_TRIGGERED = 1,
  
  SUMMARY_ONLY = 2,
  kMinValue = 0,
  kMaxValue = 2,
};

COMPONENT_EXPORT(RESOURCE_COORDINATOR_PUBLIC_MOJOM_SHARED) std::ostream& operator<<(std::ostream& os, DumpType value);
inline bool IsKnownEnumValue(DumpType value) {
  return internal::DumpType_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class LevelOfDetail : int32_t {
  
  BACKGROUND = 0,
  
  LIGHT = 1,
  
  DETAILED = 2,
  kMinValue = 0,
  kMaxValue = 2,
};

COMPONENT_EXPORT(RESOURCE_COORDINATOR_PUBLIC_MOJOM_SHARED) std::ostream& operator<<(std::ostream& os, LevelOfDetail value);
inline bool IsKnownEnumValue(LevelOfDetail value) {
  return internal::LevelOfDetail_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class Determinism : int32_t {
  
  NONE = 0,
  
  FORCE_GC = 1,
  kMinValue = 0,
  kMaxValue = 1,
};

COMPONENT_EXPORT(RESOURCE_COORDINATOR_PUBLIC_MOJOM_SHARED) std::ostream& operator<<(std::ostream& os, Determinism value);
inline bool IsKnownEnumValue(Determinism value) {
  return internal::Determinism_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class ProcessType : int32_t {
  
  OTHER = 0,
  
  BROWSER = 1,
  
  RENDERER = 2,
  
  GPU = 3,
  
  UTILITY = 4,
  
  PLUGIN = 5,
  
  ARC = 6,
  kMinValue = 0,
  kMaxValue = 6,
};

COMPONENT_EXPORT(RESOURCE_COORDINATOR_PUBLIC_MOJOM_SHARED) std::ostream& operator<<(std::ostream& os, ProcessType value);
inline bool IsKnownEnumValue(ProcessType value) {
  return internal::ProcessType_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class MemoryMapOption : int32_t {
  
  NONE = 0,
  
  MODULES = 1,
  
  FULL = 2,
  kMinValue = 0,
  kMaxValue = 2,
};

COMPONENT_EXPORT(RESOURCE_COORDINATOR_PUBLIC_MOJOM_SHARED) std::ostream& operator<<(std::ostream& os, MemoryMapOption value);
inline bool IsKnownEnumValue(MemoryMapOption value) {
  return internal::MemoryMapOption_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class MemDumpFlags : int32_t {
  
  MEM_DUMP_COUNT_MAPPINGS = 0,
  
  MEM_DUMP_PSS = 1,
  
  MEM_DUMP_PAGES_BITMAP = 2,
  kMinValue = 0,
  kMaxValue = 2,
};

COMPONENT_EXPORT(RESOURCE_COORDINATOR_PUBLIC_MOJOM_SHARED) std::ostream& operator<<(std::ostream& os, MemDumpFlags value);
inline bool IsKnownEnumValue(MemDumpFlags value) {
  return internal::MemDumpFlags_Data::IsKnownValue(
      static_cast<int32_t>(value));
}
// Interface base classes. They are used for type safety check.
class ClientProcessInterfaceBase {};

using ClientProcessPtrDataView =
    mojo::InterfacePtrDataView<ClientProcessInterfaceBase>;
using ClientProcessRequestDataView =
    mojo::InterfaceRequestDataView<ClientProcessInterfaceBase>;
using ClientProcessAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<ClientProcessInterfaceBase>;
using ClientProcessAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<ClientProcessInterfaceBase>;
class HeapProfilerInterfaceBase {};

using HeapProfilerPtrDataView =
    mojo::InterfacePtrDataView<HeapProfilerInterfaceBase>;
using HeapProfilerRequestDataView =
    mojo::InterfaceRequestDataView<HeapProfilerInterfaceBase>;
using HeapProfilerAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<HeapProfilerInterfaceBase>;
using HeapProfilerAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<HeapProfilerInterfaceBase>;
class HeapProfilerHelperInterfaceBase {};

using HeapProfilerHelperPtrDataView =
    mojo::InterfacePtrDataView<HeapProfilerHelperInterfaceBase>;
using HeapProfilerHelperRequestDataView =
    mojo::InterfaceRequestDataView<HeapProfilerHelperInterfaceBase>;
using HeapProfilerHelperAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<HeapProfilerHelperInterfaceBase>;
using HeapProfilerHelperAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<HeapProfilerHelperInterfaceBase>;
class CoordinatorInterfaceBase {};

using CoordinatorPtrDataView =
    mojo::InterfacePtrDataView<CoordinatorInterfaceBase>;
using CoordinatorRequestDataView =
    mojo::InterfaceRequestDataView<CoordinatorInterfaceBase>;
using CoordinatorAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<CoordinatorInterfaceBase>;
using CoordinatorAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<CoordinatorInterfaceBase>;
class CoordinatorConnectorInterfaceBase {};

using CoordinatorConnectorPtrDataView =
    mojo::InterfacePtrDataView<CoordinatorConnectorInterfaceBase>;
using CoordinatorConnectorRequestDataView =
    mojo::InterfaceRequestDataView<CoordinatorConnectorInterfaceBase>;
using CoordinatorConnectorAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<CoordinatorConnectorInterfaceBase>;
using CoordinatorConnectorAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<CoordinatorConnectorInterfaceBase>;


class RequestArgsDataView {
 public:
  RequestArgsDataView() = default;

  RequestArgsDataView(
      internal::RequestArgs_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  uint64_t dump_guid() const {
    return data_->dump_guid;
  }
  template <typename UserType>
  [[nodiscard]] bool ReadDumpType(UserType* output) const {
    auto data_value = data_->dump_type;
    return mojo::internal::Deserialize<::memory_instrumentation::mojom::DumpType>(
        data_value, output);
  }
  DumpType dump_type() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::memory_instrumentation::mojom::DumpType>(data_->dump_type));
  }
  template <typename UserType>
  [[nodiscard]] bool ReadLevelOfDetail(UserType* output) const {
    auto data_value = data_->level_of_detail;
    return mojo::internal::Deserialize<::memory_instrumentation::mojom::LevelOfDetail>(
        data_value, output);
  }
  LevelOfDetail level_of_detail() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::memory_instrumentation::mojom::LevelOfDetail>(data_->level_of_detail));
  }
  template <typename UserType>
  [[nodiscard]] bool ReadDeterminism(UserType* output) const {
    auto data_value = data_->determinism;
    return mojo::internal::Deserialize<::memory_instrumentation::mojom::Determinism>(
        data_value, output);
  }
  Determinism determinism() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::memory_instrumentation::mojom::Determinism>(data_->determinism));
  }
 private:
  internal::RequestArgs_Data* data_ = nullptr;
};


class RawAllocatorDumpEdgeDataView {
 public:
  RawAllocatorDumpEdgeDataView() = default;

  RawAllocatorDumpEdgeDataView(
      internal::RawAllocatorDumpEdge_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  uint64_t source_id() const {
    return data_->source_id;
  }
  uint64_t target_id() const {
    return data_->target_id;
  }
  int32_t importance() const {
    return data_->importance;
  }
  bool overridable() const {
    return data_->overridable;
  }
 private:
  internal::RawAllocatorDumpEdge_Data* data_ = nullptr;
};


class RawAllocatorDumpEntryDataView {
 public:
  RawAllocatorDumpEntryDataView() = default;

  RawAllocatorDumpEntryDataView(
      internal::RawAllocatorDumpEntry_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetNameDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadName(UserType* output) {
    
    auto* pointer = data_->name.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetUnitsDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadUnits(UserType* output) {
    
    auto* pointer = data_->units.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetValueDataView(
      RawAllocatorDumpEntryValueDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadValue(UserType* output) {
    
    auto* pointer = !data_->value.is_null() ? &data_->value : nullptr;
    return mojo::internal::Deserialize<::memory_instrumentation::mojom::RawAllocatorDumpEntryValueDataView>(
        pointer, output, message_);
  }
 private:
  internal::RawAllocatorDumpEntry_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class RawAllocatorDumpDataView {
 public:
  RawAllocatorDumpDataView() = default;

  RawAllocatorDumpDataView(
      internal::RawAllocatorDump_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  uint64_t id() const {
    return data_->id;
  }
  inline void GetAbsoluteNameDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadAbsoluteName(UserType* output) {
    
    auto* pointer = data_->absolute_name.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  bool weak() const {
    return data_->weak;
  }
  template <typename UserType>
  [[nodiscard]] bool ReadLevelOfDetail(UserType* output) const {
    auto data_value = data_->level_of_detail;
    return mojo::internal::Deserialize<::memory_instrumentation::mojom::LevelOfDetail>(
        data_value, output);
  }
  LevelOfDetail level_of_detail() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::memory_instrumentation::mojom::LevelOfDetail>(data_->level_of_detail));
  }
  inline void GetEntriesDataView(
      mojo::ArrayDataView<RawAllocatorDumpEntryDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadEntries(UserType* output) {
    
    auto* pointer = data_->entries.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::memory_instrumentation::mojom::RawAllocatorDumpEntryDataView>>(
        pointer, output, message_);
  }
 private:
  internal::RawAllocatorDump_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class RawProcessMemoryDumpDataView {
 public:
  RawProcessMemoryDumpDataView() = default;

  RawProcessMemoryDumpDataView(
      internal::RawProcessMemoryDump_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  [[nodiscard]] bool ReadLevelOfDetail(UserType* output) const {
    auto data_value = data_->level_of_detail;
    return mojo::internal::Deserialize<::memory_instrumentation::mojom::LevelOfDetail>(
        data_value, output);
  }
  LevelOfDetail level_of_detail() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::memory_instrumentation::mojom::LevelOfDetail>(data_->level_of_detail));
  }
  inline void GetAllocatorDumpEdgesDataView(
      mojo::ArrayDataView<RawAllocatorDumpEdgeDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadAllocatorDumpEdges(UserType* output) {
    
    auto* pointer = data_->allocator_dump_edges.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::memory_instrumentation::mojom::RawAllocatorDumpEdgeDataView>>(
        pointer, output, message_);
  }
  inline void GetAllocatorDumpsDataView(
      mojo::ArrayDataView<RawAllocatorDumpDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadAllocatorDumps(UserType* output) {
    
    auto* pointer = data_->allocator_dumps.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::memory_instrumentation::mojom::RawAllocatorDumpDataView>>(
        pointer, output, message_);
  }
 private:
  internal::RawProcessMemoryDump_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class VmRegionDataView {
 public:
  VmRegionDataView() = default;

  VmRegionDataView(
      internal::VmRegion_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  uint64_t start_address() const {
    return data_->start_address;
  }
  uint64_t size_in_bytes() const {
    return data_->size_in_bytes;
  }
  uint64_t module_timestamp() const {
    return data_->module_timestamp;
  }
  inline void GetModuleDebugidDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadModuleDebugid(UserType* output) {
    
    auto* pointer = data_->module_debugid.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetModuleDebugPathDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadModuleDebugPath(UserType* output) {
    
    auto* pointer = data_->module_debug_path.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  uint32_t protection_flags() const {
    return data_->protection_flags;
  }
  inline void GetMappedFileDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadMappedFile(UserType* output) {
    
    auto* pointer = data_->mapped_file.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  uint64_t byte_stats_private_dirty_resident() const {
    return data_->byte_stats_private_dirty_resident;
  }
  uint64_t byte_stats_private_clean_resident() const {
    return data_->byte_stats_private_clean_resident;
  }
  uint64_t byte_stats_shared_dirty_resident() const {
    return data_->byte_stats_shared_dirty_resident;
  }
  uint64_t byte_stats_shared_clean_resident() const {
    return data_->byte_stats_shared_clean_resident;
  }
  uint64_t byte_stats_swapped() const {
    return data_->byte_stats_swapped;
  }
  uint64_t byte_locked() const {
    return data_->byte_locked;
  }
  uint64_t byte_stats_proportional_resident() const {
    return data_->byte_stats_proportional_resident;
  }
 private:
  internal::VmRegion_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class PlatformPrivateFootprintDataView {
 public:
  PlatformPrivateFootprintDataView() = default;

  PlatformPrivateFootprintDataView(
      internal::PlatformPrivateFootprint_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  uint64_t phys_footprint_bytes() const {
    return data_->phys_footprint_bytes;
  }
  uint64_t internal_bytes() const {
    return data_->internal_bytes;
  }
  uint64_t compressed_bytes() const {
    return data_->compressed_bytes;
  }
  uint64_t rss_anon_bytes() const {
    return data_->rss_anon_bytes;
  }
  uint64_t vm_swap_bytes() const {
    return data_->vm_swap_bytes;
  }
  uint64_t private_bytes() const {
    return data_->private_bytes;
  }
 private:
  internal::PlatformPrivateFootprint_Data* data_ = nullptr;
};


class RawOSMemDumpDataView {
 public:
  RawOSMemDumpDataView() = default;

  RawOSMemDumpDataView(
      internal::RawOSMemDump_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  uint32_t resident_set_kb() const {
    return data_->resident_set_kb;
  }
  uint32_t peak_resident_set_kb() const {
    return data_->peak_resident_set_kb;
  }
  bool is_peak_rss_resettable() const {
    return data_->is_peak_rss_resettable;
  }
  inline void GetPlatformPrivateFootprintDataView(
      PlatformPrivateFootprintDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPlatformPrivateFootprint(UserType* output) {
    
    auto* pointer = data_->platform_private_footprint.Get();
    return mojo::internal::Deserialize<::memory_instrumentation::mojom::PlatformPrivateFootprintDataView>(
        pointer, output, message_);
  }
  inline void GetMemoryMapsDataView(
      mojo::ArrayDataView<VmRegionDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadMemoryMaps(UserType* output) {
    
    auto* pointer = data_->memory_maps.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::memory_instrumentation::mojom::VmRegionDataView>>(
        pointer, output, message_);
  }
  inline void GetNativeLibraryPagesBitmapDataView(
      mojo::ArrayDataView<uint8_t>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadNativeLibraryPagesBitmap(UserType* output) {
    
    auto* pointer = data_->native_library_pages_bitmap.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<uint8_t>>(
        pointer, output, message_);
  }
  uint32_t mappings_count() const {
    return data_->mappings_count;
  }
  uint32_t pss_kb() const {
    return data_->pss_kb;
  }
  uint32_t swap_pss_kb() const {
    return data_->swap_pss_kb;
  }
 private:
  internal::RawOSMemDump_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class OSMemDumpDataView {
 public:
  OSMemDumpDataView() = default;

  OSMemDumpDataView(
      internal::OSMemDump_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  uint32_t resident_set_kb() const {
    return data_->resident_set_kb;
  }
  uint32_t peak_resident_set_kb() const {
    return data_->peak_resident_set_kb;
  }
  bool is_peak_rss_resettable() const {
    return data_->is_peak_rss_resettable;
  }
  uint32_t private_footprint_kb() const {
    return data_->private_footprint_kb;
  }
  uint32_t shared_footprint_kb() const {
    return data_->shared_footprint_kb;
  }
  uint32_t private_footprint_swap_kb() const {
    return data_->private_footprint_swap_kb;
  }
  uint32_t mappings_count() const {
    return data_->mappings_count;
  }
  uint32_t pss_kb() const {
    return data_->pss_kb;
  }
  uint32_t swap_pss_kb() const {
    return data_->swap_pss_kb;
  }
 private:
  internal::OSMemDump_Data* data_ = nullptr;
};


class AllocatorMemDumpDataView {
 public:
  AllocatorMemDumpDataView() = default;

  AllocatorMemDumpDataView(
      internal::AllocatorMemDump_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetNumericEntriesDataView(
      mojo::MapDataView<mojo::StringDataView, uint64_t>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadNumericEntries(UserType* output) {
    
    auto* pointer = data_->numeric_entries.Get();
    return mojo::internal::Deserialize<mojo::MapDataView<mojo::StringDataView, uint64_t>>(
        pointer, output, message_);
  }
  inline void GetChildrenDataView(
      mojo::MapDataView<mojo::StringDataView, AllocatorMemDumpDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadChildren(UserType* output) {
    
    auto* pointer = data_->children.Get();
    return mojo::internal::Deserialize<mojo::MapDataView<mojo::StringDataView, ::memory_instrumentation::mojom::AllocatorMemDumpDataView>>(
        pointer, output, message_);
  }
 private:
  internal::AllocatorMemDump_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class ProcessMemoryDumpDataView {
 public:
  ProcessMemoryDumpDataView() = default;

  ProcessMemoryDumpDataView(
      internal::ProcessMemoryDump_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  [[nodiscard]] bool ReadProcessType(UserType* output) const {
    auto data_value = data_->process_type;
    return mojo::internal::Deserialize<::memory_instrumentation::mojom::ProcessType>(
        data_value, output);
  }
  ProcessType process_type() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::memory_instrumentation::mojom::ProcessType>(data_->process_type));
  }
  inline void GetOsDumpDataView(
      OSMemDumpDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadOsDump(UserType* output) {
    
    auto* pointer = data_->os_dump.Get();
    return mojo::internal::Deserialize<::memory_instrumentation::mojom::OSMemDumpDataView>(
        pointer, output, message_);
  }
  inline void GetChromeAllocatorDumpsDataView(
      mojo::MapDataView<mojo::StringDataView, AllocatorMemDumpDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadChromeAllocatorDumps(UserType* output) {
    
    auto* pointer = data_->chrome_allocator_dumps.Get();
    return mojo::internal::Deserialize<mojo::MapDataView<mojo::StringDataView, ::memory_instrumentation::mojom::AllocatorMemDumpDataView>>(
        pointer, output, message_);
  }
  inline void GetPidDataView(
      ::mojo_base::mojom::ProcessIdDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPid(UserType* output) {
    
    auto* pointer = data_->pid.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::ProcessIdDataView>(
        pointer, output, message_);
  }
  inline void GetServiceNameDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadServiceName(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::StringDataView, UserType>(),
    "Attempting to read the optional `service_name` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadServiceName` instead "
    "of `ReadServiceName if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->service_name.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
 private:
  internal::ProcessMemoryDump_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class AggregatedMetricsDataView {
 public:
  AggregatedMetricsDataView() = default;

  AggregatedMetricsDataView(
      internal::AggregatedMetrics_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  int32_t native_library_resident_kb() const {
    return data_->native_library_resident_kb;
  }
  int32_t native_library_resident_not_ordered_kb() const {
    return data_->native_library_resident_not_ordered_kb;
  }
  int32_t native_library_not_resident_ordered_kb() const {
    return data_->native_library_not_resident_ordered_kb;
  }
 private:
  internal::AggregatedMetrics_Data* data_ = nullptr;
};


class GlobalMemoryDumpDataView {
 public:
  GlobalMemoryDumpDataView() = default;

  GlobalMemoryDumpDataView(
      internal::GlobalMemoryDump_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetStartTimeDataView(
      ::mojo_base::mojom::TimeTicksDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadStartTime(UserType* output) {
    
    auto* pointer = data_->start_time.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeTicksDataView>(
        pointer, output, message_);
  }
  inline void GetProcessDumpsDataView(
      mojo::ArrayDataView<ProcessMemoryDumpDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadProcessDumps(UserType* output) {
    
    auto* pointer = data_->process_dumps.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::memory_instrumentation::mojom::ProcessMemoryDumpDataView>>(
        pointer, output, message_);
  }
  inline void GetAggregatedMetricsDataView(
      AggregatedMetricsDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadAggregatedMetrics(UserType* output) {
    
    auto* pointer = data_->aggregated_metrics.Get();
    return mojo::internal::Deserialize<::memory_instrumentation::mojom::AggregatedMetricsDataView>(
        pointer, output, message_);
  }
 private:
  internal::GlobalMemoryDump_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class HeapProfileResultDataView {
 public:
  HeapProfileResultDataView() = default;

  HeapProfileResultDataView(
      internal::HeapProfileResult_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetPidDataView(
      ::mojo_base::mojom::ProcessIdDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPid(UserType* output) {
    
    auto* pointer = data_->pid.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::ProcessIdDataView>(
        pointer, output, message_);
  }
  inline void GetJsonDataView(
      ::mojo_base::mojom::BigStringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadJson(UserType* output) {
    
    auto* pointer = data_->json.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::BigStringDataView>(
        pointer, output, message_);
  }
 private:
  internal::HeapProfileResult_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class RawAllocatorDumpEntryValueDataView {
 public:
  using Tag = internal::RawAllocatorDumpEntryValue_Data::RawAllocatorDumpEntryValue_Tag;

  RawAllocatorDumpEntryValueDataView() = default;

  RawAllocatorDumpEntryValueDataView(
      internal::RawAllocatorDumpEntryValue_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const {
    // For inlined unions, |data_| is always non-null. In that case we need to
    // check |data_->is_null()|.
    return !data_ || data_->is_null();
  }

  Tag tag() const { return data_->tag; }
  bool is_value_uint64() const { return data_->tag == Tag::kValueUint64; }
  uint64_t value_uint64() const {
    CHECK(is_value_uint64());
    return data_->data.f_value_uint64;
  }
  bool is_value_string() const { return data_->tag == Tag::kValueString; }
  inline void GetValueStringDataView(
      mojo::StringDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadValueString(UserType* output) const {
    
    CHECK(is_value_string());
    return mojo::internal::Deserialize<mojo::StringDataView>(
        data_->data.f_value_string.Get(), output, message_);
  }

 private:
  internal::RawAllocatorDumpEntryValue_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};



}  // memory_instrumentation::mojom

#endif  // SERVICES_RESOURCE_COORDINATOR_PUBLIC_MOJOM_MEMORY_INSTRUMENTATION_MEMORY_INSTRUMENTATION_MOJOM_DATA_VIEW_H_