// services/viz/public/mojom/compositing/begin_frame_args.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "services/viz/public/mojom/compositing/begin_frame_args.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/features.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "services/viz/public/mojom/compositing/begin_frame_args.mojom-params-data.h"
#include "services/viz/public/mojom/compositing/begin_frame_args.mojom-shared-message-ids.h"

#include "services/viz/public/mojom/compositing/begin_frame_args.mojom-import-headers.h"
#include "services/viz/public/mojom/compositing/begin_frame_args.mojom-test-utils.h"


namespace viz::mojom {
BeginFrameId::BeginFrameId()
    : source_id(),
      sequence_number() {}

BeginFrameId::BeginFrameId(
    uint64_t source_id_in,
    uint64_t sequence_number_in)
    : source_id(std::move(source_id_in)),
      sequence_number(std::move(sequence_number_in)) {}

BeginFrameId::~BeginFrameId() = default;
size_t BeginFrameId::Hash(size_t seed) const {
  seed = mojo::internal::Hash(seed, this->source_id);
  seed = mojo::internal::Hash(seed, this->sequence_number);
  return seed;
}

void BeginFrameId::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "source_id"), this->source_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint64_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "sequence_number"), this->sequence_number,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint64_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool BeginFrameId::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
BeginFrameArgs::BeginFrameArgs()
    : frame_time(),
      deadline(),
      interval(),
      frame_id(),
      frames_throttled_since_last(),
      trace_id(),
      dispatch_time(),
      client_arrival_time(),
      type(),
      on_critical_path(),
      animate_only() {}

BeginFrameArgs::BeginFrameArgs(
    ::base::TimeTicks frame_time_in,
    ::base::TimeTicks deadline_in,
    ::base::TimeDelta interval_in,
    BeginFrameIdPtr frame_id_in,
    uint64_t frames_throttled_since_last_in,
    int64_t trace_id_in,
    ::base::TimeTicks dispatch_time_in,
    ::base::TimeTicks client_arrival_time_in,
    BeginFrameArgsType type_in,
    bool on_critical_path_in,
    bool animate_only_in)
    : frame_time(std::move(frame_time_in)),
      deadline(std::move(deadline_in)),
      interval(std::move(interval_in)),
      frame_id(std::move(frame_id_in)),
      frames_throttled_since_last(std::move(frames_throttled_since_last_in)),
      trace_id(std::move(trace_id_in)),
      dispatch_time(std::move(dispatch_time_in)),
      client_arrival_time(std::move(client_arrival_time_in)),
      type(std::move(type_in)),
      on_critical_path(std::move(on_critical_path_in)),
      animate_only(std::move(animate_only_in)) {}

BeginFrameArgs::~BeginFrameArgs() = default;

void BeginFrameArgs::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "frame_time"), this->frame_time,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::base::TimeTicks>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "deadline"), this->deadline,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::base::TimeTicks>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "interval"), this->interval,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::base::TimeDelta>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "frame_id"), this->frame_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type BeginFrameIdPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "frames_throttled_since_last"), this->frames_throttled_since_last,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint64_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "trace_id"), this->trace_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int64_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "dispatch_time"), this->dispatch_time,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::base::TimeTicks>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "client_arrival_time"), this->client_arrival_time,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::base::TimeTicks>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "type"), this->type,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type BeginFrameArgsType>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "on_critical_path"), this->on_critical_path,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "animate_only"), this->animate_only,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool BeginFrameArgs::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
BeginFrameAck::BeginFrameAck()
    : source_id(),
      sequence_number(),
      trace_id(),
      has_damage() {}

BeginFrameAck::BeginFrameAck(
    uint64_t source_id_in,
    uint64_t sequence_number_in,
    int64_t trace_id_in,
    bool has_damage_in)
    : source_id(std::move(source_id_in)),
      sequence_number(std::move(sequence_number_in)),
      trace_id(std::move(trace_id_in)),
      has_damage(std::move(has_damage_in)) {}

BeginFrameAck::~BeginFrameAck() = default;

void BeginFrameAck::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "source_id"), this->source_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint64_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "sequence_number"), this->sequence_number,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint64_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "trace_id"), this->trace_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int64_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "has_damage"), this->has_damage,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool BeginFrameAck::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}


}  // viz::mojom


namespace mojo {


// static
bool StructTraits<::viz::mojom::BeginFrameId::DataView, ::viz::mojom::BeginFrameIdPtr>::Read(
    ::viz::mojom::BeginFrameId::DataView input,
    ::viz::mojom::BeginFrameIdPtr* output) {
  bool success = true;
  ::viz::mojom::BeginFrameIdPtr result(::viz::mojom::BeginFrameId::New());
  
      if (success)
        result->source_id = input.source_id();
      if (success)
        result->sequence_number = input.sequence_number();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::viz::mojom::BeginFrameArgs::DataView, ::viz::mojom::BeginFrameArgsPtr>::Read(
    ::viz::mojom::BeginFrameArgs::DataView input,
    ::viz::mojom::BeginFrameArgsPtr* output) {
  bool success = true;
  ::viz::mojom::BeginFrameArgsPtr result(::viz::mojom::BeginFrameArgs::New());
  
      if (success && !input.ReadFrameTime(&result->frame_time))
        success = false;
      if (success && !input.ReadDeadline(&result->deadline))
        success = false;
      if (success && !input.ReadInterval(&result->interval))
        success = false;
      if (success && !input.ReadFrameId(&result->frame_id))
        success = false;
      if (success)
        result->frames_throttled_since_last = input.frames_throttled_since_last();
      if (success)
        result->trace_id = input.trace_id();
      if (success && !input.ReadDispatchTime(&result->dispatch_time))
        success = false;
      if (success && !input.ReadClientArrivalTime(&result->client_arrival_time))
        success = false;
      if (success && !input.ReadType(&result->type))
        success = false;
      if (success)
        result->on_critical_path = input.on_critical_path();
      if (success)
        result->animate_only = input.animate_only();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::viz::mojom::BeginFrameAck::DataView, ::viz::mojom::BeginFrameAckPtr>::Read(
    ::viz::mojom::BeginFrameAck::DataView input,
    ::viz::mojom::BeginFrameAckPtr* output) {
  bool success = true;
  ::viz::mojom::BeginFrameAckPtr result(::viz::mojom::BeginFrameAck::New());
  
      if (success)
        result->source_id = input.source_id();
      if (success)
        result->sequence_number = input.sequence_number();
      if (success)
        result->trace_id = input.trace_id();
      if (success)
        result->has_damage = input.has_damage();
  *output = std::move(result);
  return success;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace viz::mojom {




}  // viz::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif