// services/viz/public/mojom/compositing/compositor_frame.mojom-data-view.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_VIZ_PUBLIC_MOJOM_COMPOSITING_COMPOSITOR_FRAME_MOJOM_DATA_VIEW_H_
#define SERVICES_VIZ_PUBLIC_MOJOM_COMPOSITING_COMPOSITOR_FRAME_MOJOM_DATA_VIEW_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "services/viz/public/mojom/compositing/compositor_frame.mojom-shared-internal.h"
#include "services/viz/public/mojom/compositing/compositor_frame_metadata.mojom-shared.h"
#include "services/viz/public/mojom/compositing/compositor_render_pass.mojom-shared.h"
#include "services/viz/public/mojom/compositing/transferable_resource.mojom-shared.h"


namespace viz::mojom {
class CompositorFrameDataView;



}  // viz::mojom


namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::viz::mojom::CompositorFrameDataView> {
  using Data = ::viz::mojom::internal::CompositorFrame_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace viz::mojom {


class CompositorFrameDataView {
 public:
  CompositorFrameDataView() = default;

  CompositorFrameDataView(
      internal::CompositorFrame_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetMetadataDataView(
      ::viz::mojom::CompositorFrameMetadataDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadMetadata(UserType* output) {
    
    auto* pointer = data_->metadata.Get();
    return mojo::internal::Deserialize<::viz::mojom::CompositorFrameMetadataDataView>(
        pointer, output, message_);
  }
  inline void GetResourcesDataView(
      mojo::ArrayDataView<::viz::mojom::TransferableResourceDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadResources(UserType* output) {
    
    auto* pointer = data_->resources.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::viz::mojom::TransferableResourceDataView>>(
        pointer, output, message_);
  }
  inline void GetPassesDataView(
      mojo::ArrayDataView<::viz::mojom::CompositorRenderPassDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPasses(UserType* output) {
    
    auto* pointer = data_->passes.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::viz::mojom::CompositorRenderPassDataView>>(
        pointer, output, message_);
  }
 private:
  internal::CompositorFrame_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


}  // viz::mojom

#endif  // SERVICES_VIZ_PUBLIC_MOJOM_COMPOSITING_COMPOSITOR_FRAME_MOJOM_DATA_VIEW_H_