// services/viz/public/mojom/compositing/quads.mojom-blink.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_VIZ_PUBLIC_MOJOM_COMPOSITING_QUADS_MOJOM_BLINK_H_
#define SERVICES_VIZ_PUBLIC_MOJOM_COMPOSITING_QUADS_MOJOM_BLINK_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "services/viz/public/mojom/compositing/quads.mojom-features.h"  // IWYU pragma: export
#include "services/viz/public/mojom/compositing/quads.mojom-shared.h"  // IWYU pragma: export
#include "services/viz/public/mojom/compositing/quads.mojom-blink-forward.h"  // IWYU pragma: export
#include "cc/mojom/paint_flags.mojom-blink.h"
#include "mojo/public/mojom/base/unguessable_token.mojom-blink.h"
#include "services/viz/public/mojom/compositing/compositor_render_pass_id.mojom-blink.h"
#include "services/viz/public/mojom/compositing/resource_id.mojom-blink.h"
#include "services/viz/public/mojom/compositing/view_transition_element_resource_id.mojom-blink.h"
#include "services/viz/public/mojom/compositing/shared_quad_state.mojom-blink.h"
#include "services/viz/public/mojom/compositing/surface_range.mojom-blink.h"
#include "skia/public/mojom/skcolor4f.mojom-blink.h"
#include "ui/gfx/geometry/mojom/geometry.mojom-blink.h"
#include "ui/gfx/mojom/color_space.mojom-blink-forward.h"
#include "ui/gfx/mojom/hdr_metadata.mojom-blink-forward.h"
#include "ui/gfx/mojom/transform.mojom-blink-forward.h"

#include "mojo/public/cpp/bindings/lib/wtf_clone_equals_util.h"
#include "mojo/public/cpp/bindings/lib/wtf_hash_util.h"
#include "third_party/blink/renderer/platform/wtf/hash_functions.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"




#include "third_party/blink/public/platform/web_common.h"
#if !BLINK_MOJO_IMPL && !INSIDE_BLINK
#error "File must only be imported inside blink"
#endif




namespace viz::mojom::blink {















class BLINK_PLATFORM_EXPORT DrawQuadState {
 public:
  using DataView = DrawQuadStateDataView;
  using Data_ = internal::DrawQuadState_Data;
  using Tag = Data_::DrawQuadState_Tag;

  template <typename... Args>
  static DrawQuadStatePtr New(Args&&... args) {
    static_assert(
        sizeof...(args) < 0,
        "Do not use Union::New(); to create a union of a given subtype, use "
        "New<SubType>(), not New() followed by set_<sub_type>(). To represent "
        "an empty union, mark the field or parameter as nullable in the mojom "
        "definition.");
    return nullptr;
  }

  // Construct an instance holding |debug_border_quad_state|.
  static DrawQuadStatePtr NewDebugBorderQuadState(
      DebugBorderQuadStatePtr value);
  // Construct an instance holding |render_pass_quad_state|.
  static DrawQuadStatePtr NewRenderPassQuadState(
      CompositorRenderPassQuadStatePtr value);
  // Construct an instance holding |solid_color_quad_state|.
  static DrawQuadStatePtr NewSolidColorQuadState(
      SolidColorQuadStatePtr value);
  // Construct an instance holding |surface_quad_state|.
  static DrawQuadStatePtr NewSurfaceQuadState(
      SurfaceQuadStatePtr value);
  // Construct an instance holding |texture_quad_state|.
  static DrawQuadStatePtr NewTextureQuadState(
      TextureQuadStatePtr value);
  // Construct an instance holding |tile_quad_state|.
  static DrawQuadStatePtr NewTileQuadState(
      TileQuadStatePtr value);
  // Construct an instance holding |video_hole_quad_state|.
  static DrawQuadStatePtr NewVideoHoleQuadState(
      VideoHoleQuadStatePtr value);
  // Construct an instance holding |shared_element_quad_state|.
  static DrawQuadStatePtr NewSharedElementQuadState(
      SharedElementQuadStatePtr value);

  template <typename U>
  static DrawQuadStatePtr From(const U& u) {
    return mojo::TypeConverter<DrawQuadStatePtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, DrawQuadState>::Convert(*this);
  }
  ~DrawQuadState();

  // Delete the copy constructor and copy assignment operators because `data_`
  // contains raw pointers that must not be copied.
  DrawQuadState(const DrawQuadState& other) = delete;
  DrawQuadState& operator=(const DrawQuadState& other) = delete;

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename UnionPtrType = DrawQuadStatePtr>
  DrawQuadStatePtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T,
            typename std::enable_if<std::is_same<
                T, DrawQuadState>::value>::type* = nullptr>
  bool Equals(const T& other) const;

  template <typename T,
            typename std::enable_if<std::is_same<
                T, DrawQuadState>::value>::type* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  Tag which() const {
    return tag_;
  }

  bool is_debug_border_quad_state() const { return tag_ == Tag::kDebugBorderQuadState; }
  const DebugBorderQuadStatePtr& get_debug_border_quad_state() const {
    CHECK(tag_ == Tag::kDebugBorderQuadState);
    return data_.debug_border_quad_state;
  }
  DebugBorderQuadStatePtr& get_debug_border_quad_state() {
    CHECK(tag_ == Tag::kDebugBorderQuadState);
    return data_.debug_border_quad_state;
  }
  void set_debug_border_quad_state(DebugBorderQuadStatePtr debug_border_quad_state);

  bool is_render_pass_quad_state() const { return tag_ == Tag::kRenderPassQuadState; }
  const CompositorRenderPassQuadStatePtr& get_render_pass_quad_state() const {
    CHECK(tag_ == Tag::kRenderPassQuadState);
    return data_.render_pass_quad_state;
  }
  CompositorRenderPassQuadStatePtr& get_render_pass_quad_state() {
    CHECK(tag_ == Tag::kRenderPassQuadState);
    return data_.render_pass_quad_state;
  }
  void set_render_pass_quad_state(CompositorRenderPassQuadStatePtr render_pass_quad_state);

  bool is_solid_color_quad_state() const { return tag_ == Tag::kSolidColorQuadState; }
  const SolidColorQuadStatePtr& get_solid_color_quad_state() const {
    CHECK(tag_ == Tag::kSolidColorQuadState);
    return data_.solid_color_quad_state;
  }
  SolidColorQuadStatePtr& get_solid_color_quad_state() {
    CHECK(tag_ == Tag::kSolidColorQuadState);
    return data_.solid_color_quad_state;
  }
  void set_solid_color_quad_state(SolidColorQuadStatePtr solid_color_quad_state);

  bool is_surface_quad_state() const { return tag_ == Tag::kSurfaceQuadState; }
  const SurfaceQuadStatePtr& get_surface_quad_state() const {
    CHECK(tag_ == Tag::kSurfaceQuadState);
    return data_.surface_quad_state;
  }
  SurfaceQuadStatePtr& get_surface_quad_state() {
    CHECK(tag_ == Tag::kSurfaceQuadState);
    return data_.surface_quad_state;
  }
  void set_surface_quad_state(SurfaceQuadStatePtr surface_quad_state);

  bool is_texture_quad_state() const { return tag_ == Tag::kTextureQuadState; }
  const TextureQuadStatePtr& get_texture_quad_state() const {
    CHECK(tag_ == Tag::kTextureQuadState);
    return data_.texture_quad_state;
  }
  TextureQuadStatePtr& get_texture_quad_state() {
    CHECK(tag_ == Tag::kTextureQuadState);
    return data_.texture_quad_state;
  }
  void set_texture_quad_state(TextureQuadStatePtr texture_quad_state);

  bool is_tile_quad_state() const { return tag_ == Tag::kTileQuadState; }
  const TileQuadStatePtr& get_tile_quad_state() const {
    CHECK(tag_ == Tag::kTileQuadState);
    return data_.tile_quad_state;
  }
  TileQuadStatePtr& get_tile_quad_state() {
    CHECK(tag_ == Tag::kTileQuadState);
    return data_.tile_quad_state;
  }
  void set_tile_quad_state(TileQuadStatePtr tile_quad_state);

  bool is_video_hole_quad_state() const { return tag_ == Tag::kVideoHoleQuadState; }
  const VideoHoleQuadStatePtr& get_video_hole_quad_state() const {
    CHECK(tag_ == Tag::kVideoHoleQuadState);
    return data_.video_hole_quad_state;
  }
  VideoHoleQuadStatePtr& get_video_hole_quad_state() {
    CHECK(tag_ == Tag::kVideoHoleQuadState);
    return data_.video_hole_quad_state;
  }
  void set_video_hole_quad_state(VideoHoleQuadStatePtr video_hole_quad_state);

  bool is_shared_element_quad_state() const { return tag_ == Tag::kSharedElementQuadState; }
  const SharedElementQuadStatePtr& get_shared_element_quad_state() const {
    CHECK(tag_ == Tag::kSharedElementQuadState);
    return data_.shared_element_quad_state;
  }
  SharedElementQuadStatePtr& get_shared_element_quad_state() {
    CHECK(tag_ == Tag::kSharedElementQuadState);
    return data_.shared_element_quad_state;
  }
  void set_shared_element_quad_state(SharedElementQuadStatePtr shared_element_quad_state);

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        DrawQuadState::DataView>(input);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    return mojo::internal::DeserializeImpl<DrawQuadState::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

 private:
  template <typename T>
  friend class ::mojo::InlinedStructPtr;
  template <typename T>
  friend class ::mojo::StructPtr;

  union Union_ {
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kDebugBorderQuadState)>,
        DebugBorderQuadStatePtr value);
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kRenderPassQuadState)>,
        CompositorRenderPassQuadStatePtr value);
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kSolidColorQuadState)>,
        SolidColorQuadStatePtr value);
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kSurfaceQuadState)>,
        SurfaceQuadStatePtr value);
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kTextureQuadState)>,
        TextureQuadStatePtr value);
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kTileQuadState)>,
        TileQuadStatePtr value);
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kVideoHoleQuadState)>,
        VideoHoleQuadStatePtr value);
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kSharedElementQuadState)>,
        SharedElementQuadStatePtr value);
    // The contents of the union are explicitly destroyed by `DestroyActive()`.
    ~Union_() {}

    DebugBorderQuadStatePtr debug_border_quad_state;
    CompositorRenderPassQuadStatePtr render_pass_quad_state;
    SolidColorQuadStatePtr solid_color_quad_state;
    SurfaceQuadStatePtr surface_quad_state;
    TextureQuadStatePtr texture_quad_state;
    TileQuadStatePtr tile_quad_state;
    VideoHoleQuadStatePtr video_hole_quad_state;
    SharedElementQuadStatePtr shared_element_quad_state;
  };

  DrawQuadState(
      std::in_place_index_t<static_cast<size_t>(Tag::kDebugBorderQuadState)>,
      DebugBorderQuadStatePtr value);
  DrawQuadState(
      std::in_place_index_t<static_cast<size_t>(Tag::kRenderPassQuadState)>,
      CompositorRenderPassQuadStatePtr value);
  DrawQuadState(
      std::in_place_index_t<static_cast<size_t>(Tag::kSolidColorQuadState)>,
      SolidColorQuadStatePtr value);
  DrawQuadState(
      std::in_place_index_t<static_cast<size_t>(Tag::kSurfaceQuadState)>,
      SurfaceQuadStatePtr value);
  DrawQuadState(
      std::in_place_index_t<static_cast<size_t>(Tag::kTextureQuadState)>,
      TextureQuadStatePtr value);
  DrawQuadState(
      std::in_place_index_t<static_cast<size_t>(Tag::kTileQuadState)>,
      TileQuadStatePtr value);
  DrawQuadState(
      std::in_place_index_t<static_cast<size_t>(Tag::kVideoHoleQuadState)>,
      VideoHoleQuadStatePtr value);
  DrawQuadState(
      std::in_place_index_t<static_cast<size_t>(Tag::kSharedElementQuadState)>,
      SharedElementQuadStatePtr value);

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  void DestroyActive();
  Tag tag_;
  Union_ data_;
};





class BLINK_PLATFORM_EXPORT RoundedDisplayMasksInfo {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<RoundedDisplayMasksInfo, T>::value>;
  using DataView = RoundedDisplayMasksInfoDataView;
  using Data_ = internal::RoundedDisplayMasksInfo_Data;

  template <typename... Args>
  static RoundedDisplayMasksInfoPtr New(Args&&... args) {
    return RoundedDisplayMasksInfoPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static RoundedDisplayMasksInfoPtr From(const U& u) {
    return mojo::TypeConverter<RoundedDisplayMasksInfoPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, RoundedDisplayMasksInfo>::Convert(*this);
  }


  RoundedDisplayMasksInfo();

  RoundedDisplayMasksInfo(
      bool is_horizontally_positioned,
      ::blink::Vector<uint8_t> radii);


  ~RoundedDisplayMasksInfo();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = RoundedDisplayMasksInfoPtr>
  RoundedDisplayMasksInfoPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, RoundedDisplayMasksInfo::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, RoundedDisplayMasksInfo::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, RoundedDisplayMasksInfo::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        RoundedDisplayMasksInfo::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        RoundedDisplayMasksInfo::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        RoundedDisplayMasksInfo::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::RoundedDisplayMasksInfo_UnserializedMessageContext<
            UserType, RoundedDisplayMasksInfo::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<RoundedDisplayMasksInfo::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return RoundedDisplayMasksInfo::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::RoundedDisplayMasksInfo_UnserializedMessageContext<
            UserType, RoundedDisplayMasksInfo::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<RoundedDisplayMasksInfo::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  bool is_horizontally_positioned;
  
  ::blink::Vector<uint8_t> radii;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, RoundedDisplayMasksInfo::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, RoundedDisplayMasksInfo::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, RoundedDisplayMasksInfo::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, RoundedDisplayMasksInfo::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class BLINK_PLATFORM_EXPORT DebugBorderQuadState {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<DebugBorderQuadState, T>::value>;
  using DataView = DebugBorderQuadStateDataView;
  using Data_ = internal::DebugBorderQuadState_Data;

  template <typename... Args>
  static DebugBorderQuadStatePtr New(Args&&... args) {
    return DebugBorderQuadStatePtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static DebugBorderQuadStatePtr From(const U& u) {
    return mojo::TypeConverter<DebugBorderQuadStatePtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, DebugBorderQuadState>::Convert(*this);
  }


  DebugBorderQuadState();

  DebugBorderQuadState(
      const ::SkColor4f& color,
      int32_t width);


  ~DebugBorderQuadState();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = DebugBorderQuadStatePtr>
  DebugBorderQuadStatePtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, DebugBorderQuadState::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, DebugBorderQuadState::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, DebugBorderQuadState::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        DebugBorderQuadState::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        DebugBorderQuadState::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        DebugBorderQuadState::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::DebugBorderQuadState_UnserializedMessageContext<
            UserType, DebugBorderQuadState::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<DebugBorderQuadState::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return DebugBorderQuadState::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::DebugBorderQuadState_UnserializedMessageContext<
            UserType, DebugBorderQuadState::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<DebugBorderQuadState::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::SkColor4f color;
  
  int32_t width;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, DebugBorderQuadState::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, DebugBorderQuadState::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, DebugBorderQuadState::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, DebugBorderQuadState::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class BLINK_PLATFORM_EXPORT CompositorRenderPassQuadState {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<CompositorRenderPassQuadState, T>::value>;
  using DataView = CompositorRenderPassQuadStateDataView;
  using Data_ = internal::CompositorRenderPassQuadState_Data;

  template <typename... Args>
  static CompositorRenderPassQuadStatePtr New(Args&&... args) {
    return CompositorRenderPassQuadStatePtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static CompositorRenderPassQuadStatePtr From(const U& u) {
    return mojo::TypeConverter<CompositorRenderPassQuadStatePtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, CompositorRenderPassQuadState>::Convert(*this);
  }


  CompositorRenderPassQuadState();

  CompositorRenderPassQuadState(
      ::viz::mojom::blink::CompositorRenderPassIdPtr render_pass_id,
      ::viz::mojom::blink::ResourceIdPtr mask_resource_id,
      const ::gfx::RectF& mask_uv_rect,
      const ::gfx::Size& mask_texture_size,
      const ::gfx::Vector2dF& filters_scale,
      const ::gfx::PointF& filters_origin,
      const ::gfx::RectF& tex_coord_rect,
      bool force_anti_aliasing_off,
      float backdrop_filter_quality,
      bool intersects_damage_under);

CompositorRenderPassQuadState(const CompositorRenderPassQuadState&) = delete;
CompositorRenderPassQuadState& operator=(const CompositorRenderPassQuadState&) = delete;

  ~CompositorRenderPassQuadState();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = CompositorRenderPassQuadStatePtr>
  CompositorRenderPassQuadStatePtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, CompositorRenderPassQuadState::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, CompositorRenderPassQuadState::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, CompositorRenderPassQuadState::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        CompositorRenderPassQuadState::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        CompositorRenderPassQuadState::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        CompositorRenderPassQuadState::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::CompositorRenderPassQuadState_UnserializedMessageContext<
            UserType, CompositorRenderPassQuadState::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<CompositorRenderPassQuadState::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return CompositorRenderPassQuadState::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::CompositorRenderPassQuadState_UnserializedMessageContext<
            UserType, CompositorRenderPassQuadState::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<CompositorRenderPassQuadState::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::viz::mojom::blink::CompositorRenderPassIdPtr render_pass_id;
  
  ::viz::mojom::blink::ResourceIdPtr mask_resource_id;
  
  ::gfx::RectF mask_uv_rect;
  
  ::gfx::Size mask_texture_size;
  
  ::gfx::Vector2dF filters_scale;
  
  ::gfx::PointF filters_origin;
  
  ::gfx::RectF tex_coord_rect;
  
  bool force_anti_aliasing_off;
  
  float backdrop_filter_quality;
  
  bool intersects_damage_under;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, CompositorRenderPassQuadState::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, CompositorRenderPassQuadState::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, CompositorRenderPassQuadState::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, CompositorRenderPassQuadState::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class BLINK_PLATFORM_EXPORT SolidColorQuadState {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<SolidColorQuadState, T>::value>;
  using DataView = SolidColorQuadStateDataView;
  using Data_ = internal::SolidColorQuadState_Data;

  template <typename... Args>
  static SolidColorQuadStatePtr New(Args&&... args) {
    return SolidColorQuadStatePtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static SolidColorQuadStatePtr From(const U& u) {
    return mojo::TypeConverter<SolidColorQuadStatePtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, SolidColorQuadState>::Convert(*this);
  }


  SolidColorQuadState();

  SolidColorQuadState(
      const ::SkColor4f& color,
      bool force_anti_aliasing_off);


  ~SolidColorQuadState();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = SolidColorQuadStatePtr>
  SolidColorQuadStatePtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, SolidColorQuadState::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, SolidColorQuadState::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, SolidColorQuadState::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        SolidColorQuadState::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        SolidColorQuadState::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        SolidColorQuadState::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::SolidColorQuadState_UnserializedMessageContext<
            UserType, SolidColorQuadState::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<SolidColorQuadState::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return SolidColorQuadState::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::SolidColorQuadState_UnserializedMessageContext<
            UserType, SolidColorQuadState::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<SolidColorQuadState::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::SkColor4f color;
  
  bool force_anti_aliasing_off;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, SolidColorQuadState::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, SolidColorQuadState::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, SolidColorQuadState::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, SolidColorQuadState::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class BLINK_PLATFORM_EXPORT SurfaceQuadState {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<SurfaceQuadState, T>::value>;
  using DataView = SurfaceQuadStateDataView;
  using Data_ = internal::SurfaceQuadState_Data;

  template <typename... Args>
  static SurfaceQuadStatePtr New(Args&&... args) {
    return SurfaceQuadStatePtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static SurfaceQuadStatePtr From(const U& u) {
    return mojo::TypeConverter<SurfaceQuadStatePtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, SurfaceQuadState>::Convert(*this);
  }


  SurfaceQuadState();

  SurfaceQuadState(
      const ::viz::SurfaceRange& surface_range,
      const ::SkColor4f& default_background_color,
      bool stretch_content_to_fill_bounds,
      bool is_reflection,
      bool allow_merge,
      std::optional<::cc::mojom::blink::FilterQuality> override_child_filter_quality,
      ::cc::mojom::blink::DynamicRangeLimitPtr override_child_dynamic_range_limit);

SurfaceQuadState(const SurfaceQuadState&) = delete;
SurfaceQuadState& operator=(const SurfaceQuadState&) = delete;

  ~SurfaceQuadState();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = SurfaceQuadStatePtr>
  SurfaceQuadStatePtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, SurfaceQuadState::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, SurfaceQuadState::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, SurfaceQuadState::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        SurfaceQuadState::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        SurfaceQuadState::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        SurfaceQuadState::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::SurfaceQuadState_UnserializedMessageContext<
            UserType, SurfaceQuadState::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<SurfaceQuadState::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return SurfaceQuadState::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::SurfaceQuadState_UnserializedMessageContext<
            UserType, SurfaceQuadState::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<SurfaceQuadState::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::viz::SurfaceRange surface_range;
  
  ::SkColor4f default_background_color;
  
  bool stretch_content_to_fill_bounds;
  
  bool is_reflection;
  
  bool allow_merge;
  
  std::optional<::cc::mojom::blink::FilterQuality> override_child_filter_quality;
  
  ::cc::mojom::blink::DynamicRangeLimitPtr override_child_dynamic_range_limit;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, SurfaceQuadState::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, SurfaceQuadState::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, SurfaceQuadState::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, SurfaceQuadState::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class BLINK_PLATFORM_EXPORT TextureQuadState {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<TextureQuadState, T>::value>;
  using DataView = TextureQuadStateDataView;
  using Data_ = internal::TextureQuadState_Data;

  template <typename... Args>
  static TextureQuadStatePtr New(Args&&... args) {
    return TextureQuadStatePtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static TextureQuadStatePtr From(const U& u) {
    return mojo::TypeConverter<TextureQuadStatePtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, TextureQuadState>::Convert(*this);
  }


  TextureQuadState();

  TextureQuadState(
      ::viz::mojom::blink::ResourceIdPtr resource_id,
      const ::gfx::PointF& uv_top_left,
      const ::gfx::PointF& uv_bottom_right,
      const ::SkColor4f& background_color,
      ::cc::mojom::blink::DynamicRangeLimitPtr dynamic_range_limit,
      bool nearest_neighbor,
      bool secure_output_only,
      bool is_video_frame,
      bool force_rgbx,
      ProtectedVideoState protected_video_type,
      const std::optional<::gfx::Rect>& damage_rect,
      OverlayPriority overlay_priority_hint,
      RoundedDisplayMasksInfoPtr rounded_display_masks_info);

TextureQuadState(const TextureQuadState&) = delete;
TextureQuadState& operator=(const TextureQuadState&) = delete;

  ~TextureQuadState();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = TextureQuadStatePtr>
  TextureQuadStatePtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, TextureQuadState::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, TextureQuadState::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, TextureQuadState::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        TextureQuadState::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        TextureQuadState::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        TextureQuadState::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::TextureQuadState_UnserializedMessageContext<
            UserType, TextureQuadState::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<TextureQuadState::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return TextureQuadState::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::TextureQuadState_UnserializedMessageContext<
            UserType, TextureQuadState::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<TextureQuadState::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::viz::mojom::blink::ResourceIdPtr resource_id;
  
  ::gfx::PointF uv_top_left;
  
  ::gfx::PointF uv_bottom_right;
  
  ::SkColor4f background_color;
  
  ::cc::mojom::blink::DynamicRangeLimitPtr dynamic_range_limit;
  
  bool nearest_neighbor;
  
  bool secure_output_only;
  
  bool is_video_frame;
  
  bool force_rgbx;
  
  ProtectedVideoState protected_video_type;
  
  std::optional<::gfx::Rect> damage_rect;
  
  OverlayPriority overlay_priority_hint;
  
  RoundedDisplayMasksInfoPtr rounded_display_masks_info;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, TextureQuadState::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, TextureQuadState::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, TextureQuadState::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, TextureQuadState::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class BLINK_PLATFORM_EXPORT TileQuadState {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<TileQuadState, T>::value>;
  using DataView = TileQuadStateDataView;
  using Data_ = internal::TileQuadState_Data;

  template <typename... Args>
  static TileQuadStatePtr New(Args&&... args) {
    return TileQuadStatePtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static TileQuadStatePtr From(const U& u) {
    return mojo::TypeConverter<TileQuadStatePtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, TileQuadState>::Convert(*this);
  }


  TileQuadState();

  TileQuadState(
      const ::gfx::RectF& tex_coord_rect,
      ::viz::mojom::blink::ResourceIdPtr resource_id,
      bool nearest_neighbor,
      bool force_anti_aliasing_off);

TileQuadState(const TileQuadState&) = delete;
TileQuadState& operator=(const TileQuadState&) = delete;

  ~TileQuadState();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = TileQuadStatePtr>
  TileQuadStatePtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, TileQuadState::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, TileQuadState::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, TileQuadState::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        TileQuadState::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        TileQuadState::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        TileQuadState::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::TileQuadState_UnserializedMessageContext<
            UserType, TileQuadState::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<TileQuadState::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return TileQuadState::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::TileQuadState_UnserializedMessageContext<
            UserType, TileQuadState::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<TileQuadState::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::gfx::RectF tex_coord_rect;
  
  ::viz::mojom::blink::ResourceIdPtr resource_id;
  
  bool nearest_neighbor;
  
  bool force_anti_aliasing_off;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, TileQuadState::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, TileQuadState::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, TileQuadState::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, TileQuadState::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class BLINK_PLATFORM_EXPORT VideoHoleQuadState {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<VideoHoleQuadState, T>::value>;
  using DataView = VideoHoleQuadStateDataView;
  using Data_ = internal::VideoHoleQuadState_Data;

  template <typename... Args>
  static VideoHoleQuadStatePtr New(Args&&... args) {
    return VideoHoleQuadStatePtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static VideoHoleQuadStatePtr From(const U& u) {
    return mojo::TypeConverter<VideoHoleQuadStatePtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, VideoHoleQuadState>::Convert(*this);
  }


  VideoHoleQuadState();

  explicit VideoHoleQuadState(
      const ::base::UnguessableToken& overlay_plane_id);


  ~VideoHoleQuadState();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = VideoHoleQuadStatePtr>
  VideoHoleQuadStatePtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, VideoHoleQuadState::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, VideoHoleQuadState::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, VideoHoleQuadState::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        VideoHoleQuadState::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        VideoHoleQuadState::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        VideoHoleQuadState::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::VideoHoleQuadState_UnserializedMessageContext<
            UserType, VideoHoleQuadState::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<VideoHoleQuadState::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return VideoHoleQuadState::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::VideoHoleQuadState_UnserializedMessageContext<
            UserType, VideoHoleQuadState::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<VideoHoleQuadState::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::base::UnguessableToken overlay_plane_id;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, VideoHoleQuadState::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, VideoHoleQuadState::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, VideoHoleQuadState::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, VideoHoleQuadState::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class BLINK_PLATFORM_EXPORT SharedElementQuadState {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<SharedElementQuadState, T>::value>;
  using DataView = SharedElementQuadStateDataView;
  using Data_ = internal::SharedElementQuadState_Data;

  template <typename... Args>
  static SharedElementQuadStatePtr New(Args&&... args) {
    return SharedElementQuadStatePtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static SharedElementQuadStatePtr From(const U& u) {
    return mojo::TypeConverter<SharedElementQuadStatePtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, SharedElementQuadState>::Convert(*this);
  }


  SharedElementQuadState();

  explicit SharedElementQuadState(
      ::viz::mojom::blink::ViewTransitionElementResourceIdPtr element_resource_id);

SharedElementQuadState(const SharedElementQuadState&) = delete;
SharedElementQuadState& operator=(const SharedElementQuadState&) = delete;

  ~SharedElementQuadState();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = SharedElementQuadStatePtr>
  SharedElementQuadStatePtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, SharedElementQuadState::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, SharedElementQuadState::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, SharedElementQuadState::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        SharedElementQuadState::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        SharedElementQuadState::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        SharedElementQuadState::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::SharedElementQuadState_UnserializedMessageContext<
            UserType, SharedElementQuadState::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<SharedElementQuadState::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return SharedElementQuadState::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::SharedElementQuadState_UnserializedMessageContext<
            UserType, SharedElementQuadState::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<SharedElementQuadState::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::viz::mojom::blink::ViewTransitionElementResourceIdPtr element_resource_id;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, SharedElementQuadState::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, SharedElementQuadState::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, SharedElementQuadState::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, SharedElementQuadState::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class BLINK_PLATFORM_EXPORT DrawQuad {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<DrawQuad, T>::value>;
  using DataView = DrawQuadDataView;
  using Data_ = internal::DrawQuad_Data;

  template <typename... Args>
  static DrawQuadPtr New(Args&&... args) {
    return DrawQuadPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static DrawQuadPtr From(const U& u) {
    return mojo::TypeConverter<DrawQuadPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, DrawQuad>::Convert(*this);
  }


  DrawQuad();

  DrawQuad(
      const ::gfx::Rect& rect,
      const ::gfx::Rect& visible_rect,
      bool needs_blending,
      ::viz::mojom::blink::SharedQuadStatePtr sqs,
      DrawQuadStatePtr draw_quad_state);

DrawQuad(const DrawQuad&) = delete;
DrawQuad& operator=(const DrawQuad&) = delete;

  ~DrawQuad();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = DrawQuadPtr>
  DrawQuadPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, DrawQuad::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, DrawQuad::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, DrawQuad::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        DrawQuad::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        DrawQuad::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        DrawQuad::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::DrawQuad_UnserializedMessageContext<
            UserType, DrawQuad::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<DrawQuad::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return DrawQuad::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::DrawQuad_UnserializedMessageContext<
            UserType, DrawQuad::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<DrawQuad::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::gfx::Rect rect;
  
  ::gfx::Rect visible_rect;
  
  bool needs_blending;
  
  ::viz::mojom::blink::SharedQuadStatePtr sqs;
  
  DrawQuadStatePtr draw_quad_state;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, DrawQuad::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, DrawQuad::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, DrawQuad::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, DrawQuad::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename UnionPtrType>
DrawQuadStatePtr DrawQuadState::Clone() const {
  switch (tag_) {
    case Tag::kDebugBorderQuadState:
      return NewDebugBorderQuadState(
          mojo::Clone(data_.debug_border_quad_state));
    case Tag::kRenderPassQuadState:
      return NewRenderPassQuadState(
          mojo::Clone(data_.render_pass_quad_state));
    case Tag::kSolidColorQuadState:
      return NewSolidColorQuadState(
          mojo::Clone(data_.solid_color_quad_state));
    case Tag::kSurfaceQuadState:
      return NewSurfaceQuadState(
          mojo::Clone(data_.surface_quad_state));
    case Tag::kTextureQuadState:
      return NewTextureQuadState(
          mojo::Clone(data_.texture_quad_state));
    case Tag::kTileQuadState:
      return NewTileQuadState(
          mojo::Clone(data_.tile_quad_state));
    case Tag::kVideoHoleQuadState:
      return NewVideoHoleQuadState(
          mojo::Clone(data_.video_hole_quad_state));
    case Tag::kSharedElementQuadState:
      return NewSharedElementQuadState(
          mojo::Clone(data_.shared_element_quad_state));
  }
  return nullptr;
}

template <typename T,
          typename std::enable_if<std::is_same<
              T, DrawQuadState>::value>::type*>
bool DrawQuadState::Equals(const T& other) const {
  if (tag_ != other.which())
    return false;

  switch (tag_) {
    case Tag::kDebugBorderQuadState:
      return mojo::Equals(data_.debug_border_quad_state, other.data_.debug_border_quad_state);
    case Tag::kRenderPassQuadState:
      return mojo::Equals(data_.render_pass_quad_state, other.data_.render_pass_quad_state);
    case Tag::kSolidColorQuadState:
      return mojo::Equals(data_.solid_color_quad_state, other.data_.solid_color_quad_state);
    case Tag::kSurfaceQuadState:
      return mojo::Equals(data_.surface_quad_state, other.data_.surface_quad_state);
    case Tag::kTextureQuadState:
      return mojo::Equals(data_.texture_quad_state, other.data_.texture_quad_state);
    case Tag::kTileQuadState:
      return mojo::Equals(data_.tile_quad_state, other.data_.tile_quad_state);
    case Tag::kVideoHoleQuadState:
      return mojo::Equals(data_.video_hole_quad_state, other.data_.video_hole_quad_state);
    case Tag::kSharedElementQuadState:
      return mojo::Equals(data_.shared_element_quad_state, other.data_.shared_element_quad_state);
  }

  return false;
}
template <typename StructPtrType>
RoundedDisplayMasksInfoPtr RoundedDisplayMasksInfo::Clone() const {
  return New(
      mojo::Clone(is_horizontally_positioned),
      mojo::Clone(radii)
  );
}

template <typename T, RoundedDisplayMasksInfo::EnableIfSame<T>*>
bool RoundedDisplayMasksInfo::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->is_horizontally_positioned, other_struct.is_horizontally_positioned))
    return false;
  if (!mojo::Equals(this->radii, other_struct.radii))
    return false;
  return true;
}

template <typename T, RoundedDisplayMasksInfo::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.is_horizontally_positioned < rhs.is_horizontally_positioned)
    return true;
  if (rhs.is_horizontally_positioned < lhs.is_horizontally_positioned)
    return false;
  if (lhs.radii < rhs.radii)
    return true;
  if (rhs.radii < lhs.radii)
    return false;
  return false;
}
template <typename StructPtrType>
DebugBorderQuadStatePtr DebugBorderQuadState::Clone() const {
  return New(
      mojo::Clone(color),
      mojo::Clone(width)
  );
}

template <typename T, DebugBorderQuadState::EnableIfSame<T>*>
bool DebugBorderQuadState::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->color, other_struct.color))
    return false;
  if (!mojo::Equals(this->width, other_struct.width))
    return false;
  return true;
}

template <typename T, DebugBorderQuadState::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.color < rhs.color)
    return true;
  if (rhs.color < lhs.color)
    return false;
  if (lhs.width < rhs.width)
    return true;
  if (rhs.width < lhs.width)
    return false;
  return false;
}
template <typename StructPtrType>
CompositorRenderPassQuadStatePtr CompositorRenderPassQuadState::Clone() const {
  return New(
      mojo::Clone(render_pass_id),
      mojo::Clone(mask_resource_id),
      mojo::Clone(mask_uv_rect),
      mojo::Clone(mask_texture_size),
      mojo::Clone(filters_scale),
      mojo::Clone(filters_origin),
      mojo::Clone(tex_coord_rect),
      mojo::Clone(force_anti_aliasing_off),
      mojo::Clone(backdrop_filter_quality),
      mojo::Clone(intersects_damage_under)
  );
}

template <typename T, CompositorRenderPassQuadState::EnableIfSame<T>*>
bool CompositorRenderPassQuadState::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->render_pass_id, other_struct.render_pass_id))
    return false;
  if (!mojo::Equals(this->mask_resource_id, other_struct.mask_resource_id))
    return false;
  if (!mojo::Equals(this->mask_uv_rect, other_struct.mask_uv_rect))
    return false;
  if (!mojo::Equals(this->mask_texture_size, other_struct.mask_texture_size))
    return false;
  if (!mojo::Equals(this->filters_scale, other_struct.filters_scale))
    return false;
  if (!mojo::Equals(this->filters_origin, other_struct.filters_origin))
    return false;
  if (!mojo::Equals(this->tex_coord_rect, other_struct.tex_coord_rect))
    return false;
  if (!mojo::Equals(this->force_anti_aliasing_off, other_struct.force_anti_aliasing_off))
    return false;
  if (!mojo::Equals(this->backdrop_filter_quality, other_struct.backdrop_filter_quality))
    return false;
  if (!mojo::Equals(this->intersects_damage_under, other_struct.intersects_damage_under))
    return false;
  return true;
}

template <typename T, CompositorRenderPassQuadState::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.render_pass_id < rhs.render_pass_id)
    return true;
  if (rhs.render_pass_id < lhs.render_pass_id)
    return false;
  if (lhs.mask_resource_id < rhs.mask_resource_id)
    return true;
  if (rhs.mask_resource_id < lhs.mask_resource_id)
    return false;
  if (lhs.mask_uv_rect < rhs.mask_uv_rect)
    return true;
  if (rhs.mask_uv_rect < lhs.mask_uv_rect)
    return false;
  if (lhs.mask_texture_size < rhs.mask_texture_size)
    return true;
  if (rhs.mask_texture_size < lhs.mask_texture_size)
    return false;
  if (lhs.filters_scale < rhs.filters_scale)
    return true;
  if (rhs.filters_scale < lhs.filters_scale)
    return false;
  if (lhs.filters_origin < rhs.filters_origin)
    return true;
  if (rhs.filters_origin < lhs.filters_origin)
    return false;
  if (lhs.tex_coord_rect < rhs.tex_coord_rect)
    return true;
  if (rhs.tex_coord_rect < lhs.tex_coord_rect)
    return false;
  if (lhs.force_anti_aliasing_off < rhs.force_anti_aliasing_off)
    return true;
  if (rhs.force_anti_aliasing_off < lhs.force_anti_aliasing_off)
    return false;
  if (lhs.backdrop_filter_quality < rhs.backdrop_filter_quality)
    return true;
  if (rhs.backdrop_filter_quality < lhs.backdrop_filter_quality)
    return false;
  if (lhs.intersects_damage_under < rhs.intersects_damage_under)
    return true;
  if (rhs.intersects_damage_under < lhs.intersects_damage_under)
    return false;
  return false;
}
template <typename StructPtrType>
SolidColorQuadStatePtr SolidColorQuadState::Clone() const {
  return New(
      mojo::Clone(color),
      mojo::Clone(force_anti_aliasing_off)
  );
}

template <typename T, SolidColorQuadState::EnableIfSame<T>*>
bool SolidColorQuadState::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->color, other_struct.color))
    return false;
  if (!mojo::Equals(this->force_anti_aliasing_off, other_struct.force_anti_aliasing_off))
    return false;
  return true;
}

template <typename T, SolidColorQuadState::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.color < rhs.color)
    return true;
  if (rhs.color < lhs.color)
    return false;
  if (lhs.force_anti_aliasing_off < rhs.force_anti_aliasing_off)
    return true;
  if (rhs.force_anti_aliasing_off < lhs.force_anti_aliasing_off)
    return false;
  return false;
}
template <typename StructPtrType>
SurfaceQuadStatePtr SurfaceQuadState::Clone() const {
  return New(
      mojo::Clone(surface_range),
      mojo::Clone(default_background_color),
      mojo::Clone(stretch_content_to_fill_bounds),
      mojo::Clone(is_reflection),
      mojo::Clone(allow_merge),
      mojo::Clone(override_child_filter_quality),
      mojo::Clone(override_child_dynamic_range_limit)
  );
}

template <typename T, SurfaceQuadState::EnableIfSame<T>*>
bool SurfaceQuadState::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->surface_range, other_struct.surface_range))
    return false;
  if (!mojo::Equals(this->default_background_color, other_struct.default_background_color))
    return false;
  if (!mojo::Equals(this->stretch_content_to_fill_bounds, other_struct.stretch_content_to_fill_bounds))
    return false;
  if (!mojo::Equals(this->is_reflection, other_struct.is_reflection))
    return false;
  if (!mojo::Equals(this->allow_merge, other_struct.allow_merge))
    return false;
  if (!mojo::Equals(this->override_child_filter_quality, other_struct.override_child_filter_quality))
    return false;
  if (!mojo::Equals(this->override_child_dynamic_range_limit, other_struct.override_child_dynamic_range_limit))
    return false;
  return true;
}

template <typename T, SurfaceQuadState::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.surface_range < rhs.surface_range)
    return true;
  if (rhs.surface_range < lhs.surface_range)
    return false;
  if (lhs.default_background_color < rhs.default_background_color)
    return true;
  if (rhs.default_background_color < lhs.default_background_color)
    return false;
  if (lhs.stretch_content_to_fill_bounds < rhs.stretch_content_to_fill_bounds)
    return true;
  if (rhs.stretch_content_to_fill_bounds < lhs.stretch_content_to_fill_bounds)
    return false;
  if (lhs.is_reflection < rhs.is_reflection)
    return true;
  if (rhs.is_reflection < lhs.is_reflection)
    return false;
  if (lhs.allow_merge < rhs.allow_merge)
    return true;
  if (rhs.allow_merge < lhs.allow_merge)
    return false;
  if (lhs.override_child_filter_quality < rhs.override_child_filter_quality)
    return true;
  if (rhs.override_child_filter_quality < lhs.override_child_filter_quality)
    return false;
  if (lhs.override_child_dynamic_range_limit < rhs.override_child_dynamic_range_limit)
    return true;
  if (rhs.override_child_dynamic_range_limit < lhs.override_child_dynamic_range_limit)
    return false;
  return false;
}
template <typename StructPtrType>
TextureQuadStatePtr TextureQuadState::Clone() const {
  return New(
      mojo::Clone(resource_id),
      mojo::Clone(uv_top_left),
      mojo::Clone(uv_bottom_right),
      mojo::Clone(background_color),
      mojo::Clone(dynamic_range_limit),
      mojo::Clone(nearest_neighbor),
      mojo::Clone(secure_output_only),
      mojo::Clone(is_video_frame),
      mojo::Clone(force_rgbx),
      mojo::Clone(protected_video_type),
      mojo::Clone(damage_rect),
      mojo::Clone(overlay_priority_hint),
      mojo::Clone(rounded_display_masks_info)
  );
}

template <typename T, TextureQuadState::EnableIfSame<T>*>
bool TextureQuadState::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->resource_id, other_struct.resource_id))
    return false;
  if (!mojo::Equals(this->uv_top_left, other_struct.uv_top_left))
    return false;
  if (!mojo::Equals(this->uv_bottom_right, other_struct.uv_bottom_right))
    return false;
  if (!mojo::Equals(this->background_color, other_struct.background_color))
    return false;
  if (!mojo::Equals(this->dynamic_range_limit, other_struct.dynamic_range_limit))
    return false;
  if (!mojo::Equals(this->nearest_neighbor, other_struct.nearest_neighbor))
    return false;
  if (!mojo::Equals(this->secure_output_only, other_struct.secure_output_only))
    return false;
  if (!mojo::Equals(this->is_video_frame, other_struct.is_video_frame))
    return false;
  if (!mojo::Equals(this->force_rgbx, other_struct.force_rgbx))
    return false;
  if (!mojo::Equals(this->protected_video_type, other_struct.protected_video_type))
    return false;
  if (!mojo::Equals(this->damage_rect, other_struct.damage_rect))
    return false;
  if (!mojo::Equals(this->overlay_priority_hint, other_struct.overlay_priority_hint))
    return false;
  if (!mojo::Equals(this->rounded_display_masks_info, other_struct.rounded_display_masks_info))
    return false;
  return true;
}

template <typename T, TextureQuadState::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.resource_id < rhs.resource_id)
    return true;
  if (rhs.resource_id < lhs.resource_id)
    return false;
  if (lhs.uv_top_left < rhs.uv_top_left)
    return true;
  if (rhs.uv_top_left < lhs.uv_top_left)
    return false;
  if (lhs.uv_bottom_right < rhs.uv_bottom_right)
    return true;
  if (rhs.uv_bottom_right < lhs.uv_bottom_right)
    return false;
  if (lhs.background_color < rhs.background_color)
    return true;
  if (rhs.background_color < lhs.background_color)
    return false;
  if (lhs.dynamic_range_limit < rhs.dynamic_range_limit)
    return true;
  if (rhs.dynamic_range_limit < lhs.dynamic_range_limit)
    return false;
  if (lhs.nearest_neighbor < rhs.nearest_neighbor)
    return true;
  if (rhs.nearest_neighbor < lhs.nearest_neighbor)
    return false;
  if (lhs.secure_output_only < rhs.secure_output_only)
    return true;
  if (rhs.secure_output_only < lhs.secure_output_only)
    return false;
  if (lhs.is_video_frame < rhs.is_video_frame)
    return true;
  if (rhs.is_video_frame < lhs.is_video_frame)
    return false;
  if (lhs.force_rgbx < rhs.force_rgbx)
    return true;
  if (rhs.force_rgbx < lhs.force_rgbx)
    return false;
  if (lhs.protected_video_type < rhs.protected_video_type)
    return true;
  if (rhs.protected_video_type < lhs.protected_video_type)
    return false;
  if (lhs.damage_rect < rhs.damage_rect)
    return true;
  if (rhs.damage_rect < lhs.damage_rect)
    return false;
  if (lhs.overlay_priority_hint < rhs.overlay_priority_hint)
    return true;
  if (rhs.overlay_priority_hint < lhs.overlay_priority_hint)
    return false;
  if (lhs.rounded_display_masks_info < rhs.rounded_display_masks_info)
    return true;
  if (rhs.rounded_display_masks_info < lhs.rounded_display_masks_info)
    return false;
  return false;
}
template <typename StructPtrType>
TileQuadStatePtr TileQuadState::Clone() const {
  return New(
      mojo::Clone(tex_coord_rect),
      mojo::Clone(resource_id),
      mojo::Clone(nearest_neighbor),
      mojo::Clone(force_anti_aliasing_off)
  );
}

template <typename T, TileQuadState::EnableIfSame<T>*>
bool TileQuadState::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->tex_coord_rect, other_struct.tex_coord_rect))
    return false;
  if (!mojo::Equals(this->resource_id, other_struct.resource_id))
    return false;
  if (!mojo::Equals(this->nearest_neighbor, other_struct.nearest_neighbor))
    return false;
  if (!mojo::Equals(this->force_anti_aliasing_off, other_struct.force_anti_aliasing_off))
    return false;
  return true;
}

template <typename T, TileQuadState::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.tex_coord_rect < rhs.tex_coord_rect)
    return true;
  if (rhs.tex_coord_rect < lhs.tex_coord_rect)
    return false;
  if (lhs.resource_id < rhs.resource_id)
    return true;
  if (rhs.resource_id < lhs.resource_id)
    return false;
  if (lhs.nearest_neighbor < rhs.nearest_neighbor)
    return true;
  if (rhs.nearest_neighbor < lhs.nearest_neighbor)
    return false;
  if (lhs.force_anti_aliasing_off < rhs.force_anti_aliasing_off)
    return true;
  if (rhs.force_anti_aliasing_off < lhs.force_anti_aliasing_off)
    return false;
  return false;
}
template <typename StructPtrType>
VideoHoleQuadStatePtr VideoHoleQuadState::Clone() const {
  return New(
      mojo::Clone(overlay_plane_id)
  );
}

template <typename T, VideoHoleQuadState::EnableIfSame<T>*>
bool VideoHoleQuadState::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->overlay_plane_id, other_struct.overlay_plane_id))
    return false;
  return true;
}

template <typename T, VideoHoleQuadState::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.overlay_plane_id < rhs.overlay_plane_id)
    return true;
  if (rhs.overlay_plane_id < lhs.overlay_plane_id)
    return false;
  return false;
}
template <typename StructPtrType>
SharedElementQuadStatePtr SharedElementQuadState::Clone() const {
  return New(
      mojo::Clone(element_resource_id)
  );
}

template <typename T, SharedElementQuadState::EnableIfSame<T>*>
bool SharedElementQuadState::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->element_resource_id, other_struct.element_resource_id))
    return false;
  return true;
}

template <typename T, SharedElementQuadState::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.element_resource_id < rhs.element_resource_id)
    return true;
  if (rhs.element_resource_id < lhs.element_resource_id)
    return false;
  return false;
}
template <typename StructPtrType>
DrawQuadPtr DrawQuad::Clone() const {
  return New(
      mojo::Clone(rect),
      mojo::Clone(visible_rect),
      mojo::Clone(needs_blending),
      mojo::Clone(sqs),
      mojo::Clone(draw_quad_state)
  );
}

template <typename T, DrawQuad::EnableIfSame<T>*>
bool DrawQuad::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->rect, other_struct.rect))
    return false;
  if (!mojo::Equals(this->visible_rect, other_struct.visible_rect))
    return false;
  if (!mojo::Equals(this->needs_blending, other_struct.needs_blending))
    return false;
  if (!mojo::Equals(this->sqs, other_struct.sqs))
    return false;
  if (!mojo::Equals(this->draw_quad_state, other_struct.draw_quad_state))
    return false;
  return true;
}

template <typename T, DrawQuad::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.rect < rhs.rect)
    return true;
  if (rhs.rect < lhs.rect)
    return false;
  if (lhs.visible_rect < rhs.visible_rect)
    return true;
  if (rhs.visible_rect < lhs.visible_rect)
    return false;
  if (lhs.needs_blending < rhs.needs_blending)
    return true;
  if (rhs.needs_blending < lhs.needs_blending)
    return false;
  if (lhs.sqs < rhs.sqs)
    return true;
  if (rhs.sqs < lhs.sqs)
    return false;
  if (lhs.draw_quad_state < rhs.draw_quad_state)
    return true;
  if (rhs.draw_quad_state < lhs.draw_quad_state)
    return false;
  return false;
}


}  // viz::mojom::blink

namespace mojo {


template <>
struct BLINK_PLATFORM_EXPORT StructTraits<::viz::mojom::blink::RoundedDisplayMasksInfo::DataView,
                                         ::viz::mojom::blink::RoundedDisplayMasksInfoPtr> {
  static bool IsNull(const ::viz::mojom::blink::RoundedDisplayMasksInfoPtr& input) { return !input; }
  static void SetToNull(::viz::mojom::blink::RoundedDisplayMasksInfoPtr* output) { output->reset(); }

  static decltype(::viz::mojom::blink::RoundedDisplayMasksInfo::is_horizontally_positioned) is_horizontally_positioned(
      const ::viz::mojom::blink::RoundedDisplayMasksInfoPtr& input) {
    return input->is_horizontally_positioned;
  }

  static const decltype(::viz::mojom::blink::RoundedDisplayMasksInfo::radii)& radii(
      const ::viz::mojom::blink::RoundedDisplayMasksInfoPtr& input) {
    return input->radii;
  }

  static bool Read(::viz::mojom::blink::RoundedDisplayMasksInfo::DataView input, ::viz::mojom::blink::RoundedDisplayMasksInfoPtr* output);
};


template <>
struct BLINK_PLATFORM_EXPORT StructTraits<::viz::mojom::blink::DebugBorderQuadState::DataView,
                                         ::viz::mojom::blink::DebugBorderQuadStatePtr> {
  static bool IsNull(const ::viz::mojom::blink::DebugBorderQuadStatePtr& input) { return !input; }
  static void SetToNull(::viz::mojom::blink::DebugBorderQuadStatePtr* output) { output->reset(); }

  static const decltype(::viz::mojom::blink::DebugBorderQuadState::color)& color(
      const ::viz::mojom::blink::DebugBorderQuadStatePtr& input) {
    return input->color;
  }

  static decltype(::viz::mojom::blink::DebugBorderQuadState::width) width(
      const ::viz::mojom::blink::DebugBorderQuadStatePtr& input) {
    return input->width;
  }

  static bool Read(::viz::mojom::blink::DebugBorderQuadState::DataView input, ::viz::mojom::blink::DebugBorderQuadStatePtr* output);
};


template <>
struct BLINK_PLATFORM_EXPORT StructTraits<::viz::mojom::blink::CompositorRenderPassQuadState::DataView,
                                         ::viz::mojom::blink::CompositorRenderPassQuadStatePtr> {
  static bool IsNull(const ::viz::mojom::blink::CompositorRenderPassQuadStatePtr& input) { return !input; }
  static void SetToNull(::viz::mojom::blink::CompositorRenderPassQuadStatePtr* output) { output->reset(); }

  static const decltype(::viz::mojom::blink::CompositorRenderPassQuadState::render_pass_id)& render_pass_id(
      const ::viz::mojom::blink::CompositorRenderPassQuadStatePtr& input) {
    return input->render_pass_id;
  }

  static const decltype(::viz::mojom::blink::CompositorRenderPassQuadState::mask_resource_id)& mask_resource_id(
      const ::viz::mojom::blink::CompositorRenderPassQuadStatePtr& input) {
    return input->mask_resource_id;
  }

  static const decltype(::viz::mojom::blink::CompositorRenderPassQuadState::mask_uv_rect)& mask_uv_rect(
      const ::viz::mojom::blink::CompositorRenderPassQuadStatePtr& input) {
    return input->mask_uv_rect;
  }

  static const decltype(::viz::mojom::blink::CompositorRenderPassQuadState::mask_texture_size)& mask_texture_size(
      const ::viz::mojom::blink::CompositorRenderPassQuadStatePtr& input) {
    return input->mask_texture_size;
  }

  static const decltype(::viz::mojom::blink::CompositorRenderPassQuadState::filters_scale)& filters_scale(
      const ::viz::mojom::blink::CompositorRenderPassQuadStatePtr& input) {
    return input->filters_scale;
  }

  static const decltype(::viz::mojom::blink::CompositorRenderPassQuadState::filters_origin)& filters_origin(
      const ::viz::mojom::blink::CompositorRenderPassQuadStatePtr& input) {
    return input->filters_origin;
  }

  static const decltype(::viz::mojom::blink::CompositorRenderPassQuadState::tex_coord_rect)& tex_coord_rect(
      const ::viz::mojom::blink::CompositorRenderPassQuadStatePtr& input) {
    return input->tex_coord_rect;
  }

  static decltype(::viz::mojom::blink::CompositorRenderPassQuadState::force_anti_aliasing_off) force_anti_aliasing_off(
      const ::viz::mojom::blink::CompositorRenderPassQuadStatePtr& input) {
    return input->force_anti_aliasing_off;
  }

  static decltype(::viz::mojom::blink::CompositorRenderPassQuadState::backdrop_filter_quality) backdrop_filter_quality(
      const ::viz::mojom::blink::CompositorRenderPassQuadStatePtr& input) {
    return input->backdrop_filter_quality;
  }

  static decltype(::viz::mojom::blink::CompositorRenderPassQuadState::intersects_damage_under) intersects_damage_under(
      const ::viz::mojom::blink::CompositorRenderPassQuadStatePtr& input) {
    return input->intersects_damage_under;
  }

  static bool Read(::viz::mojom::blink::CompositorRenderPassQuadState::DataView input, ::viz::mojom::blink::CompositorRenderPassQuadStatePtr* output);
};


template <>
struct BLINK_PLATFORM_EXPORT StructTraits<::viz::mojom::blink::SolidColorQuadState::DataView,
                                         ::viz::mojom::blink::SolidColorQuadStatePtr> {
  static bool IsNull(const ::viz::mojom::blink::SolidColorQuadStatePtr& input) { return !input; }
  static void SetToNull(::viz::mojom::blink::SolidColorQuadStatePtr* output) { output->reset(); }

  static const decltype(::viz::mojom::blink::SolidColorQuadState::color)& color(
      const ::viz::mojom::blink::SolidColorQuadStatePtr& input) {
    return input->color;
  }

  static decltype(::viz::mojom::blink::SolidColorQuadState::force_anti_aliasing_off) force_anti_aliasing_off(
      const ::viz::mojom::blink::SolidColorQuadStatePtr& input) {
    return input->force_anti_aliasing_off;
  }

  static bool Read(::viz::mojom::blink::SolidColorQuadState::DataView input, ::viz::mojom::blink::SolidColorQuadStatePtr* output);
};


template <>
struct BLINK_PLATFORM_EXPORT StructTraits<::viz::mojom::blink::SurfaceQuadState::DataView,
                                         ::viz::mojom::blink::SurfaceQuadStatePtr> {
  static bool IsNull(const ::viz::mojom::blink::SurfaceQuadStatePtr& input) { return !input; }
  static void SetToNull(::viz::mojom::blink::SurfaceQuadStatePtr* output) { output->reset(); }

  static const decltype(::viz::mojom::blink::SurfaceQuadState::surface_range)& surface_range(
      const ::viz::mojom::blink::SurfaceQuadStatePtr& input) {
    return input->surface_range;
  }

  static const decltype(::viz::mojom::blink::SurfaceQuadState::default_background_color)& default_background_color(
      const ::viz::mojom::blink::SurfaceQuadStatePtr& input) {
    return input->default_background_color;
  }

  static decltype(::viz::mojom::blink::SurfaceQuadState::stretch_content_to_fill_bounds) stretch_content_to_fill_bounds(
      const ::viz::mojom::blink::SurfaceQuadStatePtr& input) {
    return input->stretch_content_to_fill_bounds;
  }

  static decltype(::viz::mojom::blink::SurfaceQuadState::is_reflection) is_reflection(
      const ::viz::mojom::blink::SurfaceQuadStatePtr& input) {
    return input->is_reflection;
  }

  static decltype(::viz::mojom::blink::SurfaceQuadState::allow_merge) allow_merge(
      const ::viz::mojom::blink::SurfaceQuadStatePtr& input) {
    return input->allow_merge;
  }

  static decltype(::viz::mojom::blink::SurfaceQuadState::override_child_filter_quality) override_child_filter_quality(
      const ::viz::mojom::blink::SurfaceQuadStatePtr& input) {
    return input->override_child_filter_quality;
  }

  static const decltype(::viz::mojom::blink::SurfaceQuadState::override_child_dynamic_range_limit)& override_child_dynamic_range_limit(
      const ::viz::mojom::blink::SurfaceQuadStatePtr& input) {
    return input->override_child_dynamic_range_limit;
  }

  static bool Read(::viz::mojom::blink::SurfaceQuadState::DataView input, ::viz::mojom::blink::SurfaceQuadStatePtr* output);
};


template <>
struct BLINK_PLATFORM_EXPORT StructTraits<::viz::mojom::blink::TextureQuadState::DataView,
                                         ::viz::mojom::blink::TextureQuadStatePtr> {
  static bool IsNull(const ::viz::mojom::blink::TextureQuadStatePtr& input) { return !input; }
  static void SetToNull(::viz::mojom::blink::TextureQuadStatePtr* output) { output->reset(); }

  static const decltype(::viz::mojom::blink::TextureQuadState::resource_id)& resource_id(
      const ::viz::mojom::blink::TextureQuadStatePtr& input) {
    return input->resource_id;
  }

  static const decltype(::viz::mojom::blink::TextureQuadState::uv_top_left)& uv_top_left(
      const ::viz::mojom::blink::TextureQuadStatePtr& input) {
    return input->uv_top_left;
  }

  static const decltype(::viz::mojom::blink::TextureQuadState::uv_bottom_right)& uv_bottom_right(
      const ::viz::mojom::blink::TextureQuadStatePtr& input) {
    return input->uv_bottom_right;
  }

  static const decltype(::viz::mojom::blink::TextureQuadState::background_color)& background_color(
      const ::viz::mojom::blink::TextureQuadStatePtr& input) {
    return input->background_color;
  }

  static const decltype(::viz::mojom::blink::TextureQuadState::dynamic_range_limit)& dynamic_range_limit(
      const ::viz::mojom::blink::TextureQuadStatePtr& input) {
    return input->dynamic_range_limit;
  }

  static decltype(::viz::mojom::blink::TextureQuadState::nearest_neighbor) nearest_neighbor(
      const ::viz::mojom::blink::TextureQuadStatePtr& input) {
    return input->nearest_neighbor;
  }

  static decltype(::viz::mojom::blink::TextureQuadState::secure_output_only) secure_output_only(
      const ::viz::mojom::blink::TextureQuadStatePtr& input) {
    return input->secure_output_only;
  }

  static decltype(::viz::mojom::blink::TextureQuadState::is_video_frame) is_video_frame(
      const ::viz::mojom::blink::TextureQuadStatePtr& input) {
    return input->is_video_frame;
  }

  static decltype(::viz::mojom::blink::TextureQuadState::force_rgbx) force_rgbx(
      const ::viz::mojom::blink::TextureQuadStatePtr& input) {
    return input->force_rgbx;
  }

  static decltype(::viz::mojom::blink::TextureQuadState::protected_video_type) protected_video_type(
      const ::viz::mojom::blink::TextureQuadStatePtr& input) {
    return input->protected_video_type;
  }

  static const decltype(::viz::mojom::blink::TextureQuadState::damage_rect)& damage_rect(
      const ::viz::mojom::blink::TextureQuadStatePtr& input) {
    return input->damage_rect;
  }

  static decltype(::viz::mojom::blink::TextureQuadState::overlay_priority_hint) overlay_priority_hint(
      const ::viz::mojom::blink::TextureQuadStatePtr& input) {
    return input->overlay_priority_hint;
  }

  static const decltype(::viz::mojom::blink::TextureQuadState::rounded_display_masks_info)& rounded_display_masks_info(
      const ::viz::mojom::blink::TextureQuadStatePtr& input) {
    return input->rounded_display_masks_info;
  }

  static bool Read(::viz::mojom::blink::TextureQuadState::DataView input, ::viz::mojom::blink::TextureQuadStatePtr* output);
};


template <>
struct BLINK_PLATFORM_EXPORT StructTraits<::viz::mojom::blink::TileQuadState::DataView,
                                         ::viz::mojom::blink::TileQuadStatePtr> {
  static bool IsNull(const ::viz::mojom::blink::TileQuadStatePtr& input) { return !input; }
  static void SetToNull(::viz::mojom::blink::TileQuadStatePtr* output) { output->reset(); }

  static const decltype(::viz::mojom::blink::TileQuadState::tex_coord_rect)& tex_coord_rect(
      const ::viz::mojom::blink::TileQuadStatePtr& input) {
    return input->tex_coord_rect;
  }

  static const decltype(::viz::mojom::blink::TileQuadState::resource_id)& resource_id(
      const ::viz::mojom::blink::TileQuadStatePtr& input) {
    return input->resource_id;
  }

  static decltype(::viz::mojom::blink::TileQuadState::nearest_neighbor) nearest_neighbor(
      const ::viz::mojom::blink::TileQuadStatePtr& input) {
    return input->nearest_neighbor;
  }

  static decltype(::viz::mojom::blink::TileQuadState::force_anti_aliasing_off) force_anti_aliasing_off(
      const ::viz::mojom::blink::TileQuadStatePtr& input) {
    return input->force_anti_aliasing_off;
  }

  static bool Read(::viz::mojom::blink::TileQuadState::DataView input, ::viz::mojom::blink::TileQuadStatePtr* output);
};


template <>
struct BLINK_PLATFORM_EXPORT StructTraits<::viz::mojom::blink::VideoHoleQuadState::DataView,
                                         ::viz::mojom::blink::VideoHoleQuadStatePtr> {
  static bool IsNull(const ::viz::mojom::blink::VideoHoleQuadStatePtr& input) { return !input; }
  static void SetToNull(::viz::mojom::blink::VideoHoleQuadStatePtr* output) { output->reset(); }

  static const decltype(::viz::mojom::blink::VideoHoleQuadState::overlay_plane_id)& overlay_plane_id(
      const ::viz::mojom::blink::VideoHoleQuadStatePtr& input) {
    return input->overlay_plane_id;
  }

  static bool Read(::viz::mojom::blink::VideoHoleQuadState::DataView input, ::viz::mojom::blink::VideoHoleQuadStatePtr* output);
};


template <>
struct BLINK_PLATFORM_EXPORT StructTraits<::viz::mojom::blink::SharedElementQuadState::DataView,
                                         ::viz::mojom::blink::SharedElementQuadStatePtr> {
  static bool IsNull(const ::viz::mojom::blink::SharedElementQuadStatePtr& input) { return !input; }
  static void SetToNull(::viz::mojom::blink::SharedElementQuadStatePtr* output) { output->reset(); }

  static const decltype(::viz::mojom::blink::SharedElementQuadState::element_resource_id)& element_resource_id(
      const ::viz::mojom::blink::SharedElementQuadStatePtr& input) {
    return input->element_resource_id;
  }

  static bool Read(::viz::mojom::blink::SharedElementQuadState::DataView input, ::viz::mojom::blink::SharedElementQuadStatePtr* output);
};


template <>
struct BLINK_PLATFORM_EXPORT StructTraits<::viz::mojom::blink::DrawQuad::DataView,
                                         ::viz::mojom::blink::DrawQuadPtr> {
  static bool IsNull(const ::viz::mojom::blink::DrawQuadPtr& input) { return !input; }
  static void SetToNull(::viz::mojom::blink::DrawQuadPtr* output) { output->reset(); }

  static const decltype(::viz::mojom::blink::DrawQuad::rect)& rect(
      const ::viz::mojom::blink::DrawQuadPtr& input) {
    return input->rect;
  }

  static const decltype(::viz::mojom::blink::DrawQuad::visible_rect)& visible_rect(
      const ::viz::mojom::blink::DrawQuadPtr& input) {
    return input->visible_rect;
  }

  static decltype(::viz::mojom::blink::DrawQuad::needs_blending) needs_blending(
      const ::viz::mojom::blink::DrawQuadPtr& input) {
    return input->needs_blending;
  }

  static const decltype(::viz::mojom::blink::DrawQuad::sqs)& sqs(
      const ::viz::mojom::blink::DrawQuadPtr& input) {
    return input->sqs;
  }

  static const decltype(::viz::mojom::blink::DrawQuad::draw_quad_state)& draw_quad_state(
      const ::viz::mojom::blink::DrawQuadPtr& input) {
    return input->draw_quad_state;
  }

  static bool Read(::viz::mojom::blink::DrawQuad::DataView input, ::viz::mojom::blink::DrawQuadPtr* output);
};


template <>
struct BLINK_PLATFORM_EXPORT UnionTraits<::viz::mojom::blink::DrawQuadState::DataView,
                                        ::viz::mojom::blink::DrawQuadStatePtr> {
  static bool IsNull(const ::viz::mojom::blink::DrawQuadStatePtr& input) { return !input; }
  static void SetToNull(::viz::mojom::blink::DrawQuadStatePtr* output) { output->reset(); }

  static ::viz::mojom::blink::DrawQuadState::Tag GetTag(const ::viz::mojom::blink::DrawQuadStatePtr& input) {
    return input->which();
  }

  static const ::viz::mojom::blink::DebugBorderQuadStatePtr& debug_border_quad_state(const ::viz::mojom::blink::DrawQuadStatePtr& input) {
    return input->get_debug_border_quad_state();
  }

  static const ::viz::mojom::blink::CompositorRenderPassQuadStatePtr& render_pass_quad_state(const ::viz::mojom::blink::DrawQuadStatePtr& input) {
    return input->get_render_pass_quad_state();
  }

  static const ::viz::mojom::blink::SolidColorQuadStatePtr& solid_color_quad_state(const ::viz::mojom::blink::DrawQuadStatePtr& input) {
    return input->get_solid_color_quad_state();
  }

  static const ::viz::mojom::blink::SurfaceQuadStatePtr& surface_quad_state(const ::viz::mojom::blink::DrawQuadStatePtr& input) {
    return input->get_surface_quad_state();
  }

  static const ::viz::mojom::blink::TextureQuadStatePtr& texture_quad_state(const ::viz::mojom::blink::DrawQuadStatePtr& input) {
    return input->get_texture_quad_state();
  }

  static const ::viz::mojom::blink::TileQuadStatePtr& tile_quad_state(const ::viz::mojom::blink::DrawQuadStatePtr& input) {
    return input->get_tile_quad_state();
  }

  static const ::viz::mojom::blink::VideoHoleQuadStatePtr& video_hole_quad_state(const ::viz::mojom::blink::DrawQuadStatePtr& input) {
    return input->get_video_hole_quad_state();
  }

  static const ::viz::mojom::blink::SharedElementQuadStatePtr& shared_element_quad_state(const ::viz::mojom::blink::DrawQuadStatePtr& input) {
    return input->get_shared_element_quad_state();
  }

  static bool Read(::viz::mojom::blink::DrawQuadState::DataView input, ::viz::mojom::blink::DrawQuadStatePtr* output);
};

}  // namespace mojo

#endif  // SERVICES_VIZ_PUBLIC_MOJOM_COMPOSITING_QUADS_MOJOM_BLINK_H_