// services/viz/public/mojom/compositing/surface_info.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_VIZ_PUBLIC_MOJOM_COMPOSITING_SURFACE_INFO_MOJOM_H_
#define SERVICES_VIZ_PUBLIC_MOJOM_COMPOSITING_SURFACE_INFO_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "services/viz/public/mojom/compositing/surface_info.mojom-features.h"  // IWYU pragma: export
#include "services/viz/public/mojom/compositing/surface_info.mojom-shared.h"  // IWYU pragma: export
#include "services/viz/public/mojom/compositing/surface_info.mojom-forward.h"  // IWYU pragma: export
#include "services/viz/public/mojom/compositing/surface_id.mojom.h"
#include "ui/gfx/geometry/mojom/geometry.mojom.h"
#include <string>
#include <vector>




#include "services/viz/public/cpp/compositing/surface_info_mojom_traits.h"




namespace viz::mojom {








class  SurfaceInfo {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<SurfaceInfo, T>::value>;
  using DataView = SurfaceInfoDataView;
  using Data_ = internal::SurfaceInfo_Data;

  template <typename... Args>
  static SurfaceInfoPtr New(Args&&... args) {
    return SurfaceInfoPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static SurfaceInfoPtr From(const U& u) {
    return mojo::TypeConverter<SurfaceInfoPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, SurfaceInfo>::Convert(*this);
  }


  SurfaceInfo();

  SurfaceInfo(
      const ::viz::SurfaceId& surface_id,
      float device_scale_factor,
      const ::gfx::Size& size_in_pixels);


  ~SurfaceInfo();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = SurfaceInfoPtr>
  SurfaceInfoPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, SurfaceInfo::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, SurfaceInfo::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, SurfaceInfo::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        SurfaceInfo::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        SurfaceInfo::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        SurfaceInfo::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::SurfaceInfo_UnserializedMessageContext<
            UserType, SurfaceInfo::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<SurfaceInfo::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return SurfaceInfo::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::SurfaceInfo_UnserializedMessageContext<
            UserType, SurfaceInfo::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<SurfaceInfo::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::viz::SurfaceId surface_id;
  
  float device_scale_factor;
  
  ::gfx::Size size_in_pixels;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, SurfaceInfo::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, SurfaceInfo::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, SurfaceInfo::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, SurfaceInfo::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
SurfaceInfoPtr SurfaceInfo::Clone() const {
  return New(
      mojo::Clone(surface_id),
      mojo::Clone(device_scale_factor),
      mojo::Clone(size_in_pixels)
  );
}

template <typename T, SurfaceInfo::EnableIfSame<T>*>
bool SurfaceInfo::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->surface_id, other_struct.surface_id))
    return false;
  if (!mojo::Equals(this->device_scale_factor, other_struct.device_scale_factor))
    return false;
  if (!mojo::Equals(this->size_in_pixels, other_struct.size_in_pixels))
    return false;
  return true;
}

template <typename T, SurfaceInfo::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.surface_id < rhs.surface_id)
    return true;
  if (rhs.surface_id < lhs.surface_id)
    return false;
  if (lhs.device_scale_factor < rhs.device_scale_factor)
    return true;
  if (rhs.device_scale_factor < lhs.device_scale_factor)
    return false;
  if (lhs.size_in_pixels < rhs.size_in_pixels)
    return true;
  if (rhs.size_in_pixels < lhs.size_in_pixels)
    return false;
  return false;
}


}  // viz::mojom

namespace mojo {


template <>
struct  StructTraits<::viz::mojom::SurfaceInfo::DataView,
                                         ::viz::mojom::SurfaceInfoPtr> {
  static bool IsNull(const ::viz::mojom::SurfaceInfoPtr& input) { return !input; }
  static void SetToNull(::viz::mojom::SurfaceInfoPtr* output) { output->reset(); }

  static const decltype(::viz::mojom::SurfaceInfo::surface_id)& surface_id(
      const ::viz::mojom::SurfaceInfoPtr& input) {
    return input->surface_id;
  }

  static decltype(::viz::mojom::SurfaceInfo::device_scale_factor) device_scale_factor(
      const ::viz::mojom::SurfaceInfoPtr& input) {
    return input->device_scale_factor;
  }

  static const decltype(::viz::mojom::SurfaceInfo::size_in_pixels)& size_in_pixels(
      const ::viz::mojom::SurfaceInfoPtr& input) {
    return input->size_in_pixels;
  }

  static bool Read(::viz::mojom::SurfaceInfo::DataView input, ::viz::mojom::SurfaceInfoPtr* output);
};

}  // namespace mojo

#endif  // SERVICES_VIZ_PUBLIC_MOJOM_COMPOSITING_SURFACE_INFO_MOJOM_H_