// services/viz/public/mojom/gpu.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "services/viz/public/mojom/gpu.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/features.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "services/viz/public/mojom/gpu.mojom-params-data.h"
#include "services/viz/public/mojom/gpu.mojom-shared-message-ids.h"

#include "services/viz/public/mojom/gpu.mojom-import-headers.h"
#include "services/viz/public/mojom/gpu.mojom-test-utils.h"


namespace viz::mojom {
// The declaration includes the definition on other builds.

Gpu::IPCStableHashFunction Gpu::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::Gpu>(message.name())) {
    case messages::Gpu::kEstablishGpuChannel: {
      return &Gpu::EstablishGpuChannel_Sym::IPCStableHash;
    }
    case messages::Gpu::kCreateVideoEncodeAcceleratorProvider: {
      return &Gpu::CreateVideoEncodeAcceleratorProvider_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* Gpu::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::Gpu>(message.name())) {
      case messages::Gpu::kEstablishGpuChannel:
            return "Receive viz::mojom::Gpu::EstablishGpuChannel";
      case messages::Gpu::kCreateVideoEncodeAcceleratorProvider:
            return "Receive viz::mojom::Gpu::CreateVideoEncodeAcceleratorProvider";
    }
  } else {
    switch (static_cast<messages::Gpu>(message.name())) {
      case messages::Gpu::kEstablishGpuChannel:
            return "Receive reply viz::mojom::Gpu::EstablishGpuChannel";
      case messages::Gpu::kCreateVideoEncodeAcceleratorProvider:
            return "Receive reply viz::mojom::Gpu::CreateVideoEncodeAcceleratorProvider";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t Gpu::EstablishGpuChannel_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x5041efb8;  // IPCStableHash for viz::mojom::Gpu::EstablishGpuChannel
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t Gpu::CreateVideoEncodeAcceleratorProvider_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xbec92fde;  // IPCStableHash for viz::mojom::Gpu::CreateVideoEncodeAcceleratorProvider
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

class Gpu_EstablishGpuChannel_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  Gpu_EstablishGpuChannel_ForwardToCallback(
      Gpu::EstablishGpuChannelCallback callback
      ) : callback_(std::move(callback)) {
  }

  Gpu_EstablishGpuChannel_ForwardToCallback(const Gpu_EstablishGpuChannel_ForwardToCallback&) = delete;
  Gpu_EstablishGpuChannel_ForwardToCallback& operator=(const Gpu_EstablishGpuChannel_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  Gpu::EstablishGpuChannelCallback callback_;
};

GpuProxy::GpuProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void GpuProxy::EstablishGpuChannel(
    EstablishGpuChannelCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send viz::mojom::Gpu::EstablishGpuChannel");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Gpu::kEstablishGpuChannel), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::viz::mojom::internal::Gpu_EstablishGpuChannel_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Gpu::Name_);
  message.set_method_name("EstablishGpuChannel");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new Gpu_EstablishGpuChannel_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void GpuProxy::CreateVideoEncodeAcceleratorProvider(
    ::mojo::PendingReceiver<::media::mojom::VideoEncodeAcceleratorProvider> in_vea_provider) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send viz::mojom::Gpu::CreateVideoEncodeAcceleratorProvider", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("vea_provider"), in_vea_provider,
                        "<value of type ::mojo::PendingReceiver<::media::mojom::VideoEncodeAcceleratorProvider>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Gpu::kCreateVideoEncodeAcceleratorProvider), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::viz::mojom::internal::Gpu_CreateVideoEncodeAcceleratorProvider_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::media::mojom::VideoEncodeAcceleratorProviderInterfaceBase>>(
    in_vea_provider,
    &params->vea_provider,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->vea_provider)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid vea_provider in Gpu.CreateVideoEncodeAcceleratorProvider request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Gpu::Name_);
  message.set_method_name("CreateVideoEncodeAcceleratorProvider");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}
class Gpu_EstablishGpuChannel_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static Gpu::EstablishGpuChannelCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<Gpu_EstablishGpuChannel_ProxyToResponder> proxy(
        new Gpu_EstablishGpuChannel_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&Gpu_EstablishGpuChannel_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~Gpu_EstablishGpuChannel_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  Gpu_EstablishGpuChannel_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "Gpu::EstablishGpuChannelCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      int32_t in_client_id, ::mojo::ScopedMessagePipeHandle in_channel_handle, const ::gpu::GPUInfo& in_gpu_info, const ::gpu::GpuFeatureInfo& in_gpu_feature_info, const ::gpu::SharedImageCapabilities& in_shared_image_capabilities);
};

bool Gpu_EstablishGpuChannel_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::Gpu_EstablishGpuChannel_ResponseParams_Data* params =
      reinterpret_cast<
          internal::Gpu_EstablishGpuChannel_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for Gpu.0
  bool success = true;
  int32_t p_client_id{};
  ::mojo::ScopedMessagePipeHandle p_channel_handle{};
  ::gpu::GPUInfo p_gpu_info{};
  ::gpu::GpuFeatureInfo p_gpu_feature_info{};
  ::gpu::SharedImageCapabilities p_shared_image_capabilities{};
  Gpu_EstablishGpuChannel_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_client_id = input_data_view.client_id();
  if (success)
    p_channel_handle = input_data_view.TakeChannelHandle();
  if (success && !input_data_view.ReadGpuInfo(&p_gpu_info))
    success = false;
  if (success && !input_data_view.ReadGpuFeatureInfo(&p_gpu_feature_info))
    success = false;
  if (success && !input_data_view.ReadSharedImageCapabilities(&p_shared_image_capabilities))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        Gpu::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_client_id), 
std::move(p_channel_handle), 
std::move(p_gpu_info), 
std::move(p_gpu_feature_info), 
std::move(p_shared_image_capabilities));
  }
  return true;
}

void Gpu_EstablishGpuChannel_ProxyToResponder::Run(
    int32_t in_client_id, ::mojo::ScopedMessagePipeHandle in_channel_handle, const ::gpu::GPUInfo& in_gpu_info, const ::gpu::GpuFeatureInfo& in_gpu_feature_info, const ::gpu::SharedImageCapabilities& in_shared_image_capabilities) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply viz::mojom::Gpu::EstablishGpuChannel", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("client_id"), in_client_id,
                        "<value of type int32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("channel_handle"), in_channel_handle,
                        "<value of type ::mojo::ScopedMessagePipeHandle>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("gpu_info"), in_gpu_info,
                        "<value of type const ::gpu::GPUInfo&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("gpu_feature_info"), in_gpu_feature_info,
                        "<value of type const ::gpu::GpuFeatureInfo&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("shared_image_capabilities"), in_shared_image_capabilities,
                        "<value of type const ::gpu::SharedImageCapabilities&>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Gpu::kEstablishGpuChannel), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::viz::mojom::internal::Gpu_EstablishGpuChannel_ResponseParams_Data> params(
          message);
  params.Allocate();

  params->client_id = in_client_id;

  
  mojo::internal::Serialize<mojo::ScopedMessagePipeHandle>(
    in_channel_handle,
    &params->channel_handle,
    &params.message());
  mojo::internal::MessageFragment<
      typename decltype(params->gpu_info)::BaseType> gpu_info_fragment(
          params.message());
  
  mojo::internal::Serialize<::gpu::mojom::GpuInfoDataView>(
    in_gpu_info,
    gpu_info_fragment);

  params->gpu_info.Set(
      gpu_info_fragment.is_null() ? nullptr : gpu_info_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->gpu_info.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null gpu_info in ");
  mojo::internal::MessageFragment<
      typename decltype(params->gpu_feature_info)::BaseType> gpu_feature_info_fragment(
          params.message());
  
  mojo::internal::Serialize<::gpu::mojom::GpuFeatureInfoDataView>(
    in_gpu_feature_info,
    gpu_feature_info_fragment);

  params->gpu_feature_info.Set(
      gpu_feature_info_fragment.is_null() ? nullptr : gpu_feature_info_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->gpu_feature_info.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null gpu_feature_info in ");
  mojo::internal::MessageFragment<
      typename decltype(params->shared_image_capabilities)::BaseType> shared_image_capabilities_fragment(
          params.message());
  
  mojo::internal::Serialize<::gpu::mojom::SharedImageCapabilitiesDataView>(
    in_shared_image_capabilities,
    shared_image_capabilities_fragment);

  params->shared_image_capabilities.Set(
      shared_image_capabilities_fragment.is_null() ? nullptr : shared_image_capabilities_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->shared_image_capabilities.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null shared_image_capabilities in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Gpu::Name_);
  message.set_method_name("EstablishGpuChannel");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool GpuStubDispatch::Accept(
    Gpu* impl,
    mojo::Message* message) {
  switch (static_cast<messages::Gpu>(message->header()->name)) {
    case messages::Gpu::kEstablishGpuChannel: {
      break;
    }
    case messages::Gpu::kCreateVideoEncodeAcceleratorProvider: {
      DCHECK(message->is_serialized());
      internal::Gpu_CreateVideoEncodeAcceleratorProvider_Params_Data* params =
          reinterpret_cast<internal::Gpu_CreateVideoEncodeAcceleratorProvider_Params_Data*>(
              message->mutable_payload());
      

      // Validation for Gpu.1
      bool success = true;
      ::mojo::PendingReceiver<::media::mojom::VideoEncodeAcceleratorProvider> p_vea_provider{};
      Gpu_CreateVideoEncodeAcceleratorProvider_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_vea_provider =
            input_data_view.TakeVeaProvider<decltype(p_vea_provider)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Gpu::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CreateVideoEncodeAcceleratorProvider(        
        std::move(p_vea_provider));
      return true;
    }
  }
  return false;
}

// static
bool GpuStubDispatch::AcceptWithResponder(
    Gpu* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::Gpu>(message->header()->name)) {
    case messages::Gpu::kEstablishGpuChannel: {
      internal::Gpu_EstablishGpuChannel_Params_Data* params =
          reinterpret_cast<
              internal::Gpu_EstablishGpuChannel_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for Gpu.0
      bool success = true;
      Gpu_EstablishGpuChannel_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Gpu::Name_, 0, false);
        return false;
      }
      auto callback =
          Gpu_EstablishGpuChannel_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->EstablishGpuChannel(std::move(callback));
      return true;
    }
    case messages::Gpu::kCreateVideoEncodeAcceleratorProvider: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kGpuValidationInfo[] = {
    {base::to_underlying(messages::Gpu::kEstablishGpuChannel),
     { &internal::Gpu_EstablishGpuChannel_Params_Data::Validate,
      &internal::Gpu_EstablishGpuChannel_ResponseParams_Data::Validate}},
    {base::to_underlying(messages::Gpu::kCreateVideoEncodeAcceleratorProvider),
     { &internal::Gpu_CreateVideoEncodeAcceleratorProvider_Params_Data::Validate,
      nullptr /* no response */}},
};

bool GpuRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGeneric(
    message,
    ::viz::mojom::Gpu::Name_,
    kGpuValidationInfo);
}

bool GpuResponseValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateResponseGeneric(
    message,
    ::viz::mojom::Gpu::Name_,
    kGpuValidationInfo);

}


}  // viz::mojom


namespace mojo {

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace viz::mojom {


void GpuInterceptorForTesting::EstablishGpuChannel(EstablishGpuChannelCallback callback) {
  GetForwardingInterface()->EstablishGpuChannel(std::move(callback));
}
void GpuInterceptorForTesting::CreateVideoEncodeAcceleratorProvider(::mojo::PendingReceiver<::media::mojom::VideoEncodeAcceleratorProvider> vea_provider) {
  GetForwardingInterface()->CreateVideoEncodeAcceleratorProvider(
    std::move(vea_provider)
    );
}
GpuAsyncWaiter::GpuAsyncWaiter(
    Gpu* proxy) : proxy_(proxy) {}

GpuAsyncWaiter::~GpuAsyncWaiter() = default;


void GpuAsyncWaiter::EstablishGpuChannel(
    int32_t* out_client_id, ::mojo::ScopedMessagePipeHandle* out_channel_handle, ::gpu::GPUInfo* out_gpu_info, ::gpu::GpuFeatureInfo* out_gpu_feature_info, ::gpu::SharedImageCapabilities* out_shared_image_capabilities) {
  base::RunLoop loop;
  proxy_->EstablishGpuChannel(
      base::BindOnce(
          [](base::RunLoop* loop,
             int32_t* out_client_id
,
             ::mojo::ScopedMessagePipeHandle* out_channel_handle
,
             ::gpu::GPUInfo* out_gpu_info
,
             ::gpu::GpuFeatureInfo* out_gpu_feature_info
,
             ::gpu::SharedImageCapabilities* out_shared_image_capabilities
,
             int32_t client_id,
             ::mojo::ScopedMessagePipeHandle channel_handle,
             const ::gpu::GPUInfo& gpu_info,
             const ::gpu::GpuFeatureInfo& gpu_feature_info,
             const ::gpu::SharedImageCapabilities& shared_image_capabilities) {*out_client_id = std::move(client_id);*out_channel_handle = std::move(channel_handle);*out_gpu_info = std::move(gpu_info);*out_gpu_feature_info = std::move(gpu_feature_info);*out_shared_image_capabilities = std::move(shared_image_capabilities);
            loop->Quit();
          },
          &loop,
          out_client_id,
          out_channel_handle,
          out_gpu_info,
          out_gpu_feature_info,
          out_shared_image_capabilities));
  loop.Run();
}








}  // viz::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif