// third_party/blink/public/mojom/file_system_access/file_system_access_observer.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_FILE_SYSTEM_ACCESS_FILE_SYSTEM_ACCESS_OBSERVER_MOJOM_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_FILE_SYSTEM_ACCESS_FILE_SYSTEM_ACCESS_OBSERVER_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "third_party/blink/public/mojom/file_system_access/file_system_access_observer.mojom-features.h"  // IWYU pragma: export
#include "third_party/blink/public/mojom/file_system_access/file_system_access_observer.mojom-shared.h"  // IWYU pragma: export
#include "third_party/blink/public/mojom/file_system_access/file_system_access_observer.mojom-forward.h"  // IWYU pragma: export
#include "third_party/blink/public/mojom/file_system_access/file_system_access_directory_handle.mojom.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/lib/message_size_estimator.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"


#include "third_party/blink/public/common/common_export.h"




namespace blink::mojom {

class FileSystemAccessObserverProxy;

template <typename ImplRefTraits>
class FileSystemAccessObserverStub;

class FileSystemAccessObserverRequestValidator;


class BLINK_COMMON_EXPORT FileSystemAccessObserver
    : public FileSystemAccessObserverInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "blink.mojom.FileSystemAccessObserver";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = FileSystemAccessObserverInterfaceBase;
  using Proxy_ = FileSystemAccessObserverProxy;

  template <typename ImplRefTraits>
  using Stub_ = FileSystemAccessObserverStub<ImplRefTraits>;

  using RequestValidator_ = FileSystemAccessObserverRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kOnFileChangesMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct OnFileChanges_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~FileSystemAccessObserver() = default;

  virtual void OnFileChanges(std::vector<FileSystemAccessChangePtr> changes) = 0;
};



class BLINK_COMMON_EXPORT FileSystemAccessObserverProxy
    : public FileSystemAccessObserver {
 public:
  using InterfaceType = FileSystemAccessObserver;

  explicit FileSystemAccessObserverProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void OnFileChanges(std::vector<FileSystemAccessChangePtr> changes) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class BLINK_COMMON_EXPORT FileSystemAccessObserverStubDispatch {
 public:
  static bool Accept(FileSystemAccessObserver* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      FileSystemAccessObserver* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<FileSystemAccessObserver>>
class FileSystemAccessObserverStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  FileSystemAccessObserverStub() = default;
  ~FileSystemAccessObserverStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return FileSystemAccessObserverStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return FileSystemAccessObserverStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class BLINK_COMMON_EXPORT FileSystemAccessObserverRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};





class BLINK_COMMON_EXPORT FileSystemAccessChangeTypeAppeared {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<FileSystemAccessChangeTypeAppeared, T>::value>;
  using DataView = FileSystemAccessChangeTypeAppearedDataView;
  using Data_ = internal::FileSystemAccessChangeTypeAppeared_Data;

  template <typename... Args>
  static FileSystemAccessChangeTypeAppearedPtr New(Args&&... args) {
    return FileSystemAccessChangeTypeAppearedPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static FileSystemAccessChangeTypeAppearedPtr From(const U& u) {
    return mojo::TypeConverter<FileSystemAccessChangeTypeAppearedPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, FileSystemAccessChangeTypeAppeared>::Convert(*this);
  }


  FileSystemAccessChangeTypeAppeared();


  ~FileSystemAccessChangeTypeAppeared();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = FileSystemAccessChangeTypeAppearedPtr>
  FileSystemAccessChangeTypeAppearedPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, FileSystemAccessChangeTypeAppeared::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, FileSystemAccessChangeTypeAppeared::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, FileSystemAccessChangeTypeAppeared::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  size_t Hash(size_t seed) const;

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        FileSystemAccessChangeTypeAppeared::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        FileSystemAccessChangeTypeAppeared::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        FileSystemAccessChangeTypeAppeared::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::FileSystemAccessChangeTypeAppeared_UnserializedMessageContext<
            UserType, FileSystemAccessChangeTypeAppeared::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<FileSystemAccessChangeTypeAppeared::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return FileSystemAccessChangeTypeAppeared::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::FileSystemAccessChangeTypeAppeared_UnserializedMessageContext<
            UserType, FileSystemAccessChangeTypeAppeared::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<FileSystemAccessChangeTypeAppeared::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }


  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, FileSystemAccessChangeTypeAppeared::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, FileSystemAccessChangeTypeAppeared::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, FileSystemAccessChangeTypeAppeared::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, FileSystemAccessChangeTypeAppeared::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class BLINK_COMMON_EXPORT FileSystemAccessChangeTypeDisappeared {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<FileSystemAccessChangeTypeDisappeared, T>::value>;
  using DataView = FileSystemAccessChangeTypeDisappearedDataView;
  using Data_ = internal::FileSystemAccessChangeTypeDisappeared_Data;

  template <typename... Args>
  static FileSystemAccessChangeTypeDisappearedPtr New(Args&&... args) {
    return FileSystemAccessChangeTypeDisappearedPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static FileSystemAccessChangeTypeDisappearedPtr From(const U& u) {
    return mojo::TypeConverter<FileSystemAccessChangeTypeDisappearedPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, FileSystemAccessChangeTypeDisappeared>::Convert(*this);
  }


  FileSystemAccessChangeTypeDisappeared();


  ~FileSystemAccessChangeTypeDisappeared();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = FileSystemAccessChangeTypeDisappearedPtr>
  FileSystemAccessChangeTypeDisappearedPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, FileSystemAccessChangeTypeDisappeared::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, FileSystemAccessChangeTypeDisappeared::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, FileSystemAccessChangeTypeDisappeared::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  size_t Hash(size_t seed) const;

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        FileSystemAccessChangeTypeDisappeared::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        FileSystemAccessChangeTypeDisappeared::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        FileSystemAccessChangeTypeDisappeared::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::FileSystemAccessChangeTypeDisappeared_UnserializedMessageContext<
            UserType, FileSystemAccessChangeTypeDisappeared::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<FileSystemAccessChangeTypeDisappeared::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return FileSystemAccessChangeTypeDisappeared::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::FileSystemAccessChangeTypeDisappeared_UnserializedMessageContext<
            UserType, FileSystemAccessChangeTypeDisappeared::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<FileSystemAccessChangeTypeDisappeared::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }


  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, FileSystemAccessChangeTypeDisappeared::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, FileSystemAccessChangeTypeDisappeared::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, FileSystemAccessChangeTypeDisappeared::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, FileSystemAccessChangeTypeDisappeared::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class BLINK_COMMON_EXPORT FileSystemAccessChangeTypeErrored {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<FileSystemAccessChangeTypeErrored, T>::value>;
  using DataView = FileSystemAccessChangeTypeErroredDataView;
  using Data_ = internal::FileSystemAccessChangeTypeErrored_Data;

  template <typename... Args>
  static FileSystemAccessChangeTypeErroredPtr New(Args&&... args) {
    return FileSystemAccessChangeTypeErroredPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static FileSystemAccessChangeTypeErroredPtr From(const U& u) {
    return mojo::TypeConverter<FileSystemAccessChangeTypeErroredPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, FileSystemAccessChangeTypeErrored>::Convert(*this);
  }


  FileSystemAccessChangeTypeErrored();


  ~FileSystemAccessChangeTypeErrored();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = FileSystemAccessChangeTypeErroredPtr>
  FileSystemAccessChangeTypeErroredPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, FileSystemAccessChangeTypeErrored::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, FileSystemAccessChangeTypeErrored::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, FileSystemAccessChangeTypeErrored::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  size_t Hash(size_t seed) const;

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        FileSystemAccessChangeTypeErrored::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        FileSystemAccessChangeTypeErrored::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        FileSystemAccessChangeTypeErrored::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::FileSystemAccessChangeTypeErrored_UnserializedMessageContext<
            UserType, FileSystemAccessChangeTypeErrored::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<FileSystemAccessChangeTypeErrored::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return FileSystemAccessChangeTypeErrored::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::FileSystemAccessChangeTypeErrored_UnserializedMessageContext<
            UserType, FileSystemAccessChangeTypeErrored::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<FileSystemAccessChangeTypeErrored::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }


  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, FileSystemAccessChangeTypeErrored::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, FileSystemAccessChangeTypeErrored::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, FileSystemAccessChangeTypeErrored::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, FileSystemAccessChangeTypeErrored::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class BLINK_COMMON_EXPORT FileSystemAccessChangeTypeModified {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<FileSystemAccessChangeTypeModified, T>::value>;
  using DataView = FileSystemAccessChangeTypeModifiedDataView;
  using Data_ = internal::FileSystemAccessChangeTypeModified_Data;

  template <typename... Args>
  static FileSystemAccessChangeTypeModifiedPtr New(Args&&... args) {
    return FileSystemAccessChangeTypeModifiedPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static FileSystemAccessChangeTypeModifiedPtr From(const U& u) {
    return mojo::TypeConverter<FileSystemAccessChangeTypeModifiedPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, FileSystemAccessChangeTypeModified>::Convert(*this);
  }


  FileSystemAccessChangeTypeModified();


  ~FileSystemAccessChangeTypeModified();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = FileSystemAccessChangeTypeModifiedPtr>
  FileSystemAccessChangeTypeModifiedPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, FileSystemAccessChangeTypeModified::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, FileSystemAccessChangeTypeModified::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, FileSystemAccessChangeTypeModified::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  size_t Hash(size_t seed) const;

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        FileSystemAccessChangeTypeModified::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        FileSystemAccessChangeTypeModified::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        FileSystemAccessChangeTypeModified::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::FileSystemAccessChangeTypeModified_UnserializedMessageContext<
            UserType, FileSystemAccessChangeTypeModified::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<FileSystemAccessChangeTypeModified::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return FileSystemAccessChangeTypeModified::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::FileSystemAccessChangeTypeModified_UnserializedMessageContext<
            UserType, FileSystemAccessChangeTypeModified::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<FileSystemAccessChangeTypeModified::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }


  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, FileSystemAccessChangeTypeModified::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, FileSystemAccessChangeTypeModified::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, FileSystemAccessChangeTypeModified::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, FileSystemAccessChangeTypeModified::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}






class BLINK_COMMON_EXPORT FileSystemAccessChangeTypeUnknown {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<FileSystemAccessChangeTypeUnknown, T>::value>;
  using DataView = FileSystemAccessChangeTypeUnknownDataView;
  using Data_ = internal::FileSystemAccessChangeTypeUnknown_Data;

  template <typename... Args>
  static FileSystemAccessChangeTypeUnknownPtr New(Args&&... args) {
    return FileSystemAccessChangeTypeUnknownPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static FileSystemAccessChangeTypeUnknownPtr From(const U& u) {
    return mojo::TypeConverter<FileSystemAccessChangeTypeUnknownPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, FileSystemAccessChangeTypeUnknown>::Convert(*this);
  }


  FileSystemAccessChangeTypeUnknown();


  ~FileSystemAccessChangeTypeUnknown();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = FileSystemAccessChangeTypeUnknownPtr>
  FileSystemAccessChangeTypeUnknownPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, FileSystemAccessChangeTypeUnknown::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, FileSystemAccessChangeTypeUnknown::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, FileSystemAccessChangeTypeUnknown::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  size_t Hash(size_t seed) const;

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        FileSystemAccessChangeTypeUnknown::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        FileSystemAccessChangeTypeUnknown::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        FileSystemAccessChangeTypeUnknown::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::FileSystemAccessChangeTypeUnknown_UnserializedMessageContext<
            UserType, FileSystemAccessChangeTypeUnknown::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<FileSystemAccessChangeTypeUnknown::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return FileSystemAccessChangeTypeUnknown::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::FileSystemAccessChangeTypeUnknown_UnserializedMessageContext<
            UserType, FileSystemAccessChangeTypeUnknown::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<FileSystemAccessChangeTypeUnknown::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }


  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, FileSystemAccessChangeTypeUnknown::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, FileSystemAccessChangeTypeUnknown::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, FileSystemAccessChangeTypeUnknown::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, FileSystemAccessChangeTypeUnknown::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}







class BLINK_COMMON_EXPORT FileSystemAccessChangeType {
 public:
  using DataView = FileSystemAccessChangeTypeDataView;
  using Data_ = internal::FileSystemAccessChangeType_Data;
  using Tag = Data_::FileSystemAccessChangeType_Tag;

  template <typename... Args>
  static FileSystemAccessChangeTypePtr New(Args&&... args) {
    static_assert(
        sizeof...(args) < 0,
        "Do not use Union::New(); to create a union of a given subtype, use "
        "New<SubType>(), not New() followed by set_<sub_type>(). To represent "
        "an empty union, mark the field or parameter as nullable in the mojom "
        "definition.");
    return nullptr;
  }

  // Construct an instance holding |appeared|.
  static FileSystemAccessChangeTypePtr NewAppeared(
      FileSystemAccessChangeTypeAppearedPtr value);
  // Construct an instance holding |disappeared|.
  static FileSystemAccessChangeTypePtr NewDisappeared(
      FileSystemAccessChangeTypeDisappearedPtr value);
  // Construct an instance holding |errored|.
  static FileSystemAccessChangeTypePtr NewErrored(
      FileSystemAccessChangeTypeErroredPtr value);
  // Construct an instance holding |modified|.
  static FileSystemAccessChangeTypePtr NewModified(
      FileSystemAccessChangeTypeModifiedPtr value);
  // Construct an instance holding |moved|.
  static FileSystemAccessChangeTypePtr NewMoved(
      FileSystemAccessChangeTypeMovedPtr value);
  // Construct an instance holding |unknown|.
  static FileSystemAccessChangeTypePtr NewUnknown(
      FileSystemAccessChangeTypeUnknownPtr value);

  template <typename U>
  static FileSystemAccessChangeTypePtr From(const U& u) {
    return mojo::TypeConverter<FileSystemAccessChangeTypePtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, FileSystemAccessChangeType>::Convert(*this);
  }
  ~FileSystemAccessChangeType();

  // Delete the copy constructor and copy assignment operators because `data_`
  // contains raw pointers that must not be copied.
  FileSystemAccessChangeType(const FileSystemAccessChangeType& other) = delete;
  FileSystemAccessChangeType& operator=(const FileSystemAccessChangeType& other) = delete;

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename UnionPtrType = FileSystemAccessChangeTypePtr>
  FileSystemAccessChangeTypePtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T,
            typename std::enable_if<std::is_same<
                T, FileSystemAccessChangeType>::value>::type* = nullptr>
  bool Equals(const T& other) const;

  template <typename T,
            typename std::enable_if<std::is_same<
                T, FileSystemAccessChangeType>::value>::type* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  Tag which() const {
    return tag_;
  }

  bool is_appeared() const { return tag_ == Tag::kAppeared; }
  const FileSystemAccessChangeTypeAppearedPtr& get_appeared() const {
    CHECK(tag_ == Tag::kAppeared);
    return data_.appeared;
  }
  FileSystemAccessChangeTypeAppearedPtr& get_appeared() {
    CHECK(tag_ == Tag::kAppeared);
    return data_.appeared;
  }
  void set_appeared(FileSystemAccessChangeTypeAppearedPtr appeared);

  bool is_disappeared() const { return tag_ == Tag::kDisappeared; }
  const FileSystemAccessChangeTypeDisappearedPtr& get_disappeared() const {
    CHECK(tag_ == Tag::kDisappeared);
    return data_.disappeared;
  }
  FileSystemAccessChangeTypeDisappearedPtr& get_disappeared() {
    CHECK(tag_ == Tag::kDisappeared);
    return data_.disappeared;
  }
  void set_disappeared(FileSystemAccessChangeTypeDisappearedPtr disappeared);

  bool is_errored() const { return tag_ == Tag::kErrored; }
  const FileSystemAccessChangeTypeErroredPtr& get_errored() const {
    CHECK(tag_ == Tag::kErrored);
    return data_.errored;
  }
  FileSystemAccessChangeTypeErroredPtr& get_errored() {
    CHECK(tag_ == Tag::kErrored);
    return data_.errored;
  }
  void set_errored(FileSystemAccessChangeTypeErroredPtr errored);

  bool is_modified() const { return tag_ == Tag::kModified; }
  const FileSystemAccessChangeTypeModifiedPtr& get_modified() const {
    CHECK(tag_ == Tag::kModified);
    return data_.modified;
  }
  FileSystemAccessChangeTypeModifiedPtr& get_modified() {
    CHECK(tag_ == Tag::kModified);
    return data_.modified;
  }
  void set_modified(FileSystemAccessChangeTypeModifiedPtr modified);

  bool is_moved() const { return tag_ == Tag::kMoved; }
  const FileSystemAccessChangeTypeMovedPtr& get_moved() const {
    CHECK(tag_ == Tag::kMoved);
    return data_.moved;
  }
  FileSystemAccessChangeTypeMovedPtr& get_moved() {
    CHECK(tag_ == Tag::kMoved);
    return data_.moved;
  }
  void set_moved(FileSystemAccessChangeTypeMovedPtr moved);

  bool is_unknown() const { return tag_ == Tag::kUnknown; }
  const FileSystemAccessChangeTypeUnknownPtr& get_unknown() const {
    CHECK(tag_ == Tag::kUnknown);
    return data_.unknown;
  }
  FileSystemAccessChangeTypeUnknownPtr& get_unknown() {
    CHECK(tag_ == Tag::kUnknown);
    return data_.unknown;
  }
  void set_unknown(FileSystemAccessChangeTypeUnknownPtr unknown);

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        FileSystemAccessChangeType::DataView>(input);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    return mojo::internal::DeserializeImpl<FileSystemAccessChangeType::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

 private:
  template <typename T>
  friend class ::mojo::InlinedStructPtr;
  template <typename T>
  friend class ::mojo::StructPtr;

  union Union_ {
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kAppeared)>,
        FileSystemAccessChangeTypeAppearedPtr value);
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kDisappeared)>,
        FileSystemAccessChangeTypeDisappearedPtr value);
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kErrored)>,
        FileSystemAccessChangeTypeErroredPtr value);
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kModified)>,
        FileSystemAccessChangeTypeModifiedPtr value);
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kMoved)>,
        FileSystemAccessChangeTypeMovedPtr value);
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kUnknown)>,
        FileSystemAccessChangeTypeUnknownPtr value);
    // The contents of the union are explicitly destroyed by `DestroyActive()`.
    ~Union_() {}

    FileSystemAccessChangeTypeAppearedPtr appeared;
    FileSystemAccessChangeTypeDisappearedPtr disappeared;
    FileSystemAccessChangeTypeErroredPtr errored;
    FileSystemAccessChangeTypeModifiedPtr modified;
    FileSystemAccessChangeTypeMovedPtr moved;
    FileSystemAccessChangeTypeUnknownPtr unknown;
  };

  FileSystemAccessChangeType(
      std::in_place_index_t<static_cast<size_t>(Tag::kAppeared)>,
      FileSystemAccessChangeTypeAppearedPtr value);
  FileSystemAccessChangeType(
      std::in_place_index_t<static_cast<size_t>(Tag::kDisappeared)>,
      FileSystemAccessChangeTypeDisappearedPtr value);
  FileSystemAccessChangeType(
      std::in_place_index_t<static_cast<size_t>(Tag::kErrored)>,
      FileSystemAccessChangeTypeErroredPtr value);
  FileSystemAccessChangeType(
      std::in_place_index_t<static_cast<size_t>(Tag::kModified)>,
      FileSystemAccessChangeTypeModifiedPtr value);
  FileSystemAccessChangeType(
      std::in_place_index_t<static_cast<size_t>(Tag::kMoved)>,
      FileSystemAccessChangeTypeMovedPtr value);
  FileSystemAccessChangeType(
      std::in_place_index_t<static_cast<size_t>(Tag::kUnknown)>,
      FileSystemAccessChangeTypeUnknownPtr value);

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  void DestroyActive();
  Tag tag_;
  Union_ data_;
};









class BLINK_COMMON_EXPORT FileSystemAccessChangeTypeMoved {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<FileSystemAccessChangeTypeMoved, T>::value>;
  using DataView = FileSystemAccessChangeTypeMovedDataView;
  using Data_ = internal::FileSystemAccessChangeTypeMoved_Data;

  template <typename... Args>
  static FileSystemAccessChangeTypeMovedPtr New(Args&&... args) {
    return FileSystemAccessChangeTypeMovedPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static FileSystemAccessChangeTypeMovedPtr From(const U& u) {
    return mojo::TypeConverter<FileSystemAccessChangeTypeMovedPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, FileSystemAccessChangeTypeMoved>::Convert(*this);
  }


  FileSystemAccessChangeTypeMoved();

  explicit FileSystemAccessChangeTypeMoved(
      std::optional<std::vector<std::string>> former_relative_path);


  ~FileSystemAccessChangeTypeMoved();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = FileSystemAccessChangeTypeMovedPtr>
  FileSystemAccessChangeTypeMovedPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, FileSystemAccessChangeTypeMoved::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, FileSystemAccessChangeTypeMoved::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, FileSystemAccessChangeTypeMoved::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        FileSystemAccessChangeTypeMoved::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        FileSystemAccessChangeTypeMoved::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        FileSystemAccessChangeTypeMoved::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::FileSystemAccessChangeTypeMoved_UnserializedMessageContext<
            UserType, FileSystemAccessChangeTypeMoved::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<FileSystemAccessChangeTypeMoved::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return FileSystemAccessChangeTypeMoved::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::FileSystemAccessChangeTypeMoved_UnserializedMessageContext<
            UserType, FileSystemAccessChangeTypeMoved::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<FileSystemAccessChangeTypeMoved::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::optional<std::vector<std::string>> former_relative_path;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, FileSystemAccessChangeTypeMoved::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, FileSystemAccessChangeTypeMoved::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, FileSystemAccessChangeTypeMoved::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, FileSystemAccessChangeTypeMoved::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}






class BLINK_COMMON_EXPORT FileSystemAccessChangeMetadata {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<FileSystemAccessChangeMetadata, T>::value>;
  using DataView = FileSystemAccessChangeMetadataDataView;
  using Data_ = internal::FileSystemAccessChangeMetadata_Data;

  template <typename... Args>
  static FileSystemAccessChangeMetadataPtr New(Args&&... args) {
    return FileSystemAccessChangeMetadataPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static FileSystemAccessChangeMetadataPtr From(const U& u) {
    return mojo::TypeConverter<FileSystemAccessChangeMetadataPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, FileSystemAccessChangeMetadata>::Convert(*this);
  }


  FileSystemAccessChangeMetadata();

  FileSystemAccessChangeMetadata(
      ::blink::mojom::FileSystemAccessEntryPtr root,
      ::blink::mojom::FileSystemAccessEntryPtr changed_entry,
      std::vector<std::string> relative_path);

FileSystemAccessChangeMetadata(const FileSystemAccessChangeMetadata&) = delete;
FileSystemAccessChangeMetadata& operator=(const FileSystemAccessChangeMetadata&) = delete;

  ~FileSystemAccessChangeMetadata();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = FileSystemAccessChangeMetadataPtr>
  FileSystemAccessChangeMetadataPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, FileSystemAccessChangeMetadata::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, FileSystemAccessChangeMetadata::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, FileSystemAccessChangeMetadata::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        FileSystemAccessChangeMetadata::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::FileSystemAccessChangeMetadata_UnserializedMessageContext<
            UserType, FileSystemAccessChangeMetadata::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<FileSystemAccessChangeMetadata::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return FileSystemAccessChangeMetadata::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::FileSystemAccessChangeMetadata_UnserializedMessageContext<
            UserType, FileSystemAccessChangeMetadata::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<FileSystemAccessChangeMetadata::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::blink::mojom::FileSystemAccessEntryPtr root;
  
  ::blink::mojom::FileSystemAccessEntryPtr changed_entry;
  
  std::vector<std::string> relative_path;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, FileSystemAccessChangeMetadata::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, FileSystemAccessChangeMetadata::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, FileSystemAccessChangeMetadata::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, FileSystemAccessChangeMetadata::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class BLINK_COMMON_EXPORT FileSystemAccessChange {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<FileSystemAccessChange, T>::value>;
  using DataView = FileSystemAccessChangeDataView;
  using Data_ = internal::FileSystemAccessChange_Data;

  template <typename... Args>
  static FileSystemAccessChangePtr New(Args&&... args) {
    return FileSystemAccessChangePtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static FileSystemAccessChangePtr From(const U& u) {
    return mojo::TypeConverter<FileSystemAccessChangePtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, FileSystemAccessChange>::Convert(*this);
  }


  FileSystemAccessChange();

  FileSystemAccessChange(
      FileSystemAccessChangeMetadataPtr metadata,
      FileSystemAccessChangeTypePtr type);

FileSystemAccessChange(const FileSystemAccessChange&) = delete;
FileSystemAccessChange& operator=(const FileSystemAccessChange&) = delete;

  ~FileSystemAccessChange();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = FileSystemAccessChangePtr>
  FileSystemAccessChangePtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, FileSystemAccessChange::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, FileSystemAccessChange::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, FileSystemAccessChange::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        FileSystemAccessChange::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::FileSystemAccessChange_UnserializedMessageContext<
            UserType, FileSystemAccessChange::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<FileSystemAccessChange::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return FileSystemAccessChange::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::FileSystemAccessChange_UnserializedMessageContext<
            UserType, FileSystemAccessChange::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<FileSystemAccessChange::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  FileSystemAccessChangeMetadataPtr metadata;
  
  FileSystemAccessChangeTypePtr type;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, FileSystemAccessChange::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, FileSystemAccessChange::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, FileSystemAccessChange::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, FileSystemAccessChange::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename UnionPtrType>
FileSystemAccessChangeTypePtr FileSystemAccessChangeType::Clone() const {
  switch (tag_) {
    case Tag::kAppeared:
      return NewAppeared(
          mojo::Clone(data_.appeared));
    case Tag::kDisappeared:
      return NewDisappeared(
          mojo::Clone(data_.disappeared));
    case Tag::kErrored:
      return NewErrored(
          mojo::Clone(data_.errored));
    case Tag::kModified:
      return NewModified(
          mojo::Clone(data_.modified));
    case Tag::kMoved:
      return NewMoved(
          mojo::Clone(data_.moved));
    case Tag::kUnknown:
      return NewUnknown(
          mojo::Clone(data_.unknown));
  }
  return nullptr;
}

template <typename T,
          typename std::enable_if<std::is_same<
              T, FileSystemAccessChangeType>::value>::type*>
bool FileSystemAccessChangeType::Equals(const T& other) const {
  if (tag_ != other.which())
    return false;

  switch (tag_) {
    case Tag::kAppeared:
      return mojo::Equals(data_.appeared, other.data_.appeared);
    case Tag::kDisappeared:
      return mojo::Equals(data_.disappeared, other.data_.disappeared);
    case Tag::kErrored:
      return mojo::Equals(data_.errored, other.data_.errored);
    case Tag::kModified:
      return mojo::Equals(data_.modified, other.data_.modified);
    case Tag::kMoved:
      return mojo::Equals(data_.moved, other.data_.moved);
    case Tag::kUnknown:
      return mojo::Equals(data_.unknown, other.data_.unknown);
  }

  return false;
}
template <typename StructPtrType>
FileSystemAccessChangeTypeAppearedPtr FileSystemAccessChangeTypeAppeared::Clone() const {
  return New(
  );
}

template <typename T, FileSystemAccessChangeTypeAppeared::EnableIfSame<T>*>
bool FileSystemAccessChangeTypeAppeared::Equals(const T& other_struct) const {
  return true;
}

template <typename T, FileSystemAccessChangeTypeAppeared::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  return false;
}
template <typename StructPtrType>
FileSystemAccessChangeTypeDisappearedPtr FileSystemAccessChangeTypeDisappeared::Clone() const {
  return New(
  );
}

template <typename T, FileSystemAccessChangeTypeDisappeared::EnableIfSame<T>*>
bool FileSystemAccessChangeTypeDisappeared::Equals(const T& other_struct) const {
  return true;
}

template <typename T, FileSystemAccessChangeTypeDisappeared::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  return false;
}
template <typename StructPtrType>
FileSystemAccessChangeTypeErroredPtr FileSystemAccessChangeTypeErrored::Clone() const {
  return New(
  );
}

template <typename T, FileSystemAccessChangeTypeErrored::EnableIfSame<T>*>
bool FileSystemAccessChangeTypeErrored::Equals(const T& other_struct) const {
  return true;
}

template <typename T, FileSystemAccessChangeTypeErrored::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  return false;
}
template <typename StructPtrType>
FileSystemAccessChangeTypeModifiedPtr FileSystemAccessChangeTypeModified::Clone() const {
  return New(
  );
}

template <typename T, FileSystemAccessChangeTypeModified::EnableIfSame<T>*>
bool FileSystemAccessChangeTypeModified::Equals(const T& other_struct) const {
  return true;
}

template <typename T, FileSystemAccessChangeTypeModified::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  return false;
}
template <typename StructPtrType>
FileSystemAccessChangeTypeMovedPtr FileSystemAccessChangeTypeMoved::Clone() const {
  return New(
      mojo::Clone(former_relative_path)
  );
}

template <typename T, FileSystemAccessChangeTypeMoved::EnableIfSame<T>*>
bool FileSystemAccessChangeTypeMoved::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->former_relative_path, other_struct.former_relative_path))
    return false;
  return true;
}

template <typename T, FileSystemAccessChangeTypeMoved::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.former_relative_path < rhs.former_relative_path)
    return true;
  if (rhs.former_relative_path < lhs.former_relative_path)
    return false;
  return false;
}
template <typename StructPtrType>
FileSystemAccessChangeTypeUnknownPtr FileSystemAccessChangeTypeUnknown::Clone() const {
  return New(
  );
}

template <typename T, FileSystemAccessChangeTypeUnknown::EnableIfSame<T>*>
bool FileSystemAccessChangeTypeUnknown::Equals(const T& other_struct) const {
  return true;
}

template <typename T, FileSystemAccessChangeTypeUnknown::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  return false;
}
template <typename StructPtrType>
FileSystemAccessChangeMetadataPtr FileSystemAccessChangeMetadata::Clone() const {
  return New(
      mojo::Clone(root),
      mojo::Clone(changed_entry),
      mojo::Clone(relative_path)
  );
}

template <typename T, FileSystemAccessChangeMetadata::EnableIfSame<T>*>
bool FileSystemAccessChangeMetadata::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->root, other_struct.root))
    return false;
  if (!mojo::Equals(this->changed_entry, other_struct.changed_entry))
    return false;
  if (!mojo::Equals(this->relative_path, other_struct.relative_path))
    return false;
  return true;
}

template <typename T, FileSystemAccessChangeMetadata::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.root < rhs.root)
    return true;
  if (rhs.root < lhs.root)
    return false;
  if (lhs.changed_entry < rhs.changed_entry)
    return true;
  if (rhs.changed_entry < lhs.changed_entry)
    return false;
  if (lhs.relative_path < rhs.relative_path)
    return true;
  if (rhs.relative_path < lhs.relative_path)
    return false;
  return false;
}
template <typename StructPtrType>
FileSystemAccessChangePtr FileSystemAccessChange::Clone() const {
  return New(
      mojo::Clone(metadata),
      mojo::Clone(type)
  );
}

template <typename T, FileSystemAccessChange::EnableIfSame<T>*>
bool FileSystemAccessChange::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->metadata, other_struct.metadata))
    return false;
  if (!mojo::Equals(this->type, other_struct.type))
    return false;
  return true;
}

template <typename T, FileSystemAccessChange::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.metadata < rhs.metadata)
    return true;
  if (rhs.metadata < lhs.metadata)
    return false;
  if (lhs.type < rhs.type)
    return true;
  if (rhs.type < lhs.type)
    return false;
  return false;
}


}  // blink::mojom

namespace mojo {


template <>
struct BLINK_COMMON_EXPORT StructTraits<::blink::mojom::FileSystemAccessChangeTypeAppeared::DataView,
                                         ::blink::mojom::FileSystemAccessChangeTypeAppearedPtr> {
  static bool IsNull(const ::blink::mojom::FileSystemAccessChangeTypeAppearedPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::FileSystemAccessChangeTypeAppearedPtr* output) { output->reset(); }

  static bool Read(::blink::mojom::FileSystemAccessChangeTypeAppeared::DataView input, ::blink::mojom::FileSystemAccessChangeTypeAppearedPtr* output);
};


template <>
struct BLINK_COMMON_EXPORT StructTraits<::blink::mojom::FileSystemAccessChangeTypeDisappeared::DataView,
                                         ::blink::mojom::FileSystemAccessChangeTypeDisappearedPtr> {
  static bool IsNull(const ::blink::mojom::FileSystemAccessChangeTypeDisappearedPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::FileSystemAccessChangeTypeDisappearedPtr* output) { output->reset(); }

  static bool Read(::blink::mojom::FileSystemAccessChangeTypeDisappeared::DataView input, ::blink::mojom::FileSystemAccessChangeTypeDisappearedPtr* output);
};


template <>
struct BLINK_COMMON_EXPORT StructTraits<::blink::mojom::FileSystemAccessChangeTypeErrored::DataView,
                                         ::blink::mojom::FileSystemAccessChangeTypeErroredPtr> {
  static bool IsNull(const ::blink::mojom::FileSystemAccessChangeTypeErroredPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::FileSystemAccessChangeTypeErroredPtr* output) { output->reset(); }

  static bool Read(::blink::mojom::FileSystemAccessChangeTypeErrored::DataView input, ::blink::mojom::FileSystemAccessChangeTypeErroredPtr* output);
};


template <>
struct BLINK_COMMON_EXPORT StructTraits<::blink::mojom::FileSystemAccessChangeTypeModified::DataView,
                                         ::blink::mojom::FileSystemAccessChangeTypeModifiedPtr> {
  static bool IsNull(const ::blink::mojom::FileSystemAccessChangeTypeModifiedPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::FileSystemAccessChangeTypeModifiedPtr* output) { output->reset(); }

  static bool Read(::blink::mojom::FileSystemAccessChangeTypeModified::DataView input, ::blink::mojom::FileSystemAccessChangeTypeModifiedPtr* output);
};


template <>
struct BLINK_COMMON_EXPORT StructTraits<::blink::mojom::FileSystemAccessChangeTypeMoved::DataView,
                                         ::blink::mojom::FileSystemAccessChangeTypeMovedPtr> {
  static bool IsNull(const ::blink::mojom::FileSystemAccessChangeTypeMovedPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::FileSystemAccessChangeTypeMovedPtr* output) { output->reset(); }

  static const decltype(::blink::mojom::FileSystemAccessChangeTypeMoved::former_relative_path)& former_relative_path(
      const ::blink::mojom::FileSystemAccessChangeTypeMovedPtr& input) {
    return input->former_relative_path;
  }

  static bool Read(::blink::mojom::FileSystemAccessChangeTypeMoved::DataView input, ::blink::mojom::FileSystemAccessChangeTypeMovedPtr* output);
};


template <>
struct BLINK_COMMON_EXPORT StructTraits<::blink::mojom::FileSystemAccessChangeTypeUnknown::DataView,
                                         ::blink::mojom::FileSystemAccessChangeTypeUnknownPtr> {
  static bool IsNull(const ::blink::mojom::FileSystemAccessChangeTypeUnknownPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::FileSystemAccessChangeTypeUnknownPtr* output) { output->reset(); }

  static bool Read(::blink::mojom::FileSystemAccessChangeTypeUnknown::DataView input, ::blink::mojom::FileSystemAccessChangeTypeUnknownPtr* output);
};


template <>
struct BLINK_COMMON_EXPORT StructTraits<::blink::mojom::FileSystemAccessChangeMetadata::DataView,
                                         ::blink::mojom::FileSystemAccessChangeMetadataPtr> {
  static bool IsNull(const ::blink::mojom::FileSystemAccessChangeMetadataPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::FileSystemAccessChangeMetadataPtr* output) { output->reset(); }

  static  decltype(::blink::mojom::FileSystemAccessChangeMetadata::root)& root(
       ::blink::mojom::FileSystemAccessChangeMetadataPtr& input) {
    return input->root;
  }

  static  decltype(::blink::mojom::FileSystemAccessChangeMetadata::changed_entry)& changed_entry(
       ::blink::mojom::FileSystemAccessChangeMetadataPtr& input) {
    return input->changed_entry;
  }

  static const decltype(::blink::mojom::FileSystemAccessChangeMetadata::relative_path)& relative_path(
      const ::blink::mojom::FileSystemAccessChangeMetadataPtr& input) {
    return input->relative_path;
  }

  static bool Read(::blink::mojom::FileSystemAccessChangeMetadata::DataView input, ::blink::mojom::FileSystemAccessChangeMetadataPtr* output);
};


template <>
struct BLINK_COMMON_EXPORT StructTraits<::blink::mojom::FileSystemAccessChange::DataView,
                                         ::blink::mojom::FileSystemAccessChangePtr> {
  static bool IsNull(const ::blink::mojom::FileSystemAccessChangePtr& input) { return !input; }
  static void SetToNull(::blink::mojom::FileSystemAccessChangePtr* output) { output->reset(); }

  static  decltype(::blink::mojom::FileSystemAccessChange::metadata)& metadata(
       ::blink::mojom::FileSystemAccessChangePtr& input) {
    return input->metadata;
  }

  static const decltype(::blink::mojom::FileSystemAccessChange::type)& type(
      const ::blink::mojom::FileSystemAccessChangePtr& input) {
    return input->type;
  }

  static bool Read(::blink::mojom::FileSystemAccessChange::DataView input, ::blink::mojom::FileSystemAccessChangePtr* output);
};


template <>
struct BLINK_COMMON_EXPORT UnionTraits<::blink::mojom::FileSystemAccessChangeType::DataView,
                                        ::blink::mojom::FileSystemAccessChangeTypePtr> {
  static bool IsNull(const ::blink::mojom::FileSystemAccessChangeTypePtr& input) { return !input; }
  static void SetToNull(::blink::mojom::FileSystemAccessChangeTypePtr* output) { output->reset(); }

  static ::blink::mojom::FileSystemAccessChangeType::Tag GetTag(const ::blink::mojom::FileSystemAccessChangeTypePtr& input) {
    return input->which();
  }

  static const ::blink::mojom::FileSystemAccessChangeTypeAppearedPtr& appeared(const ::blink::mojom::FileSystemAccessChangeTypePtr& input) {
    return input->get_appeared();
  }

  static const ::blink::mojom::FileSystemAccessChangeTypeDisappearedPtr& disappeared(const ::blink::mojom::FileSystemAccessChangeTypePtr& input) {
    return input->get_disappeared();
  }

  static const ::blink::mojom::FileSystemAccessChangeTypeErroredPtr& errored(const ::blink::mojom::FileSystemAccessChangeTypePtr& input) {
    return input->get_errored();
  }

  static const ::blink::mojom::FileSystemAccessChangeTypeModifiedPtr& modified(const ::blink::mojom::FileSystemAccessChangeTypePtr& input) {
    return input->get_modified();
  }

  static const ::blink::mojom::FileSystemAccessChangeTypeMovedPtr& moved(const ::blink::mojom::FileSystemAccessChangeTypePtr& input) {
    return input->get_moved();
  }

  static const ::blink::mojom::FileSystemAccessChangeTypeUnknownPtr& unknown(const ::blink::mojom::FileSystemAccessChangeTypePtr& input) {
    return input->get_unknown();
  }

  static bool Read(::blink::mojom::FileSystemAccessChangeType::DataView input, ::blink::mojom::FileSystemAccessChangeTypePtr* output);
};

}  // namespace mojo

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_FILE_SYSTEM_ACCESS_FILE_SYSTEM_ACCESS_OBSERVER_MOJOM_H_