// third_party/blink/public/mojom/frame/frame_replication_state.mojom-data-view.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_FRAME_FRAME_REPLICATION_STATE_MOJOM_DATA_VIEW_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_FRAME_FRAME_REPLICATION_STATE_MOJOM_DATA_VIEW_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "third_party/blink/public/mojom/frame/frame_replication_state.mojom-shared-internal.h"
#include "services/network/public/mojom/web_sandbox_flags.mojom-shared.h"
#include "services/network/public/mojom/permissions_policy/permissions_policy.mojom-shared.h"
#include "third_party/blink/public/mojom/frame/frame_policy.mojom-shared.h"
#include "third_party/blink/public/mojom/frame/tree_scope_type.mojom-shared.h"
#include "third_party/blink/public/mojom/security_context/insecure_request_policy.mojom-shared.h"
#include "url/mojom/origin.mojom-shared.h"


namespace blink::mojom {
class FrameReplicationStateDataView;



}  // blink::mojom


namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::blink::mojom::FrameReplicationStateDataView> {
  using Data = ::blink::mojom::internal::FrameReplicationState_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace blink::mojom {


class FrameReplicationStateDataView {
 public:
  FrameReplicationStateDataView() = default;

  FrameReplicationStateDataView(
      internal::FrameReplicationState_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetOriginDataView(
      ::url::mojom::OriginDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadOrigin(UserType* output) {
    
    auto* pointer = data_->origin.Get();
    return mojo::internal::Deserialize<::url::mojom::OriginDataView>(
        pointer, output, message_);
  }
  inline void GetNameDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadName(UserType* output) {
    
    auto* pointer = data_->name.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetUniqueNameDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadUniqueName(UserType* output) {
    
    auto* pointer = data_->unique_name.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetPermissionsPolicyHeaderDataView(
      mojo::ArrayDataView<::network::mojom::ParsedPermissionsPolicyDeclarationDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPermissionsPolicyHeader(UserType* output) {
    
    auto* pointer = data_->permissions_policy_header.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::network::mojom::ParsedPermissionsPolicyDeclarationDataView>>(
        pointer, output, message_);
  }
  template <typename UserType>
  [[nodiscard]] bool ReadActiveSandboxFlags(UserType* output) const {
    auto data_value = data_->active_sandbox_flags;
    return mojo::internal::Deserialize<::network::mojom::WebSandboxFlags>(
        data_value, output);
  }
  ::network::mojom::WebSandboxFlags active_sandbox_flags() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::network::mojom::WebSandboxFlags>(data_->active_sandbox_flags));
  }
  inline void GetFramePolicyDataView(
      ::blink::mojom::FramePolicyDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadFramePolicy(UserType* output) {
    
    auto* pointer = data_->frame_policy.Get();
    return mojo::internal::Deserialize<::blink::mojom::FramePolicyDataView>(
        pointer, output, message_);
  }
  template <typename UserType>
  [[nodiscard]] bool ReadInsecureRequestPolicy(UserType* output) const {
    auto data_value = data_->insecure_request_policy;
    return mojo::internal::Deserialize<::blink::mojom::InsecureRequestPolicy>(
        data_value, output);
  }
  ::blink::mojom::InsecureRequestPolicy insecure_request_policy() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::blink::mojom::InsecureRequestPolicy>(data_->insecure_request_policy));
  }
  inline void GetInsecureNavigationsSetDataView(
      mojo::ArrayDataView<uint32_t>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadInsecureNavigationsSet(UserType* output) {
    
    auto* pointer = data_->insecure_navigations_set.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<uint32_t>>(
        pointer, output, message_);
  }
  bool has_potentially_trustworthy_unique_origin() const {
    return data_->has_potentially_trustworthy_unique_origin;
  }
  bool has_active_user_gesture() const {
    return data_->has_active_user_gesture;
  }
  bool has_received_user_gesture_before_nav() const {
    return data_->has_received_user_gesture_before_nav;
  }
  bool is_ad_frame() const {
    return data_->is_ad_frame;
  }
 private:
  internal::FrameReplicationState_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


}  // blink::mojom

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_FRAME_FRAME_REPLICATION_STATE_MOJOM_DATA_VIEW_H_