// third_party/blink/public/mojom/page/page.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_PAGE_PAGE_MOJOM_SHARED_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_PAGE_PAGE_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "third_party/blink/public/mojom/page/page.mojom-shared-internal.h"
#include "mojo/public/mojom/base/time.mojom-shared.h"
#include "mojo/public/mojom/base/unguessable_token.mojom-shared.h"
#include "skia/public/mojom/skcolor.mojom-shared.h"
#include "services/network/public/mojom/attribution.mojom-shared.h"
#include "third_party/blink/public/mojom/frame/frame_replication_state.mojom-shared.h"
#include "third_party/blink/public/mojom/frame/remote_frame.mojom-shared.h"
#include "third_party/blink/public/mojom/frame/view_transition_state.mojom-shared.h"
#include "third_party/blink/public/mojom/navigation/was_activated_option.mojom-shared.h"
#include "third_party/blink/public/mojom/page/page_visibility_state.mojom-shared.h"
#include "third_party/blink/public/mojom/tokens/tokens.mojom-shared.h"
#include "third_party/blink/public/mojom/webpreferences/web_preferences.mojom-shared.h"
#include "third_party/blink/public/mojom/renderer_preferences.mojom-shared.h"
#include "ui/color/color_id.mojom-shared.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization.h"
#include "mojo/public/cpp/system/data_pipe.h"



#include "third_party/blink/public/mojom/page/page.mojom-data-view.h"
#include "base/component_export.h"




namespace std {

template <>
struct hash<::blink::mojom::PagehideDispatch>
    : public mojo::internal::EnumHashImpl<::blink::mojom::PagehideDispatch> {};

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::PagehideDispatch, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::blink::mojom::PagehideDispatch, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::blink::mojom::PagehideDispatch>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::PageLifecycleStateDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::PageLifecycleStateDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::PageLifecycleState_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    fragment->is_frozen = Traits::is_frozen(input);

    
    mojo::internal::Serialize<::blink::mojom::PageVisibilityState>(
      Traits::visibility(input),
      &fragment->visibility);

    fragment->is_in_back_forward_cache = Traits::is_in_back_forward_cache(input);

    
    mojo::internal::Serialize<::blink::mojom::PagehideDispatch>(
      Traits::pagehide_dispatch(input),
      &fragment->pagehide_dispatch);

    fragment->eviction_enabled = Traits::eviction_enabled(input);
  }

  static bool Deserialize(::blink::mojom::internal::PageLifecycleState_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::PageLifecycleStateDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::PageRestoreParamsDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::PageRestoreParamsDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::PageRestoreParams_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::navigation_start(input)) in_navigation_start = Traits::navigation_start(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->navigation_start)::BaseType> navigation_start_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::mojo_base::mojom::TimeTicksDataView>(
      in_navigation_start,
      navigation_start_fragment);

    fragment->navigation_start.Set(
        navigation_start_fragment.is_null() ? nullptr : navigation_start_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->navigation_start.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null navigation_start in PageRestoreParams struct");

    fragment->pending_history_list_index = Traits::pending_history_list_index(input);

    fragment->current_history_list_length = Traits::current_history_list_length(input);

    decltype(Traits::view_transition_state(input)) in_view_transition_state = Traits::view_transition_state(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->view_transition_state)::BaseType> view_transition_state_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::blink::mojom::ViewTransitionStateDataView>(
      in_view_transition_state,
      view_transition_state_fragment);

    fragment->view_transition_state.Set(
        view_transition_state_fragment.is_null() ? nullptr : view_transition_state_fragment.data());
  }

  static bool Deserialize(::blink::mojom::internal::PageRestoreParams_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::PageRestoreParamsDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::ColorProviderColorMapsDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::ColorProviderColorMapsDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::ColorProviderColorMaps_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::light_colors_map(input)) in_light_colors_map = Traits::light_colors_map(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->light_colors_map)::BaseType>
        light_colors_map_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& light_colors_map_validate_params =
        mojo::internal::GetMapValidator<*&mojo::internal::GetArrayOfEnumsValidator<0, false, ::color::mojom::internal::RendererColorId_Data::Validate>(), *&mojo::internal::GetArrayValidator<0, false, nullptr>()>();
    
    mojo::internal::Serialize<mojo::MapDataView<::color::mojom::RendererColorId, ::skia::mojom::SkColorDataView>>(
      in_light_colors_map,
      light_colors_map_fragment,
      &light_colors_map_validate_params);

    fragment->light_colors_map.Set(
        light_colors_map_fragment.is_null() ? nullptr : light_colors_map_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->light_colors_map.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null light_colors_map in ColorProviderColorMaps struct");

    decltype(Traits::dark_colors_map(input)) in_dark_colors_map = Traits::dark_colors_map(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->dark_colors_map)::BaseType>
        dark_colors_map_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& dark_colors_map_validate_params =
        mojo::internal::GetMapValidator<*&mojo::internal::GetArrayOfEnumsValidator<0, false, ::color::mojom::internal::RendererColorId_Data::Validate>(), *&mojo::internal::GetArrayValidator<0, false, nullptr>()>();
    
    mojo::internal::Serialize<mojo::MapDataView<::color::mojom::RendererColorId, ::skia::mojom::SkColorDataView>>(
      in_dark_colors_map,
      dark_colors_map_fragment,
      &dark_colors_map_validate_params);

    fragment->dark_colors_map.Set(
        dark_colors_map_fragment.is_null() ? nullptr : dark_colors_map_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->dark_colors_map.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null dark_colors_map in ColorProviderColorMaps struct");

    decltype(Traits::forced_colors_map(input)) in_forced_colors_map = Traits::forced_colors_map(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->forced_colors_map)::BaseType>
        forced_colors_map_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& forced_colors_map_validate_params =
        mojo::internal::GetMapValidator<*&mojo::internal::GetArrayOfEnumsValidator<0, false, ::color::mojom::internal::RendererColorId_Data::Validate>(), *&mojo::internal::GetArrayValidator<0, false, nullptr>()>();
    
    mojo::internal::Serialize<mojo::MapDataView<::color::mojom::RendererColorId, ::skia::mojom::SkColorDataView>>(
      in_forced_colors_map,
      forced_colors_map_fragment,
      &forced_colors_map_validate_params);

    fragment->forced_colors_map.Set(
        forced_colors_map_fragment.is_null() ? nullptr : forced_colors_map_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->forced_colors_map.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null forced_colors_map in ColorProviderColorMaps struct");
  }

  static bool Deserialize(::blink::mojom::internal::ColorProviderColorMaps_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::ColorProviderColorMapsDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::PrerenderPageActivationParamsDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::PrerenderPageActivationParamsDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::PrerenderPageActivationParams_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    
    mojo::internal::Serialize<::blink::mojom::WasActivatedOption>(
      Traits::was_user_activated(input),
      &fragment->was_user_activated);

    decltype(Traits::activation_start(input)) in_activation_start = Traits::activation_start(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->activation_start)::BaseType> activation_start_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::mojo_base::mojom::TimeTicksDataView>(
      in_activation_start,
      activation_start_fragment);

    fragment->activation_start.Set(
        activation_start_fragment.is_null() ? nullptr : activation_start_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->activation_start.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null activation_start in PrerenderPageActivationParams struct");

    decltype(Traits::view_transition_state(input)) in_view_transition_state = Traits::view_transition_state(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->view_transition_state)::BaseType> view_transition_state_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::blink::mojom::ViewTransitionStateDataView>(
      in_view_transition_state,
      view_transition_state_fragment);

    fragment->view_transition_state.Set(
        view_transition_state_fragment.is_null() ? nullptr : view_transition_state_fragment.data());
  }

  static bool Deserialize(::blink::mojom::internal::PrerenderPageActivationParams_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::PrerenderPageActivationParamsDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace blink::mojom {



inline void PageRestoreParamsDataView::GetNavigationStartDataView(
    ::mojo_base::mojom::TimeTicksDataView* output) {
  auto pointer = data_->navigation_start.Get();
  *output = ::mojo_base::mojom::TimeTicksDataView(pointer, message_);
}
inline void PageRestoreParamsDataView::GetViewTransitionStateDataView(
    ::blink::mojom::ViewTransitionStateDataView* output) {
  auto pointer = data_->view_transition_state.Get();
  *output = ::blink::mojom::ViewTransitionStateDataView(pointer, message_);
}


inline void ColorProviderColorMapsDataView::GetLightColorsMapDataView(
    mojo::MapDataView<::color::mojom::RendererColorId, ::skia::mojom::SkColorDataView>* output) {
  auto pointer = data_->light_colors_map.Get();
  *output = mojo::MapDataView<::color::mojom::RendererColorId, ::skia::mojom::SkColorDataView>(pointer, message_);
}
inline void ColorProviderColorMapsDataView::GetDarkColorsMapDataView(
    mojo::MapDataView<::color::mojom::RendererColorId, ::skia::mojom::SkColorDataView>* output) {
  auto pointer = data_->dark_colors_map.Get();
  *output = mojo::MapDataView<::color::mojom::RendererColorId, ::skia::mojom::SkColorDataView>(pointer, message_);
}
inline void ColorProviderColorMapsDataView::GetForcedColorsMapDataView(
    mojo::MapDataView<::color::mojom::RendererColorId, ::skia::mojom::SkColorDataView>* output) {
  auto pointer = data_->forced_colors_map.Get();
  *output = mojo::MapDataView<::color::mojom::RendererColorId, ::skia::mojom::SkColorDataView>(pointer, message_);
}


inline void PrerenderPageActivationParamsDataView::GetActivationStartDataView(
    ::mojo_base::mojom::TimeTicksDataView* output) {
  auto pointer = data_->activation_start.Get();
  *output = ::mojo_base::mojom::TimeTicksDataView(pointer, message_);
}
inline void PrerenderPageActivationParamsDataView::GetViewTransitionStateDataView(
    ::blink::mojom::ViewTransitionStateDataView* output) {
  auto pointer = data_->view_transition_state.Get();
  *output = ::blink::mojom::ViewTransitionStateDataView(pointer, message_);
}



}  // blink::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

namespace perfetto {

template <>
struct COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) TraceFormatTraits<::blink::mojom::PagehideDispatch> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::blink::mojom::PagehideDispatch value);
};

} // namespace perfetto

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_PAGE_PAGE_MOJOM_SHARED_H_