// third_party/blink/public/mojom/shared_storage/shared_storage.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_SHARED_STORAGE_SHARED_STORAGE_MOJOM_SHARED_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_SHARED_STORAGE_SHARED_STORAGE_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "third_party/blink/public/mojom/shared_storage/shared_storage.mojom-shared-internal.h"
#include "mojo/public/mojom/base/string16.mojom-shared.h"
#include "mojo/public/mojom/base/time.mojom-shared.h"
#include "services/network/public/mojom/fetch_api.mojom-shared.h"
#include "services/network/public/mojom/shared_storage.mojom-shared.h"
#include "third_party/blink/public/mojom/fenced_frame/fenced_frame_config.mojom-shared.h"
#include "third_party/blink/public/mojom/messaging/cloneable_message.mojom-shared.h"
#include "third_party/blink/public/mojom/origin_trials/origin_trial_feature.mojom-shared.h"
#include "url/mojom/origin.mojom-shared.h"
#include "url/mojom/url.mojom-shared.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization.h"
#include "mojo/public/cpp/system/data_pipe.h"



#include "third_party/blink/public/mojom/shared_storage/shared_storage.mojom-data-view.h"
#include "base/component_export.h"




namespace std {

template <>
struct hash<::blink::mojom::SharedStorageGetStatus>
    : public mojo::internal::EnumHashImpl<::blink::mojom::SharedStorageGetStatus> {};

template <>
struct hash<::blink::mojom::SharedStorageWorkletCreationMethod>
    : public mojo::internal::EnumHashImpl<::blink::mojom::SharedStorageWorkletCreationMethod> {};

template <>
struct hash<::blink::mojom::SharedStorageDataOriginType>
    : public mojo::internal::EnumHashImpl<::blink::mojom::SharedStorageDataOriginType> {};

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::SharedStorageGetStatus, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::blink::mojom::SharedStorageGetStatus, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::blink::mojom::SharedStorageGetStatus>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::SharedStorageWorkletCreationMethod, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::blink::mojom::SharedStorageWorkletCreationMethod, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::blink::mojom::SharedStorageWorkletCreationMethod>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::SharedStorageDataOriginType, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::blink::mojom::SharedStorageDataOriginType, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::blink::mojom::SharedStorageDataOriginType>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::SharedStorageUrlWithMetadataDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::SharedStorageUrlWithMetadataDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::SharedStorageUrlWithMetadata_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::url(input)) in_url = Traits::url(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->url)::BaseType> url_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::url::mojom::UrlDataView>(
      in_url,
      url_fragment);

    fragment->url.Set(
        url_fragment.is_null() ? nullptr : url_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->url.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null url in SharedStorageUrlWithMetadata struct");

    decltype(Traits::reporting_metadata(input)) in_reporting_metadata = Traits::reporting_metadata(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->reporting_metadata)::BaseType>
        reporting_metadata_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& reporting_metadata_validate_params =
        mojo::internal::GetMapValidator<*&mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>(), *&mojo::internal::GetArrayValidator<0, false, nullptr>()>();
    
    mojo::internal::Serialize<mojo::MapDataView<mojo::StringDataView, ::url::mojom::UrlDataView>>(
      in_reporting_metadata,
      reporting_metadata_fragment,
      &reporting_metadata_validate_params);

    fragment->reporting_metadata.Set(
        reporting_metadata_fragment.is_null() ? nullptr : reporting_metadata_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->reporting_metadata.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null reporting_metadata in SharedStorageUrlWithMetadata struct");
  }

  static bool Deserialize(::blink::mojom::internal::SharedStorageUrlWithMetadata_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::SharedStorageUrlWithMetadataDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::PrivateAggregationConfigDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::PrivateAggregationConfigDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::PrivateAggregationConfig_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::aggregation_coordinator_origin(input)) in_aggregation_coordinator_origin = Traits::aggregation_coordinator_origin(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->aggregation_coordinator_origin)::BaseType> aggregation_coordinator_origin_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::url::mojom::OriginDataView>(
      in_aggregation_coordinator_origin,
      aggregation_coordinator_origin_fragment);

    fragment->aggregation_coordinator_origin.Set(
        aggregation_coordinator_origin_fragment.is_null() ? nullptr : aggregation_coordinator_origin_fragment.data());

    decltype(Traits::context_id(input)) in_context_id = Traits::context_id(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->context_id)::BaseType> context_id_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_context_id,
      context_id_fragment);

    fragment->context_id.Set(
        context_id_fragment.is_null() ? nullptr : context_id_fragment.data());

    fragment->filtering_id_max_bytes = Traits::filtering_id_max_bytes(input);
    fragment->max_contributions_$flag = Traits::max_contributions(input).has_value();
    if (Traits::max_contributions(input).has_value()) {
      fragment->max_contributions_$value = Traits::max_contributions(input).value();
    }
  }

  static bool Deserialize(::blink::mojom::internal::PrivateAggregationConfig_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::PrivateAggregationConfigDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace blink::mojom {

inline void SharedStorageUrlWithMetadataDataView::GetUrlDataView(
    ::url::mojom::UrlDataView* output) {
  auto pointer = data_->url.Get();
  *output = ::url::mojom::UrlDataView(pointer, message_);
}
inline void SharedStorageUrlWithMetadataDataView::GetReportingMetadataDataView(
    mojo::MapDataView<mojo::StringDataView, ::url::mojom::UrlDataView>* output) {
  auto pointer = data_->reporting_metadata.Get();
  *output = mojo::MapDataView<mojo::StringDataView, ::url::mojom::UrlDataView>(pointer, message_);
}


inline void PrivateAggregationConfigDataView::GetAggregationCoordinatorOriginDataView(
    ::url::mojom::OriginDataView* output) {
  auto pointer = data_->aggregation_coordinator_origin.Get();
  *output = ::url::mojom::OriginDataView(pointer, message_);
}
inline void PrivateAggregationConfigDataView::GetContextIdDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->context_id.Get();
  *output = mojo::StringDataView(pointer, message_);
}



}  // blink::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

namespace perfetto {

template <>
struct COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) TraceFormatTraits<::blink::mojom::SharedStorageGetStatus> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::blink::mojom::SharedStorageGetStatus value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) TraceFormatTraits<::blink::mojom::SharedStorageWorkletCreationMethod> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::blink::mojom::SharedStorageWorkletCreationMethod value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) TraceFormatTraits<::blink::mojom::SharedStorageDataOriginType> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::blink::mojom::SharedStorageDataOriginType value);
};

} // namespace perfetto

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_SHARED_STORAGE_SHARED_STORAGE_MOJOM_SHARED_H_